/* ESPANOL.CMD: Instalacin de MEMSIZE en espaol */

'@Echo Off'
'CHCP 850'

/* Cargar REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Instalacin de MEMSIZE...'
Say ''


/* Verify the existence of the various component files. */

Language = 'ESPANOL'

Result = SysFileTree( 'MEMSIZE.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: No se encuentra el MEMSIZE.EXE!'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: No se encuentra el 'Language'.DLL!'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: No se encuentra el 'Language'.HLP!'
  Signal DONE
  End

/* Ask for the target directory name. */

Default = SysIni('USER', 'MEMSIZE', 'INIPATH' )
If Default = 'ERROR:'
  Then Default = 'C:\OS2\Apps'
If SUBSTR(Default,LENGTH(Default),1) <= ' '
  Then Default = SUBSTR(Default,1,LENGTH(Default)-1)

Say 'Por favor, escriba el nombre completo del directorio en el'
Say '  que quiere instalar el programa MEMSIZE (por defecto es 'Default'): '
Parse Pull Directory
If Directory = "" Then Directory = Default


/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: No se puede crear el directorio destino.'
    Signal DONE
    End
  End
Say ''


/* Ask for the target folder. */

Say "Quiere instalarlo de forma que se ejecute automticamente al arrancar? (S/N)"
Pull YesNo
If YesNo = "S" Then
  Do
  Folder = '<WP_START>'
  Say "El objeto se copiar en la carpeta Inicio."
  End
Else
  Do
  Folder = '<WP_DESKTOP>'
  Say "El objeto se copiar en el Escritorio."
  End
Say ''


/* Destroy the old object, if present. */

Call SysDestroyObject( '<MEMSIZE>' )
Call SysSleep( 5 )


/* Perform the installation. */

Say 'Copiando MEMSIZE al directorio 'Directory' ...'
Copy MEMSIZE.EXE Directory                  '1>NUL'
Copy Language".DLL" Directory"\MEMSIZE.DLL" '1>NUL'
Copy Language".HLP" Directory"\MEMSIZE.HLP" '1>NUL'
Copy Language".DOC" Directory"\MEMSIZE.DOC" "1>NUL"

Result = SysFileTree( "HLP2INF.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Result = SysFileTree( Directory"\MEMSIZE.INF", 'Files', 'F' )
   If Files.0 > 0 Then
      Do
      "Erase" Directory"\MEMSIZE.INF"
      End
   "HLP2INF" Directory"\MEMSIZE.HLP"
   End

Result = SysFileTree( "SNAPSHOT.EXE", 'Files', 'F' )
If Files.0 > 0 Then
   Do
   Copy "SNAPSHOT.EXE" Directory"\SNAPSHOT.EXE"  '1>NUL'
   End

Say "Creando el objeto del programa..."
Type = 'WPProgram'
Title = 'Recursos del Sistema'
Parms = 'OPEN=DEFAULT;MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='Directory'\MEMSIZE.EXE;STARTUPDIR='Directory';OBJECTID=<MEMSIZE>;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say "El objeto se ha creado.  Fin."
Else
  Say "ERROR: No se ha podido crear el objeto!"

Signal DONE

FAILURE:
Say 'Error del REXX.'
Signal DONE

HALT:
Say 'Se ha parado el REXX.'
Signal DONE

SYNTAX:
Say 'Error de sntaxis del REXX.'
Signal DONE

DONE:
Exit
