/* query.cmd - compute connect time                            951222 */
/* (C) Copyright Martin Lafaix 1995.  All rights reserved.            */

/* Recognized command line args

   query date
   query time
   query [timeframe] [detailed] connect time [for ...]
   query [timeframe] [last] connect message [for ...]
   
   timeframe == ((this|last) (year|month)|monthname)
   monthname == JANuary | FEBruary | MARch | APRil | MAY | JUNe | JULy |
                AUGust | SEPtember | OCTober | NOVember | DECember
                
   examples
   
   query connect time
   query this year connect time for user1
   query detailed november connect time for user1 user2 
   query last connect message
*/

arg user_arg
parse arg request

select
   when user_arg = 'DATE' then
      say date()
   when user_arg = 'TIME' then 
      say time()
   when wordpos('CONNECT',user_arg) > 0 then
      say connect()
otherwise
   say 'Unknown request:' request
end  /* select */

exit

connect:
   monthname = '\JANUARY  \FEBRUARY \MARCH    \APRIL    \MAY      \JUNE     '||,
               '\JULY     \AUGUST   \SEPTEMBER\OCTOBER  \NOVEMBER \DECEMBER'
   detailed = wordpos('DETAILED',user_arg) > 0
   msg = wordpos('MESSAGE',user_arg)+wordpos('MESSAGES',user_arg) > 0
   this = wordpos('THIS',user_arg) > 0
   last = wordpos('LAST',user_arg) > 0
   user = wordpos('FOR',user_arg) > 0
   mm = wordpos('MONTH',user_arg)+wordpos('MONTH''S',user_arg) > 0
   yy = wordpos('YEAR',user_arg)+wordpos('YEAR''S',user_arg) > 0
   m = 0
   do i = 1 to words(user_arg)
      w = pos('\'word(user_arg,i),monthname)
      if w > 0 then
         if abbrev(substr(monthname,w+1,9),word(user_arg,i),3) = 1 then
            if m \= 0 then
               return 'Incorrect request:' request
            else
               m = 1 + w % 10
   end /* do */

   count = \user
   if user then
      userlist = substr(request,wordindex(user_arg,wordpos('FOR',user_arg))+4)

   if this & last | mm & yy | mm & (m > 0) then
      return 'Incorrect request:' request

   log = value('ETC',,'OS2ENVIRONMENT')'\Connect.log'
   time = 0
   parse value date('S') with year 5 month 7 .
   if last & mm then month = month-1
   if last & yy then year = year-1
   if yy then month = ''
   if m \= 0 then month = m
   yymm = year'/'month

   message = ''
   curLine = 1
   do while lines(log) \= 0
      line=linein(log); curLine = curLine+1
      if left(line,length(yymm)) = yymm then do
         if substr(line,21,1) = '' then beginning = curLine
         if count & msg & curLine > beginning+2 & substr(line,21,18) <> 'Disconnected after' then
            if last & curLine = beginning+3 then
               message = line
            else
               message = message || copies('0d0a'x,1+(curLine = beginning+3)) || line
         else
         if user & word(line,5) = 'dialed' then 
            count = wordpos(word(line,4),userlist) > 0
         else
         if count & substr(line,21,18) = 'Disconnected after' then
            call sum word(line,5), line
         end
   end

   call stream log, 'c', 'close'

   if msg then
      return message
   else
   if yy then
      return year 'Yearly connect time' (time % 3600)':' || right((time // 3600) % 60,2,0) || ':' || right(time // 60,2,0)
   else
      return year'/'right(month,2,0) 'Monthly connect time' (time % 3600)':' || right((time // 3600) % 60,2,0) || ':' || right(time // 60,2,0)

sum:
   parse value arg(1) with h ':' m ':' s
   if detailed then say word(arg(2),1) arg(1)
   time = time + s + 60 * m + 3600 * h
   return
