/* Translate and compile a NetRexx program             */
/*                                                     */
/* use as:  NETREXXC hello [file2]...                  */
/*                                                     */
/*   which will use the NetRexx translator             */
/*     translate hello.nrx to hello.java               */
/*   then will use JAVAC to compile hello.java         */
/*                                                     */
/* Any NetRexxT (translator) flags may be used, along  */
/* with the following extra flags:                     */
/*                                                     */
/*   -run       = run class after compilation          */
/*   -runpm     = run class as a PM application        */
/*   -keep      = keep the java file after successful  */
/*                compilation (as xxx.java.keep)       */
/*   -nocompile = only translate, do not compile       */
/*                                                     */
/* Multiple programs may be specified; in this case    */
/* they are all run (if requested) after all compiles. */
/*                                                     */
/* ----------                                          */
/* 1996.09.02 -- handle Warnings from NetRexxC (rc=1)  */

parse arg args
w=wordpos('-run', args)
if w>0 then do; run=1;   args=delword(args,w,1); end; else run=0
w=wordpos('-runpm', args)
if w>0 then do; runpm=1; args=delword(args,w,1); end; else runpm=0
w=wordpos('-nocompile', args)
if w>0 then do; noc=1; end; else noc=0


/* ----- Translate & Compile ----- */
'@java netrexx.process.NetRexxC' args

/* ----- Run ----- */
if rc<=1 & (run | runpm) then do
  if noc then say 'Run option ignored as -nocompile specified'
   else do
    if runpm then exe='javapm'; else exe='java'
    do forever /* find the file parameters */
      parse var args file args
      if file='' then leave
      if left(file,1)='-' then iterate
      filename=filespec('n', file); parse var filename fn '.' fe
      /* Now determine the exact case of the class, for java commands */
      file=fn'.class'
      '@dir' file '/n /b 2>nul | rxqueue'    /* use DIR to get exact case */
      if queued()<>1 then do
        if queued()=0 then say 'Cannot find file:' file
        if queued()>1 then do; do queued(); parse pull .; end
          say 'File "'file'" is not a unique specification'
          end
        exit 1; end
      parse pull file                         /* is now correct case */
      parse var file fn '.' fe
      say 'Running' fn '...'
      '@'exe fn
      end
    end
  end

exit rc

