#ifndef _GENERAL_INCLUDED_
#define _GENERAL_INCLUDED_



#define playerFileVersion 2

#define ABS(x) ((x)<0 ? -(x) : (x))
#define SGN(x) ((x)==0 ? 0 : ((x)<0 ? (-1) : 1))

#define EVEN(i) ((i) % 2 == 0)
#define ODD(i) ((i) % 2 == 1)


// attack-tactics
#define uniAtt  0
#define fullAtt  1
#define backAtt  2
#define enterAtt  3
#define planAtt  10
// defense-tactics
#define maxShields  0
#define fullScan  1
#define fighterAtt  2
#define lastLine  3


// for non-Watcom-Compilers, comment out if your compiler knows these types
#ifndef __WATCOMC__
typedef unsigned short USHORT; 
typedef USHORT *PUSHORT;
typedef unsigned char BYTE;
typedef unsigned long BOOL;
typedef unsigned long ULONG; 
#endif

typedef struct password {
                BOOL set;
                char  pwd[20];
};

typedef struct  damageStr  {
        BYTE kind;   // what is damaged: 1,2,4,... (Shields, Engine, Cargoroom, Ops, Beamweapons, Launchers, Fighterbays, Crew)
        BYTE repair; // what is about to be repaired
        };

typedef struct  pos  {
        USHORT x;
        USHORT y;
        };

typedef struct wormHole {
            struct pos startPos;
            struct pos endPos;
};

typedef struct msg  {
        BYTE to;      // (0-9 = Races, 10 = to all, 11 = to the host)
        BYTE from;  // (0-9 = Races, 10 = from the host)
        char subj[20];
        char body[2048];
        };

typedef struct msg *PMsg;

typedef struct  sClass  {
        char name[40];
        BYTE bays;
        USHORT cargo;
        BYTE beams;
        BYTE launchers;
        BYTE spMiss;     //  special shipmission, 0 - 9 :
                               // (no special-mission, Build Dilithium, Hyperspeed, Change climate, Build Fighters,
                               //  Build Torpedos, Build Material, Release Scouts, Build Outpost, Transport Hull)
        USHORT fuel;
        BOOL canCloak;
        USHORT mass;
        BYTE nrOfEng;   // number of engines
        BYTE level;
        BYTE race;
        };

typedef struct sClass *PClass;

typedef struct  shipStruct  {
        char shipname[40];  // initial value: classname + absolute ID
        BYTE classId;
        USHORT torpedos;
        BYTE launcherLevel;  // >= 1
        BYTE beamLevel;      // >= 1
        BYTE beams;
        BYTE launchers;
        USHORT fighters;
        BYTE speed;
        BOOL warp;       // warp or impulse-speed
        struct pos location;
        struct pos way;
        BYTE mission;    // 0-12 :
                               // (Script, Tractor Beam, Attack, Intercept, Lay Mines, Disassemble, Sensor Sweep,
                               //  Mine Sweep, Exploration, Race-Mission 1, Race-Mission 2, Ship-Mission or Cloak, 
                               //  Ship-Mission if ship cloakable)

        BYTE engine; // (level) >= 1
        struct damageStr damage;   // s. struct
        USHORT dilithium;
        USHORT bilithrium;
        USHORT duranium;
        USHORT latinum;
        ULONG money;
        USHORT colonists;
        USHORT targetShip;  // ID of ship to intercept or track
        BOOL cloaked;
        BOOL attack;    // will be set while intercepting with attack
        BYTE attTac;  // (tactic) see at top for values, bit 4 set = no torpedos, bit 5 set = no fighters
        BYTE defTac;  // (tactic)
        BYTE fleet;   // 0 = no fleet
        BYTE prio;   // attack-priority
        BYTE script;  // script-index (>= 0)
        BYTE actScrLine;  // actual scriptLine
        BYTE race;  // 0 - 9
        USHORT id;
        USHORT mines;  // how many mines to lay
        BOOL mineType;  // normal = false, dense = true
        USHORT raceSpec; // release probes/scouts: direction and amount of probes, bits 0-15, bit 0 = northwest, increased clockwise
                                  // metamorph: classId
                                 // steal Tech: bits 0 - 3: Level, 4: hullLev, 5: engLev, 6: beam-lev, 7: launLev
                                // transport hull: shipclass
        };

typedef struct shipStruct *PShipStruct;

typedef struct  planetStruct {
        BYTE planetclass; // 0 = arctic, 1 = cool, 2 = normal, 3 = warm, 4 = tropic
                                 // bitwise: 8 = holiday, 16 = industry, 32 = military, 64 = technology, 128 = commercial
        USHORT id;               // id-number
        USHORT dilTot;         // dilithium total amount
        USHORT bilTot;         // bilithrium total amount
        USHORT durTot;        // duranium total amount
        USHORT latTot;         // latinum total amount
        USHORT dilMine;         // dilithium mined
        USHORT bilMine;         // bilitihrum mined
        USHORT durMine;        // duranium mined
        USHORT latMine;         // latinum mined
        ULONG money;
        ULONG colonists;
        BYTE tax;               // tax rate
        USHORT primInd[2];      // primary industry (mines, cultivation)
        USHORT secInd[3];        // secondary industry (metallurgy, luxury, food)
        USHORT tertInd[3];       // tertiary industry (police, hospitals, schools)
        USHORT defStat;          // defense-stations
        BYTE defLevel;        // level of above (>= 1)
        BYTE script;             // planet-script to use, 0 = no script
        struct pos location;   // coordinates
        BYTE  base;             // 0 = no base, 1 = base, 2 = base under construction 4 = outpost
        BYTE race;              // native race, 0-9, 10 = no race
        BYTE enemy;              // primary enemy, 0-9, 10 = no enemy - last 4 bits = industry-level
        };

typedef struct planetStruct *PPlanetStruct;

typedef struct scriptStruct {   // for planets
                char name[20];
                BYTE pref[4];     // preferences: 1 = growth, 2 = money, 3 = mine, 4 = defense
                };

typedef struct scriptStruct *PScriptStruct;

typedef struct shScriptStruct {   // for ships
                BYTE order; // GotoPl = 1, GotoSh = 2, GotoLine = 4, Load = 8, Unload = 16
                USHORT param1;    // planet or ship or material
                BYTE param2;   // percentage (only material)
                };

typedef struct shScriptStruct *PShScriptStruct;

typedef struct scrLineStruct {     // for ships
                USHORT linenumbers;
                struct shScriptStruct  scriptLine[50];
                };

typedef struct scrLineStruct *PScrLineStruct;

typedef struct _battleItem {
        BYTE   attTac;   // attack-tactic
        BYTE   defTac;   // defense-tactic
        BYTE   classId;      // if attTac = 10 (planet-attack) => climate of planet
        BYTE   beams;
        BYTE   launchers;
        BYTE   beamLev;
        BYTE   launLev;
        BYTE   bays;
        USHORT   torpedos;
        USHORT   fighters;
        USHORT   mass;
        BYTE race;
        USHORT index; // (Class-ID of ships or planet-ID)
        } battleItem;

typedef battleItem *PBattleItem;

typedef struct  baseStruct {
        USHORT id;     // absolute planet-ID
        BYTE hullLev;  // levels on base ...
        BYTE engLev;
        BYTE beamLev;
        BYTE launLev;
        USHORT newBeam;  // how many beams for next ship
        USHORT newLaun;  // how many launchers for next ship
        BYTE newHullLev;   // class for the new ship...
        BYTE newEngLev;  // levels for the new ships >= 1 !!!  (0 = no item)
        BYTE newBeamLev;
        BYTE newLaunLev;
        short recShip;   // recycle ship-id, -1 = no recycle
        BYTE stockHulls;     // number of different hulls
        BYTE stockEngines;
        BYTE stockBeams;
        BYTE stockLaunchers;
        };

typedef struct baseStruct *PBaseStruct;

typedef struct  fileInXY {  // struct for xyplan.dat
        USHORT x;
        USHORT y;
        USHORT dummy;   // to be compatible with VGA-Planets
        };

typedef struct  fileInNames {  // struct for planet.nm
        char name[18];
        char end[2]; // to be compatible with VGA-Planets
       };


typedef struct playerMine {
        struct pos location;
        BOOL onOff;
        };

typedef struct playerMine *PPlayerMine;


        // API-calls:
extern int getShipnumbers();       // gets number of ships
extern int getPlanetnumbers();   // gets number of planets
extern int getBasenumbers();     // gets number of bases
extern int getMsgnumbers();      // gets number of messages
extern PShipStruct getShip(USHORT nr);        // gets ship with number nr
extern PPlanetStruct getPlanet(USHORT nr);  // gets planet with number nr
extern PBaseStruct getBase(USHORT nr);      // gets base with number nr
extern PMsg getMsg(USHORT nr);                 // gets message with number nr
extern short initAPI(CHAR *name, CHAR *reg);    // initialize structs
extern short openRST(CHAR *fileStr, CHAR *pwd);   // opens rst-file
extern short closeRST();                                 // closes rst-file
extern PSZ queryActualFileName();               // gets current rst-filename
extern PSZ getAPIVersion();                      // returns API-Version
extern PUSHORT getScore();                      // get Pointer to Score-Array
                                                             //   (Turn 1 Score Race1, Race2, ..., Race10
                                                             //    Turn 2 Score Race1, Race2, ..., Race10,
                                                             //    ...,
                                                             //    Last Turn Score Race1, Race2, ..., Race10)
extern short getTurn();                      // returns actual turnnumber
extern PClass getShipClass(short id);   // returns the shipclass of the given ship-class-ID
extern PScrLineStruct getShipScript(short idx);  // returns the given ship-script
extern PScriptStruct getPlanetScript(short idx);  // returns the given planet-script

        // starbase-stocks
// pointer to an array of Byte
// number of material: see basestruct (stockHulls, etc.)
// example getHullEngine returns a pointer to the following bytes:
//              1 2 1 3 2
//              base[index].stockEng = 5
//  =>         2 x Impulse Drive 1, 2 x Impulse Drive 2, 1 x Impulse Drive 3

extern PBYTE getHullStock(short nr);  // returns current hulls in stock of base nr
extern PBYTE getEngineStock(short nr); // returns current engines in stock of base nr
extern PBYTE getBeamStock(short nr); // returns current beamweapons in stock of base nr
extern PBYTE getLauncherStock(short nr); // returns current launchers in stock of base nr

extern short getBattleNr();        // returns number of battles
extern short getBattleShipNr(short battle);        // returns number of ships in battle
extern battleItem getBattleItem(short battle, short shipNr);        // returns battle-item (ship/planet)


/*

error-codes (non-pointer return-values):
 0:     no error
-1:     RST-File or XYPLAN.*-File not found
-2:     wrong password
-3:     no or wrong registration-code
-4:     cheating-task is waiting
-5:     RST-File not opened 
-6:     not initialized

otherwise NULL is returned

if you specified a wrong password or registration-code the task will wait
60 seconds before returning to the command prompt.
if you open another task while one process is waiting, error-code -4 is returned

*/

const char *raceStr[] = {"The Marquis", "The Federation of Planets", "The Krax",
"The Phoenix People", "The Argonauts", "The Magic Empire", "The Metamorphs",
"The Cave-People", "The Anarchists", "The Mercators", "unknown"};


// engine-names
const char  *engine[] = {"Impulse Drive 1", "Impulse Drive 2", "Impulse Drive 3", "Small Warp Drive 1", "Small Warp Drive 2",
                 "Small Warp Drive 3", "Warp Drive", "Special Warp Drive", "Super Warp Drive", "Hyper Warp Drive"};
// fuel-consumption [engine][speed]
const USHORT fConsum[10][11] = {0, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    0, 5,5,5,5,5,5,5,5,5,5,
    0, 2, 2, 2, 2, 2, 2, 2, 2, 2,2,
    0, 5, 10, 15, 20, 25, 30, 35, 40, 45,50,
    0, 5, 10, 15, 20, 25, 30, 35, 40, 45,50,
    0, 5, 10, 15, 20, 25, 30, 35, 40, 45,50,
    0, 5, 10, 15, 20, 25, 30, 35, 40, 45,50,
    0, 2, 5, 7, 9, 11, 13, 15, 17, 19, 22,
    0, 1, 2, 3, 4, 5, 5, 6, 7, 8, 9,
    0, 1, 1, 1, 2, 2, 3, 3, 4, 4, 5};

// maximal speed
const USHORT maxSpeed [10] = {3, 6, 9, 2, 4, 7, 9, 9, 9, 10};

// missions for all races
const  char  *mission[] = {"Script", "Tractor Beam", "Attack", "Intercept", "Lay Mines", "Disassemble", "Sensor Sweep",
                        "Mine Sweep", "Exploration"};
// special race-missions 1
const  char  *raceMission1[] = {"Rob Ship","Calm Population", "Wide Scan",  "Adopt Technology", "Convert Mines",
                "Rob Planet", "Convert Colonists", "Cloak Scan", "Sabotage",  "Trade"};

// special race-missions 2
const  char  *raceMission2[] = {"Pirate Mines", "Steal Mines", "Mislead Scouts", "Super Track","Ground Attack",
        "Release Probes", "Metamorph", "Attack Cloak-Ship","Steal Technologie",  "Spy Ship"};

// special ship-missions
const  char  *shipMission[]  =  {"", "Build Dilithium", "Hyperspeed", "Change climate", "Build Fighters", "Build Torpedos",
                  "Build Material", "Release Scouts", "Build Outpost", "Transport Hull"};

// name of the torpedo-launchers
const  char  *launcherName[] = {"Photon", "Proton", "Photon Cascade", "Heavy Photon", "Heavy Proton",
         "Poseidon", "Nautilus","Heavy Poseidon",  "Heavy Nautilus", "Parabolic Nautilus"};

// name of the beamweapons
const  char *beamName[] = {"Laser", "Disruptor", "Phaser", "Centric Laser", "Hyperbolic Phaser", "Heavy Laser",
        "Heavy Disruptor", "Heavy Phaser", "Parabolic Disruptor", "Parabolic Phaser"};


// name of the kind of damage
const  char  *damageStr[] = {"Shields", "Engine", "Cargoroom", "Ops", "Beamweapons", "Launchers", "Fighterbays", "Crew"};

// cost to repair the specific damages
const  USHORT    repCost[]  =  {80, 30, 30, 40, 20, 40, 40, 50};

//  2^x
const  USHORT pow2[] = {1,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768};


#endif
