#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "api_str.h"


// type in your reg-name and your reg-code

#define RegName "Jupp Zupp"
#define RegCode "RegisterCode"


PClass PShipClass;
PShipStruct PShips[1000];
PPlanetStruct PPlanet[500];
PBaseStruct PBases[500];
PMsg PMessage[100];
battleItem batItem;
struct  fileInNames plName[500];
short battleNr, battleShipNr, turn, nrOfScores, k, mNr, bNr, j, sNr, plNr;
HFILE hfile;
ULONG len, filesize, action;
APIRET rc;
CHAR buffer[10], fileStr[13], pwd[20];
FILE *fp;
short ScoreArray[500][10];
PBYTE pStockLaunchers, pStockBeams, pStockHulls, pStockEng;

void main() {

   strcpy(fileStr,"PLAYER2.RST");
   strcpy(pwd, "");


  printf("Version of API: %s\n", getAPIVersion());

        // initialize structures
   rc = initAPI(RegName, RegCode);
   printf("Init: %d\n",rc);

        // open RST-File
   rc=openRST(fileStr, pwd);
   printf("Open: %d\n",rc);

        // get number of ships
   sNr = getShipnumbers();
   printf("Number of ships: %d\n", sNr);

        // get all ships
   for (j = 0; j < sNr ; j++ ) {
      PShips[j] = getShip(j);
      printf("%s - ", PShips[j]->shipname);
      PShipClass = getShipClass(PShips[j]->classId);
      printf("%s\n", PShipClass->name);
   };

        // get planet-names
   DosOpen("planet.nm", &hfile, &action, 0, 0L, OPEN_ACTION_OPEN_IF_EXISTS,
          OPEN_SHARE_DENYWRITE, 0L);
   DosRead(hfile, plName, 10000, &len);
   DosClose(hfile);
        // fill zero-byte to terminate string
   for (j = 0; j < 500 ; j++) 
     strcpy(plName[j].end, "");

        // get number of planets
   plNr = getPlanetnumbers();
   printf("Number of planets: %d\n", plNr);

        // get all planets
   for (j = 0; j < plNr ; j++ ) {
      PPlanet[j] = getPlanet(j);
      printf("%s\n", plName[PPlanet[j]->id].name);
   };

        // get number of bases
   bNr = getBasenumbers();
   printf("Number of bases: %d\n", bNr);

        // get all bases
   for (j = 0; j < bNr ; j++ ) {
      PBases[j] = getBase(j);
      printf("%s\n", plName[PBases[j]->id].name);
      printf("%d hulls in stock of base %s\n", PBases[j]->stockHulls, plName[PBases[j]->id].name);
      if(PBases[j]->stockHulls != 0) {
         pStockHulls = getHullStock(j);
         for (k = 0; k < PBases[j]->stockHulls ; k++) {
              PShipClass = getShipClass(*(pStockHulls + k));
              printf("%s\n", PShipClass->name);
	 };
      };
      printf("%d engines in stock of base %s\n", PBases[j]->stockEngines, plName[PBases[j]->id].name);
      if(PBases[j]->stockEngines != 0) {
         pStockEng = getEngineStock(j);
         for (k = 0; k < PBases[j]->stockEngines ; k++)                        
              printf("%s\n", engine[*(pStockEng + k)]);
      };
      printf("%d beamweapons in stock of base %s\n", PBases[j]->stockBeams, plName[PBases[j]->id].name);
      if(PBases[j]->stockBeams != 0) {
         pStockBeams = getBeamStock(j);
         for (k = 0; k < PBases[j]->stockBeams ; k++)
              printf("%s\n", beamName[*(pStockBeams + k)]);
      };
      printf("%d launchers in stock of base %s\n", PBases[j]->stockLaunchers, plName[PBases[j]->id].name);
      if(PBases[j]->stockLaunchers != 0) {
         pStockLaunchers = getLauncherStock(j);
         for (k = 0; k < PBases[j]->stockLaunchers ; k++)
              printf("%s\n", launcherName[*(pStockLaunchers + k)]);
      };
   };


        // get number of messages
   mNr = getMsgnumbers();
   printf("Number of messages: %d\n", mNr);

        // get all messages
   for (j = 0; j < mNr ; j++ ) {
      PMessage[j] = getMsg(j);
      printf("%s\n", PMessage[j]->subj);
   };

   // get number of battles
   battleNr = getBattleNr();
   printf("Number of battles: %d\n", battleNr);
   for (j = 0;  j < battleNr; j++) {
     battleShipNr = getBattleShipNr(j);
     printf("Number of ships/planets in battle %d: %d\n", j + 1, battleShipNr);
     for (k = 0; k < battleShipNr ; k++) {
        batItem = getBattleItem(j,k);                 
        if(batItem.attTac != planAtt) {
           PShipClass = getShipClass(batItem.classId);
           printf("%s\n", PShipClass->name);
        }
        else
           printf("Planet %s\n", plName[batItem.index].name);
     };
   };

   fp = fopen("SCORES", "rb");  // File "SCORES" = Turnnumber + ScoreArray
   fseek(fp, 0L, SEEK_END);
   filesize = ftell(fp);
   fseek(fp, 0L, SEEK_SET);
   fread(&turn, sizeof(turn), 1, fp);
   fread(&ScoreArray, filesize - sizeof(turn), 1, fp);
   fclose(fp);
   nrOfScores = (filesize - 2) / 20;

   for (j=0; j < nrOfScores ; j++) {
     for (k = 0; k < 10 ; k++) 
        printf("%s, ", _itoa(ScoreArray[j][k], buffer, 10));
     printf("\n");
   };
 
 

        // get the actual playerfilename
   printf("%s\n", queryActualFileName());

        // close structures
   rc=closeRST();
   printf("Close: %d\n",rc);
};

