extproc perl5 -Sx
#! perl

die "Usage: compare orig-dir actual-dir patchfile\n" unless $#ARGV >= 2;

system("rm -rc $ARGV[1]/*.diff");
unlink($ARGV[2]);

open(F, "find $ARGV[0] -print |") || die "Cannot find\n";
while (<F>) {
	chop;
	next if m'/\.';
	next if m'/config\.'i;
	next if m'/auto'i;
	next if m'/ext/[^/]*/[^/]*\.(bs|bso|c|so)$'i;
	next if m'/hints/';
	next if m'/pod/';
	next if m'/sdbm/';
	next if m'/patches/';
	next if m'\.orig$';
	next if m'/h2ph$';
	next if -d $_;
	substr($_, 0, length($ARGV[0])+1) = "";
	next unless -r "$ARGV[1]/$_";
	print "$_\n";
	if (compare("$ARGV[0]/$_", "$ARGV[1]/$_")) {
		print "   is different\n";
		system("diff -c $ARGV[0]/$_ $ARGV[1]/$_ > $ARGV[1]/$_.diff");
		system("cat $ARGV[1]/$_.diff >> $ARGV[2]");
	}
}
close(F);

sub compare
{
    open(F1, "< $_[0]") or die $_[0];
    open(F2, "< $_[1]") or die $_[1];
    do {
	$l1 = <F1>;
	$l2 = <F2>;
    } while ($l1 eq $l2 && $l1);
    close(F1);
    close(F2);
    return $l1 cmp $l2;
}

exit 0;
