#
# This Makefile is for the library part of sdbm.  For the
# Full package, see makefile.sdbm.
# 
# Makefile for public domain ndbm-clone: sdbm
# DUFF: use duff's device (loop unroll) in parts of the code
#
#
CC = gcc
RANLIB = ar s
TOP = ../../..
ABSTOP = e:/hsrc/perl5
LDFLAGS = 
CLDFLAGS = 
SMALL = 
LARGE =  

# To use an alternate make, set $altmake in config.sh.
MAKE = make

# The following are used to build and install shared libraries for
# dynamic loading.
LDDLFLAGS = 
CCDLFLAGS = 
CCCDLFLAGS = 

SHELL = /bin/sh
CCCMD = gcc -c -O

.c.o:
	$(CCCMD) $(CCCDLFLAGS) -I$(TOP) -DSDBM -DDUFF $*.c

LIBOBJS = sdbm.o pair.o hash.o
LIBSRCS = sdbm.c pair.c hash.c
HDRS = tune.h sdbm.h pair.h $(TOP)/config.h

all:	sdbm.a

sdbm.a: $(LIBOBJS)
	ar cr sdbm.a $(LIBOBJS)
	$(RANLIB) sdbm.a
	emxomf -l sdbm.a
	cp sdbm.a sdbm.lib $(ROOTDIR)/usr/lib/emx

$(LIBOBJS): $(HDRS)

lint:
	lint -abchx $(LIBSRCS)

clean:
	rm -f *.o *.a mon.out core

realclean: 	clean
	rm -f dbu sdbm.a dbd dba dbe x-dbu *.dir *.pag
	rm -f makefile Makefile

purge:	realclean

sdbm.o : sdbm.c $(TOP)/config.h sdbm.h tune.h pair.h 
hash.o : hash.c $(TOP)/config.h sdbm.h 
pair.o : pair.c $(TOP)/config.h sdbm.h tune.h pair.h 

