extproc perl -Sx
#!perl

$zipfile = "perl502b";
$refpath = "e:/perl5.002b3";

@files = grep(chomp, <DATA>);

open(F, "find . -type f -print|") or die "find";
while (<F>) {
  chomp;
  next unless $_;
  s'^./'';
  next if m'~$';			# Emacs backups
  next if -r "$refpath/$_"		# source code and regression tests
       && !m'^(eg|lib|pod)/'i;		# 	of standard distribution
  next if m'^lib/ExtUtils/'i;		# only required for building Perl
  next if m'\.diff$'i;			# diffs for patches
  next if m'\.html$'i;			# HTML docs
  next if m'\bSSB\b'i;			# SSB code
  next if m'^OS2/.*\.zip$'i;		# ZIP files
  next if m'^(ak|info|pod2ipf)/'i;	# my own stuff and zombies
  next if m'^lib/auto/GDBM_File'i;	# GNU license
  next if m'\.obj$'i || m'\.o$'i;	# intermediate files
  next if m'\.lib$'i || m'\.a$'i;
  next if m'^ext/(.*/)?(\w+)/(\w+)\.(bs|c|def|in)'i
       && lc($2) == lc($3);		# generated files
  next if m'^ext/SDBM_File/'i;		# no longer distributed
  next if m'^ext/DB2CLI/const.h$'i;
  next if m'^config.h$'i;
  next if m'^config.sh$'i;
  next if m'^makefile.mk$'i;
  next if m'^writemain'i;
  next if m'^main_'i;
  next if m'^miniperl\.'i;
  next if m'^sed\.'i;
  next if m'^perl5x$'i;
  next if m'^perl5.*\.(zip|def)$'i;
  next if m'^OS2/save.cmd'i;
  push @files, $_;
}
close(F);

open(F, "|zip -ru9@ $zipfile") or die "zip";
foreach (@files) {
  print F "$_\n";
}
close(F);

exit(0);

__END__
README
Artistic
Copying
