use DB2CLI;

SQLAllocEnv($henv)				and message("AllocEnv");
SQLAllocConnect($henv, $hdbc)			and message("AllocConnect");
SQLConnect($hdbc, 'SAMPLE', 'AK', '')		and message("Connect");
SQLAllocStmt($hdbc, $hstmt)			and message("AllocStmt");

SQLPrepare($hstmt, <<)				and message("Prepare");
	SELECT name,salary FROM ADMIN.STAFF
        WHERE salary >= ?

SQLExecute($hstmt, 20000)			and message("Execute");

while (($r = SQLFetch($hstmt)) == 0) {
    SQLGetData($hstmt, 1, SQL_C_CHAR(), $name)	and message("GetData");
    SQLGetData($hstmt, 2, SQL_C_DOUBLE(), $sal)	and message("GetData");
    print "$name,$sal\n";
}
message("Fetch", $r) if $r != SQL_NO_DATA_FOUND();

SQLFreeStmt($hstmt)				and message("FreeStmt");
SQLDisconnect($hdbc)				and message("Disconnect");
SQLFreeConnect($hdbc)				and message("FreeConnect");
SQLFreeEnv($henv)				and message("FreeEnv");

exit 0;

sub message
{
    my ($where, $retcode) = @_;
    my ($state, $native, $text);
    if (SQLError($henv, $hdbc, $hstmt, $state, $native, $text) >= 0) {
	print "$where: $state,$native: $text\n";
	exit 1;
    }
    print "$where: cannot retrieve error info, retcode=$retcode\n";
    exit 2;
}
