#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#undef SNMP_DPI_VERSION
#undef SNMP_DPI_RELEASE
#define SNMP_DPI_VERSION 2
#define SNMP_DPI_RELEASE 0

#include "snmp_dpi.h"
#include "dpiconst.h"

typedef struct {
        STRLEN	len;
        void *	ptr;
} DPIString;

typedef unsigned char *	DPIPacket;
typedef void *		DPIPointer;

static int
not_here(char *s)
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

static long
constant(name, arg)
char *name;
int arg;
{
	const struct DpiConst *p = in_word_set(name, strlen(name));
	if (p) {
		errno = 0;
		return p->val;
	}
	errno = ENOENT;
	return 0;
}


MODULE = DPI		PACKAGE = DPI


double
constant(name,arg)
	char *		name
	int		arg

int
DPIawait_packet_from_agent(handle,timeout,message)
	int		handle
	int		timeout
	DPIString	message = NO_INIT
    CODE:
	RETVAL = DPIawait_packet_from_agent(handle,timeout,
		(unsigned char **)&message.ptr,(unsigned long *)&message.len);
    OUTPUT:
	RETVAL
	message

int
DPIconnect_to_agent_NMQ(t_qname,s_qname)
	char *		t_qname
	char *		s_qname

int
DPIconnect_to_agent_TCP(hostname,community)
	char *		hostname
	char *		community

int
DPIconnect_to_agent_UDP(hostname,community)
	char *		hostname
	char *		community

void
DPIdisconnect_from_agent(handle)
	int		handle

int
DPIsend_packet_to_agent(handle,message)
	int		handle
	DPIString	message
    CODE:
	RETVAL = DPIsend_packet_to_agent(handle,message.ptr,message.len);
    OUTPUT:
	RETVAL
	message

int
lookup_host(hostname)
	char *		hostname

int
query_DPI_port(hostname,community,porttype=dpiPortForTCP)
	char *		hostname
	char *		community
	int		porttype

void
DPIdebug(level=0)
	int		level

void
fDPIparse(hdr)
	DPIPointer	hdr

void
fDPIset(packet)
	DPIPointer	packet

DPIPacket
mkDPIAreYouThere()

# DPIPacket
# mkDPIbulk(non_repeaters,max_repetitions,packet)
#	long		non_repeaters
#	long		max_repetitions
#	DPIPointer	packet

DPIPacket
mkDPIclose(reason_code)
	short		reason_code

DPIPointer
mkDPIget(packet,group,instance)
	DPIPointer	packet
	char *		group
	char *		instance

DPIPointer
mkDPIhdr(type)
	int		type

DPIPointer
mkDPIhdr_version(type,version,release)
	int		type
	short		version
	short		release

DPIPointer
mkDPInext(packet,group,instance)
	DPIPointer	packet
	char *		group
	char *		instance

DPIPacket
mkDPIopen(oid,description,timeout,max_varBinds,character_set,password)
	char *		oid
	char *		description
	unsigned long	timeout
	unsigned long	max_varBinds
	short		character_set
	DPIString	password
    CODE:
	RETVAL = mkDPIopen(oid,description,timeout,max_varBinds,character_set,
			password.len,password.ptr);
    OUTPUT:
	RETVAL

DPIPacket
mkDPIpacket(hdr)
	DPIPointer	hdr

DPIPacket
mkDPIregister(timeout,priority,group,bulk_select)
	unsigned short	timeout
	long		priority
	char *		group
	short		bulk_select

DPIPacket
mkDPIresponse(hdr,error_code,error_index,packet)
	DPIPointer	hdr
	long		error_code
	long		error_index
	DPIPointer	packet

DPIPointer
mkDPIset(packet,group,instance,type,value)
	DPIPointer	packet
	char *		group
	char *		instance
	int		type
	DPIString	value
    CODE:
	RETVAL = mkDPIset(packet,group,instance,type,value.len,value.ptr);
    OUTPUT:
	RETVAL

DPIPacket
mkDPItrap(generic,specific,packet=NULL,enterprise=NULL)
	long		generic
	long		specific
	DPIPointer	packet
	char *		enterprise

DPIPacket
mkDPIunregister(reason_code,group)
	short		reason_code
	char *		group

DPIPointer
pDPIpacket(packet)
	DPIPointer	packet
