# NOTE: Derived from lib/DB2CLI.pm.  Changes made here will be lost.
package DB2CLI;

sub Connect
{
    my ($class, $database, $user, $pw) = @_;
    my ($henv, $hdbc, $rc);
    if ($rc = SQLAllocEnv($henv)) {
	warn "SQLAllocEnv failed with rc=$rc\n";
	return undef;
    }
    if ($rc = SQLAllocConnect($henv, $hdbc)) {
	iMessage($henv, undef, undef, "SQLAllocConnect", $rc);
	SQLFreeEnv($henv);
	return undef;
    }
    my $connRef = bless { HENV => $henv, HDBC => $hdbc, DATABASE => $database };
    if ($rc = SQLConnect($hdbc, $database, $user, $pw)) {
	$connRef->Message("SQLConnect to $database", $rc);
	SQLFreeConnect($hdbc);
	SQLFreeEnv($henv);
	return undef;
    }
    return $connRef;
}

1;
