/* REXX **********************************************/
/*                                                   */
/* Description: This file is the collection of some  */
/*            : Rexx-algorithms. Following templates */
/*            : are placed at your's disposal at the */
/*            : moment:                              */
/*            :  1. Binary search                    */
/*            :  2. Bubble sort                      */
/*            :  3. Insertion sort                   */
/*            :  4. Quick sort                       */
/*            :  5. Shell sort                       */
/*            :  6. Square root                      */
/*            :  7. Digital Audio Player (mciRexx)   */
/*            :  8. Translation to lower case        */
/*            :  9. Translation date to the julian   */
/*            :     date                             */
/*            : 10. Translation julian date to the   */
/*            :     date                             */
/*            : All these code templates are written */
/*            : as internal subroutines.             */
/*                                                   */
/* Author.....: Janosch R. Kowalczyk                 */
/*              Oberwaldstr. 42                      */
/*              63538 Grosskrotzenburg / Germany     */
/*              Tel: +49 (0)6186 201676              */
/*              Fax: +49 (0)6186 470                 */
/*              Compuserve: 101572,2160              */
/*                                                   */
/* Create date: 26 May 1996                          */
/* Version....: 1.0                                  */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/* Made use of GREED.  26 May 1996 / 12:29:24   JRK  */
/*****************************************************/

Say 'This file is the collection of the sample internal'
Say 'Rexx-subroutines with some necessary algorythms such'
Say 'as: various sorts, search, square root...'
Say
Say 'Refer to the source code of this file for more'
Say 'informations, please.'
Say 
Say 'Call the sample test-routine named TESTALG1.CMD to'
Say 'test these procedures.'


Exit

/*===============(Internal subroutines)==============*/

/*==================(Binary search)==================*/
/* :-))                                              */
/* Name.......: BiSearch                             */
/*                                                   */
/* Function...: Search a stem variable for a value   */
/* Call parm..: Search value                         */
/* Returns....: 0 if nothing found                   */
/*              index of the found value             */
/* Sample call: found_index = BiSearch(value)        */
/*              If found_index = 0 Then              */
/*                Say 'Value' value 'not found!'     */
/*              Else                                 */
/*                Say stem.found_index               */
/*                                                   */
/* Notes......: The elements to search for must be   */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*              The stem-variable must be in the     */
/*              sorted order                         */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

BiSearch: Procedure Expose stem.

Parse Arg value           /* Search value            */

found  = 0                /* Index of the found Item */
bottom = 1                /* Index of the first Item */
top    = stem.0           /* Index of the last Item  */

/*------------------(Binary Search)------------------*/
Do While found = 0 & top >= bottom
  mean = (bottom + top) % 2
  If value = stem.mean Then
    found = mean
  Else If value < stem.mean Then
    top = mean - 1
  Else
    bottom = mean + 1
End /* Do While */

Return found


/*===================(Bubble sort)===================*/
/* :-I                                               */
/* Name.......: BubSort                              */
/*                                                   */
/* Function...: Bubble Sort for a stem variable      */
/* Call parm..: No                                   */
/* Returns....: nothing (NULL string)                */
/*                                                   */
/* Sample call: Call BubSort                         */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

BubSort: Procedure Expose stem.

/*------------(Bubble Sort for the Stem)-------------*/
Do i = stem.0 To 1 By -1 Until flip_flop = 1
  flip_flop = 1
  Do j = 2 To i
    m = j - 1
    If stem.m > stem.j Then Do
      xchg   = stem.m
      stem.m = stem.j
      stem.j = xchg
      flip_flop = 0
    End /* If stem.m ... */
  End /* Do j = 2 ...    */
End /* Do i = stem.0 ... */

Return ''


/*=================(Insertion sort)==================*/
/* :-!                                               */
/* Name.......: InsSort                              */
/*                                                   */
/* Function...: Insertion Sort for a stem variable   */
/* Call parm..: No                                   */
/* Returns....: nothing (NULL string)                */
/*                                                   */
/* Sample call: Call InsSort                         */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

InsSort: Procedure Expose stem.

/*------------(Insertion Sort for Stem)--------------*/
Do x = 2 To stem.0
  xchg = stem.x
  Do y = x - 1 By -1 To 1 While stem.y > xchg
    xchg   = stem.x
    stem.x = stem.y
    stem.y = xchg
    x = y
  End /* Do y = x... */
  stem.x = xchg
End /* Do x = 2 ...  */

Return ''


/*====================(Quick sort)===================*/
/* :-))                                              */
/* Name.......: QSort                                */
/*                                                   */
/* Function...: Quick Sort for a stem variable       */
/* Call parm..: No                                   */
/* Returns....: Left-Right span                      */
/*                                                   */
/* Sample call: Call QSort                           */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

QSort: Procedure Expose stem.

/*--------------(Quick Sort for Stem)----------------*/
Arg left, right

If left  = '' Then left  = 1
If right = '' Then right = stem.0
If right > left Then Do
  i = left
  j = right
  k = (left+right)%2
  x = stem.k
  Do Until i > j
    Do While stem.i < x; i = i + 1; End
    Do While stem.j > x; j = j - 1; End
    If i <= j Then Do
      xchg = stem.i
      stem.i = stem.j
      stem.j = xchg
      i = i + 1
      j = j - 1
    End
  End
  y = QSort(left,j)
  y = QSort(i,right)
End

Return right - left 


/*====================(Shell sort)===================*/
/* :-)                                               */
/* Name.......: ShlSort                              */
/*                                                   */
/* Function...: Shell Sort for a stem variable       */
/* Call parm..: No                                   */
/* Returns....: nothing (NULL string)                */
/*                                                   */
/* Sample call: Call ShlSort                         */
/*                                                   */
/* Notes......: The elements to sort for must be     */
/*              saved in the stem named so as the    */
/*              stem in this Procedure (in this case */
/*              "STEM.")                             */
/*              stem.0 must contain the number of    */
/*              elements in stem.                    */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

ShlSort: Procedure Expose stem.

/*---------------(Shell Sort for Stem)---------------*/
parts = 3       /* adjust to your necessities ( >1 ) */
Do n = 1 To parts
  incr = 2**n - 1
  Do j = incr + 1 To stem.0
    i = j - incr
    xchg = stem.j
    Do While xchg < stem.i & i > 0
      m = i + incr
      stem.m = stem.i
      i = i - incr
    End /* Do While xchg ... */
    m = i + incr
    stem.m = xchg
  End /* Do j = incr ... */
End /* Do n = 1 ... */

Return ''


/*===================(Square root)===================*/
/* :-)                                               */
/* Name.......: SqrRoot                              */
/*                                                   */
/* Function...: Square root evolution for the call   */
/*              parameter                            */
/* Call parms.: Evolution number, precision          */
/* Returns....: Square root                          */
/*                                                   */
/* Syntax.....: sqrt = SqrRoot(number, [precision])  */
/*                                                   */
/* Notes......: precision is the highest possible    */
/*              error for the evaluation.            */
/*              Default Value is 0.00001             */
/*              You are responsible for the valid    */
/*              number value                         */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/

SqrRoot: Procedure Expose stem.

/*--------------(Square root evolution)-------------*/
Arg number, precision

If Datatype(number) \= 'NUM' Then Return -1
If precision <= 0 | precision > 1 Then precision = 0.00001

sqrt = 1
 
Do Until Abs(sqrt_old - sqrt) < precision
  sqrt_old = sqrt
  sqrt = (sqrt_old * sqrt_old + number) / (2 * sqrt_old)
End /* Do Until ... */

Return sqrt


/*============(Play digital WAV/MID file)============*/
/* :-)                                OS/2 Only!!!   */
/* Name.......: PlayFile                             */
/*                                                   */
/* Function...: Play digital WAV/MID file            */
/*                                                   */
/* Call parms.: File name to play                    */
/* Returns....: RC from the last mciRexx function    */
/*                                                   */
/* Sample call: rc = PlayFile('bach.mid')            */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
PlayFile: Procedure

Arg CmdObject
If CmdObject = '' Then Return -1

loudness = 70 /* % */
/*--------------(Prepare MCI-commands)---------------*/
CmdStr.1 = 'OPEN' CmdObject 'ALIAS W WAIT'
CmdStr.2 = 'SET W TIME FORMAT MS WAIT'
CmdStr.3 = 'SET W AUDIO VOLUME' loudness 'WAIT'
CmdStr.4 = 'PLAY W WAIT'
/*------------(Play digital WAV/MID file)------------*/
Do i = 1 To 4
  /*-------(Send MCI command strings)--------*/
  rc = mciRxSendString(CmdStr.i, 'retstrvar', '0','0')
  If rc > 0 Then Leave
End

CmdStr = 'CLOSE W WAIT'
/*-------------(Send MCI command string)-------------*/
rc = mciRxSendString(CmdStr, 'retstrvar', '0','0')

Return rc


/*=============(Translate To Lower Case)=============*/
/* :-)                                               */
/* Name.......: ToLower                              */
/*                                                   */
/* Function...: Translate entired string to lower    */
/*              case                                 */
/* Call parms.: String to translate                  */
/* Returns....: Translated string                    */
/*                                                   */
/* Syntax.....: lowString = ToLower(upperString)     */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
ToLower: Procedure

/*-----------(Lower Case entired string)------------*/
Parse Arg Upper_String

Lowers='abcdefghijklmnopqrstuvwxyz'
Uppers='ABCDEFGHIJKLMNOPQRSTUVWXYZ'

Return Translate(Upper_String,Lowers,Uppers)


/*===================(Test routines)=================*/
/*                                                   */
/* Name.......: RandomStem                           */
/*                                                   */
/* Function...: Fills the stem with random numbers   */
/*                                                   */
/* Call parm..: Number of items  (default = 10)      */
/* Returns....: Nothing (NULL string)                */
/*                                                   */
/* Syntax.....: Call RandomStem number               */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
RandomStem: Procedure Expose stem.

Arg number

If Datatype(number) \= 'NUM' Then number = 10
stem.0 = number

Do i = 1 To number
  stem.i = Random( )
  Say stem.i
End

Return ''

/*==========(Translate date to julian date)==========*/
/*                                                   */
/* Name.......: G2J                                  */
/*                                                   */
/* Function...: translates gregorian date to the     */
/*              julian date                          */
/* Call parm..: gregorian date in format yyyy.mm.dd  */
/* Returns....: julian date (yyyy.ddd)               */
/*                                                   */
/* Syntax.....: julDate = G2J(yyyy.mm.dd)            */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
G2J: Procedure
Arg gregDat

year = SubStr(gregDat,1,4)
mon  = SubStr(gregDat,6,2) + 0
day  = SubStr(gregDat,9,2)

mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334

If year // 4 = 0 & year // 400 > 0 & mon > 2 Then leap = 1
Else leap = 0

julDay = mon.mon + day + leap

Return year'.'julDay


/*==========(Translate julian date to date)==========*/
/*                                                   */
/* Name.......: J2G                                  */
/*                                                   */
/* Function...: translates julian to gregorian date  */
/*              julian date                          */
/* Call parm..: julian date in format yyyy.ddd       */
/* Returns....: julian date (yyyy.mm.dd)             */
/*                                                   */
/* Syntax.....: gregDate = J2G(yyyy.gdd)             */
/*                                                   */
/* Changes....: No                                   */
/*                                                   */
/*===================================================*/
J2G: Procedure
Arg julDate

Parse Var julDate year'.'jday

mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334


Do i = 1 To 12 Until jday < mon.i
End

mon = i - 1

If year // 4 = 0 & year // 400 > 0 & mon > 2 Then leap = -1
Else leap = 0

day = jday - mon.mon + leap
gregDate = year'.'Right(mon,2,'0')'.'Right(day,2,'0')

return gregDate
