/* REXX *********************************************/
/*                                                  */
/* Program name: J2G                                */
/* Function    : translates julian date to gregorian*/
/*               date                               */
/* Syntax      : gDat = J2G(yyyy.ddd)               */
/* Changes     :                                    */
/* Author      : Janosch R. Kowalczyk               */
/*                                                  */
/* Made use of GREED.  09 Jul 1996 / 18:08:30   JRK */
/****************************************************/
Parse Arg julDate

If julDate = '' Then julDate = 1983.267

If julDate > '' Then Do
  /*-------------(Exceptions handling)--------------*/
  Signal On Failure Name BEENDEN
  Signal On Halt Name BEENDEN
  Signal On Syntax Name BEENDEN

  julDate = TestDate(julDate)
  Say julDate '--->' J2G(julDate)

End
Else
  Call HelpText
/*-------------------(End program)------------------*/
Exit

BEENDEN:
Say 'GREED001E - Break, Failure or Syntax Error'
Exit


HelpText: Procedure

Say 'Syntax:'
Say
Say 'J2G julian_date'
Say
Say 'julian_date has format: yyyy.ddd (0 < ddd < 367)'

Return


/*===============(Test plausibilty)================*/
TestDate: Procedure
Arg julDate

Parse Var julDate year '.' jday
If jday = '' Then Do
  jday = year
  Parse Value Date() With . . year .
End
If jday < 0 ! jday > 366 Then Do
  Call HelpText
  Exit
End
If Length(year) = 2 Then year = '19' || year

Return year || '.' || jday


/*=========(Julian Date to Gregorian Date)==========*/
J2G: Procedure
/*--------------------------------------------------*/
/*                                                  */
/* Program name: J2G                                */
/* Function    : translates julian to gregorian     */
/*               date                               */
/* Syntax      : J2G yyyy.ddd                       */
/* Author      : Janosch R. Kowalczyk               */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  09 Jul 1996 / 18:08:30   JRK */
/*--------------------------------------------------*/
Arg julDate

Parse Var julDate year'.'jday

mon.1  = 0
mon.2  = 31
mon.3  = 59
mon.4  = 90
mon.5  = 120
mon.6  = 151
mon.7  = 181
mon.8  = 212
mon.9  = 243
mon.10 = 273
mon.11 = 304
mon.12 = 334


Do i = 1 To 12 Until jday < mon.i
End

mon = i - 1

If year // 4 = 0 & year // 400 > 0 & mon > 2 Then leap = -1
Else leap = 0

day = jday - mon.mon + leap
gregDate = year'.'Right(mon,2,'0')'.'Right(day,2,'0')

return gregDate


