/* Rexx Program */

env = "OS2ENVIRONMENT"
Parse Arg Argv
argc = words(argv)

len = value("CONTENT_LENGTH",,env)
post_string = charin(,,len)  /* read only the number specified in CONTENT_LENGTH */

nf = ParseQueryString(post_string)
do i = 1 to nf
   if Parms.Tag.i = 'HCODE' Then
      hcode = Parms.XVal.i 
   if Parms.Tag.i = 'MODULE' Then
      module = Parms.XVal.i
   if Parms.Tag.i = 'FUNCTION' Then
      func = Parms.Xval.i
   if Parms.Tag.i = 'LEVEL' Then
      level = Parms.Xval.i 
end

call RxFuncAdd 'RxLoadFuncsCP290', 'RxCP290', 'RxLoadFuncsCP290'
call RxLoadFuncsCP290                      /* Load RxCP290 Routines           */
CP290 = ''                                 /* Initialize Com Port Handle Var  */ 
rc = RxInitCP290('COM2', 'CP290')          /* Initialize Com Port             */
ret = RxDirCmdCP290(CP290, level, func, hcode, module) /* Issue a direct command */
ret = 0
do while ret < 5
   ret = RxCmdUploadCP290(CP290, 'report')  /* Get the Report upon completion  */
end
RxCloseCP290(CP290)                        /* Close Communications            */
Say "Content-type: text/html"
Say
Say "<Head><Title>Demonstration of CGI -> X10 Interface</Title></Head>"
Say "<Body><H1>Results of Command</H1>"
if ret > 5 then
   do
     Say 'Module 'report.1 report.3.1' is now 'report.2
   end
else
     say "Communications Error"
exit

/* Do not modify below this line --  Important parsing code... */

ParseQueryString: procedure expose Parms. NFields
  Parse arg P
  i = 1
  do while ((P \= '') & (i < 10))
     Parse var P Parms.Text.i '&' rest
     Parse var Parms.Text.i Parms.Tag.i '=' Parms.KeyVal.i
     Parms.Tag.i = translate( Parms.Tag.i)
     Parms.XVal.i=DecodeKeyVal( Parms.KeyVal.i)
     P = rest
     i = i + 1
  end
  NFields = i - 1
  return NFields

DecodeKeyVal: procedure
  parse arg Code
  Text=''
  Code=translate(Code, ' ', '+')
  rest='%'
  do while (rest\='')
     Parse var Code T '%' rest
     Text=Text || T
     if (rest\='') then
      do
        ch = left( rest,2)
        c=X2C(ch)
        Text=Text || c
        Code=substr( rest, 3)
      end
  end
  return Text

