/* Rexx Program to Test RXCP290 Routines */

/* Load RxCP290 Routines                 */

call RxFuncAdd 'RxLoadFuncsCP290', 'RxCP290', 'RxLoadFuncsCP290'
call RxLoadFuncsCP290
say 'RxLoadFuncsCP290, CP290rc:   'CP290rc

/* Initialize Com Port Handle Variable  */
CP290 = '' 

/* Initialize Com Port                  */

rc = RxInitCP290('COM2', 'CP290')
say 'RxInitCP290:   'rc', CP290rc:   'CP290rc
 

/* Get All Events from CP290 */

rc = RxGetEventsCP290(CP290, 'events')
say 'RxGetEventsCP290:  'rc

/* Print Out events information */

say

do i=0 to 127
  if events.i.0 = 1 then
     Do 
       say 'events.'i'.0  :  'events.i.0
       say 'events.'i'.1  :  'events.i.1
       say 'events.'i'.2.0:  'events.i.2.0
       Do j = 1 to events.i.2.0
	  say 'events.'i'.2.'j':  'events.i.2.j
       end
       say 'events.'i'.3  :  'events.i.3
       say 'events.'i'.4  :  'events.i.4
       say 'events.'i'.5.0:  'events.i.5.0
       Do j = 1 to events.i.5.0
	  say 'events.'i'.5.'j':  'events.i.5.j
       end
       say 'events.'i'.6  :  'events.i.6
       say 'events.'i'.7  :  'events.i.7
       say 'events.'i'.8  :  'events.i.8
     end
end

/* Save the events information        */

file = "testfile.sav"
call SaveEvents file 


/* Erase the internal events structure */
events. = 0

/* Retrieve the Events from a file     */

call RtrvEvents file 

/* Print out Events retrieved   */

say
do i=0 to 127
  if events.i.0 = 1 then
     Do 
       say 'events.'i'.0  :  'events.i.0
       say 'events.'i'.1  :  'events.i.1
       say 'events.'i'.2.0:  'events.i.2.0
       Do j = 1 to events.i.2.0
	  say 'events.'i'.2.'j':  'events.i.2.j
       end
       say 'events.'i'.3  :  'events.i.3
       say 'events.'i'.4  :  'events.i.4
       say 'events.'i'.5.0:  'events.i.5.0
       Do j = 1 to events.i.5.0
	  say 'events.'i'.5.'j':  'events.i.5.j
       end
       say 'events.'i'.6  :  'events.i.6
       say 'events.'i'.7  :  'events.i.7
       say 'events.'i'.8  :  'events.i.8
     end
end

/* Erase CP290 Timer Events              */

rc = RxSetHCodeCP290(CP290, "D")

/* Reload CP290 Events from events.      */

do i = 0 to 127
   if events.i.0 = 1 then
    do
      /* Create name of events entry - events.1, events.2, etc. */
      evt = 'events.'||i         
      rc = RxDwnLdEvtCP290(CP290, i, evt)
      say 'RxDwnLdEvtCP290: rc = 'rc ' Event number: 'i
    end
end

/* Close Communications                  */

rc = RxCloseCP290(CP290)
say 'RxCloseCP290:  'rc', CP290rc:   'CP290rc

/* Drop RXCP290 Functions */

call RxDropFuncsCP290 
say 'RxDropFuncsCP290, CP290rc:  'CP290rc

exit

SaveEvents: Procedure Expose events. 
   arg filenm 

call lineout filenm, ,1
do i=0 to 127
   call lineout filenm,  events.i.0
   if events.i.0 = 1 then
      Do
       call lineout filenm,  events.i.1 
       call lineout filenm,  events.i.2.0
       Do j = 1 to events.i.2.0
	  call lineout filenm,  events.i.2.j
       end
       call lineout filenm,  events.i.3
       call lineout filenm,  events.i.4
       call lineout filenm,  events.i.5.0
       Do j = 1 to events.i.5.0
	  call lineout filenm,  events.i.5.j
       end
       call lineout filenm,  events.i.6
       call lineout filenm,  events.i.7
       call lineout filenm,  events.i.8
     end
end
call lineout(filenm)
return   

RtrvEvents: Procedure Expose events.
   arg filenm 

call linein filenm, ,0
do i=0 to 127
   events.i.0 = linein(filenm)
   if events.i.0 = 1 then
      Do
       events.i.1 = linein(filenm)
       events.i.2.0 = linein(filenm)
       Do j = 1 to events.i.2.0
          events.i.2.j = linein(filenm)
       end
       events.i.3 = linein(filenm)
       events.i.4 = linein(filenm)
       events.i.5.0 = linein(filenm)
       Do j = 1 to events.i.5.0
          events.i.5.j = linein(filenm)
       end
       events.i.6 = linein(filenm)
       events.i.7 = linein(filenm) 
       events.i.8 = linein(filenm)
     end
end
return   







