/* An example of setting a timeout for a window */

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE


/* ====================== 'Main Window' ======================= */
/* First Group is TEXT */
RXTYPE.1 = 'TEXT'

/* Default */
RXFLAGS.1 = ' '

/* Text lines */
RXLABEL.1 = "Example of a timeout. Here's the elapsed seconds:"

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases */
RXINFO.1 = '1 1 0 0'

/* Position */
RXX.1 = 10
RXY.1 = 30

/* Use another TEXT Group to display the elapsed timeout */
RXTYPE.2 = 'TEXT'

/* Default */
RXFLAGS.2 = ' '

/* Text lines */
RXLABEL.2 = '0'

/* TotalPhrases, PhrasesPerLine, WidthOfPhrase, BetweenPhrases. Note that
 we deliberately set WidthOfPhrase non-0 to allow enough width to accomodate
 a range of text digits */
RXINFO.2 = '1 1 64 0'

/* Position */
RXX.2 = 10
RXY.2 = 10

/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '
RXDLG 2 '"Main Window"' 'RXWINMAIN' 'NOCLOSE|RESULT'

/* Start with 0 seconds */
Seconds=0

/* Setup a timeout (in Main Window) for 1000 milliseconds (ie, every second) */
RXSET '""' 'TIME' 1000

more:
   /* Do user interaction (and also timeout). We go to sleep while user
      manipulates the window and timer counts down, until such time as the
      user presses ESC or ENTER if the window's RESULT Flag is set, or tries
      to close a dialog using its CLOSE ICON, or uses a RESULT Group, or
      uses some Group with its END Flag set, or presses a key if the window's
      KEYS Flag is set, or the timer times out */
   RXDLG  /* NOTE: No window title means "use Main Window". No operation
		   specified means an operation of 0 (ie, PROCESS) */

   /* RXWIND now specifies which window woke us up. (The window is still
      there because we specified NOCLOSE). NOTE: All of the RXVAL and any
     LIST/DROP BOX stem variables, RXID, RXSUBID, and RXWIND variables and the
      Dimensions string for that window) have been setup according to the
      state of this window when RXDLG returned */

   /* Did user press ESC or click on the CLOSE ICON? Note that we haven't set
      the KEYS flag of any window, so we don't need to check for particular
      negative values of RXID because the only 2 we ever receive here are
      for the ESC key and CLOSE ICON */
   IF RXID < 0 THEN EXIT

   /* If user didn't abort, then check if this is a timeout (ie, both RXID and
      RXSUBID are 0) */
   IF RXID+RXSUBID = 0 THEN DO
       Seconds = Seconds+1
       RXSET '"Main Window"' 2 1 'VAL' Seconds
   END

   /* NOTE: We have no RESULT Group nor any Groups with the END Flag set,
      so there's no need to further check for RXID being anything but -1 or 0,
      and therefore what we must have here is the ENTER key (ie, RXID=0,
      RXSUBID=10) */
   ELSE DO
      /* Throw up a RXSAY message. This will cause us to stop here until the
	 user dismisses the box. Note that during this time, our display isn't
	 updating because we need to be sleeping in RXDLG in order for any
	 timeouts to be received */
      RXSAY 'ENTER pressed.'
   END

/* Do another message loop */
SIGNAL more

/* ========================== Done ========================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
