#include "example.h"

void GetScrSize ( int *piScrW, int *piScrH )
/* Fetch out current width and height of screen */
{
   #ifdef GUI
   #ifdef OS2
   RECTL Rect;
   WinQueryWindowRect (hWndClient, &Rect);
   *piScrW = Rect.xRight;
   *piScrH = Rect.yTop;
   #else
   *piScrW = getmaxx ();
   *piScrH = getmaxy ();
   #endif
   #else
   struct text_info ti;
   gettextinfo (&ti);
   *piScrW = ti.screenwidth;
   *piScrH = ti.screenheight;
   #endif
}

void ClrScr ( void )
/* Clear the screen */
{
   #ifdef GUI
   #ifdef OS2
   RECTL Rect;
   WinQueryWindowRect (hWndClient, &Rect);
   WinFillRect (hPS, &Rect, CLR_BLACK);
   #else
   cleardevice ();
   #endif
   #else
   clrscr ();
   #endif
}

void Pause ( int iMilliSeconds )
/* Sleep specified number of milliseconds */
{
   #ifdef OS2
   DosSleep (iMilliSeconds);
   #else
   delay (iMilliSeconds);
   #endif
}
