/********************************************/
/*                                          */
/*    Soup KIDchen installation program     */
/*                                          */
/********************************************/

TRACE 'OFF'
ADDRESS CMD

'@ECHO OFF'
'cls'


SAY "Soup KIDchen v1.01s Installation"
SAY "-------------------------------"
SAY ""
SAY ""
SAY "This installation utility will install Soup KIDchen to your hard"
SAY "disk in the directory of your choice, and then create desktop objects"
SAY "for Soup KIDchen if you desire."
SAY ""
SAY "Neither this installation program nor Soup KIDchen itself modifies"
SAY "any files outside of the Soup KIDchen directory."
SAY ""
SAY "You will need about 7 megabytes of free space on the drive where"
SAY "Soup KIDchen is to be installed."
SAY ""
SAY "This version of Soup KIDchen is equivalent to version 1.00s with the"
SAY "exception that all the sounds are 8-bit rather than 16-bit."
SAY ""

CALL RxFuncAdd SysLoadFuncs, RexxUtil, SysLoadFuncs
CALL SysLoadFuncs

/*
 *  Find out from where we're installing.
 *
 */

instFrom = DIRECTORY( )
instFromDrv = LEFT( instFrom, 2 )
instFromPath = SUBSTR( instFrom, 3 )

/*  This is necessary because on hard drive, no '\', on floppy, yes  */
IF( RIGHT( instFromPath, 1 ) \= "\" ) THEN  instFromPath = instFromPath||'\'

instFrom = instFromDrv||instFromPath

/*
 *  Get the installation drive
 *
 */

SAY ""
CALL CHAROUT, "Please enter the drive upon which to install [ C: ]: "

PARSE UPPER PULL instToDrv

IF( instToDrv == '' ) THEN             instToDrv='C:'
IF( RIGHT(instToDrv, 1) \= ':' ) THEN  instToDrv=instToDrv||':'

/*
 *  Get the installation path
 *
 */

SAY ""
SAY "Please enter the directory where you would like Soup KIDchen"
CALL CHAROUT, "to be installed [ \SoupKID\ ] : "

PARSE UPPER PULL ans
IF( ans \= '' ) THEN
DO
  IF( LEFT(ans, 1) \= '\' ) THEN  ans='\'||ans
  IF( RIGHT(ans, 1) \= '\' ) THEN  ans=ans||'\'
END
ELSE  ans = '\SoupKID\'

instToPath = ans
instTo = instToDrv||instToPath

/*
 *  Verify installation drive and path
 *
 */

SAY ""
SAY "Soup KIDchen will be installed to: "instTo
CALL CHAROUT, "Is this correct? (Y/[N]) : "

PARSE UPPER PULL ans
IF( ans \= 'Y' ) THEN
DO
  SAY ""
  SAY "Please type INSTALL again and enter the correct drive:path."
  CALL ErrorOut
END

IF( TRANSLATE( instFrom ) == TRANSLATE( instTo ) ) THEN
DO
  SAY ""
  SAY "You cannot install Soup KIDchen to this drive:path.  Type INSTALL"
  SAY "again and choose a different drive and/or path."
  CALL ErrorOut
END

/*
 *  O.K.  We have the paths, now unpack the files
 *
 */

CALL UnpackFiles

/*
 *  Files have been unpacked.  Ask if WPS objects should be created,
 *  and do it if the answer is yes.
 *
 */

SAY ""
SAY "Would you like Workplace Shell objects for Soup KIDchen created"
CALL CHAROUT, "on the desktop? ( [Y]/N ) : "

PARSE UPPER PULL ans
IF( ans == 'Y' | ans == '' ) THEN
DO
  interpret 'res = SKDesk( instTo )'
  IF( res \= 0 ) THEN CALL ErrorOut
END

/*
 *  Give the option to view the documentation right now.
 *  We hope the user will say yes.  Maybe we should just force it?
 *
 */

SAY ""
SAY "Would you like to view the Soup KIDchen documentation"
CALL CHAROUT, "now? ( [Y]/N ) : "

PARSE UPPER PULL ans
IF( ans == 'Y' | ans == '' ) THEN
DO
  'view 'instTo||'SoupKID.inf'
END

/*
 *  All done!
 *
 */

CALL BEEP  250, 50
CALL BEEP  500, 50
CALL BEEP 1000, 50

SAY ""
SAY "Soup KIDchen installation program ending successfully."
SAY ""
SAY "If you need to re-create the desktop objects in the future,"
SAY "just run SKDESK.CMD, which can be found in the Soup KIDchen"
SAY "directory ("instTo")."
SAY ""
SAY "The distributed program does not contain a complete database."
SAY "Rather, an example database is provided.  Therefore, if you get"
SAY "the message "Image Not Found" when you run the program, don't"
SAY "worry- you've simply chosen an item that doesn't have an entry"
SAY "in the database."

rc = DIRECTORY( LEFT( instFrom, LENGTH( instFrom ) - 1 ) )

EXIT 0

/***********************************************************/

/*
 *  Something bad happened.  Clean up, leave message, and
 *  get out.
 *
 */

ErrorOut:

  SAY ""
  SAY "Soup KIDchen installation aborted."
  SAY ""
  rc = DIRECTORY( LEFT( instFrom, LENGTH( instFrom ) - 1 ) )
  CALL BEEP 125, 500
  EXIT 1

/***********************************************************/

/*
 *  Unpack the files.  They may be on the hard drive or over
 *  two floppies.  Copy the unpack utility to the destination
 *  in any case. (Might not be on user's system.)
 *
 */

UnpackFiles:

SAY ""
SAY "Installing Soup KIDchen files..."


/*  First create the directories, because unpack2 doesn't do
 *  this for us, but will error out.
 *  rc = 5 from SysMkDir indicates path already exists
 */

SAY "Creating directory "||instTo"..."
rc = SysMkDir( LEFT( instTo, LENGTH( instTo ) - 1 )  )
IF( rc \= 0 & rc \= 5 ) THEN
DO
  SAY ""
  SAY "Error creating directory "instTo". rc = "rc
  CALL ErrorOut
END

SAY ""
SAY "Unpacking files.  Please wait..."

rc = SysFileTree( instFrom'SupK101s.ex1', files, 'FO' )
IF( files.0 = 0 ) THEN
DO
  SAY 'The file SupK101s.ex1 must reside where this install program resides.'
  Call ErrorOut
END

rc = DIRECTORY( LEFT( instTo, LENGTH( instTo ) - 1 )  )

instFrom'SupK101s.ex1'

IF( rc \= 0 ) THEN
DO
  SAY ""
  SAY "Error unzipping SupK101s.ex1"
  CALL ErrorOut
END

IF( instFromDrv == 'A:'  |  instFromDrv == 'B:' ) THEN
DO

DiskLoop:

  CALL BEEP 250, 250
  SAY ""
  SAY "Please insert Soup KIDchen disk 2 in drive "instFromDrv
  CALL CHAROUT, "and press Return to continue or 'Q' to quit..."
  PARSE UPPER PULL ans
  IF( ans == 'Q' ) THEN CALL ErrorOut

  rc = SysFileTree( instFrom'SupK101s.ex2', files, 'FO' )
  IF( files.0 = 0 ) THEN  SIGNAL DiskLoop
END
ELSE
DO
  rc = SysFileTree( instFrom'SupK101s.ex2', files, 'FO' )
  IF( files.0 = 0 ) THEN
  DO
    SAY "The file "instFrom"SupK101s.ex2 doesn't exist."
    CALL ErrorOut
  END
END

instFrom'SupK101s.ex2'

IF( result \= 0 ) THEN
DO
  SAY ""
  SAY "Error unzipping SupK101s.ex2"
  CALL ErrorOut
END

RETURN

/***********************************************************/
