/* 


	tapelab.cpp (emx+gcc) 
	Tape Label Editor Version 0.07

	1995 Giovanni Iachello
	This is freeware software. You can use or modify it as you wish,
	provided that the part of code that I wrote remains freeware.
	Freeware means that the source code must be available on request 
	to anyone.
	You must also include this notice in all files derived from this
	file.


*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "tapelab.h"
#include "pmstdres.h"

PMApp* App;


////////////////////////////////////////////////////////////////////////////

class InfoDlg : public PMModalDialog {
public:
	InfoDlg(HWND hwnd,PMControlMap* ctrlmap,void* data) : PMModalDialog(HWND_DESKTOP,hwnd,DLG_INFO,ctrlmap,data)
		{ }
	BOOL command(USHORT id,USHORT cmddev) {
		switch (id) {
			case DINFO_PB_CURRDATE1:
			case DINFO_PB_CURRDATE2:
				char buf[64];
				time_t t;
				t=time(NULL);
				strftime(buf,64,"%D",localtime(&t));
				if (id == DINFO_PB_CURRDATE1) controlFromID(DINFO_EF_DATE1)->setText(buf);
				else controlFromID(DINFO_EF_DATE2)->setText(buf);
  	        	return TRUE;
		} 
		return PMModalDialog::command(id,cmddev);
	}		 
	BOOL initdlg()
	{
		PMSpinButton* sp;
		sp=(PMSpinButton*)controlFromID(DINFO_SB_SOURCE1);
		sp->setArray(apchSources,5); sp->set();

		sp=(PMSpinButton*)controlFromID(DINFO_SB_SOURCE2);
		sp->setArray(apchSources,5); sp->set();

		sp=(PMSpinButton*)controlFromID(DINFO_SB_NR1);
		sp->setArray(apchNR,6); sp->set();

		sp=(PMSpinButton*)controlFromID(DINFO_SB_NR2);
		sp->setArray(apchNR,6); sp->set();

		return TRUE;
	}
};

class SizeDlg : public PMModalDialog {
public:
	SizeDlg(HWND hwnd,PMControlMap* ctrlmap,void* data) : PMModalDialog(HWND_DESKTOP,hwnd,DLG_SIZE,ctrlmap,data)
		{ }
	BOOL initdlg()
	{
		PMSpinButton* sp=(PMSpinButton*)controlFromID(DSIZE_SB_FLAPS);
		sp->setLimits(4,2);
		sp->set();
		return TRUE;
	}
};

////////////////////////////////////////////////////////////////////////////


TapeLab::TapeLab(HAB ab,char* file) : PMMainWin("tapelab",ab) 
{		
	createArgs->flCreateFlags|=FCF_MENU|FCF_ICON|FCF_ACCELTABLE|FCF_VERTSCROLL;
	createArgs->idResources=ID_TAPELAB;
	createArgs->pszTitle="Tape Lab - (untitled)";
	caption="Tape Lab";
	fnFilter="*.TL";
	flCaption="Open Tape Label File";
	fsCaption="Save Tape Label File";
	fileFlags=PMMWFF_UNTITLED;
	tempfile=file;
	sb=NULL;
	posy=-1;				  // deve essere impostata la prima volta
	sizey=-1;
}

TapeLab::~TapeLab()
{
	delete sb;	
}

BOOL TapeLab::createWin() 
{
	PMMainWin::createWin();
	sb=new PMVertScrollBar(this,NULL);
	if (tempfile)
		if (fileOpen(tempfile)) {
			strcpy(filename,tempfile);
			fileFlags=PMMWFF_FILE;
			setTitleCaption();
			tempfile=NULL;
		}
	return TRUE;
}	

BOOL TapeLab::size(SHORT cx,SHORT cy)
{
	posy=posy+sizey-cy;
	sizey=cy;	   // aggiorna dimensioni della finestra
	return TRUE;
}

BOOL TapeLab::other(PMEvent &event)
{
	if (event.msg==WM_VSCROLL) {	  // gestione scroll bar
		PMWindowPresSpace ps(this);	  // crea pres space della finestra
		SIZEL size;
		size.cx=1500;
		size.cy=fixpoints[labelformat.size][0].y+100;
		ps.set(&size,PU_LOMETRIC);
		PMRect q;
		ps.queryPageViewport(&q);
		switch (SHORT2FROMMP(event.mp2) ) {
			case SB_SLIDERPOSITION: {
				posy=q.yTop-sizey-SHORT1FROMMP(event.mp2);
				invalidate(TRUE);		
				return TRUE;
			}
			case SB_LINEUP: {
				posy=min(q.yTop-sizey,posy+10);
				invalidate(TRUE);		
				return TRUE;
			}
			case SB_LINEDOWN: {
				posy=max(0,posy-10);
				invalidate(TRUE);		
				return TRUE;
			}
			case SB_PAGEUP: {
				SWP swp;
				queryPos(&swp);
				posy=min(q.yTop-sizey,posy+swp.cy);
				invalidate(TRUE);		
				return TRUE;
			}
			case SB_PAGEDOWN: {
				SWP swp;
				queryPos(&swp);
				posy=max(0,posy-swp.cy);
				invalidate(TRUE);		
				return TRUE;
			}
		}
	}
	return FALSE;
}	

BOOL TapeLab::command(USHORT id,USHORT cmddev)
{
	switch (id) {
   	    case IDM_TITLE:	{
			struct _temp {
				char t1[200];
				char t2[200];
			};
			_temp *temp=new _temp;
			strcpy(temp->t1,labelformat.title1);
			strcpy(temp->t2,labelformat.title2);
			static PMControlMap titlectrlmap[]={
				cmEntryField(DTITLE_EF_T1,_temp,t1)
				cmEntryField(DTITLE_EF_T2,_temp,t2)
				cmEnd(DTITLE_EF_T1)
			};
			PMModalDialog titledlg(HWND_DESKTOP,hwnd,DLG_TITLE,titlectrlmap,temp);
			int ret=titledlg.createWin();
			if (ret) {
				delete labelformat.title1;
				delete labelformat.title2;
				labelformat.title1=new char[strlen(temp->t1)+1];
				labelformat.title2=new char[strlen(temp->t2)+1];
				strcpy(labelformat.title1,temp->t1);
				strcpy(labelformat.title2,temp->t2);
				setModified(TRUE);
				invalidate(TRUE);
			}
			delete temp;
			return TRUE;
		}
   	    case IDM_TEXT:	{
			struct _temp1 {
				char t1[3000];
				char t2[3000];
			};
			_temp1 *temp=new _temp1;
			strcpy(temp->t1,labelformat.text1);
			strcpy(temp->t2,labelformat.text2);

			static PMControlMap textctrlmap[]={
				cmMultiLineEdit(DTEXT_MLE_T1,_temp1,t1)
				cmMultiLineEdit(DTEXT_MLE_T2,_temp1,t2)
				cmEnd(DTEXT_MLE_T1)
			};
			PMModalDialog textdlg(HWND_DESKTOP,hwnd,DLG_TEXT,textctrlmap,temp);
			int ret=textdlg.createWin();
			if (ret) {
				delete labelformat.text1;
				delete labelformat.text2;
				labelformat.text1=new char[strlen(temp->t1)+1];
				labelformat.text2=new char[strlen(temp->t2)+1];
				strcpy(labelformat.text1,temp->t1);
				strcpy(labelformat.text2,temp->t2);
				setModified(TRUE);
				invalidate(TRUE);
			}
			delete temp;
			return TRUE;
		}
   	    case IDM_SIZE:	{
			struct _temp2 {
				int size;
				int flaps;
			} temp;
			temp.size=labelformat.size;
			temp.flaps=labelformat.flaps;
			static PMControlMap sizectrlmap[]={
				cmRadioButtonGroup(DSIZE_RB_NORMAL,_temp2,size)
				cmSpinButton(DSIZE_SB_FLAPS,_temp2,flaps)
				cmEnd(DSIZE_RB_NORMAL)
			};
			SizeDlg sizedlg(hwnd, sizectrlmap, &temp);
			int ret=sizedlg.createWin();
			if (ret) {
				labelformat.size=temp.size;
				labelformat.flaps=temp.flaps;
				setModified(TRUE);
				posy=-1;				// ricalcola la scroll bar
				sizey=-1;
				invalidate(TRUE);
			}
			return TRUE;
		}
   	    case IDM_INFO:	{
			struct _temp3 {
				char date1[40];
				int nr1;
				int source1;
				char date2[40];
				int nr2;
				int source2;
				int whatinfo[6];
			} temp;
			strcpy(temp.date1,labelformat.date1);
			strcpy(temp.date2,labelformat.date2);
			temp.nr1=labelformat.nr1;
			temp.nr2=labelformat.nr2;
			temp.source1=labelformat.source1;
			temp.source2=labelformat.source2;
			for (int i=0; i<6; i++) temp.whatinfo[i]=labelformat.whatinfo[i];

			static PMControlMap infoctrlmap[]={
				cmEntryField(DINFO_EF_DATE1,_temp3,date1)
				cmSpinButton(DINFO_SB_SOURCE1,_temp3,source1)
				cmSpinButton(DINFO_SB_NR1,_temp3,nr1)
				cmEntryField(DINFO_EF_DATE2,_temp3,date2)
				cmSpinButton(DINFO_SB_SOURCE2,_temp3,source2)
				cmSpinButton(DINFO_SB_NR2,_temp3,nr2)
				cmCheckBox(DINFO_CB_BASE0,_temp3,whatinfo[0])
				cmCheckBox(DINFO_CB_BASE1,_temp3,whatinfo[1])
				cmCheckBox(DINFO_CB_BASE2,_temp3,whatinfo[2])
				cmCheckBox(DINFO_CB_BASE3,_temp3,whatinfo[3])
				cmCheckBox(DINFO_CB_BASE4,_temp3,whatinfo[4])
				cmCheckBox(DINFO_CB_BASE5,_temp3,whatinfo[5])
				cmEnd(DINFO_EF_DATE1)
			};
			InfoDlg infodlg(hwnd, infoctrlmap, &temp);
			int ret=infodlg.createWin();
			if (ret) {
				delete labelformat.date1;
				delete labelformat.date2;
				labelformat.date1=new char[strlen(temp.date1)+1];
				labelformat.date2=new char[strlen(temp.date2)+1];
				strcpy(labelformat.date1,temp.date1);
				strcpy(labelformat.date2,temp.date2);
				labelformat.nr1=temp.nr1;
				labelformat.nr2=temp.nr2;
				labelformat.source1=temp.source1;
				labelformat.source2=temp.source2;
				for (int i=0; i<6; i++) labelformat.whatinfo[i]=temp.whatinfo[i];
				setModified(TRUE);
				invalidate(TRUE);
			}
			return TRUE;
		}
   	    case IDM_FORM:	{
			struct _temp4 {
				char titlelm[32]; // margine sin. titolo
				char textlm[32],texttm[32]; // margine sinistro e superiore testo
				char tabsize[32]; // dimensione tabs
				char textvert1[32],textvert2[32];	// permillesimi di spaziatura orizzontale e verticale
				char texthoriz1[32],texthoriz2[32];
			};
			_temp4 *temp=new _temp4;
			sprintf(temp->tabsize,"%d",labelformat.form.tabsize);
			sprintf(temp->titlelm,"%d",labelformat.form.titlelm);
			sprintf(temp->textlm,"%d",labelformat.form.textlm);
			sprintf(temp->texttm,"%d",labelformat.form.texttm);
			sprintf(temp->textvert1,"%d",labelformat.form.textvert1);
			sprintf(temp->texthoriz1,"%d",labelformat.form.texthoriz1);
			sprintf(temp->textvert2,"%d",labelformat.form.textvert2);
			sprintf(temp->texthoriz2,"%d",labelformat.form.texthoriz2);
			static PMControlMap formctrlmap[]={
				cmEntryField(DFORM_EF_TITLM,_temp4,titlelm)
				cmEntryField(DFORM_EF_TABSIZE,_temp4,tabsize)
				cmEntryField(DFORM_EF_TLM,_temp4,textlm)
				cmEntryField(DFORM_EF_TTM,_temp4,texttm)
				cmEntryField(DFORM_EF_THSA,_temp4,texthoriz1)
				cmEntryField(DFORM_EF_THSB,_temp4,texthoriz2)
				cmEntryField(DFORM_EF_TVSA,_temp4,textvert1)
				cmEntryField(DFORM_EF_TVSB,_temp4,textvert2)
				cmEnd(DFORM_EF_TITLM)
			};
			PMModalDialog titledlg(HWND_DESKTOP,hwnd,DLG_FORMAT,formctrlmap,temp);
			int ret=titledlg.createWin();
			if (ret) {
				labelformat.form.tabsize=strtol(temp->tabsize,NULL,0);
				labelformat.form.titlelm=strtol(temp->titlelm,NULL,0);
				labelformat.form.textlm=strtol(temp->textlm,NULL,0);
				labelformat.form.texttm=strtol(temp->texttm,NULL,0);
				labelformat.form.textvert1=strtol(temp->textvert1,NULL,0);
				labelformat.form.textvert2=strtol(temp->textvert2,NULL,0);
				labelformat.form.texthoriz1=strtol(temp->texthoriz1,NULL,0);
				labelformat.form.texthoriz2=strtol(temp->texthoriz2,NULL,0);
				setModified(TRUE);
				invalidate(TRUE);
			}
			delete temp;
			return TRUE;
		}
   	    case IDM_FON_TIA:	
			setFont(&labelformat.title1font,"Title Side A Font"); 
			return TRUE;
   	    case IDM_FON_TIB:	
			setFont(&labelformat.title2font,"Title Side B Font"); 
			return TRUE;
   	    case IDM_FON_TXA:	
			setFont(&labelformat.text1font,"Text Side A Font");
			return TRUE;
   	    case IDM_FON_TXB:	
			setFont(&labelformat.text2font,"Text Side B Font");
			return TRUE;
   	    case IDM_FON_DATE:	
			setFont(&labelformat.datefont,"Date Font"); 
			return TRUE;
   	    case IDM_FON_SOURCE: 
			setFont(&labelformat.sourcefont,"Source Font");
			return TRUE;
   	    case IDM_FON_NR: 
			setFont(&labelformat.nrfont,"NR Font");
			return TRUE;
	}
	return PMMainWin::command(id,cmddev);
}


BOOL TapeLab::fileNew() 
{
	labelformat.~_labelformat();  // azzera la struttura dati!
	labelformat._labelformat();
	invalidate(TRUE);
	return TRUE;
}

//
// usa un thread separato per stampare l'output! in modo da non bloccare
// il programma!
//

class PMPrintLabelThread : public PMWindowThread 
{
	TapeLab* tl;
	char* buf;
public:
	PMPrintLabelThread(char* ibuf,TapeLab *itl) : PMWindowThread() 
	{
		buf=ibuf; tl=itl;
	}
	void main(void* arg=NULL) 
	{
		PMPrinterDC printer(hab);
		printer.open();
		printer.startDoc(buf);

		PMPresSpace *prnps=new PMPresSpace(&printer,0,0,PU_LOMETRIC|GPIF_DEFAULT|GPIT_NORMAL|GPIA_ASSOC,hab);

		tl->paintlabel(*prnps);

		delete prnps;
		printer.endDoc(buf);
	}
};

BOOL TapeLab::filePrint() 
{
	char buf[300];

	if (fileFlags==PMMWFF_FILE) sprintf(buf,"Tape Lab Document: %s",filename);
	else sprintf(buf,"Tape Lab Document: %s",fileUntitled);

	new PMPrintLabelThread(buf,this);
	
	return TRUE;
}

BOOL TapeLab::fileOpen(PCSZ filename) 
{
	if (labelformat.load(filename)) {
		invalidate(TRUE);
		return TRUE;
	}
	ErrBox("Error Loading file %s",filename);

	return FALSE;
}

BOOL TapeLab::fileSave(PCSZ filename) 
{
	labelformat.save(filename);
	invalidate(TRUE);
	return TRUE;
}

int main (int argc,char* argv[])
{
	char* file=NULL;
	if (argc>1) file=argv[1];
	
	PMAnchorBlock ab;
	PMMessageQueue mq;
	ab.init();
	mq.create(ab);
	
	App=new PMApp(ab,mq,argc,argv);

	TapeLab * tl=new TapeLab(ab,file); // dagli anche il nome di un'eventuale file
	tl->createWin();
	
	App->run();

	tl->destroyWin();

	mq.destroy();
	ab.uninit();

	return (0);
}

