/* 


	tapelab.h (emx+gcc) 
	Tape Label Editor Version 0.07

	1995 Giovanni Iachello
	This is freeware software. You can use or modify it as you wish,
	provided that the part of code that I wrote remains freeware.
	Freeware means that the source code must be available on request 
	to anyone.
	You must also include this notice in all files derived from this
	file.


*/
#ifndef _TAPELAB_H_
#define _TAPELAB_H_

#define ID_TAPELAB 1

#define IDM_COMP 10
#define IDM_SIZE 11
#define IDM_TITLE 12
#define IDM_TEXT 13
#define IDM_INFO 14
#define IDM_FORM 15

#define IDM_FONTS 20
#define IDM_FON_TIA 21
#define IDM_FON_TIB 22
#define IDM_FON_TXA 23
#define IDM_FON_TXB 24
#define IDM_FON_DATE 25
#define IDM_FON_SOURCE 26
#define IDM_FON_NR 27


#define DLG_TITLE 100
#define DTITLE_EF_T1 101
#define DTITLE_EF_T2 102

#define DLG_TEXT 200
#define DTEXT_MLE_T1 201
#define DTEXT_MLE_T2 202

#define DLG_SIZE 300
#define DSIZE_SB_FLAPS 301
#define DSIZE_RB_NORMAL 302
#define DSIZE_RB_TDK 303
#define DSIZE_RB_SONY 304
#define DSIZE_RB_CUSTOM 305
#define DSIZE_EF_X 306
#define DSIZE_EF_Y 307

#define DLG_INFO 400
#define DINFO_EF_DATE1 401
#define DINFO_PB_CURRDATE1 407
#define DINFO_SB_NR1 402
#define DINFO_SB_SOURCE1 403
#define DINFO_EF_DATE2 404
#define DINFO_PB_CURRDATE2 408
#define DINFO_SB_NR2 405
#define DINFO_SB_SOURCE2 406
#define DINFO_CB_BASE0 410   // riserva fino a 415 compreso
#define DINFO_CB_BASE1 411
#define DINFO_CB_BASE2 412
#define DINFO_CB_BASE3 413
#define DINFO_CB_BASE4 414
#define DINFO_CB_BASE5 415

#define DLG_FORMAT 600
#define DFORM_EF_TABSIZE 601
#define DFORM_EF_TITLM 602
#define DFORM_EF_TTM 603
#define DFORM_EF_TLM 604
#define DFORM_EF_THSB 605
#define DFORM_EF_THSA 606
#define DFORM_EF_TVSA 607
#define DFORM_EF_TVSB 608

#ifndef RC_INVOKED

#define INCL_WIN
#include "pmwin.h"
#include "pmdlg.h"
#include "pmgpi.h"

struct _fontinfo 
{
	FATTRS fattrs;
	LONG height;
	LONG extleading;
	ULONG type;
	SHORT point;
};

struct _formatting {
	int titlelm; // margine sin. titolo
	int textlm,texttm; // margine sinistro e superiore testo
	int tabsize; // dimensione tabs
	int textvert1,textvert2;	// permillesimi di spaziatura orizzontale e verticale
	int texthoriz1,texthoriz2;
};

struct _labelformat 
{
	int flaps; // numero di flaps 3 o 4
	int size;  // parametri di dimensione

	char* title1;
	char* title2;
	_fontinfo title1font;
	_fontinfo title2font;

	char* text1;
	char* text2;
	_fontinfo text1font;
	_fontinfo text2font;

	_formatting form;
	
	int whatinfo[6]; // sceglie quali info stampare
	char* date1;
	int source1;
	int nr1;
	char* date2;
	int source2;
	int nr2;
	_fontinfo datefont;
	_fontinfo sourcefont;
	_fontinfo nrfont;
	
	_labelformat();
	~_labelformat();
	BOOL save(const char* file);
	BOOL load(const char* file);
};

extern POINTL fixpoints[3][10];
extern char *apchSources[];
extern char *apchNR[];

#ifndef min
#define min(a,b) ((a) < (b) ? (a) : (b))
#endif
#ifndef max
#define max(a,b) ((a) > (b) ? (a) : (b))
#endif

#define pts2dmm(x) ((x)*254L/72L)

class TapeLab : public PMMainWin {
	char* tempfile;
	_labelformat labelformat;
	PMVertScrollBar* sb;
	PMRect viewport;
	LONG sizey,posy;
public:
	TapeLab(HAB ab,char* file);
	~TapeLab();
	BOOL paint(PMPresSpace& ps);
	BOOL paintlabel(PMPresSpace& ps);
	BOOL size(SHORT cx,SHORT cy);
	BOOL other(PMEvent &event);	

	BOOL command(USHORT id,USHORT cmddev);
	BOOL setFont(_fontinfo *font,char* title);
	BOOL paintString(char* str,_fontinfo *font,int spc,PMPoint pos,PMPresSpace &ps);
	BOOL createWin(); 
	
	BOOL fileNew(); 
	BOOL filePrint();
	BOOL fileOpen(PCSZ filename); 
	BOOL fileSave(PCSZ filename); 
	LONG queryStrWidth(PSZ pszString,_fontinfo *font,PMPresSpace& ps);
};

#endif	 /* RC_INVOKED */

#endif	 /* _TAPELAB_H_ */


