/* inews rexx v0.9 by Rupa Schomaker (rupa@netcom.com) */
/* post an aritcle to an NNTP deamon  */
/* options -- none are used but -h is required, input to stdin expected */
/* env variables used: NNTPSERVER */

CALL ON halt
CALL ON error 
CALL init

/* eat the -h option, and take the next argument as input    */
/* this should also work with stdin -- at least it does with */
/* person rexx -- dunno about OS/2 rexx                      */
PARSE ARG '-h' infile 
infile=Strip(infile)

/* setup the structure for the socket calls */
sin.!family='AF_INET'
sin.!port=port
if SockGetHostByName(nntpserver,'host.!') = 0 THEN 
   IF SockGetHostByAddr(nntpserver,'host.!') = 0 THEN DO 
   SAY 'Could not resolve:' host
   EXIT
END
sin.!addr=host.!addr

socket = SockSocket('AF_INET','SOCK_STREAM','IPPROTO_TCP')
if SockConnect(socket,'sin.!') = -1 THEN DO
   SAY 'Could not open socket with:' nntpserver 'on port' port'.'
   EXIT
END

line = SockGets(socket,nntprc)
SELECT 
 WHEN nntprc = 200 THEN NOP
 WHEN nntprc = 201 THEN DO
    SAY 'You do not have permission to post on this server.'
    SIGNAL halt
 END
 OTHERWISE DO
    SAY 'Your nntp server did no respond with code 200, but rather with:'
    SAY line
    SAY 'Report this to rupa@netcom.com and maybe your news admin.'
    SIGNAL halt
 END
END


IF SockSend(socket,'POST'||crlf) = -1 THEN DO 
   SAY 'Attempt to send data to socket failed.'
   SIGNAL halt
END

line = SockGets(socket,nntprc)
SELECT
 WHEN nntprc = 340 THEN NOP
 WHEN nntprc = 380 THEN DO
    SAY 'Your host needs authorization info, we do not do that yet.'
    SAY line
    signal halt
 END
 OTHERWISE DO
   SAY 'Could not post to your NNTP server, it returned:'
   SAY line
   SIGNAL halt
 END
END

DO WHILE Lines(infile)
   line = LineIn(infile)
   /* take care of lines with just a '.' in it */
   IF line = '.' THEN 
      line = line||'.'
   IF SockSend(socket,line||crlf) = -1 THEN DO
      SAY 'unexpected close of server socket, article not sent.'
      SIGNAL halt
   END
END
IF SockSend(socket,'.'||crlf) = -1 THEN DO
   SAY 'unexpected close of server socket, article not sent.'
   SIGNAL halt
END

line = SockGets(socket,nntprc)
SELECT
 WHEN nntprc = 235 THEN NOP
 WHEN nntprc = 240 THEN NOP
 OTHERWISE DO
    SAY 'Article not posted, server said:'
    SAY line
 END
END

/* done, CALL the halt stuff */
SIGNAL halt

EXIT


init:
   /* Set some definitions for easier handling */
   cr='0d'x
   crlf='0d0a'x
   eot = '.'||crlf
   buffsize = 512
   port = 119
   
   
   nntpserver=value('NNTPSERVER',,'OS2ENVIRONMENT')
   IF nntpserver ='' THEN DO
      SAY 'You must have "NNTPSERVER" set in order to post articles.'
      EXIT
   END

   /* init socket library */
   rc = RxFuncAdd("SockLoadFuncs","rxsock","SockLoadFuncs")
   rc = SockLoadFuncs('quiet')
   IF RxFuncQuery("SockLoadFuncs") THEN DO
      SAY 'Could not find rxsock.dll!'
      SAY 'Make sure it is in your LIBPATH.  If you do not have it,'
      say 'get it from software.watson.ibm.com:/pub/os2/ews/rxsock.zip'
   END

   /* load the rxutil stuff */
   IF RxFuncQuery("SysLoadFuncs") THEN DO
      rc = RxFuncAdd("SysLoadFuncs","rexxutil","SysLoadFuncs")
      rc = SysLoadFuncs()
   END
return

SockGets: PROCEDURE EXPOSE buffsize nntprc crlf
   sock = Arg(1)
   nntprc = Arg(2)
   
   if (symbol('!.buff') = "LIT") then
      !.buff = ""

   do while (pos(crlf,!.buff) = 0)
      rc = SockRecv(sock,"data",8000)
      !.buff = !.buff || data
   end

   p = pos(crlf,!.buff)

   line = substr(!.buff,1,p-1)
   !.buff = substr(!.buff,p+2)
   
   PARSE VAR line nntprc .
   
RETURN line

halt:
   rc = SockClose(socket)
EXIT


error:
   SAY 'oops, better send an email to rupa@netcom.com to squash that bug!'
   SIGNAL halt 
EXIT

