; Program.....:FOXPOP.ASM (for fast calls to VIDPOP with FOXBASE Plus)
; Author......:G. Rothbart, Technical Support, The Research Group
; Date........:8/2/1986        modified 5/28/87
;
;
; NOTE........: This module provides a link from FOXBASE PLUS to VIDPOP.
;               If you are using the earlier FoxBase (the dBASE II clone)
;               please read the instructions in the file called FOXII.ASM.
;
;               Since FOXBASE+ performs direct screen writes, the ordinary
;               ?? chr(255) + ... of invoking VIDPOP will fail. The
;               assembly patch provided will allow you to correctly invoke
;               VIDPOP.
;
;               The file to load into FOXBASE+ is called FOXPOP.BIN.
;               The FOXBASE command, needed to be issued one time is:
;
;               LOAD FOXPOP
;
;               The syntax to pop a SAYWHAT screen, or use any VIDPOP
;               command is:
;
;               CALL FOXPOP WITH '<screen name or VIDPOP command>'
;                         the terminating slash ----------------^
;                         is now optional here
;
      PUBLIC      FOXPOP
_PROG SEGMENT     BYTE
      ASSUME      CS:_PROG
;
FOXPOP      PROC       FAR
      PUSH     SS
      LEA      SI,[BX]      ; DS:SI now points to the string being passed by Foxbase

      MOV      AH,14        ; set up for INT 10 function 'TTY'
      MOV      AL,255       ; VIDPOP's wake up character
      INT      10H
      INT      10H          ; send it twice to awaken vidpop

MORE: MOV      AL,[SI]      ; get a character from the passed string
      cmp      al,0         ; is it the 0 string terminator?
      jz       finish       ; yes
      cmp      al,'/'       ; no, is it the slash?
      jz       finish       ; yes
      INT      10H          ; no, send it to VIDPOP
      INC      SI           ; point to the next character
      jmp      MORE         ; go get next character
finish:
      MOV      AL,'/'       ; send VIDPOP's delimiter (forward slash)
      INT      10H
      POP      SS
      RET
FOXPOP      ENDP
_PROG      ENDS
      END

