procedure EvaluateAnswer;
{written by W. Jeffrey Wilson & lynne ostergren,
            Department of Psychological Sciences,
            Indiana University - Purdue University at Fort Wayne,
            2101 Coliseum Boulevard East,
            Fort Wayne, IN  46805.
copyright, 1985 by Purdue Research Foundation, West Lafayette, Indiana 47907.
                    All Rights Reserved.  Unmodified copies of this program
                    may be freely distributed.  Each copy must contain this
                    notice.}

begin
   if Answer = 'CORRECT' then begin
      CorrectAnswer;
   end else begin
      IncorrectAnswer;
   end;
end;

procedure GetAnswer;
begin
   repeat
      readln(Answer);
      if length(Answer) < 3 then
         writeln('Too brief! Try again.');
   until length(Answer) > 2;
   for index := 1 to ord(Answer[0]) do
      Answer[index] := UpCase(Answer[index]);
   Delete(Answer,4,length(Answer));
   if pos(Answer,RightAnswers) > 0 then
      Answer := 'CORRECT'
   else
      Answer := 'WRONG';
end;

procedure AmygdalaQuestions;
   begin
      writeln('To pass in that direction, you must answer a');
      writeln('question.  Once the question has been answered');
      writeln('correctly, you will have free access between');
      writeln('the amygdala and the limbic system.');
      repeat
         writeln;
         case Random(5) of
            0:begin
                 writeln('Who proposed that several limbic structures');
                 writeln('form a loop that plays a critical role in the');
                 writeln('expression of emotion?');
                 RightAnswers := 'PAPEZ';
                 GetAnswer;
              end;
            1:begin
                 writeln('In general, do lesions of the amygdala');
                 writeln('facilitate or inhibit aggressive behavior?');
                 RightAnswers := 'INHIBIT';
                 GetAnswer;
              end;
            2:begin
                 writeln('What syndrome is produced by lesioning the');
                 writeln('septal area in a rat?');
                 RightAnswers := '"SEPTAL RAGE" AGGRESSION';
                 GetAnswer;
              end;
            3:begin
                 writeln('What sensory system seems to be closely linked');
                 writeln('to the limbic system?');
                 RightAnswers := 'SMELL OLFACTION';
                 GetAnswer;
              end;
            4:begin
                 writeln('Name one of the two people credited with the');
                 writeln('theory of emotion that states that emotions');
                 writeln('arise as a result of our perception of bodily');
                 writeln('responses.');
                 RightAnswers := 'WILLIAM JAMES CARL LANGE';
                 GetAnswer;
              end
         end;
       if Answer = 'CORRECT' then begin
                    clrscr;
                    writeln;
                    writeln;
                    writeln('You are absolutely correct!  This answer has');
                    writeln('opened the limbic system to you.');
                    Room[Amygdala].AdjRoom[C] := Hippocampus;
                    Room[Amygdala].AdjRoom[M] := Septum;
                    Room[Septum].AdjRoom[L] := Amygdala;
                    Room[Hippocampus].AdjRoom[R] := Amygdala;
                    WrongAnswer := False;
                 end else begin
                    IncorrectAnswer;
                 end;
until WrongAnswer = False;
Loc := Loc1;
end;

procedure VisualCxQuestions;
begin
   writeln('To leave the striate cortex you must answer a');
   writeln('question.  If you answer correctly, you will be');
   writeln('transported to a random location elsewhere in');
   writeln('the brain.  Dire consequences await you if your');
   writeln('answer is incorrect!');
   repeat
      writeln;
      case random(8) of
         0:begin
              writeln('What hypothalamic nucleus plays a role in');
              writeln('circadian rhythms?');
              RightAnswers := 'SUPRACHIASMATIC NUCLEUS';
              GetAnswer;
           end;
         1:begin
              writeln('Where do optic nerve fibers decussate?');
              RightAnswers := 'OPTIC CHIASMA';
              GetAnswer;
           end;
         2:begin
              writeln('In the periphery, bundles of axons are called');
              writeln('nerves.  What are bundles of axons in the');
              writeln('central nervous system called?');
              RightAnswers := 'TRACTS';
              GetAnswer;
           end;
         3:begin
              writeln('In what lobe of the cortex is the primary');
              writeln('visual area located?');
              RightAnswers := 'OCCIPITAL';
              GetAnswer;
           end;
         4:begin
              writeln('What part of the brain contains the superior');
              writeln('colliculus?');
              RightAnswers := 'TECTUM MIDBRAIN MESENCEPHALON';
              GetAnswer;
           end;
         5:begin
              writeln('What is the name of the thalamic relay nucleus');
              writeln('for visual information?');
              RightAnswers := 'LATERAL GENICULATE NUCLEUS LGN L.G.N.';
              GetAnswer;
           end;
         6:begin
              writeln('Name one of the three people who received the');
              writeln('Nobel prize in medicine for their work on');
              writeln('visual system physiology.');
              RightAnswers := 'HUBEL WEISEL SPERRY';
              GetAnswer;
           end;
         7:begin
              writeln('What kind of cells in the retina provide the');
              writeln('axons that make up the optic nerve?');
              RightAnswers := 'GANGLION CELLS';
              GetAnswer;
           end
      end;
      EvaluateAnswer;
   until WrongAnswer = False;
end;

procedure PituitaryQuestions;
begin
   writeln('A question must be answered correctly in order');
   writeln('to leave the pituitary.  A correct answer will');
   writeln('send you randomly to another part of the brain.');
   writeln('For your own sake, do NOT answer incorrectly!');
   repeat
      writeln;
      case random(4) of
         0:begin
              writeln('What is the name of the stalk that attaches the');
              writeln('pituitary to the hypothalamus?');
              RightAnswers := 'INFUNDIBULUM';
              GetAnswer;
           end;
         1:begin
              writeln('What hormone promotes the masculinization of');
              writeln('the brain?');
              RightAnswers := 'TESTOSTERONE';
              GetAnswer;
           end;
         2:begin
              writeln('What diencephalic structure controls the');
              writeln('release of hormones from the pituitary?');
              RightAnswers := 'HYPOTHALAMUS';
              GetAnswer;
           end;
         3:begin
              writeln('What hormone, released from the pituitary at');
              writeln('the onset of puberty, promotes increased');
              writeln('function of the testes or ovaries?');
              RightAnswers := 'GONADOTROPIC HORMONE';
              GetAnswer;
           end
      end;
      EvaluateAnswer;
   until WrongAnswer = False;
end;

procedure TrapezoidBodyQuestions;
begin
   writeln('To leave this brainstem auditory nucleus, you');
   writeln('must answer a question.  A correct answer will');
   writeln('send you to another region of the brain.  An');
   writeln('incorrect answer will be dealt with severely!');
   repeat
      writeln;
      case random(7) of
         0:begin
              writeln('What is the name for the language impairment');
              writeln('that results from damage to Broca'+chr(39)+'s or');
              writeln('Wernicke'+chr(39)+'s area?');
              RightAnswers := 'APHASIA';
              GetAnswer;
           end;
         1:begin
              writeln('What major fissure lies just superior to the');
              writeln('auditory cortex?');
              RightAnswers := 'LATERAL FISSURE';
              GetAnswer;
           end;
         2:begin
              writeln('What is the name of the largest band of fibers');
              writeln('interconnecting the two hemispheres of the');
              writeln('brain?');
              RightAnswers := 'CORPUS CALLOSUM';
              GetAnswer;
           end;
         3:begin
              writeln('The thalamus receives afferent projections');
              writeln('from every sensory system except which one?');
              RightAnswers := 'OLFACTION SMELL';
              GetAnswer;
           end;
         4:begin
              writeln('In what lobe is auditory cortex located?');
              RightAnswers := 'TEMPORAL';
              GetAnswer;
           end;
         5:begin
              writeln('Which of the aphasias is characterized by');
              writeln('fluent but meaningless speech?');
              RightAnswers := 'WERNICKE'+chr(39)+'S APHASIA';
              GetAnswer;
           end;
         6:begin
              writeln('What is the name of the membrane within the');
              writeln('ear that contains the hair cells, and vibrates');
              writeln('in response to sound?');
              RightAnswers := 'BASILAR MEMBRANE';
              GetAnswer;
           end
      end;
      EvaluateAnswer;
   until WrongAnswer = False;
end;

procedure PyramidsQuestions;
begin
   writeln('You have reached the end of the road, so to');
   writeln('speak, and must answer a question to leave');
   writeln('this area.  Do NOT answer incorrectly!');
   repeat
      writeln;
      case random(7) of
         0:begin
              writeln('Are the pyramids in primarily an afferent or');
              writeln('efferent pathway?');
              RightAnswers := 'EFFERENT MOTOR';
              GetAnswer;
           end;
         1:begin
              writeln('If you, at your present size, got a job as a');
              writeln('neurotransmitter at a neuromuscular junction,');
              writeln('what neurotransmitter would you become (if you');
              writeln('wanted to keep your job, that is)?');
              RightAnswers := 'ACETYLCHOLINE ACH';
              GetAnswer;
           end;
         2:begin
              writeln('In what lobe is the motor strip located?');
              RightAnswers := 'FRONTAL LOBES';
              GetAnswer;
           end;
         3:begin
              writeln('What basal ganglion structure, along with the');
              writeln('globus pallidus, makes up the lentiform or');
              writeln('lenticular nucleus?');
              RightAnswers := 'PUTAMEN';
              GetAnswer;
           end;
         4:begin
              writeln('What type of cell gives rise to the axons that');
              writeln('pass through the pyramids in the corticospinal');
              writeln('tract?');
              RightAnswers := 'PYRAMIDAL CELLS BETZ CELL';
              GetAnswer;
           end;
         5:begin
              writeln('Loss of the dopaminergic cells of the');
              writeln('substantia nigra results in what clinical');
              writeln('condition?');
              RightAnswers := 'PARKINSONISM PARKINSON'+chr(39)+'S DISEASE';
              GetAnswer;
           end;
         6:begin
              writeln('What structure is presumed to be involved with');
              writeln('the execution of skilled, coordinated');
              writeln('movements?');
              RightAnswers := 'CEREBELLUM';
              GetAnswer;
           end
      end;
      EvaluateAnswer;
   until WrongAnswer = False;
end;

procedure PoseQuestion;
begin
   case Loc1 of
      Amygdala: AmygdalaQuestions;
      VisualCx: VisualCxQuestions;
      Pituitary: PituitaryQuestions;
      TrapezoidBody: TrapezoidBodyQuestions;
      Pyramids: PyramidsQuestions
   end;
end;