program gerb_lmc;

{ convert gerber files to layo1 .LMC files}

uses
  crt,
  dos;

const
  layer : byte = 1;

type
  string80 = string[80];

  array_type_integer = array[1..maxint] of integer;
  array_type_word    = array[1..maxint] of word;

var
  ch : char;
  top_array : word;

  attr : ^array_type_word;
  xpos,
  ypos : ^array_type_integer;

  apert_pen : array[10..99] of byte;
  apert_pad : array[10..99] of byte;

procedure save_lmc;
type
  lrec = record b,a:word; x,y:integer; end;
var
  rec : lrec; f1 : file of lrec; i:word;
begin
  assign(f1,paramstr(2));
  rewrite(f1);
  for i:=1 to top_array do
  begin
    rec.b:= 0;
    rec.a:=attr^[i];
    rec.x:=xpos^[i];
    rec.y:=ypos^[i];
    write(f1,rec);
  end;
  close(f1);
end;

procedure init;
var
  i : word;
begin
  top_array := 0;
  new(xpos);
  new(ypos);
  new(attr);
  fillchar(attr^,sizeof(attr^),0);
  fillchar(xpos^,sizeof(xpos^),0);
  fillchar(ypos^,sizeof(ypos^),0);
  val(paramstr(3),layer,i);
end;

procedure load_aperture_dat;
var
  f1:text;
  s1:string;
  apert_str : string[2];
  pen_str,
  pad_str : string;
  i,apert,pen,pad : word;
begin
  fillchar(apert_pen,sizeof(apert_pen),1);
  fillchar(apert_pad,sizeof(apert_pad),0);
  assign(f1,'aperture.dat');
  reset(f1);
  while not eof(f1) do
  begin
    readln(f1,s1);
    if (pos('D',s1) = 1) and (pos('*',s1) = 4) then
    begin
      apert_str := copy(s1,2,2);
      val(apert_str,apert,i);
      if apert >9 then
      begin
        i := pos('PEN',s1);
        if i > 0 then
        begin
          inc(i,4);
          pen_str := '';
          while (i<=length(s1)) and (s1[i] in ['0'..'9']) do
          begin
            pen_str := pen_str + s1[i];
            inc(i);
          end;
          val(pen_str,pen,i);
          apert_pen[apert] := pen;
        end;
        i := pos('PAD',s1);
        if i > 0 then
        begin
          inc(i,4);
          pad_str := '';
          while (i<=length(s1)) and (s1[i] in ['0'..'9']) do
          begin
            pad_str := pad_str + s1[i];
            inc(i);
          end;
          val(pad_str,pad,i);
          apert_pad[apert] := pad;
        end;
      end;
    end;
    writeln(s1);
  end;
  close(f1);
end;

{
D01* = PEN DOWN
D02* = PEN UP
D03* = FLASH
D11* = PEN 1
D12* = PEN 2
D13* = PEN 3
D14* = PEN 4
D15* = PEN 5
D16* = PEN 6
D17* = PEN 7
D30* = PEN 1    PAD 0
D31* = PEN 1    PAD 7
D32* = PEN 1    PAD 9

}



procedure mess(w:string80);
begin
  writeln(#13#10,w);
  halt;
end;


procedure load_gerber;
var
  f1:text;
{  nummer : char;}
  xs,ys,ds,dummy_str : string80;
  dummy_int : integer;
  xr,yr:real;
  i,x,y : integer;
  pen,pad:word;
  gerb_str : string80;
  apert : word;
begin
  writeln(#10#10#13,'Reading ',paramstr(1));
  assign(f1,paramstr(1));
  {$i-} reset(f1); {$I+}
  if ioresult <> 0 then
  begin
    writeln('Gerber file ',paramstr(1),' not open...');
    halt;
  end;
  while not eof(f1) do
  begin
    readln(f1,gerb_str);
    if length(gerb_str) > 0 then
    begin
      if gerb_str[1] = 'D' then {select aperture}
      begin
        dummy_str := copy(gerb_str,2,2);
        val(dummy_str,apert,dummy_int);
        pen := apert_pen[apert];
        pad := apert_pad[apert];

{       writeln('PEN = ',pen,'  PAD = ',pad);
        ch := readkey;
}
      end;
      if gerb_str[1] = 'X' then
      begin
        if top_array < 30000 then inc(top_array) else mess('full');
        xs := copy(gerb_str,2,pos('Y',gerb_str)-2);
        ys := copy(gerb_str,pos('Y',gerb_str)+1,pos('D',gerb_str) - pos('Y',gerb_str)-1);
        ds := copy(gerb_str,pos('D',gerb_str)+1,pos('*',gerb_str) - pos('D',gerb_str)-1);

        if ((xs[1] = '-') or (xs[1] = '+')) and (pos('.',xs) = 0)
        then insert('.',xs,4);
        if ((ys[1] = '-') or (ys[1] = '+')) and (pos('.',ys) = 0)
        then insert('.',ys,4);
        if pos('.',xs) = 0 then insert('.',xs,3);
        if pos('.',ys) = 0 then insert('.',ys,3);
{        writeln(#13#10' XS =',xs,' YS =',ys,' DS =',ds); }
        val(xs,xr,x);
        val(ys,yr,y);
        x := round(xr * 1280);
        y := round(yr * 1280);
{        writeln(hoogsteregel,'  X = ',x,' Y = ',y,' ',ds);}
        xpos^[top_array] := x;
        ypos^[top_array] := y;
        if ds = '01' then attr^[top_array] := (layer shl 3) + pen {pd} else
        if ds = '02' then attr^[top_array] := (layer shl 3)       {pu} else
        if ds = '03' then attr^[top_array] := $80 + (pad shl 3);
      end;
    end;
  end;
  close(f1);
end;


begin
  if paramcount < 2 then
  begin
    clrscr;
    writeln('type   GERBLAYO source destination [layer]');
    writeln;
    writeln('Example : gerblayo a:\demo.g01 c:\layo1p\demo.lmc 2');
    writeln;
    halt;
  end;
  init;
  load_aperture_dat;
  load_gerber;
  save_lmc;
  writeln('ok...');
end.

