program layotool;

{  PROGRAMM EXAMPLES Layo1 PCB-CAD-CAM SOFTWARE  REV 4.90  }

{  MAKE YOUR OWN TOOLS !!  }

uses
  crt;

const
{  max_data = $7FEF; }
  max_data = 2046;
  remark = '****************************************************************';

type
  string100 = string[100];

  wrd_array = array[0..max_data] of word;
  int_array = array[0..max_data] of integer;

var
  block : ^wrd_array;
  attr : ^wrd_array;
  xpos  : ^int_array;
  ypos  : ^int_array;
  net   : ^wrd_array;

  top_array : word;

  board_offset_x : integer;
  board_offset_y : integer;
  board_size_x   : integer;
  board_size_y   : integer;

  f2 : text;


procedure init;
begin
  new(block); fillchar(block^,sizeof(block^),0);
  new(attr);  fillchar(attr^ ,sizeof(attr^) ,0);
  new(xpos);  fillchar(xpos^ ,sizeof(xpos^) ,0);
  new(ypos);  fillchar(ypos^ ,sizeof(ypos^) ,0);
  new(net);   fillchar(net^  ,sizeof(net^)  ,0);
  top_array := 0;
end;




procedure load_ply(f_name:string100;var ok:boolean);

type
  ply_rec = record
              blk : word;
              att : word;
              xps : integer;
              yps : integer;
              net : word;
            end;

var
  i      : word;
  f1     : file of ply_rec;
  f1_rec : ply_rec;
  f1_len : word;
begin
  assign(f1,f_name);
  {$I-} reset(F1) {$I+};
  ok:=(ioresult = 0);
  if not ok then
  begin
    writeln(f2,f_name,' not found...');
    exit;
  end;
  f1_len := filesize(f1);
  if f1_len > max_data then
  begin
    writeln(f2,'file to long (',f1_len,') datalines...');
    exit;
  end;

  for i := 1 to f1_len do
  begin
    read(f1,f1_rec);
    block^[i] := f1_rec.blk;
    attr^[i]  := f1_rec.att;
    xpos^[i]  := f1_rec.xps;
    ypos^[i]  := f1_rec.yps;
    net^[i]   := f1_rec.net;
  end;
  close(f1);
  top_array := f1_len;
  board_offset_x := xpos^[2] + 8;
  board_offset_y := ypos^[2] + 8;
  board_size_x   := (xpos^[8] - xpos^[2]) - 16;
  board_size_y   := (ypos^[8] - ypos^[2]) - 16;
end;






procedure show_fixed_data;
var
  i : word;
begin
  clrscr;
  writeln(f2,'    line   block    attr     net    xpos    ypos');
  window(1,2,80,24);
  for i := 1 to top_array do
  begin
    writeln(f2,i:8,block^[i]:8,attr^[i]:8,net^[i]:8,xpos^[i]:8,ypos^[i]:8);
  end;
  window(1,1,80,25)
end;




procedure show_net_data;
var
  i : word;
begin
  clrscr;
  for i := 1 to top_array do
  begin
    if net^[i] and $1FFF > 0 then writeln(f2,i:4,' net = ',net^[i] and $1FFF);
  end;
end;

procedure show_block_data;
var
  i : word;
begin
  clrscr;
  for i := 1 to top_array do
  begin
    if block^[i] and $1FFF > 0
                then writeln(f2,i:4,' block = ',block^[i] and $1FFF);
  end;
end;


procedure show_pad(atr,blk:word);
var
  xm,
  ym : boolean;
begin
  if atr and $80 = $80 then write(f2,'pad = ',atr and $78 shr 3:3,
                                  '  tool = ',(blk shr 10) + (atr and 7):3)
  else
  if atr and $100 = $100 then write(f2,'pad = ',atr and $7F:3,
                                     ' Layer = 1 ')
  else
  if atr and $200 = $200 then write(f2,'pad = ',atr and $7F:3,
                                     ' Layer = 2 ');

  write(f2,' Rot. = ',(atr shr 10 and $3F) * 7.5 :6:1,' Degr.');
  writeln(f2,' x_mirr = ',blk shr 15,' y_mirr = ',blk shr 14 and 1);
end;


procedure show_pen_data(atr:word);
begin
  writeln(f2,'layer = ',atr and $78 shr 3:3,'   pen = ',atr and 7:3);
end;


procedure show_data;
var
  i : word;
begin
  clrscr;
  for i := 1 to top_array do if attr^[i] and $380 > 0

  then show_pad(attr^[i],block^[i]) else show_pen_data(attr^[i]);
end;


procedure show_cnf(f_name:string100);
var
  f1 : text;
  w1 : string100;
  i,
  max_pad_read : word;
begin
  assign(f1,f_name);
  {$I-} reset(f1);  {$i+}
  if ioresult > 0 then
  begin
    writeln(f2,f_name,' not found...');
    exit;
  end;
  readln(f1,w1); writeln(f2,'version : ',w1);
  max_pad_read := 15;
  if pos('4.85',w1) > 0 then max_pad_read := 127;
  readln(f1,w1); writeln(f2,'program_name : ',w1);
  readln(f1,w1); writeln(f2,'file_name : ',w1);
  readln(f1,w1); writeln(f2);
  readln(f1,w1); writeln(f2);
  readln(f1,w1); writeln(f2,'board_size_x : ',w1);
  readln(f1,w1); writeln(f2,'board_size_y : ',w1);
  readln(f1,w1); writeln(f2,'board_offset_x : ',w1);
  readln(f1,w1); writeln(f2,'board_offset_y : ',w1);
  readln(f1,w1); writeln(f2,'LAY file_name : ',w1);
  readln(f1,w1); writeln(f2,'PLY file_name : ',w1);
  readln(f1,w1); writeln(f2,'CMP file_name : ',w1);
  readln(f1,w1); writeln(f2,'NET file_name : ',w1);
  for i:=1 to 6 do
  begin
    readln(f1,w1); {notting}
    writeln(f2);
  end;
  for i:=0 to 15 do
  begin
    readln(f1,w1);
    writeln(f2,'tool_diam[',i,'] : ',w1);
  end;
  readln(f1,w1);
  writeln(f2,'pad_type       x-      y-     x+    y+    corner');
  for i:=0 to max_pad_read do
  begin
    readln(f1,w1);
    writeln(f2,copy(w1,1,8),   { pad type  }
               copy(w1,9,8),   { x1 }
               copy(w1,17,8),  { y1 }
               copy(w1,25,8),  { x2 }
               copy(w1,33,8),  { y2 }
               copy(w1,41,8)); { corner }
  end;
  readln(f1,w1);
  for i:=1 to 7 do
  begin
    readln(f1,w1);
    writeln(f2,'pen_diam[',i,'] = ',w1);
  end;
  readln(f1,w1);
  while not eof(f1) do
  begin
    readln(f1,w1);
    if w1 > '' then writeln(f2,w1);
  end;
  close(f1);
end;


procedure test;
var
  result : boolean;
begin
  init;
  load_ply('testtool.ply',result);
  if not result then halt;

  writeln(f2,remark);

  show_fixed_data;

  writeln(f2,remark);

  show_data;

  writeln(f2,remark);

  show_cnf('testtool.cnf');

  writeln(f2,remark);
end;




begin
  assign(f2,'layotool.lst');
  rewrite(f2);
  test;
  close(f2);
  writeln('all output in "layotool.lst"');
end.


