program show_lay;

uses crt;

const max_arr = 30000;

type barr = array[0..max_arr] of byte;
     iarr = array[0..max_arr] of integer;

var
  b,s : ^barr;
  x,y : ^iarr;

procedure init;
var
  i:word;
begin
  new(b);
  new(s);
  new(x);
  new(y);
  for i := 0 to max_arr do
  begin
    b^[i] := 0;
    s^[i] := 0;
    x^[i] := 0;
    y^[i] := 0;
  end;
end;

procedure show_lay_inp;
type
  lay_rec = record b,s : byte; x,y : integer; end;
var
  f1 : file of lay_rec;
  f2 : text;
  lr : lay_rec;
  i  : word;
  size : word;
  w1 : string;
begin
  assign(f1,paramstr(1));
  reset(f1);
  assign(f2,'show_lay.dat');
  rewrite(f2);
  size := filesize(f1);
  writeln(f2,' In ',paramstr(1),' ',size,' datalines found..');
  if length(paramstr(2)) > 0 then
  begin
    w1 := paramstr(2);
    val(w1,size,i);
    if i > 0 then
    begin
      writeln('Error in paramstr(2)');
      halt;
    end;
    writeln(f2,' In ',paramstr(1),' ',size,' datalines to read..'#13#10);
  end;
  {$i-}
  for i := 1 to size do
  begin
    read(f1,lr);
    b^[i] := lr.b;
    s^[i] := lr.s;
    x^[i] := lr.x;
    y^[i] := lr.y;
  end;
  close(f1);
  {$i+}
  writeln(ioresult);
  writeln(f2,' Data of ',paramstr(1),#13#10);
  writeln(f2,' Line   Block  Sympen  Xposition  Yposition');
  for i := 1 to size do
  begin
    writeln(f2,i:5,b^[i]:8,s^[i]:8,x^[i]:11,y^[i]:11);
  end;
  close(f2);
end;

procedure save_data;
type
  lay_rec = record b,s : byte; x,y : integer; end;
var
  f1 : file of lay_rec;
  lr : lay_rec;
  i  : word;
  size : word;
  w1 : string;
begin
  if paramstr(3) = '' then exit;
  assign(f1,paramstr(3));
  rewrite(f1);
  for i := 1 to size do
  begin
    lr.b := b^[i];
    lr.s := s^[i];
    lr.x := x^[i];
    lr.y := y^[i];
    write(f1,lr);
  end;
  close(f1);
end;

begin
  clrscr;
  init;
  show_lay_inp;
  save_data;
end.
