program smartcon;

uses  Crt;

const bufsize                 = 64000;

type  directions              = (up,down,right,left,
                                 upright,upleft,dnright,dnleft);

var   infile                  : file;
      outfile                 : text;

      filhead                 : record
      code                    : array [0..3] of char;
      dummy                   : array [4..9] of byte;
      headx                   : integer;
      heady                   : integer;
      rest                    : integer;
      end;

      lbuffer                 : array [0..bufsize] of byte;
      flen,plen,xmax,ymax     : integer;
      padcnt,junction         : integer;
      lincnt,barcnt           : integer;
      traceend                : boolean;
      direction,olddir,sdir   : directions;

      ch                      : char;

function GETSYMBOL (xcor,ycor,page: integer): integer;
var   adr       : integer;

begin
  adr := plen*page+trunc(ycor*(xmax shr 1) + (xcor shr 1));
{  if (adr > bufsize) or (adr<0)
               then ch:=readkey; }
  if (xcor and 1)=0 then getsymbol := (lbuffer[adr] shr 4) and 15
                    else getsymbol := lbuffer[adr] and 15;
end; { von getsymbol }

procedure PUTSYMBOL (xcor,ycor,page,symbol: integer);
var   adr       : integer;

begin
  adr := plen*page+trunc(ycor*(xmax shr 1) +(xcor shr 1));
  if (xcor and 1)=0 then lbuffer[adr] := symbol*16+lbuffer[adr] and 15
                    else lbuffer[adr] := symbol+lbuffer[adr] and 240;
end; { von putsymbol }

procedure SETPAD (xcor,ycor : integer);
var   offx,offy    : integer;

begin
  offx := 64*xcor; offy := -64*ycor; write (outfile,chr(1),chr(186));
  write (outfile,chr(lo(offx)),chr(hi(offx)),chr(lo(offy)),chr(hi(offy)));
end; { von setpad }

procedure GETPADS (page : integer);
var       loopx,loopy :   integer;

begin
  padcnt := 0;
  for loopy :=0 to ymax-1 do
    for loopx := 0 to xmax-1 do
     if getsymbol(loopx,loopy,page)=14 then begin
        padcnt := padcnt+1; gotoxy(1,wherey);
        write ('create LAYER 0 : transfering PAD  : ',padcnt:4);
        setpad(loopx,loopy);
     end; { von if }
     if padcnt>0 then begin writeln; writeln; end;
end; { von getpads }

procedure DOJUNCTION (xcor,ycor,page,symbol,junction : integer);
var   offx,offy,diff : integer;

begin
  gotoxy(1,wherey);
  write('create LAYER ',page+1:1,' : replace JUNCTION : ',junction:4);
  offx := 64*xcor; offy := -64*ycor;
  write (outfile,chr(0),chr(8*page+8));
  write (outfile,chr(lo(offx)),chr(hi(offx)),chr(lo(offy)),chr(hi(offy)));
  case symbol of
        7 : begin offy := offy-32; putsymbol(xcor,ycor,page,6); end;
        8 : begin offx := offx+32; putsymbol(xcor,ycor,page,5); end;
        9 : begin offy := offy+32; putsymbol(xcor,ycor,page,6); end;
       10 : begin offx := offx-32; putsymbol(xcor,ycor,page,5); end;
       end; { von case }
  write (outfile,chr(0),chr(8*page+9));
  write (outfile,chr(lo(offx)),chr(hi(offx)),chr(lo(offy)),chr(hi(offy)));
end; { von dojunction }

procedure GETJUNCTION (page : integer);
var       loopx,loopy,symbol : integer;

begin
  junction := 0;
  for loopy :=0 to ymax-1 do
    for loopx := 0 to xmax-1 do begin
      symbol := getsymbol(loopx,loopy,page);
      if (symbol>6) and (symbol<11) then begin
         junction := junction+1;
         dojunction(loopx,loopy,page,symbol,junction);
      end; { von if }
    end; { von for }
    if junction>0 then writeln;
end; { von getjunction }

procedure DOTRACE (page,mode,xcor,ycor,offx,offy : integer);

begin
  offx := offx+64*xcor; offy := offy-64*ycor;
  write (outfile,chr(0),chr(8*page+8+mode));
  write (outfile,chr(lo(offx)),chr(hi(offx)),chr(lo(offy)),chr(hi(offy)));
end; { von dotrace }

procedure TRACEUP (var xcor,ycor,flag : integer; page,mode : integer);
var       sy : integer;

begin
  sy := getsymbol(xcor,ycor,page);
  while (ycor<ymax) and (sy=5) or (sy=11) do
    begin
      if mode=1 then
         if sy=5 then putsymbol(xcor,ycor,page,0)
                 else putsymbol(xcor,ycor,page,6);
      ycor := ycor+1;
      sy := getsymbol(xcor,ycor,page);
    end; { von while }
  if (ycor=ymax) or (sy=0) or (sy=1) or (sy=2) or (sy=6) or (sy=15) then
     begin
       dotrace(page,mode,xcor,ycor,0,32); traceend := true;
       ycor := ycor-1; olddir := direction; direction := down;
     end { von then }
  else if sy=14 then
          begin
            dotrace(page,mode,xcor,ycor,0,32); traceend := true;
            ycor := ycor-1; olddir := direction; direction := down;
          end { von then }
       else begin
              case sy of
                3: begin olddir := direction; direction := upright; end;
                4: begin olddir := direction; direction := upleft; end;
               12: begin olddir := direction; direction := upright; end;
               13: begin olddir := direction; direction := upleft; end;
              end; { von case }
              flag := 0;
              if mode=1 then dotrace(page,mode,xcor,ycor,0,32);
       end; { von else }
end; { von traceup }

procedure TRACEDOWN (var xcor,ycor,flag : integer; page,mode : integer);
var       sy : integer;

begin
  sy := getsymbol(xcor,ycor,page);
  while (ycor>-1) and (sy=5) or (sy=11) do
    begin
      if mode=1 then
         if sy=5 then putsymbol(xcor,ycor,page,0)
                 else putsymbol(xcor,ycor,page,6);
      ycor := ycor-1;
      sy := getsymbol(xcor,ycor,page);
    end; { von while }
  if (ycor=-1) or (sy=0) or (sy=3) or (sy=4) or (sy=6) or (sy=15) then
     begin
       dotrace(page,mode,xcor,ycor,0,-32); traceend := true;
       ycor := ycor+1; olddir := direction; direction := up;
     end { von then }
  else if sy=14 then
          begin
            dotrace(page,mode,xcor,ycor,0,-32); traceend := true;
            ycor := ycor+1; olddir := direction; direction := up;
          end { von then }
       else begin
              case sy of
                1: begin olddir := direction; direction := dnleft; end;
                2: begin olddir := direction; direction := dnright; end;
               12: begin olddir := direction; direction := dnleft; end;
               13: begin olddir := direction; direction := dnright; end;
              end; { von case }
              flag := 0;
              if mode=1 then dotrace(page,mode,xcor,ycor,0,-32);
       end; { von else }
end; { von tracedown }

procedure TRACERIGHT (var xcor,ycor,flag : integer; page,mode : integer);
var       sy : integer;

begin
  sy := getsymbol(xcor,ycor,page);
  while (xcor<xmax) and (sy=6) or (sy=11) do
    begin
      if mode=1 then
         if sy=6 then putsymbol(xcor,ycor,page,0)
                 else putsymbol(xcor,ycor,page,5);
      xcor := xcor+1;
      sy := getsymbol(xcor,ycor,page);
    end; { von while }
  if (xcor=xmax) or (sy=0) or (sy=2) or (sy=3) or (sy=5) or (sy=15) then
     begin
       dotrace(page,mode,xcor,ycor,-32,0); traceend := true;
       xcor := xcor-1; olddir := direction; direction := left;
     end { von then }
  else if sy=14 then
          begin
            dotrace(page,mode,xcor,ycor,-32,0); traceend := true;
            xcor := xcor-1; olddir := direction; direction := left;
          end { von then }
       else begin
              case sy of
                1: begin olddir := direction; direction := upright; end;
                4: begin olddir := direction; direction := dnright; end;
               12: begin olddir := direction; direction := upright; end;
               13: begin olddir := direction; direction := dnright; end;
              end; { von case }
              flag := 1;
              if mode=1 then dotrace(page,mode,xcor,ycor,-32,0);
       end; { von else }
end; { von traceright }

procedure TRACELEFT (var xcor,ycor,flag : integer; page,mode : integer);
var       sy : integer;

begin
  sy := getsymbol(xcor,ycor,page);
  while (xcor>-1) and (sy=6) or (sy=11) do
    begin
      if mode=1 then
         if sy=6 then putsymbol(xcor,ycor,page,0)
                 else putsymbol(xcor,ycor,page,5);
      xcor := xcor-1;
      sy := getsymbol(xcor,ycor,page);
    end; { von while }
  if (xcor=-1) or (sy=0) or (sy=1) or (sy=4) or (sy=5) or (sy=15) then
     begin
       dotrace(page,mode,xcor,ycor,32,0); traceend := true;
       xcor := xcor+1; olddir := direction; direction := right;
     end { von then }
  else if sy=14 then
          begin
            dotrace(page,mode,xcor,ycor,32,0); traceend := true;
            xcor := xcor+1; olddir := direction; direction := right;
          end { von then }
       else begin
              case sy of
                2: begin olddir := direction; direction := upleft; end;
                3: begin olddir := direction; direction := dnleft; end;
               12: begin olddir := direction; direction := dnleft; end;
               13: begin olddir := direction; direction := upleft; end;
              end; { von case }
              flag := 1;
              if mode=1 then dotrace(page,mode,xcor,ycor,32,0);
       end; { von else }
end; { von traceleft }

procedure TRACEUPRIGHT (var xcor,ycor,flag : integer; page,mode : integer);
var       sy : integer;

begin
  sy := getsymbol(xcor,ycor,page);
  while (xcor<xmax) and (ycor<ymax) and (sy=12) or
        ((flag=0) and (sy=3)) or ((flag=1) and (sy=1)) do
    begin
      if mode=1 then
         if (sy=1) or (sy=3) then putsymbol(xcor,ycor,page,0) else
            if flag=0 then putsymbol(xcor,ycor,page,1)
                      else putsymbol(xcor,ycor,page,3);
      if flag=0 then xcor := xcor+1 else ycor := ycor+1;
      sy := getsymbol(xcor,ycor,page);
      flag := 1-flag;
    end; { von while }
  if flag=1 then
    if (xcor=xmax) or (sy=0) or (sy=2) or (sy=3) or (sy=5) or (sy=15) then
       begin
         dotrace(page,mode,xcor,ycor,-32,0); traceend := true;
         xcor := xcor-1; olddir := direction; direction := dnleft;
       end { von then }
    else if sy=14 then
            begin
              dotrace(page,mode,xcor,ycor,-32,0); traceend := true;
              xcor := xcor-1; olddir := direction; direction := dnleft;
            end { von then }
         else begin
                case sy of
                  4: begin olddir := direction; direction := dnright; end;
                  6: begin olddir := direction; direction := right; end;
                 11: begin olddir := direction; direction := right; end;
                 13: begin olddir := direction; direction := dnright; end;
                end; { von case }
                if mode=1 then dotrace(page,mode,xcor,ycor,-32,0);
         end { von else }
  else
    if (ycor=ymax) or (sy=0) or (sy=1) or (sy=2) or (sy=6) or (sy=15) then
       begin
         dotrace(page,mode,xcor,ycor,0,32); traceend := true;
         ycor := ycor-1; olddir := direction; direction := dnleft;
       end { von then }
    else if sy=14 then
            begin
              dotrace(page,mode,xcor,ycor,0,32); traceend := true;
              ycor := ycor-1; olddir := direction; direction := dnleft;
            end { von then }
         else begin
                case sy of
                  4: begin olddir := direction; direction := upleft; end;
                  5: begin olddir := direction; direction := up; end;
                 11: begin olddir := direction; direction := up; end;
                 13: begin olddir := direction; direction := upleft; end;
                end; { von case }
                if mode=1 then dotrace(page,mode,xcor,ycor,0,32);
         end; { von else }
end; { von traceupright }

procedure TRACEUPLEFT (var xcor,ycor,flag : integer; page,mode : integer);
var       sy : integer;

begin
  sy := getsymbol(xcor,ycor,page);
  while (xcor>-1) and (ycor<ymax) and (sy=13) or
        ((flag=0) and (sy=4)) or ((flag=1) and (sy=2)) do
    begin
      if mode=1 then
         if (sy=2) or (sy=4) then putsymbol(xcor,ycor,page,0) else
            if flag=0 then putsymbol(xcor,ycor,page,2)
                      else putsymbol(xcor,ycor,page,4);
      if flag=0 then xcor := xcor-1 else ycor := ycor+1;
      sy := getsymbol(xcor,ycor,page);
      flag := 1-flag;
    end; { von while }
  if flag=1 then
    if (xcor=-1) or (sy=0) or (sy=1) or (sy=4) or (sy=5) or (sy=15) then
       begin
         dotrace(page,mode,xcor,ycor,32,0); traceend := true;
         xcor := xcor+1; olddir := direction; direction := dnright;
       end { von then }
    else if sy=14 then
            begin
              dotrace(page,mode,xcor,ycor,32,0); traceend := true;
              xcor := xcor+1; olddir := direction; direction := dnright;
            end { von then }
         else begin
                case sy of
                  3: begin olddir := direction; direction := dnleft; end;
                  6: begin olddir := direction; direction := left; end;
                 11: begin olddir := direction; direction := left; end;
                 12: begin olddir := direction; direction := dnleft; end;
                end; { von case }
                if mode=1 then dotrace(page,mode,xcor,ycor,32,0);
         end { von else }
  else
    if (ycor=ymax) or (sy=0) or (sy=1) or (sy=2) or (sy=6) or (sy=15) then
       begin
         dotrace(page,mode,xcor,ycor,0,32); traceend := true;
         ycor := ycor-1; olddir := direction; direction := dnright;
       end { von then }
    else if sy=14 then
            begin
              dotrace(page,mode,xcor,ycor,0,32); traceend := true;
              ycor := ycor-1; olddir := direction; direction := dnright;
            end { von then }
         else begin
                case sy of
                  3: begin olddir := direction; direction := upright; end;
                  5: begin olddir := direction; direction := up; end;
                 11: begin olddir := direction; direction := up; end;
                 12: begin olddir := direction; direction := upright; end;
                end; { von case }
                if mode=1 then dotrace(page,mode,xcor,ycor,0,32);
         end; { von else }
end; { von traceupleft }

procedure TRACEDNRIGHT (var xcor,ycor,flag : integer; page,mode : integer);
var       sy : integer;

begin
  sy := getsymbol(xcor,ycor,page);
  while (xcor<xmax) and (ycor>-1) and (sy=13) or
        ((flag=0) and (sy=2)) or ((flag=1) and (sy=4)) do
    begin
      if mode=1 then
         if (sy=2) or (sy=4) then putsymbol(xcor,ycor,page,0) else
            if flag=0 then putsymbol(xcor,ycor,page,4)
                      else putsymbol(xcor,ycor,page,2);
      if flag=0 then xcor := xcor+1 else ycor := ycor-1;
      sy := getsymbol(xcor,ycor,page);
      flag := 1-flag;
    end; { von while }
  if flag=1 then
    if (xcor=xmax) or (sy=0) or (sy=2) or (sy=3) or (sy=5) or (sy=15) then
       begin
         dotrace(page,mode,xcor,ycor,-32,0); traceend := true;
         xcor := xcor-1; olddir := direction; direction := upleft;
       end { von then }
    else if sy=14 then
            begin
              dotrace(page,mode,xcor,ycor,-32,0); traceend := true;
              xcor := xcor-1; olddir := direction; direction := upleft;
            end { von then }
         else begin
                case sy of
                  1: begin olddir := direction; direction := upright; end;
                  6: begin olddir := direction; direction := right; end;
                 11: begin olddir := direction; direction := right; end;
                 12: begin olddir := direction; direction := upright; end;
                end; { von case }
                if mode=1 then dotrace(page,mode,xcor,ycor,-32,0);
         end { von else }
  else
    if (ycor=-1) or (sy=0) or (sy=3) or (sy=4) or (sy=6) or (sy=15) then
       begin
         dotrace(page,mode,xcor,ycor,0,-32); traceend := true;
         ycor := ycor+1; olddir := direction; direction := upleft;
       end { von then }
    else if sy=14 then
            begin
              dotrace(page,mode,xcor,ycor,0,-32); traceend := true;
              ycor := ycor+1; olddir := direction; direction := upleft;
            end { von then }
         else begin
                case sy of
                  1: begin olddir := direction; direction := dnleft; end;
                  5: begin olddir := direction; direction := down; end;
                 11: begin olddir := direction; direction := down; end;
                 12: begin olddir := direction; direction := dnleft; end;
                end; { von case }
                if mode=1 then dotrace(page,mode,xcor,ycor,0,-32);
         end; { von else }
end; { von tracednright }

procedure TRACEDNLEFT (var xcor,ycor,flag : integer; page,mode : integer);
var       sy : integer;

begin
  sy := getsymbol(xcor,ycor,page);
  while (xcor>-1) and (ycor>-1) and (sy=12) or
        ((flag=0) and (sy=1)) or ((flag=1) and (sy=3)) do
    begin
      if mode=1 then
         if (sy=1) or (sy=3) then putsymbol(xcor,ycor,page,0) else
            if flag=0 then putsymbol(xcor,ycor,page,3)
                      else putsymbol(xcor,ycor,page,1);
      if flag=0 then xcor := xcor-1 else ycor := ycor-1;
      sy := getsymbol(xcor,ycor,page);
      flag := 1-flag;
    end; { von while }
  if flag=1 then
    if (xcor=-1) or (sy=0) or (sy=1) or (sy=4) or (sy=5) or (sy=15) then
       begin
         dotrace(page,mode,xcor,ycor,32,0); traceend := true;
         xcor := xcor+1; olddir := direction; direction := upright;
       end { von then }
    else if sy=14 then
            begin
              dotrace(page,mode,xcor,ycor,32,0); traceend := true;
              xcor := xcor+1; olddir := direction; direction := upright;
            end { von then }
         else begin
                case sy of
                  2: begin olddir := direction; direction := upleft; end;
                  6: begin olddir := direction; direction := left; end;
                 11: begin olddir := direction; direction := left; end;
                 13: begin olddir := direction; direction := upleft; end;
                end; { von case }
                if mode=1 then dotrace(page,mode,xcor,ycor,32,0);
         end { von else }
  else
    if (ycor=-1) or (sy=0) or (sy=3) or (sy=4) or (sy=6) or (sy=15) then
       begin
         dotrace(page,mode,xcor,ycor,0,-32); traceend := true;
         ycor := ycor+1; olddir := direction; direction := upright;
       end { von then }
    else if sy=14 then
            begin
              dotrace(page,mode,xcor,ycor,0,-32); traceend := true;
              ycor := ycor+1; olddir := direction; direction := upright;
            end { von then }
         else begin
                case sy of
                  2: begin olddir := direction; direction := dnright; end;
                  5: begin olddir := direction; direction := down; end;
                 11: begin olddir := direction; direction := down; end;
                 13: begin olddir := direction; direction := dnright; end;
                end; { von case }
                if mode=1 then dotrace(page,mode,xcor,ycor,0,-32);
         end; { von else }
end; { von tracednleft }

procedure TRACELINE (strtx,strty,page : integer);
var xcor,ycor,mode,sy,flag,sflag : integer;
    key               : char;

begin
  mode := 0;
  traceend := false;
  xcor := strtx; ycor := strty;
  sy := getsymbol(xcor,ycor,page);
  case sy of
       1: begin direction := upright; flag := 1; end;
       2: begin direction := dnright; flag := 0; end;
       3: begin direction := upright; flag := 0; end;
       4: begin direction := dnright; flag := 1; end;
       5: begin direction := up;      flag := 0; end;
       6: begin direction := right;   flag := 0; end;
      11: begin direction := right;   flag := 0; end;
      12: begin direction := upright; flag := 1; end;
      13: begin direction := dnright; flag := 1; end;
      end; { von case }
  sdir := direction; sflag := flag;
  repeat
    { writeln (xcor:4,ycor:4,ord(direction):4); }
    case direction of
         up      : traceup(xcor,ycor,flag,page,mode);
         down    : tracedown(xcor,ycor,flag,page,mode);
         right   : traceright(xcor,ycor,flag,page,mode);
         left    : traceleft(xcor,ycor,flag,page,mode);
         upright : traceupright(xcor,ycor,flag,page,mode);
         upleft  : traceupleft(xcor,ycor,flag,page,mode);
         dnright : tracednright(xcor,ycor,flag,page,mode);
         dnleft  : tracednleft(xcor,ycor,flag,page,mode);
         end; { von case }
  until (traceend=true) or
        ((direction=sdir) and (flag=sflag) and (xcor=strtx) and (ycor=strty));
  if traceend=false then dotrace(page,mode,xcor,ycor,0,-32);
  traceend := false;
  mode := 1;
  repeat
  { writeln (xcor:4,ycor:4,ord(direction):4); }
    case direction of
         up      : traceup(xcor,ycor,flag,page,mode);
         down    : tracedown(xcor,ycor,flag,page,mode);
         right   : traceright(xcor,ycor,flag,page,mode);
         left    : traceleft(xcor,ycor,flag,page,mode);
         upright : traceupright(xcor,ycor,flag,page,mode);
         upleft  : traceupleft(xcor,ycor,flag,page,mode);
         dnright : tracednright(xcor,ycor,flag,page,mode);
         dnleft  : tracednleft(xcor,ycor,flag,page,mode);
         end; { von case }
  until traceend=true;
end; { von traceline }

procedure GETLINES (page : integer);
var       loopx,loopy,sy : integer;

begin
  lincnt := 0;
  for loopy :=0 to ymax-1 do
    for loopx := 0 to xmax-1 do
        begin
          sy := getsymbol(loopx,loopy,page);
          if (sy>0) and (sy<14) then
             begin
               lincnt := lincnt+1; gotoxy(1,wherey);
               if junction=0 then write ('create LAYER ',page+1:1)
                             else write ('              ');
               write(' : rerouting TRACE  : ',lincnt:4);
               traceline(loopx,loopy,page);
             end; { von if }
        end; { von for }
  if lincnt>0 then writeln;
end; { von getlines }

procedure DOBAR (page,mode,xcor,ycor,offx,offy : integer);

begin
  offx := offx+64*xcor; offy := offy-64*ycor;
  write (outfile,chr(0),chr(8*(page+2)+8+3*mode));
  write (outfile,chr(lo(offx)),chr(hi(offx)),chr(lo(offy)),chr(hi(offy)));
end; { von dobar }

procedure GETBARS (page : integer);
var       loopx,loopy,sy1,sy2 : integer;

begin
  barcnt := 0;
  for loopy :=0 to ymax-1 do
    begin
      loopx := 0;
      sy1 := getsymbol(loopx,loopy,page);
      sy2 := getsymbol(loopx+1,loopy,page);
      repeat
        while (loopx<xmax-1) and ((sy1<>15) or (sy2<>15)) do
          begin
            loopx := loopx+1;
            sy1 := getsymbol(loopx,loopy,page);
            sy2 := getsymbol(loopx+1,loopy,page);
          end;
        if loopx<xmax-1 then
           begin
             barcnt := barcnt+1; gotoxy(1,wherey);
             write ('create LAYER ',page+3:1,' : simulate FATWIRE : ',barcnt:4);
             dobar(page,0,loopx,loopy,0,0);
             while (loopx<xmax) and (sy1=15) do
               begin
                 putsymbol(loopx,loopy,page,0);
                 loopx := loopx+1;
                 sy1 := getsymbol(loopx,loopy,page);
               end;
             dobar(page,1,loopx-1,loopy,0,0);
           end;
      until loopx>xmax-2;
    end;
  for loopx :=0 to xmax-1 do
    begin
      loopy := 0;
      sy1 := getsymbol(loopx,loopy,page);
      repeat
        while (loopy<ymax) and (sy1<>15) do
          begin
            loopy := loopy+1;
            sy1 := getsymbol(loopx,loopy,page);
          end;
        if loopy<ymax then
           begin
             barcnt := barcnt+1; gotoxy(1,wherey);
             write ('create LAYER ',page+3:1,' : simulate FATWIRE : ',barcnt:4);
             dobar(page,0,loopx,loopy,0,1);
             while (loopy<ymax) and (sy1=15) do
               begin
                 putsymbol(loopx,loopy,page,0);
                 loopy := loopy+1;
                 sy1 := getsymbol(loopx,loopy,page);
               end;
             dobar(page,1,loopx,loopy-1,0,-1);
           end;
      until loopy=ymax;
    end;
    if barcnt>0 then writeln;
    writeln;
end; { von getbars }

begin
  lowvideo;
  writeln;
  writeln ('smARTWORK - LAYO1 Datenkonverter Version 1.1');
  writeln ('CD-Elektronik,Saarwellingen. (c)88 M+M Comtech.');
  writeln;
  if ParamCount=2 then begin
    assign (infile,paramstr(1));
    (*$I-*) reset (infile,1); (*$I+*)
    if IOResult=0 then begin
      blockread (infile,filhead,16);
      with filhead do begin xmax := headx; ymax := heady; end;
      flen := xmax*ymax; plen := flen shr 1;
      blockread (infile,lbuffer,flen);
      close (infile);
      assign (outfile,paramstr(2));
      (*$I-*) rewrite (outfile); (*$I+*)
      if IOResult=0 then begin
        getpads(0);
        getjunction(0); getlines(0); getbars(0);
        getjunction(1); getlines(1); getbars(1);
        close(outfile);
        writeln ('SUCCESS: DESIGN-TRANSLATION COMPLETED.');
      end else writeln ('Outputfile ',paramstr(2),': opening failed.');
    end else writeln ('Inputfile ',paramstr(1),': opening failed.');
  end else writeln ('Call: SMARTCON smartfile layofile.bnk');
end.
