Class:Contact
  Index:FullName
  Index:Company
  Index:WorkPhone
  Index:LastName
  Index:ZipCode
  Addr1
  Addr2
  Addr3
  HomePhone
  FaxPhone
  StartDate
  LastUpDate
  MailCode
  CustCode
  Location
  Dear
  PhoneNote
  Comment
  Type
  Notes
  Sales         | Actual sales to date
  ForSales      | Forcast Sales
  ForDate       |     Date,
  ForChances    |     Chances

Contact:Start
  | JORF Contact Management Data Base
  New (Contact:Contact)

  | Other source files
  Jorf:File("TextEdit.J",Here)            | Text Editor
  Jorf:File("DirList.J",Here)             | Directory Lister
  Jorf:File("Filter.J",Here)              | Filters
  Jorf:File("ConHelp.J",Here)             | Help

  | Initialization . . .
  Mem:Ptr->ContactFile   = "CONTACT"      | Default Contact File
  Mem:Ptr->ContactFilter = Null           | All Records
  Mem:Ptr->FilterDescr   = "All Records"  | All Records

  | System Parameters.
  Contact:SetFile(Here)
  Event:Add ("Contact","Key",Here)              | Set Contact handler
  Contact:KeySearch("FullName",False)           | Go to top of file

  | Contact Manager Main Window
  |  The purpose of this window is to provide basic information on
  |  the contact, as well as show a browser of nearby contacts.  When
  |  you add, change or view, you can see additional information for
  |  this contact.  The Additional screens are unlimited.
  |
  |  The Main Window also acts as the Main Menu.  All functions are
  |  menu options from this screen.  When the operator hits escape
  |  (or Alt-X) we are done with the program.
  Win:Add ("Josephine's Contact Manager", 2, 2, 0, 0, Here)
    Menu:"&File"
      Menu:"&Open           F4", Action:"Contact:F4_Key"
      Menu:"&Filter         F7", Action:"Contact:F7_Key"
      Menu:"&Text Editor    F8", Action:"Contact:F8_Key"
      Menu:"&Rebuild        ", Action:"Contact:Rebuild"
      Menu:
      Menu:"&Set Mailcode   F2", Action:"Contact:F2_Key"
      Menu:"&Clear Mailcode ", Action:"Contact:ClearMailCode"
      Menu:
      Menu:"&About            "  Action:"Contact:About"
      Menu:"&Help           F1", Action:"Contact:F1_Key"
      Menu:
      Menu:"E&xit        Alt-X", Action:"Jorf:Exit"

    Menu:"&Edit"
      Menu:"&Add     Alt-A",  Action:"Contact:Edit ('Add')"
      Menu:"&Change  Alt-C",  Action:"Contact:Edit ('Change')"
      Menu:"&Delete       ",  Action:"Contact:Edit ('Delete')"

    Menu:"&Search",
      Menu:"&Name       ",  Action:"Contact:KeySearch ('FullName' ,True)
      Menu:"&Company    ",  Action:"Contact:KeySearch ('Company'  ,True)
      Menu:"&Last Name  ",  Action:"Contact:KeySearch ('LastName' ,True)
      Menu:"&Phone      ",  Action:"Contact:KeySearch ('WorkPhone',True)
      Menu:"&Zip        ",  Action:"Contact:KeySearch ('ZipCode'  ,True)

    Menu:"&Reports"
      Menu:"&Contact Data",       Action:"Contact:PrintData"
      Menu:"&List of Contacts",   Action:"Contact:List"
      Menu:"&Merge Letter",       Action:"Contact:MergeLetter"
      Menu:"L&abels",
        Menu:"&Avery 5162 - Laser Labels", Action:"Contact:Avery5162('All')"
        Menu:"&Continuous - 1x3 Inch   ", Action:"Contact:ContinLabels('All')"
      Menu:"&One Label",
        Menu:"&Avery 5162 - Laser Labels", Action:"Contact:Avery5162('One')"
        Menu:"&Continuous - 1x3 Inch   ", Action:"Contact:ContinLabels('One')"

    InpBefore:"Contact:Lock(Mem:Ptr->Contact)"
    InpAfter:"Contact:UnLock(Mem:Ptr->Contact)"
    Input:"File:"   Row:22 Col:1  Wid:8  Field:"Mem:Ptr->ContactFile"  Before:"False"
    Input:"Index:"  Row:22 Col:18 Wid:10 Field:"Mem:Ptr->IndexName"  Before:"False"
    Input:"Filter:" Row:22 Col:40 Wid:30 Field:"Mem:Ptr->FilterDescr"  Before:"False"
    Group:"&Browse List", Row:1 Col:1, Len:14, Wid:35
    List:""
      Field:"Mem:Ptr->Contact"
      Next:"Contact:NextRecord('Next')"
      Prev:"Contact:NextRecord('Prev')"
      Show:"Contact:Show()"

    Group:"C&ontact", Row:1, Col:38, Wid:39, Len:14
    Input:"Contact   ", Wid:28,        Field:"Mem:Ptr->Contact->FullName"
    Input:"Company   ", Wid:28,        Field:"Mem:Ptr->Contact->Company"
    Input:"Address   ", Wid:28,        Field:"Mem:Ptr->Contact->Addr1"
    Input:"          ", Wid:28,        Field:"Mem:Ptr->Contact->Addr2"
    Input:"          ", Wid:28,        Field:"Mem:Ptr->Contact->Addr3"
    Input:"&Work phone", Row:7 Col:39 Wid:28, Field:"Mem:Ptr->Contact->WorkPhone"
    Input:"Home phone", Row:8 Col:39 Wid:28, Field:"Mem:Ptr->Contact->HomePhone"
    Input:"Comment   ", Row:9 Col:39 Wid:28, Field:"Mem:Ptr->Contact->PhoneNote"

    Input:"Type      ", Row:11 Col:39  Wid:12,
      Field:"Mem:Ptr->Contact->Type"
      Before:"Return(False)"

    Input:"&Mail Code ", Row:12 Col:39  Wid:20,
      Field:"Mem:Ptr->Contact->MailCode"
    Input:"C&ust Code ", Row:13 Col:39  Wid:20,
      Field:"Mem:Ptr->Contact->CustCode"

    Group:"&Notes", Row:17, Col:1, Wid:76, Len:3
    Text:"Notes", Field:"Mem:Ptr->Contact->Notes"
  Return

Contact:About
  Msg:Add ("The JORF Contact Manager", "Ok")
    The JORF Contact Manager
    Version 1.2,  Feb 23, 1992

    Copyright (C) 1992 by Wayland Bruns
    All Rights Reserved

    The JORF Contact Manager is written as
    a demonstration of what you can do with
    the JORF Language.  The contact manager
    is a "flat file" data base with multiple
    keys, multiple files, filters, mail-
    merge capability, reports and labels.

    The source code for this entire system
    is less than 1000 lines, and you can
    easily change it to suit your own
    contact management needs.
  Return (Ok)

Contact:Alt_A_Key
  Contact:Edit('Add')
  Return(Ok)

Contact:Alt_C_Key
  Contact:Edit('Change')
  Return(Ok)

Contact:Avery5162(Flag)
  New (Dest,CurrContact)
  Dest=Jorf:Printer()
  If (Dest==Null)
    Return

  Event:Add
  Mem:Ptr->StartPos=1
  Mem:Ptr->InsMode='OverStrike'
  Win:Add ("Starting Position")
    String:"This format prints on the right row of the"
    String:"Avery 5162 label.  To conserve paper, you"
    String:"may enter the label to start with.  The top"
    String:"label is #1, and the bottom is #7."
    String:""
    Input:"Label to start        ", Wid:5, Field:"Mem:Ptr->StartPos"
    String:""
    String:"When each sheet is printed, turn it around"
    String:"to print on the other side."
  Win:Del
  Mem:Ptr->InsMode='Insert"
  If (Kbd:Got = 'Esc_Key')
    Return (Ok)

  Win:Add("Printing")
    Printing . . .
  Contact:SetFile(Here)
  CurrContact        = Mem:Ptr->Contact
  Mem:Ptr->OneContact= CurrContact
  Mem:Ptr->Contact   = Null

  | Report format for Continuous labels, 6 lines per label
  |
  Rep:Add ("Avery Labels", 9, 5, 49, 45, Here)
    Next:"Contact:NextLabel(Flag)"  Before:"Contact:Avery5162check"
    Item:"" NewRow:2
    Item:"'('+Mem:Ptr->Contact->MailCode+')'"  NewRow:1 Col:26 Wid:12
      Before:"Mem:Ptr->Contact->MailCode!=Null"
    Item:"" NewRow:1 Col:26 Wid:12
      Before:"Mem:Ptr->Contact->MailCode==Null"
    Item:"Mem:Ptr->Contact->FullName"    NewRow:1 Col:1  Wid:40
    Item:"Mem:Ptr->Contact->Company"     NewRow:1 Col:1  Wid:40
      Before:"Mem:Ptr->Contact->Company!=Null"
    Item:"Mem:Ptr->Contact->Addr1"       NewRow:1 Col:1  Wid:40
    Item:"Mem:Ptr->Contact->Addr2"       NewRow:1 Col:1  Wid:40
    Item:"Mem:Ptr->Contact->Addr3"       NewRow:1 Col:1  Wid:40
    Item:"" NewRow:1
      Before:"Mem:Ptr->Contact->Company==Null"
  File:Print("JREPORT.LST",Dest)
  Mem:Ptr->Contact=CurrContact
  Return(Null)

Contact:Avery5162check
  If (Mem:Ptr->StartPos > 1)
    --Mem:Ptr->StartPos
    Return (False)
  Return (True)

Contact:ClearCode
  New (Res,CurrContact)

  Contact:SetFile(Here)
  CurrContact        = Mem:Ptr->Contact
  Mem:Ptr->OneContact= CurrContact
  Mem:Ptr->Contact   = Null

  Res=Msg:Add ('Clear Mail Code','Cancel')
    This process will clear the Mail Code field
    that is used to filter for labels and merge
    letters.
  If (Res)
    Win:Add
      Clearing contact records
    While (Contact:NextRecord('Next'))
      If (Jorf:Lock(Mem:Ptr->Contact)==False)
        While (Jorf:Lock(Mem:Ptr->Contact)==False)
          Win:Msg("Waiting for locked record to clear")
        Win:Del
      Mem:Ptr->Contact->MailCode=Null
      Jorf:UnLock(Mem:Ptr->Contact)
    Mem:Ptr->Contact=CurrContact
  Return(Ok)

Contact:ClearMailCode
  New (Res,CurrContact)

  Contact:SetFile(Here)
  CurrContact        = Mem:Ptr->Contact
  Mem:Ptr->OneContact= CurrContact
  Mem:Ptr->Contact   = Null

  Res=Msg:Add ('Clear Mail Code','Cancel')
    This process will clear the Mail Code field
    that is used to filter for labels and merge
    letters.
  If (Res)
    Win:Add
      Clearing contact records
    While (Contact:NextRecord('Next'))
      If (Jorf:Lock(Mem:Ptr->Contact)==False)
        While (Jorf:Lock(Mem:Ptr->Contact)==False)
          Win:Msg("Waiting for locked record to clear")
        Win:Del
      Mem:Ptr->Contact->MailCode=Null
      Jorf:UnLock(Mem:Ptr->Contact)
    Mem:Ptr->Contact=CurrContact
    Win:Dsp
  Return(Ok)

Contact:ContinLabels(Flag)
  New (Dest,CurrContact,i)
  Dest=Jorf:Printer()
  Win:Add("Printing")
    Printing . . .

  Contact:SetFile(Here)
  CurrContact        = Mem:Ptr->Contact
  Mem:Ptr->OneContact= CurrContact
  Mem:Ptr->Contact   = Null

  | Report format for Continuous labels, 6 lines per label, 1 line between
  |
  Rep:Add ("Continuous Labels")
    Next:"Contact:Nextlabel(Flag)"
    Item:"'('+Mem:Ptr->Contact->MailCode+')'" NewRow:1 Col:26 Wid:12
      Before:"Mem:Ptr->Contact->MailCode!=Null"
    Item:"" NewRow:1 Col:26 Wid:12
      Before:"Mem:Ptr->Contact->MailCode==Null"
    Item:"Mem:Ptr->Contact->FullName"    NewRow:1 Col:1  Wid:40
    Item:"Mem:Ptr->Contact->Company"     NewRow:1 Col:1  Wid:40
      Before:"Mem:Ptr->Contact->Company!=Null"
    Item:"Mem:Ptr->Contact->Addr1"       NewRow:1 Col:1  Wid:40
    Item:"Mem:Ptr->Contact->Addr2"       NewRow:1 Col:1  Wid:40
    Item:"Mem:Ptr->Contact->Addr3"       NewRow:1 Col:1  Wid:40
    Item:"" NewRow:1
      Before:"Mem:Ptr->Contact->Company==Null"
  For (i=1 Thru 5)
    File:Write("JREPORT.LST")
  File:Print("JREPORT.LST",Dest)
  Mem:Ptr->Contact=CurrContact
  Return(Null)

Contact:Create()
  New (Contact:Contact, Time)
  Time->NDFormat = "MM-DD-YY"
  Time:Get (Time)
  Contact->StartDate   = Time->NDate
  Contact->LastUpDate  = Time->NDate
  Jorf:Write(Contact)
  Return Contact

Contact:Dear (Contact)
  If (Contact->Dear==Null)
    Contact->Dear = (Word:At(Contact->FullName,1))
  Return(Ok)

Contact:Edit(Action)
  | Add/Edit/Delete Contact Records
  New (Choice, Contact:Contact, Result)

  Contact:SetFile(Here)
  Event:Add()

  If (Action=="Add")
    Contact=Contact:Create
  Else
    Contact=Mem:Ptr->Contact

  If (Action=='Delete')
    Result=Msg:Add('Contact Delete','No')
      Delete this record

      Name:     {Contact->FullName}
      Company:  {Contact->Company}
    If (Result)
      Mem:Ptr->Contact = Struct:Next('Contact',Mem:Ptr->IndexName,Mem:Ptr->Contact)
      Jorf:Del(Contact)
      Win:Dsp
    Return

  Mem:Ptr->Page   = 1
  Choice = Ok
  While (Mem:Ptr->Page > 0)
    Switch (Mem:Ptr->Page)
      Case (1)
        Win:Add ("{Action} Contact Records - Page 1")
          InpBefore:"Contact:Lock(Contact)"
          InpAfter:"Contact:UnLock(Contact)"
          Group:"&Contact", Row:1, Col:1, Wid:38, Len:6
          Input:"Name   ", Wid:30, Field:"Contact->FullName"
          Input:"Company", Wid:30, Field:"Contact->Company"
          Input:"Address", Wid:30, Field:"Contact->Addr1"
          Input:"Address"  Wid:30, Field:"Contact->Addr2"
          Input:"Address", Wid:30, Field:"Contact->Addr3"
          Radio:"USA"  Row:7 Col:2
            Action:"Contact->Location='USA'"
            UnAction:"Contact->Location=Null"
            Check:"Contact->Location=='USA'"
          Radio:"Canada/Mexico" Row:7 Col:11
            Action:"Contact->Location='CanMex'"
            UnAction:"Contact->Location=Null"
            Check:"Contact->Location=='CanMex'"
          Radio:"Foreign" Row:7 Col:30
            Action:"Contact->Location='Foreign'"
            UnAction:"Contact->Location=Null"
            Check:"Contact->Location=='Foreign'"

          Group:"&Telephone", Row:09, Col:1, Wid:39, Len:5
          Input:"Work   ", Row:10 Wid:30, Field:"Contact->WorkPhone"
          Input:"FAX    ", Row:11 Wid:30, Field:"Contact->FaxPhone"
          Input:"Home   ", Row:12 Wid:30, Field:"Contact->HomePhone"
          Input:"Comment", Row:14 Wid:30, Field:"Contact->PhoneNote"
          Group:"&Key Fields", Row:1, Col:41 Wid:24, Len:3
          Input:"Last Name", Row:2 Col:42 Wid:14,
            Field:"Contact->LastName"
            Before:"Contact:LastName(Contact)"
          Input:"Dear     ", Row:3 Col:42 Wid:14,
            Field:"Contact->Dear"
            Before:"Contact:Dear(Contact)"
          Input:"Zip Code ", Row:4 Col:42 Wid:14,
            Field:"Contact->ZipCode"
            Before:"Contact:ZipCode(Contact)"

          Button:"Page &2"   Row:10 Col:50, Wid:10, Action:"Contact:SetPage(2)"
          Button:" &Done "   Row:13 Col:50, Wid:10, Action:"Contact:SetPage(0)"
        Win:Del
      Case (2)
        Win:Add ("{Action} Contact Records - Page 2")
          InpBefore:"Contact:Lock(Contact)"
          InpAfter:"Contact:UnLock(Contact)"
          Group:"Contact", Row:1, Col:1, Wid:40, Len:2
          Input:"Name   ", Wid:30, Field:"Contact->FullName", Before:"False"
          Input:"Company", Wid:30, Field:"Contact->Company",  Before:"False"
          Group:"Codes", Row:5, Col:1, Wid:32, Len:2
          Input:"&Mail Code ", Row:6 Col:2  Wid:20,
             Field:"Contact->MailCode"

          Input:"C&ust Code ", Row:7 Col:2  Wid:20,
             Field:"Contact->CustCode"

          Group:"T&ype",  Row:5, Col:36, Wid:15, Len:4
          Radio:" &Prospect"
            Action:"Contact->Type='Prospect'"
            Check:"Contact->Type=='Prospect'"

          Radio:" &Customer"
            Action:"Contact->Type='Customer'"
            Check:"Contact->Type=='Customer'"

          Radio:" D&istributor"
            Action:"Contact->Type='Distributor'"
            Check:"Contact->Type=='Distributor'"

          Radio:" &Vendor"
            Action:"Contact->Type='Vendor'"
            Check:"Contact->Type=='Vendor'"

          Group:"&Sales",  Row:9, Col:1, Wid:32, Len:4
          Input:"Actual sales         ", Row:10 Wid:10
            Field:"Contact->Sales"
            Before:"Contact->Type=='Customer'"
          Input:"Forecast sales amount", Row:11 Wid:10 Field:"Contact->ForSales"
          Input:"Forecast closing date", Row:12 Wid:10 Field:"Contact->ForDate"
          Input:"Chances of closing   ", Row:13 Wid:3  Field:"Contact->ForChances"
          String:"%", Row:13 Col:22

          Button:" &Done "   Row:17 Col:4,  Wid:10, Action:"Contact:SetPage(0)"
          Button:"Page &1"   Row:17 Col:24, Wid:10, Action:"Contact:SetPage(1)"
        Win:Del
      Else | End of switch Statement
        Break
    If (Kbd:Got = 'Esc_Key')
      Break
  If (Kbd:Got == 'Esc_Key')
    If (Action=='Add')
      Mem:Ptr->Contact = Struct:Next('Contact',Mem:Ptr->IndexName,Mem:Ptr->Contact)
      Jorf:Del(Contact)
  Mem:Ptr->Contact=Contact
  Win:Dsp
  Return(Null)

Contact:Enter_Key
  | Block enter key - which would otherwise cause
  | the screen (and program) to go bye.
  Return (Ok)

Contact:Esc_Key
  | Even block the escape key - which would otherwise cause
  | the screen (and program) to go bye.
  New (Res)
  Res=Msg:Add(Null,"Cancel")
    This will end your session with
    Josephine's Contact Manager
  If (Res)
    Jorf:Exit
  Return (Ok)

Contact:F1_Key
  If File:Access("ConHelp.Jrf" 0)
    Jorf:File ("ConHelp.Jrf" Here)
    ConHelp:Start
  Else
    Msg:Add
      The CONHELP.JRF file is not &
      on the current directory
  Return Ok

Contact:F2_Key
  New (Res)

  Event:Add
  If (Jorf:Lock(Mem:Ptr->Contact)==False) | Lock Record
    Msg:Add
      Cannot set mail code,
      record is locked.
  Else
    Win:Add ('Set Mail Code')
      Input:"Set code to", Wid:20 Field:"Mem:Ptr->MailCode"
    If (Kbd:Got!='Esc_Key')
      Mem:Ptr->Contact->MailCode=Mem:Ptr->MailCode
    Jorf:UnLock(Mem:Ptr->Contact)          | Write and Unlock
    Win:Dsp
  Return(Ok)

Contact:F4_Key
  New (ArrFiles,ArrChoice,FileName)
  ArrFiles=Arr:Sort(Arr:Dir("*.JCM"))
  Event:Add() | Block Contact event class
  Win:Add ("Open a Contact File")
     Group:"&File Name" Row:1 Col:1 Len:1, Wid:32
     Input:"New File Name", Wid:18, Field:"FileName"
     Group:"&Pick File" Row:4 Col:1 Len:5, Wid:32
     Array:"", Field:"ArrFiles", Choice:"ArrChoice"
     Button:"  &Open  ", Row:11 Col:4 Action:"Return(Ok)"
     Button:" &Cancel ", Row:11 Col:20 Action:"Return('Esc_Key')"
  If (Kbd:Got!='Esc_Key')
    If (FileName = Null And ArrChoice > 0)
      FileName = ArrFiles[ArrChoice]
    If (Str:In(FileName,"."))
      FileName = Str:AtCut(FileName,Str:In(Filename,"."))
    If (Str:Len(FileName))
      Mem:Ptr->ContactFile = FileName
      Mem:Ptr->Contact=Null
      Win:Dsp      | Redisplay all contact fields
  Return

Contact:F7_Key
  New (NewFilter)
  NewFilter=Filter:Start()
  If (Kbd:Got!='Esc_Key')
    Mem:Ptr->ContactFilter = Filter:Method()
    Mem:Ptr->FilterName    = Filter:Name()
    Mem:Ptr->FilterDescr   = Filter:Descr()
  Win:Dsp

  | Test current contact - if it doesn't count, null it out
  If (Mem:Ptr->ContactFilter != Null)
    If (Jorf:Do(Mem:Ptr->ContactFilter)==False)
      Mem:Ptr->Contact=Null
  Return(Null)

Contact:F8_Key
  TextEdit:Start()
  Return(Ok)

Contact:FirstRecord()
  Contact:SetFile(Here)
  While Ok
    Mem:Ptr->Contact=Struct:Next('Contact',Mem:Ptr->IndexName,Null)
    Break
  Return(Mem:Ptr->Contact)

Contact:GetLetter
  New (PrintList,PrintChoice,Letter)

  PrintList = Arr:Sort(Arr:Dir('*.LTR'))
  If (Arr:Len(PrintList) < 1)
    Msg:Add
      There are no .LTR files
      on the current directory.
  Else
    Win:Add("Select Letter")
      Group:"&Merge Letters", Row:1 Col:1 Len:6 Wid:22
      Array:"" Field:"PrintList" Choice:"PrintChoice"

      Button:"  &Go  " Row:1 Col:32
        Action:"Letter=PrintList[PrintChoice]"
      Button:" &Cancel " Row:4 Col:32 Action:"Return ('Esc_Key')"
  Return(Letter)

Contact:KeySearch (Field, GetInp)
  New (Value,Prompt,Display,Contact:Contact)

  Contact:SetFile(Here)         | Set Current File
  Event:Add                     | Block "Contact" Events so Alt-A won't work
  Switch (Field)
    Case ("FullName")
      Prompt="Name"
    Case ("Company")
      Prompt="Company"
    Case ("WorkPhone")
      Prompt="Phone"
    Case ("LastName")
      Prompt="Last Name"
    Case ("ZipCode")
      Prompt="Zip Code"
    Else
      Msg:Add
        Unknown Field {Field}
      Return (Ok)

  If (GetInp)
    Win:Add ("Key Search", 10, 25, 0, 0, Here)
      Input:"Search for {Prompt}", Wid:30, Field:"Value"
  If (Kbd:Got <> "Esc_Key")
    Mem:Ptr->IndexName=Field
    Mem:Ptr->Contact=Struct:Find('Contact',Mem:Ptr->IndexName,Value)
    If (Mem:Ptr->Contact=Null And Value)
      Msg:Add
        Cannot find {Prompt} {Value}
      Mem:Ptr->Contact=Struct:Find('Contact',Mem:Ptr->IndexName,Null)
    Win:Dsp
  Return (Null)

Contact:LastName (Contact)
  If (Contact->LastName==Null)
    Contact->LastName= (Word:At(Contact->FullName,Word:Len(Contact->FullName)))
  Return(Ok)

Contact:List
  New (Dest,CurrContact)
  Time:Get(Mem:Ptr)
  Mem:Ptr->Page=1

  Dest=Jorf:Printer()
  If (Dest)
    Win:Add("Printing")
      Printing . . .
    Contact:SetFile(Here)
    CurrContact=Mem:Ptr->Contact
    Mem:Ptr->Contact=Null
    Rep:Add ("Contact Listing", 5, 5, 60, 75,Here)
      Header:"'Contact Listing Report'"     NewRow:1 Col:30
      Header:"'Page '+Mem:Ptr->Page"       NewRow:1 Col:1
      Header:"'Date '+Mem:Ptr->SDate"               Col:50
      Header:"Str:AtSet(Null,1,'-',80)" NewRow:1 Col:1
      Next:"Struct:Next('Contact',Mem:Ptr->IndexName,Mem:Ptr->Contact)"
      Item:"Mem:Ptr->Contact->FullName"      NewRow:2 Col:1  Len:20
      Item:"Mem:Ptr->Contact->Company "               Col:22 Len:32
      Item:"Mem:Ptr->Contact->WorkPhone"              Col:52 Len:28
      Item:"Mem:Ptr->Contact->Addr1"         NewRow:1 Col:5  Len:30
      Item:"Mem:Ptr->Contact->Addr2"         NewRow:1 Col:5  Len:30
      Item:"Mem:Ptr->Contact->Addr3"         NewRow:1 Col:5  Len:30
      Item:"Null"                            NewRow:1 Col:5  Len:30
      Footer:"'Continued on Page '+(Contact:NextPage)" Row:56 Col:1
        Before:"Mem:Ptr->Contact!=Null"
    File:Print("Jreport.lst",Dest)
    Mem:Ptr->Contact=CurrContact
  Return (Ok)

Contact:Lock(Contact)
  If (Jorf:Lock(Contact))
    Return (Ok)
  Win:Msg("Record is locked")
  Return(Null)

Contact:MergeLetter
  New (Dest,Letter,CurrContact)
  Time:Get(Mem:Ptr)

  Letter=File:Load(Contact:GetLetter)
  If (Letter!=Null)
    Dest=Jorf:Printer()
    If (Dest)
      CurrContact=Mem:Ptr->Contact
      Mem:Ptr->Contact=Null
      Win:Add("Printing")
        Printing . . .
      Rep:Add ("Merge Letter", 5, 5, 60, 75,Here)
        Next:"Contact:NextRecord('Next')"
        Text:"Letter" Row:1
      File:Print("JREPORT.LST",Dest)
      Mem:Ptr->Contact=CurrContact
  Return (Ok)

Contact:NextLabel(Flag)
  If (Flag=='All')
    Contact:NextRecord('Next')
  Else
    If (Mem:Ptr->OneContact)
      Mem:Ptr->Contact=Mem:Ptr->OneContact
      Mem:Ptr->OneContact=Null
    Else
      Mem:Ptr->Contact=Null
  Return (Mem:Ptr->Contact)

Contact:NextPage
  Mem:Ptr->Page=Mem:Ptr->Page+1
  Return (Mem:Ptr->Page)

Contact:NextRecord(Flag)
  | Gets the next (or previous) record depending on Flag
  | Flag is "Next" or "Prev" Easy!
  |
  Contact:SetFile(Here)
  While (Ok)
    If (Flag=='Prev')
      Mem:Ptr->Contact=Struct:Prev('Contact',Mem:Ptr->IndexName,Mem:Ptr->Contact)
    Else
      Mem:Ptr->Contact=Struct:Next('Contact',Mem:Ptr->IndexName,Mem:Ptr->Contact)
    If (Mem:Ptr->Contact==Null)
      Break
    If (Mem:Ptr->ContactFilter = Null)
      Break
    If (Jorf:Do(Mem:Ptr->ContactFilter))
      Break
  Return(Mem:Ptr->Contact)

Contact:PrintData
  New (Dest,Contact)
  Time:Get(Mem:Ptr)
  Mem:Ptr->Page=1

  If (File:Access("Contact.Rpt",0)==0)
    Msg:Add
      Print format "Contact.Rpt" is
      not in the current directory.
    Return (Ok)
  Dest=Jorf:Printer()
  Contact=Mem:Ptr->Contact
  If (Dest)
    Win:Add("Printing")
      Printing . . .
    Rep:Add ("Contact Information", 5, 5, 60, 75,Here)
      Header:"'Contact Information Report'"     NewRow:1 Col:30
      Header:"'Date '+Mem:Ptr->SDate"         Col:50
      Header:"Str:AtSet(Null,1,'-',80)" NewRow:1 Col:1
      Text:"File:Load('Contact.Rpt')"
      Next:"Null"
    File:Print("Jreport.lst",Dest)
  Return (Ok)

Contact:Rebuild()
  | A rebuild writes the entire data file to an ascii file,
  | then erases the original, reads the ascii and reindexes.
  | The resulting process cleans any problem with the file and
  | indexes.
  |
  | The process also moves all pointers.  Before you start it, you
  | must clear _any_ pointers that may be in the stack.  In this case
  | the only pointer is Mem:Ptr->Contact - which is easy to clear.
  Mem:Ptr->Contact=Null

  | Set file
  Contact:SetFile(Here)

  | Then do the rebuild . . .
  Jorf:Rebuild

  | Finall, force a redisplay of the browser list
  Win:Dsp
  Return

Contact:SetFile(Level)
  | This method is used to set the current file.  The current file
  | name is in Mem:Ptr->Contactfile, and we just add the extension
  Jorf:File (Mem:Ptr->ContactFile+".JCM", Level) | Set file to use
  Return

Contact:SetPage(Page)
  Mem:Ptr->Page=Page
  Return(Null)

Contact:Show ()
  | The "Show" routine is used for the browser window.  The data that
  | is shown changes depending on the index in use - (try switching to
  | the phone number or zip code indexes to see the difference).
  New (Contact,Display)                | Create var "Contact" and "Display"
  Contact = Mem:Ptr->Contact           | Set to current contact
                                       | And interpret "Display" string
  Switch (Mem:Ptr->IndexName)
    Case ("FullName")
      Display = Str:Pad(Contact->FullName,17)+' '+Str:Pad(Contact->Company,17)
    Case ("Company")
      Display = Str:Pad(Contact->Company,17)+' '+Str:Pad(Contact->FullName,17)
    Case ("WorkPhone")
      Display = Str:Pad(Contact->WorkPhone,17)+' '+Str:Pad(Contact->FullName,17)
    Case ("LastName")
      Display = Str:Pad(Contact->FullName,17)+' '+Str:Pad(Contact->Company,17)
    Case ("ZipCode")
      Display = Str:Pad(Contact->ZipCode,5)+' '+Str:Pad(Contact->Company,16)
      Display = Display +' '+Str:Pad(Contact->FullName,12)
  Return (Display)

Contact:Unlock(Contact)
  Jorf:UnLock(Contact)
  Return (Ok)

Contact:Write (Contact)
  New (Time)
  Time->NDFormat = "MM-DD-YY"
  Time:Get (Time)
  Contact->LastUpDate  = Time->NDate
  Jorf:Write (Contact)
  Return (Null)

Contact:ZipCode (Contact)
  New (Field)
  If (Contact->ZipCode==Null)
    If (Contact->Addr3)
      Field=Contact->Addr3
    Else
      Field=Contact->Addr2
    While (Str:In(Field," "))
      Field=Str:At(Field,Str:In(Field," ")+1)
    Contact->ZipCode=Field
  Return (Ok)

