Class:DirList                   | Class Definition
  Name                          | File Name
  Path                          | File Path
  WildCard                      | Wildcard for directory
  ExclusionList                 | Extension Exclusion List
  FileArray                     | Array of files on this path
  DirArray                      | Array of other paths

DirList:Start                   | FOR TESTING:  Start routine
  New (FileName)
  FileName = DirList:GetFile("*.*",Null)
  Msg:Add
    File name is {FileName}
  Return (Ok)

DirList:Cancel(List)            | Routine to Cancel data entry
  List->Name=Null               | Signal that we canceled
  Return(Null)                  | Returning Null will finish input

DirList:Done(List,Name)         | Routine to finish data entry
  If (List->Name==Null)         | If name is null - try setting
    DirList:NewName(List,Name)  |   it from the current highlighted name

  If (List->Name==Null)         | If name is still null display message
    Msg:Add
      Please select a file
      name or "Cancel".
    Return (Ok)                 | Returning Ok will continue input
  Return (Null)                 | Returning Null will finish input

DirList:FileArray(WildCard,Exclusionlist)  | Read a file array
  New (Array)

  | Read Array
  Array = Arr:Dir (WildCard, ExclusionList, 12)

  | If length is over 30, we should sort which can take a minute,
  |  how about displaying a little window . . .
  If (Arr:Len(Array) > 30)
    Win:Add ('Sorting')
      Sorting directory

  | Then Sort
  Arr:Sort (Array)
  Return (Array)

DirList:GetFile(WildCard,ExclusionList)
  New (OrigPath, DirList:List, DirChoice, FileChoice)

  | Initalize values
  OrigPath            = File:ChDir()
  List->Path          = OrigPath
  List->WildCard      = WildCard
  List->ExclusionList = Exclusionlist
  List->FileArray     = DirList:FileArray(List->Wildcard, List->Exclusionlist)
  List->DirArray      = DirList:FileArray("SUBDIR")

  Event:Add(Null)               | Block prior keystroke events
  Win:Add ("Get File Name", 0, 0, 10, 56, Here)

    | Input File Name
    Input:"File&name:  ",  Wid:24, Row:2, Col:3, Field:"List->Name"

    | Display directory  "Before" command returns null so there is
    |  never any input here - but field is refreshed every time
    |  Win:Dsp command is called
    Input:"Directory: ",   Wid:24, Row:4, Col:3, Field:"List->Path"
      Before:"Null"

    | Files array with a group box around
    Group:"&Files",       Row:6, Col:2, Wid:16, Len:10
    Array:"", Field:"List->FileArray",
              Choice:"FileChoice",
              Action:"DirList:NewName(List,List->FileArray[FileChoice])"

    | Directories array with a group box around
    Group:"&Directories", Row:6, Col:22, Wid:16, Len:10
    Array:"", Field:"List->DirArray",
              Choice:"DirChoice"
              Action:"DirList:NewDir(List,List->DirArray[DirChoice])"

    | Two buttons
    Button:"   &Ok   ", Row:1, Col:42, Wid:14
      Action:"DirList:Done(List,List->FileArray[FileChoice])"
    Button:" &Cancel ", Row:4, Col:42, Wid:14
      Action:"DirList:Cancel(List)"

  File:ChDir(OrigPath)
  If (List->Name)
    Return (List->Path+'\'+List->Name)
  Return (Null)

DirList:NewDir(List,Path)       | Routine to set a new path
  File:Chdir(Path)              | Change to the new path
  List->Path = File:ChDir()     | Reset path name
  List->Name = Null             | Set file name to null

  | Re-read file array
  List->FileArray = DirList:FileArray(List->Wildcard, List->Exclusionlist)

  | Re-Read directory array - special argument "SUBDIR" does this
  List->DirArray  = DirList:FileArray("SUBDIR")

  Win:Dsp                       | Redisplay Window
  Return(Ok)                    | Returning Ok continues input

DirList:NewName(List,Name)      | Routine to set a new name
  List->Name = Name             | Set the name (Easy!)
  Win:Dsp                       | Redisplay the screen
  Return(Ok)                    | Returning OK will continue input

