Class:Isa

Isa:Start
  New (Key, TextIn)
  Jorf:File ("ISA.JRF", Here)
  While (Ok)
    Win:Add("Is-A data base")
      String:"Enter information in the form of:     A is B"
      String:"Enter a query in the form:            Is A B"
      String:"You can get a query list with:     What is B"
      String:""
      String:"Enter 'Display' to display the data base. "
      String:""
      Input:"", Wid:40, Field:"TextIn"
      String:""
    If (TextIn)
      Isa:Parse (TextIn)
    Win:Del
    TextIn = Null
  Return



Isa:Display
  New (Rule:Rule, Counter)
  Win:Add("Is-A Data Base",0,0,10,50,Here)
  Rule->Type = 2
  Rule->Obj  = "is"
  Rule->KLen = 1
  While (Ok)
    Rule:Next (Rule)
    If (Rule->Fnd = False)
      Win:Pause
      Return
    If (Counter > 9)
      Win:Pause
      Counter = 0
    Str:PutLine(Rule->Ptr)
    ++Counter
  Return

Isa:IsArticle (Word)
  Switch (Word)
    Case "a"
    Case "an"
    Case "the"
      Return (True)
  Return (False)

Isa:Parse (Text)
  | Parse the sentence to see what is in it
  New (Pos, StartText, GoalText, Result)

  Pos = Str:In(Text," is ")
  If (Pos)
    StartText = Str:At(Text, 1, Pos-1)
    GoalText  = Str:At(Text, Pos+4, Str:Len(Text))

  Switch
    | What is B
    Case (Word:At(StartText,1) = "what")
      Result = Isa:Search (Null, GoalText)
      If (Result = Null)
        Result = Isa:Search (GoalText, Null)
      If (Result = Null)
        Result = Text:Add ("I don't know")
      Msg:Add (Null,"Ok",Result)
      Return

    | A is B
    Case (StartText && GoalText)
      Isa:SaveRule (StartText, GoalText, Text)
      Msg:Add
        I Understand
      Return

    | is A B
    Case (Pos < 1)
      If (Word:At (Text, 1) = "is")
        | This is kinda a pain -
        |  need to parse two expressions without having any
        |  real guide as to the separation between them.
        |  Instead, assume expressions are one word or
        |  an article (a,an,the) followed by one word.
        Pos = 2
        StartText = Word:At (Text,Pos)
        If (Isa:IsArticle(StartText))
          ++Pos
          StartText = StartText + " " + Word:At(Text,Pos)
        ++Pos
        GoalText = Word:At(Text, Pos)
        If (Isa:IsArticle (GoalText))
          ++Pos
          GoalText = GoalText + " " + Word:At (Text,Pos)
        Result = Isa:Search (StartText, GoalText)
        If (Result)
          Msg:Add(Null,"Ok",Result)
        Else
          Msg:Add
            I don't know whether
            {StartText} is {GoalText}
        Return
      If (Word:At (Text, 1) = "display")
        Isa:Display
        Return

  | If nothing has been done, try showing a help screen
  Msg:Add
    Statements should take the
    form "A is B". examples:

      Josephine is a Goat
      A Goat is a Mammal
      A Mammal is an Animal
      Socrates is a Person
      A Person is Mortal

    Queries should begin with "Is"
    or "What".  Examples:
      What is mortal
      Is Socrates mortal
      Is Josephine an Animal
      What is an Animal

    The special command "Display" will
    display the Is-A Data Base.
  Return

Isa:SaveRule (StartText, GoalText, Text)
  | Store text as O-A-V and A-V-O to allow
  | front and back chaining
  New (Rule:Rule)
  Rule->Type   = 1
  Rule->Obj    = StartText
  Rule->Att    = "is"
  Rule->Val    = GoalText
  Rule->Ptr    = Text
  Rule:Add (Rule)

  Rule->Type   = 2
  Rule->Obj    = "is"
  Rule->Att    = GoalText
  Rule->Val    = StartText
  Rule->Ptr    = Text
  Rule:Add (Rule)

Isa:Search (StartText, GoalText)
  | Search data base for item
  New (Rule:Rule, Result)
  Switch
    | If Start and Goal are known
    |   first look to see if there is a
    |   rule that encompasses both
    Case (StartText && GoalText)
      Rule->Type   = 1
      Rule->Obj    = StartText
      Rule->Att    = "is"
      Rule->Val    = GoalText
      Rule->KLen   = 3
      Rule:Find (Rule)
      If (Rule->Ptr)
        | This was easy!
        Return (Text:Add ("Yes, " + Rule->Ptr), Null)
      Else
        | There is no rule for Start and Goal
        | So lets see what rules there are for Start,
        | and check if any match the Goal.
        Rule->Type   = 1
        Rule->Obj    = StartText
        Rule->Att    = "is"
        Rule->Val    = Null
        Rule->Fnd    = False
        Rule->KLen   = 2
        While (Ok)
          Rule:Next (Rule)
          | If not Fnd then we are out of rules for Start
          If (Rule->Fnd = False)
            Return (Null)
          | If Fnd, see if this Mid-rule matches the goal
          Result = Isa:Search (Rule->Val, GoalText)

          | If a match was Fnd, we are home free,
          |  add this rule to the result list, and return.
          |  Otherwise, loop back to see if there is another
          |  Start rule we can check.
          If (Result)
            Result = Text:Add (Rule->Ptr, Result)
            Return (Text:Top (Result))


    Case (GoalText)
      | StartText is null, so look through all goaltexts
      Rule->Type = 2
      Rule->Obj  = "is"
      Rule->Att  = GoalText
      Rule->KLen = 2
      | Dropping through to loop below

    Case (StartText)
      | GoalText is null, so look through all Start texts
      Rule->Type = 1
      Rule->Obj  = StartText
      Rule->Att  = "is"
      Rule->KLen = 2
      | Dropping through to loop below

    Else
      | Both Start and Goal are null.
      | This should probably be an error because
      | it indicates that something has gone wrong.
      Return (Null)

  While Ok
    | Read through any matching rules, exit when
    | there are no more..
    Rule:Next (Rule)
    If (Rule->Fnd = False)
      Return (Text:Top (Result))
    Result = Text:Add (Rule->Ptr, Result)

