

/* "jorf.h"

  Copyright (c) 1988,1989,1990.1991
  by The JORF Company
  All Rights Reserved

*/

#if ! defined (_JORF_H)
#define _JORF_H 1

#include <stdlib.h>

#if defined (_Windows)
#include <windows.h>
#endif

/* Some basic definitions */
#define TRUE        	1
#define FALSE       	0
#define null        ((void far *)0)
#define EOL         ((void far *)0xffffffffl)
#define NULL 		0


/* Some typedefs for common types */
typedef unsigned char       boolean;	/* True/False Flag 		*/
typedef unsigned char       ascii;	/* Integer value of a character */
typedef void far *          addr;	/* Pointer to something 	*/
typedef unsigned long       unlong;	/* unlong  			*/
typedef unsigned short      unshort;	/* unshort 			*/
typedef unsigned char       unchar;	/* unchar  			*/
typedef unsigned char far * string;	/* Pointer to far string     	*/
typedef unsigned char 	  * rule;	/* Pointer to rule	     	*/


/* JORF Record Number */
struct jrec
  {
  unlong  rec;
  unshort cnt;
  unshort fil;
  };
typedef struct jrec far *jrec;


/* JORF Data Pointer */
struct jorf
  {
  struct jrec rec;
  unsigned char len;
  unsigned char flg;

#define JORF_FLG_STRING  (0x01) /* TRUE=Character String follows rec    */
#define JORF_FLG_JARR    (0x02) /* TRUE=JARR struct follows rec         */
#define JORF_FLG_NUMBER  (0x08) /* Rec holds a floating point value    	*/

#define JORF_FLG_LOWER   (0x04) /* A Flag modifier  STRING,NUMBER,JARR  */
#define JORF_CFLG_LCS    (0x05) /* STRING|LOWER= Lower case string      */
#define JORF_CFLG_INT    (0x0C) /* NUMBER|LOWER= Integer value	       	*/
#define JORF_CFLG_ARR	 (0x06) /* JARR|LOWER  = Array		       	*/

#define JORF_FLG_TMP     (0x10) /* Rec holds the malloc address        	*/
#define JORF_FLG_WTMP    (0x20) /* Was TMP - flushed to disk           	*/

/* Most processing excludes top two bits for comparison. 		*/
#define JORF_FLG_ORIG	 (0x40) /* This is created string		*/

/* WTMP is not stored in file, only in pointers to the file.  The read
   command will re-read the record, and assign WTMP if the pointer had
   it.  Any function can un-WTMP the pointer IN MEMORY to make
   the element permanent. 						*/

#define JORF_FLG_NDEL    (0x80) /* TMP - don't delete unless full flush */

  };
typedef struct jorf far *jorf;
typedef struct jorf near *jorfnear;





/* Low level functions ------------------------------------------------ */
extern 	jorf    far _fastcall   jmemptr(jorf j);
extern  jorf    far _fastcall   jmemptrlock(jorf j);
extern  jorf    far _fastcall	jmemptrunlock(jorf j);

extern 	jorf 	far _fastcall	ftoj(double d);
extern 	jorf 	far _fastcall	ftojstruct(double d,struct jorf *j);

extern 	jorf 	far _fastcall	itoj(long i);
extern 	jorf 	far _fastcall	itojstruct(long   i,struct jorf *j);

extern 	jorf   	far _fastcall	jgetjptr(jorf object, unchar *name);
extern 	void 	far _fastcall	jputjptr(jorf object, unchar *membername, jorf membervalue);

extern 	double 	far _fastcall	jtof(jorf j);
extern 	int     far _fastcall	jtoi(jorf j);
extern 	long   	far _fastcall	jtol(jorf j);
extern 	string 	far _fastcall	jtos(jorf j);
extern  string  far _fastcall	jtotext(jorf j);

extern 	jorf 	far _fastcall	stoj(string s);
extern  jorf    far _fastcall	stojlwr(string s);
extern  jorf    far _fastcall	stojlwrsave(char *s);
extern 	jorf 	far _fastcall	stojstruct(string s,struct jorf *j);

extern  jorf    far _fastcall	texttoj(string s);
extern  jorf	far _fastcall	spadtoj(string s, int len, int chr);
extern void     far _fastcall   jsl_put_wptext(string s);




/* Translator Functions that take the place of interpreter ------------	*/
extern 	jorf 	far _fastcall   jbye(jorf j);
extern 	jorf 	far cdecl	jcall(unchar *s, unchar *t, ...);
extern  void 	far _fastcall   jcpy(jorf j, jorf k);
extern  void 	far _fastcall   jnearcpy(jorfnear j, jorf k);
extern 	void 	far cdecl	jfnc(unchar *sclass,unchar *sname, ...);
extern 	jorf 	far cdecl	jmath(jorf j, ...);
extern 	jorf 	far _fastcall   jmath_unary(unchar *op, jorf j);
extern 	void 	far _fastcall   jnew(jorf j, unchar *name);
extern 	void 	far _fastcall   jnewc(jorf j, unchar *name, unchar *class);
extern 	void 	far pascal      jorfcpy(jorf dest, jorf source);
extern 	void 	far _fastcall   jtextalloc(jorf j, unchar **txt);
extern 	void 	far _fastcall   jtextfree(jorf j);
extern  void    far _fastcall   jmethodload(void);
extern  void    far _fastcall   jfunctionload(void);
extern  void    far _fastcall   jinterpreterload(void);



/* Middle level string and jorf pointer commands ----------------------	*/
extern 	long 	far _fastcall   jarraylength(jorf text);

extern 	void 	far _fastcall   jclassopen(int argc, char **argv,string argstr);
extern 	void 	far _fastcall   jclassdefine(unchar *classdef);
extern  boolean far _fastcall   jdefined(unchar *classdef);

extern 	boolean far _fastcall	jfarheapcheck(int k);

extern 	void    far pascal      jfarmemset(addr a, int c, int n);
extern 	void 	far pascal      jfarmemcpy(addr addr1, addr addr2, int count);
extern 	int 	far pascal      jfarmemcmp(addr addr1, addr addr2, int count);

extern  void   	far pascal	jfarstrcat(string str1, string str2);
extern  int    	far pascal	jfarstrcmpi(string str1, string str2);
extern  void   	far pascal	jfarstrcpy(string str1, string str2);
extern  int    	far pascal	jfarstrlen(string str1);
extern  void   	far pascal	jfarstrlwr(string s);
extern  void   	far pascal	jfarstrncpy(string str1, string str2, int n);
extern  void   	far pascal	jfarstrupr(string s);

extern  void   	far pascal      jfarstrcap(string s);
extern  string 	far _fastcall   jfarstrchr(string str1, int c);
extern  string 	far _fastcall   jfarstrstr(string str1, string str2);
extern  string 	far _fastcall   jfarstrtrim(string s);

extern boolean  far pascal	jfortest(unlong var, unlong thru, unlong step);

extern 	void    far _fastcall   jfunctiondefine(unchar *fncclass, unchar *fncname, jorf (far pascal *adr)(), int count);


extern 	int     far _fastcall   jorfbye(void);
extern 	void 	far _fastcall   jorfexit(void);
extern 	jorf 	far pascal	jorfflush(jorf j);
extern 	void 	far cdecl	jerror(int errno, unchar *s,...);
extern  void    far _fastcall 	jorfinit(int argc, char **argv,string argstr);
extern 	jorf 	far pascal	jorflock(jorf j);
extern 	jorf 	far pascal	jorfmove(jorf src, jorf dst, jorf class);
extern 	jorf 	far pascal	jorfsound(int sound, int delay);
extern 	jorf 	far pascal	jorfunlock(jorf j);

extern 	jorf 	far pascal	jwindowlinerelease(void);




/* High level JORF Interpreter commands */
extern jorf 	far pascal	jarradd(jorf arr, jorf pos, jorf cnt);
extern jorf 	far pascal	jarrdel(jorf arr, jorf pos, jorf cnt);
extern jorf 	far pascal	jarrdir(jorf wildcard,jorf exclusionlist,jorf width);
extern jorf 	far pascal	jarrprinters(void);
extern jorf 	far pascal	jarrlen(jorf arr);
extern jorf 	far pascal	jarrpick(jorf arr, jorf command, jorf title, jorf row, jorf col, jorf len, jorf dft);
extern jorf 	far pascal	jarrsort(jorf arr, jorf command, jorf direction);

extern jorf 	far pascal	jchardel(jorf j);
extern jorf 	far pascal	jcharget(void);
extern jorf 	far pascal	jcharins(jorf j);
extern jorf 	far pascal	jcharprint(jorf c, jorf p);
extern jorf 	far pascal	jcharput(jorf j);

extern jorf 	far pascal	jclasschange(jorf j, jorf class);
extern jorf 	far pascal	jclasscheck(jorf name);
extern jorf 	far pascal	jclassfile(jorf name,	jorf level);
extern jorf 	far pascal	jclassfileclear(void);
extern jorf 	far pascal	jclassfilecount(void);
extern jorf 	far pascal	jclassread(jorf name);
extern jorf 	far _fastcall   jclassstart(void);
extern jorf     far pascal      jtranslate(jorf class,jorf name);
extern jorf 	far pascal	jclasswrite(void);

extern jorf 	far pascal	jeventadd(jorf class, 	jorf eventtype,	jorf level);
extern jorf 	far pascal	jeventdo(jorf command, 	jorf eventtype);
extern jorf 	far pascal	jeventdelete(jorf eventtype);

extern jorf 	far pascal	jfileaccess(jorf name, jorf mode);
extern jorf 	far pascal	jfileappend(jorf name);
extern jorf 	far pascal	jfilebackup(jorf name);
extern jorf 	far pascal	jfilechdir(jorf dir);
extern jorf	far pascal	jfilecopy(jorf fromname,jorf toname);
extern jorf 	far pascal	jfilecreate(jorf name);
extern jorf 	far pascal 	jfiledelete(jorf name);
extern jorf 	far pascal	jfilelength(jorf name);
extern jorf 	far pascal	jfileload(jorf name);
extern jorf 	far pascal	jfilemoveto(jorf name, 	jorf lev, 	jorf from);
extern jorf 	far pascal 	jfileprint(jorf f, jorf p);
extern jorf 	far pascal	jfileread(jorf name, jorf lev, jorf siz, jorf off);
extern jorf 	far pascal	jfileremove(jorf name);
extern jorf 	far pascal	jfilerename(jorf oldname,jorf newname);
extern jorf 	far pascal	jfilesave(jorf name,jorf text);
extern jorf 	far pascal	jfilewrite(jorf name, jorf lev, jorf line, jorf siz, jorf off);
extern jorf 	far pascal	jfilenewer(jorf oldname, jorf newname);

extern jorf 	far pascal	jhere(void);

extern jorf 	far pascal	jletter(unchar *function, jorf start, string letterstring);

extern jorf 	far pascal	jlineattribute(jorf length, jorf from, jorf to);
extern jorf 	far _fastcall   jlineinput(jorf origin, int row, int col, int len, int wid, ascii action_io);
extern jorf 	far pascal	jlineinp(jorf field, jorf row, jorf col, jorf len, jorf wid);
extern jorf 	far pascal	jlineout(jorf field, jorf row, jorf col, jorf len, jorf wid);
extern jorf 	far pascal	jlinerel(void);

extern jorf 	far pascal	jmenubar(jorf items);
extern jorf 	far pascal	jmenubox(jorf title, jorf row, jorf col, jorf items);

extern jorf 	far pascal	jmessage(jorf title, jorf type, jorf message);
extern jorf 	far pascal	jmessageadd(void);

extern jorf 	far pascal	jmethodadd(jorf j);
extern jorf 	far pascal 	jmethodarray(jorf j);
extern jorf 	far pascal	jmethoddelete(jorf j);
extern jorf 	far pascal  	jmethodfind(jorf theclass, jorf themethod);

extern jorf 	far pascal	jnumabs(jorf j);
extern jorf 	far pascal	jnummin(jorf j, jorf k);
extern jorf 	far pascal	jnummax(jorf j, jorf k);
extern jorf 	far pascal	jnumbtw(jorf j, jorf k, jorf l);
extern jorf 	far pascal	jnumpow(jorf j, jorf k);
extern jorf 	far pascal	jnumrand(jorf j, jorf k);
extern jorf 	far pascal	jnumsqrt(jorf j);
extern jorf     far pascal      jnumint(jorf j);
extern jorf     far pascal 	jnumlog(jorf j);
extern jorf     far pascal 	jnumexp(jorf j);

extern jorf 	far pascal	jorfcls();
extern jorf 	far pascal	jorfcopy(jorf j);
extern jorf 	far pascal	jorffile(jorf name, jorf level);
extern jorf 	far pascal	jorfflush(jorf j);
extern jorf 	far pascal	jorffuncdelete(jorf j);
extern jorf 	far pascal	jorffuncexit(jorf sts, jorf cmd, jorf msg);
extern jorf 	far pascal	jorffuncwrite(jorf j);
extern jorf 	far pascal	jorfglobal(void);
extern jorf 	far pascal	jorfinterpret(jorf line, jorf jobnum);
extern jorf 	far pascal	jorfmove(jorf src, jorf dst, jorf class);
extern jorf 	far pascal	jorfpack(void);
extern jorf 	far pascal	jorfptr(void);
extern jorf 	far pascal	jorfprinter(void);
extern jorf 	far pascal	jorfrebuild(void);
extern jorf 	far pascal	jorfstacktop(void);
extern jorf 	far pascal	jorfstacklevel(void);
extern jorf 	far pascal	jorfstatus(void);
extern jorf 	far pascal	jorfstatusclear(void);
extern jorf 	far pascal	jorfsystem(jorf command);
extern jorf 	far pascal	jorfwintop(void);

extern jorf 	far pascal	jorfkeyadd(jorf j);
extern jorf 	far pascal	jorfkeydel(jorf j);
extern jorf 	far pascal	jorfkeyfind(jorf j);
extern jorf 	far pascal	jorfkeynext(jorf j);
extern jorf 	far pascal	jorfkeypref(jorf j);

extern jorf 	far pascal	jorfruleadd(jorf j);
extern jorf 	far pascal	jorfruledel(jorf j);
extern jorf 	far pascal	jorfrulefind(jorf j);
extern jorf 	far pascal	jorfrulenext(jorf j);
extern jorf 	far pascal	jorfrulepref(jorf j);

extern void 	far _fastcall   jputs(string s);
extern void 	far _fastcall   jputstring(string s);
extern jorf 	far pascal	jsound(jorf sound, jorf delay);


extern jorf  	far pascal 	jreportadd(jorf title, jorf row, jorf col, jorf len, jorf wid, jorf lev, jorf text);



extern jorf 	far pascal 	jstringafter  (jorf j, jorf k);
extern jorf 	far pascal 	jstringat     (jorf j, jorf k, jorf l);
extern jorf 	far pascal 	jstringatchar (jorf j, jorf k);
extern jorf 	far pascal 	jstringatcut  (jorf j, jorf k);
extern jorf 	far pascal 	jstringatdel  (jorf j, jorf k, jorf l);
extern jorf 	far pascal 	jstringatput  (jorf j, jorf k, jorf l);
extern jorf 	far pascal 	jstringatset  (jorf j, jorf k, jorf l, jorf m);
extern jorf 	far pascal 	jstringin     (jorf j, jorf k);
extern jorf 	far pascal	jstringindent(jorf s);
extern jorf 	far pascal	jstringlength(jorf s);
extern jorf 	far pascal	jstringpad(jorf s,jorf l);
extern jorf 	far pascal	jstringnpad(jorf s,jorf l);
extern jorf 	far pascal	jstringprint(jorf s, jorf p);
extern jorf 	far pascal	jstringput(jorf s);
extern jorf 	far pascal	jstringputline(jorf s);

extern jorf 	far pascal	jsystem(jorf command);

extern jorf 	far pascal	jtextaddj(jorf j,   jorf prvline);
extern jorf 	far pascal	jtextat(jorf text, jorf pos);
extern jorf 	far pascal	jtextfirst(jorf text);
extern jorf 	far pascal	jtextdelete(jorf text, jorf count);
extern jorf 	far pascal	jtextinsert(jorf text, 	jorf count);
extern jorf 	far pascal	jtextlast(jorf text);
extern jorf 	far pascal	jtextlength(jorf j);
extern jorf 	far pascal	jtextlinespaces(jorf text);
extern jorf 	far pascal	jtextmove(jorf dest,	jorf source);
extern jorf 	far pascal	jtextnext(jorf text);
extern jorf 	far pascal	jtextpos(jorf text);
extern jorf 	far pascal	jtextptr(jorf text);
extern jorf 	far pascal	jtextprev(jorf text);
extern jorf 	far pascal	jtextwidth(jorf j);

extern jorf 	far pascal	jtimeget(jorf j);
extern jorf 	far pascal	jtimeset(jorf j);
extern jorf 	far pascal	jtimeticks(void);

extern jorf 	far pascal	jtoascii(jorf j);
extern jorf 	far pascal	jtocapj(jorf j);
extern jorf 	far pascal	jtocharacter(jorf j);
extern jorf 	far pascal	jtolcsj(jorf j);
extern jorf 	far pascal	jtonumber(jorf j, jorf jbase);
extern jorf 	far pascal	jtostring(jorf j, jorf jfmt, jorf jbase, jorf jwid);
extern jorf 	far pascal	jtoucsj(jorf j);

extern jorf 	far pascal	jtraceadd(jorf j);
extern jorf 	far pascal	jtracedel(jorf j);
extern jorf 	far pascal	jtracedo(void);
extern jorf 	far pascal	jtraceend(void);
extern jorf 	far pascal	jtraceoff(void);
extern jorf 	far pascal	jtraceon(void);

extern jorf 	far pascal	jtrue(void);

extern jorf 	far _fastcall   jword(unchar *action, jorf line, int pos, jorf insertstring, int length);
extern jorf 	far _fastcall   jorfwordat(jorf line, int pos,ascii flg);
extern jorf 	far pascal 	jwordat(jorf j, jorf k);
extern jorf 	far pascal 	jwordatcut(jorf j, jorf k);
extern jorf 	far pascal 	jwordatput(jorf j, jorf k, jorf l);
extern jorf 	far pascal 	jwordatdel(jorf j, jorf k, jorf l);
extern jorf 	far pascal 	jwordin(jorf j, jorf k);
extern jorf 	far pascal 	jwordlen(jorf j);
extern jorf 	far pascal 	jwordtype(jorf j, jorf k);
extern jorf 	far pascal 	jclassat(jorf j, jorf k);
extern jorf 	far pascal 	jclassatput(jorf j, jorf k, jorf l);
extern jorf 	far pascal 	jclassin(jorf j, jorf k);

extern jorf 	far pascal	jwindowadd(void);
extern jorf 	far pascal	jwindowattr(jorf attribute);
extern jorf 	far pascal	jwindowblock(jorf j,jorf k);
extern void 	far _fastcall   jwindowcharinsert(int count);
extern jorf 	far pascal	jwindowdelete(void);
extern jorf 	far pascal	jwindowflrco(jorf flrco);
extern jorf 	far pascal	jwindowgetline(void);
extern jorf 	far pascal	jwindowkeybye(void);
extern jorf 	far pascal	jwindowkeyhit(void);
extern jorf 	far pascal	jwindowkeyget_m(jorf cursor_size_nlb);
extern jorf 	far pascal	jwindowkeygot(void);
extern jorf 	far pascal	jwindowkeyput(jorf j);
extern void 	far pascal	jwindowlineinsert(int count);
extern jorf 	far pascal	jwindowlineio(unchar *action, jorf j);
extern jorf 	far pascal	jwindowmagic(jorf j);
extern jorf 	far pascal	jwindowmessage(jorf message);

extern jorf 	far pascal	jwindowjmoveby(jorf row, jorf column);
extern void 	far _fastcall   jwindowmoveby(int row, int column);
extern jorf 	far pascal	jwindowjmoveto(jorf row, jorf column);
extern void 	far _fastcall   jwindowmoveto(int row, int column);

extern jorf 	far _fastcall   jwindowpause(unlong seconds,boolean checkkey_tf);
extern jorf 	far pascal 	jwindowredisplay(void);
extern jorf 	far pascal	jwindowreplace(jorf searchstring, jorf replacestring, jorf flags);
extern jorf 	far pascal	jwindowstructure(void);
extern jorf 	far pascal	jwindowsearch(jorf searchstring, jorf flags);


/* Global Variables */
extern 	jorf 	ok;
extern 	boolean jorf_return_tf;
extern 	boolean jorf_exit_tf;
extern 	struct 	jorf jswitchvalue;
extern  char 	jspacestr[];
extern  jorf    jescptr;
extern  jorf    jkeyptr;

#define define_function(class,name,function,count);   \
  {				              \
  jorf far pascal function();	    	      \
  jfunctiondefine(class,name,function,count); \
  }

#define define_class(class);   \
  {			       \
  jclassdefine(class);         \
  }


/* Windows stuff */
#if defined (_Windows)
extern HANDLE jwin_hInstance;
extern HANDLE jwin_hPrevInstance;

extern long far pascal _export JorfWndProc (HWND,WORD,WORD,LONG) ;
extern boolean 	far _fastcall	JorfWndDo(void);
extern boolean 	far _fastcall	JorfWndWait(void);
extern void 	far _fastcall	jshowfocus(boolean on);
#endif


#endif	/* _JORF_H */