Tutorial:Start
  Win:Add ("Josephine's Recipe Filer Tutorial", 0, 0, 23, 78, Here.)
    Menu:"&About JORF"
      Menu:"&JORF Tutorial", Action:"About:Tut"
      Menu:"&Memory and Disk", Action:"About:Mem"
      Menu:"Fast &Windows", Action:"About:Win"
      Menu:"Fancy &DOS",    Action:"About:DOS"
    Menu:"&OOP Tutorial"
      Menu:"&Intro to OOP", Action:"Intro:OOP1"
      Menu:"&Classes",      Action:"Intro:Class1"
      Menu:"&Methods",      Action:"Intro:Meth1"
      Menu:"I&nheritance",  Action:"Intro:Inh1"
      Menu:"&Polymorphism", Action:"Intro:Poly1"
      Menu:"&Summary",      Action:"Intro:Sum"
    Menu:"&JORF Language"
      Menu:"&Hello Classes",           Action:"Clss:Start"
      Menu:"&Methods and Windows",     Action:"Methods:Start"
      Menu:"&Keyboard and Windows",    Action:"Put:Start"
      Menu:"&Data Entry Screens",      Action:"Put:Real"
    Menu:"&Programming in JORF"
      Menu:"&Math and Functions",      Action:"Math:Start"
      Menu:"&Library Functions",       Action:"Math:Lib1"
      Menu:"&Arrays and Rules",        Action:"Adv:Start"
      Menu:"&Writing JORF Programs",   Action:"Write:Start"
      Menu:"&Comparing OOP Languages", Action:"Comp:Start"
    This tutorial is {prompt:"&Hypertext", Action:"Intro:Hyper"}. &
    Press Enter to see the highlighted subjects.  Use your &
    arrow keys to highlight different subjects.  You can &
    zoom to highlighted letters by holding the Alt key down &
    while pressing that letter.

    {Prompt:"&Josephine", Action:"Intro:Jo"}'s Recipe Filer, &
    JORF(tm), is a new computer &
    language.  JORF was created by a &
    {Prompt:"&Grunt-Programmer" Action:"Intro:Grunt"} &
    frustrated by low level math based computer languages &
    that are inapproprate for business data processing.  With the JORF &
    language you can easily create hypertext and data entry screens,  &
    and write sophisticated routines using an Object Oriented &
    data base manager.
    This Tutorial is a living example of what JORF &
    can do for you.  The runtime system JORF.EXE is &
    interpreting this program line-by-line as you view &
    these screens.  JORF programs also can be compiled, &
    to lock in trade secrets and increase run-time speed.

    Press "Enter" now, to read more about the Hypertext system. &
    Then, highlight the various topics and explore &
    this Tutorial.   Thank you for your support.

    {Group:"More Topics" Row:18 Col:5 Len:3 Wid:68}
    {Prompt:"     &Quick Demo           " Row:19 Col:8 Wid:30 Action:"Quick:Start"}
    {Prompt:"     JORF &Company         " Row:20 Col:8 Wid:30 Action:"Tut:JorfCo"}
    {Prompt:"     &Registering JORF     " Row:21 Col:8 Wid:30 Action:"Tut:Regist"}
    {Prompt:"   JORF Company &Products   " Row:19 Col:42 Wid:30 Action:"Tut:Prod"}
    {Prompt:"   The JORF &Link Libraries " Row:20 Col:42 Wid:30 Action:"Tut:Link"}
    {Prompt:"   The JORF &Developer's Kit" Row:21 Col:42 Wid:30 Action:"Tut:Devel"}
  Jorf:Exit

About:DOS
  Win:Add ("Fancy DOS", 4, 4, 17, 68, Here)
    Button:" More . . . ", Row:15, Col:24, Action:"About:DOS2"
    If you read PC Magazine, you might believe that DOS &
    somehow died when {Bold:"Lo"}MS Windows Version 3{Bold:"No"} &
    was introduced. &
    Anyone with two eyes can see that most people &
    are still running DOS, and that reports of its &
    death are premature.

    I don't question that the future is &
    in MS-Windows.  But there are {Bold:"Lo"}Millions{Bold:"No"} &
    of PC XT and AT computers in current usage that &
    cannot run Windows at a reasonable speed.  &
    And there are thousands of {Bold:"Lo"}Networks{Bold:"No"}, that &
    are too speed sensitive to run Windows.

    And don't forget that trade restrictions limit &
    the sale of 386 machines to formerly communist countries. &
    Until these barriers are lifted, DOS will make an &
    indeleble mark on Eastern Europe, just as it has in &
    Western Europe.
  Return (Tut:Ret)

About:DOS2
  Win:Add ("Will continue to Dominate", 0, 0, 11, 60, Here)
    Button:" More . . . ", Row:9, Col:24, Action:"About:DOS3"
    DOS is {Bold:"Lo"}fast{Bold:"No"} and &
    DOS is {Bold:"Lo"}cheap{Bold:"No"}.  DOS isn't going to die &
    this year or next.  We will continue to see DOS in &
    speed sensitive and cost sensitive applications &
    through the turn of the century, eight years from now.

    If DOS isn't dead and MS-Windows &
    is the Future, then the {Bold:"Lo"}Present{Bold:"No"} of &
    IBM PC style machines is locked into &
    {Bold:"Lo"}Dual Platforms{Bold:"No"}; DOS and MS-Windows.
  Return (Tut:Ret)

About:DOS3
  Win:Add ("The PC Industry for at least eight more years", 8, 2, 13, 78, Here)
    Button:" Done ", Row:11, Col:32, Action:"Return Ok"
    The JORF Language was written for DOS and remains &
    a DOS style application, even when running under &
    MS-Windows.  That doesn't mean it can't be fancy.

    {Bold:"Lo"}JORF Version 2{Bold:"No"} has a new &
    window handler that conforms to the keystroke, menu &
    and input style of MS-Windows. &
    This mode is fast, even on standard XT computers, and &
    and provides some of the visual and functional &
    benefits of the MS-Windows interface.

    Since MS-DOS and MS-Windows files are the same, it is easy &
    to provide same source, same data support in these environments. &
    So that is what I did!
  Return (Tut:Ret)

About:Mem
  Win:Add ("Memory and Disk Management", 4, 4, 16, 68, Here)
    Button:" More . . . ", Row:14, Col:24, Action:"About:Mem2"
    My greatest frustration as a grunt programmer comes from &
    the amount of time I spend dinking around with memory &
    allocation and disk storage of variables.

    It is not my memory, and not my disk.  The management of the &
    computer is the responsiblity of the operating system, and the &
    software tools.  Instead, most languages make me responsible &
    for memory, especially when its time to say &
    {Bold:"Lo"}Out of Memory{Bold:"No"}.

    We put men on the moon a decade ago.  The Berlin wall has &
    disappeared.  We can map the human gene sequence.  Why not &
    have a programming language that takes care of Memory and Disk &
    so I can spend my time with my program.
  Return (Tut:Ret)

About:Mem2
  Win:Add ("Seems Fine to Academics and Engineers", 0, 0, 12, 68, Here)
    Button:" More . . . ", Row:10, Col:24, Action:"About:Mem3"
    The biggest problem now is these friendly user interfaces. &
    Just the main Tutorial window takes over 8 Kilobytes for &
    background and refresh buffers, and up to 128 bytes for &
    every one of the 16 menu items and 10 hypertext prompts.

    Press Ctrl-Break and another 25 Kilobytes is used just to &
    display the debugger window.  By the time you pull up a couple &
    menus, a browse window, and select a method to edit, you &
    will be Out of Memory on any 640K DOS system.
  Return (Tut:Ret)

About:Mem3
  Win:Add ("Who get paid, even when they waste time", 8, 16, 11, 64, Here)
    Button:" More . . . ", Row:9, Col:24, Action:"About:Mem4"
    The Memory management system in JORF dates from 1988 when &
    most applications were not as fancy.  But this system has &
    paid off now, because the "professional software look" &
    demands this memory intensive interface.

    Even under MS-Windows, where &
    the operating system is supposed to handle memory for you (but &
    doesn't), the JORF scheme &
    is faster and more polite than most other Windows Applications.
  Return (Tut:Ret)

About:Mem4
  Win:Add ("But no one pays Me to waste time!", 10, 8, 15, 68, Here)
    Button:" More . . . ", Row:13, Col:24, Action:"About:Mem5"
    In the JORF language, use the {Bold:"Lo"}New{Bold:"no"} &
    command to allocate a variable.  New variables may be &
    numbers, strings, text, or arrays.  New variables are &
    always initialized to Null.

    When you index a variable to be retrieved, the JORF &
    language assumes you want to keep it, and saves it to disk. &
    If you replace that index, the interpreter replaces &
    the value of the variable.

    Variables that are not indexed are deallocated when the &
    method that creates them is ended.  Variables are swapped &
    to disk whenever memory becomes scarce.  This system works &
    for both interpreted programs and for programs translated &
    and compiled in the C language.
  Return (Tut:Ret)

About:Mem5
  Win:Add ("This is Innovation", 0, 0, 6, 50, Here)
    Button:" Done ", Row:4, Col:20, Action:"Return Ok"
    The only JORF language command you need to know is &
    {Bold:"Lo"}New{Bold:"No"} which allocates &
    a new variable.  The JORF language &
    will take care of the rest.  Easy!
  Return (Tut:Ret)

About:Tut
  Win:Add ("The JORF Tutorial", 6, 8, 14, 68 Here)
    Button:" More . . . ", Row:12, Col:28, Action:"About:Tut2"
    The JORF Tutorial is a demonstration of the JORF language. &
    It features hypertext screens, &
    self writing programs, pull down and pop up menus, and &
    data entry screens.

    This tutorial is also being run, {Bold:"Lo"}(Right Now){Bold:"No"} &
    from within the JORF Editor and Debugger.  The Debugger is an &
    integrated part of the Runtime system for interpreted programs.

    To see the Debugger, press {Bold:"Lo"}Ctrl-Break{Bold:"No"}.  (Press &
    the Escape key to return to the program from the Debugger).  Try &
    it now!
  Return (Tut:Ret)

About:Tut2
  Msg:Add
    {FLRCO:"C"}
    The JORF Tutorial
    by Wayland Bruns

    Version 2.1   April 1, 1992
  Return (Tut:Ret)

About:Win
  Win:Add ("Fast Windows", 4, 4, 10, 50, Here)
    Button:" More . . . ", Row:8, Col:18, Action:"About:Win2"
    When you look at most WinApps today, it is &
    easy to sum them up as &
    {Bold:"Lo"}Sophisticated, Slow, and Spendy{Bold:"No"}.

    But grunt programmer that I am, all I want out of &
    MS-Windows is {Bold:"Lo"}Friendly, &
    Fast, and Fairly cheap{Bold:"No"}.

    This is what I want JORF to be.
  Return (Tut:Ret)

About:Win2
  Win:Add ("for Winning", 6, 10, 16, 68, Here)
    Button:" More . . . ", Row:14, Col:28, Action:"About:Win3"
    When Running under MS-Windows, only &
    only the System Fixed Font is supported, &
    only the top window is active, and data entry is done using &
    JORF style prompts, not Windows dialog boxes.

    JORF uses your MS-Windows colors and border styles, supports &
    several types of MS-Windows button styles, and is terribly &
    well behaved with MS-Windows Memory and Disk functions.

    In supporting a subset of MS-Windows features, JORF is smaller, &
    faster and easier to use than most other MS-Windows application &
    tools.  The MS-Windows version is almost as &
    fast as the DOS version, and that is Damn good for a WinApp.
  Return (Tut:Ret)

About:Win3
  Win:Add ("Fair re-Wards", 8, 12, 16, 62, Here)
    Button:" Done ", Row:14, Col:26, Action:"Return Ok"
    I'm not here to give you a cheap version of Toolbook, &
    or FoxBase.  If you need fancy graphics, image processing &
    dynamic data exchange, and some of the other fancy features of &
    Windows, you are not going to find them here in JORF.

    What you will find here is a programming language where &
    you can create a new data entry screen in one tenth the time &
    of Visual BASIC.

    With JORF, you can easily create a &
    decent screen that runs fast and looks fine in just a few &
    lines of code.  Faster and easier than Point and Click, &
    and runs on DOS systems too.  Easy!
  Return (Tut:Ret)

Adv:Arrays
  Win:Add ("Arrays", 0, 0, 16, 64, Here)
    Button:" More . . . ", Row:14, Col:24, Action:"Adv:Words"
    Arrays are created by referencing a variable &
    using an offset in [square brackets].
    {Bold:"Lo"}
                New Foo
                Foo[5]=10       | Foo is now an array
    {Bold:"No"}
    Arrays are allocated to the largest member you have &
    referenced.  The interpreter expands them as necessary &
    as you reference higher numbers.  Custom dictates the first &
    element is 1, although if you want, element zero is available.
  Return (Tut:Ret)

Adv:Casts2
  Win:Add ("Polymorphic Method Calls", 0, 0, 21, 72, Here)
    Button:" More . . . ", Row:19, Col:30, Action:"Adv:Structs"
    A polymorphic call is influenced by the class of the &
    first variable in that call.  If the method exists for &
    that class, it is called.  The parents of the class are &
    also checked, a key feature of inheritance.
    {Bold:"Lo"}
               New Rule:R TextWin:TW Menu:M Jorf:Q
               Start R     | Same as 'Rule:Start R'
               Start TW    | Same as 'TextWin:Start TW'
               Start M     | Same as 'Menu:Start M'
               Q=R
               Show Q      | Will call Rule:Show
               Q=TW
               Show Q      | Will call TextWin:Show
    {Bold:"No"}
    Polymorphism seems obscure in simple examples.  But its &
    advantage lies in being able to put data from different &
    classes in the same data file, and then use polymorphism &
    to redisplay that data.  This ability allows you to make &
    more complex applications than ones that can only store one &
    data type per file.
  Return (Tut:Ret)

Adv:Rules
  Win:Add ("The Rule System", 0, 0, 17, 68, Here)
    Button:" More . . . ", Row:15, Col:26, Action:"Adv:Rules2"
    JORF uses an {Bold:"Lo"}Object-Attribute-Value{Bold:"No"} rule system.  This &
    system is alien to conventional languages but &
    comes from the wonderful world of Artificial Intelligence &
    research.  This triplet is a compact and flexible way to &
    store information to implement deductive systems.

    It is unfortunate that there are name conflicts between &
    the triplet's {Bold:"Lo"}Object{Bold:"No"}, and an OOP {Bold:"Lo"}Object{Bold:"No"}.  But the world is &
    not perfect and we must live with this.  Also, if this is &
    new to you, you will have to memorize this triplet until &
    it rolls trippingly from your tongue in your sleep.

    There is no particular meaning to Object-Attribute-Value.  &
    (There was once, but use has diluted the need for meaning.) &
    These names are just used to avoid saying &
    {Bold:"Lo"}Thingy1-Thingy2-Thingy3{Bold:"No"}.
  Return (Tut:Ret)

Adv:Rules2
  Win:Add ("The Rule System", 5, 0, 15, 64, Here)
    Button:" More . . . ", Row:13, Col:24, Action:"Adv:Rules3"
    The JORF triplet also includes more than three elements:
    {Bold:"Lo"}
        Type           | The Type of Rule  (A Number)
        Obj            | Object
        Att            | Attribute
        Prob           | For AI Probability Calculations
        Val            | Value
        Ptr            | A Pointer to Data
    {Bold:"No"}
    The {Bold:"Lo"}Type{Bold:"No"} is a number that designates &
    the index to use.  This is simply to avoid conflicts arising &
    from different uses of this system.  The &
    {Bold:"Lo"}Ptr{Bold:"No"} points to data that pertains to the &
    rule.
  Return (Tut:Ret)

Adv:Rules3
  Win:Add ("Finding Rules", 0, 0, 20, 70, Here)
    Button:" More . . . ", Row:18, Col:28, Action:"Adv:Rules4"
    The Rule system has five commands, {Bold:"Lo"}Rule:Add{Bold:"No"}, &
    {Bold:"Lo"}Rule:Find{Bold:"No"}, {Bold:"Lo"}Rule:Del{Bold:"No"} &
    {Bold:"Lo"}Rule:Next{Bold:"No"}, and {Bold:"Lo"}Rule:Prev{Bold:"No"}.

    The {Bold:"Lo"}Rule:Next{Bold:"No"} command can be used multiple times &
    to find the next rule in sequence. {Bold:"Lo"}Rule:Prev{Bold:"No"} &
    can be used to "backtrack" in a sequence.

    Rules may be found using a partial rule, but the values must be complete &
    to a point.  If you think of a rule as a &
    scale, you must fill it to any point but with no gaps:
    {Bold:"Lo"}
            Type  Obj       Att        Prob       Val
    OK       1    "Jo"     "is a"      100      "Mammal"
             1    "Festus" "is a"
    No       1             "is a"      100      "Mammal"
    {Bold:"No"}
    The last example will never find anything because there is  &
    no {Bold:"Lo"}Object{Bold:"No"}, but there is &
    an {Bold:"Lo"}Attribute{Bold:"No"}.
  Return (Tut:Ret)

Adv:Rules4
  Win:Add ("How Methods are Indexed", 0, 0, 18, 66, Here)
    Button:" More . . . ", Row:16, Col:24, Action:"Adv:Rules5"
    The Rule system is used internally for all indexed storage. &
    If you look closely at the {Bold:"Lo"}Method{Bold:"No"} class, &
    you find that it can look up methods by knowing that JORF &
    stores them like this:
    {Bold:"Lo"}
          Type         121
          Obj          Class Name
          Att          First 7 digits of Method Name
          Val          Method Name
          Prob         100
          Ptr          Method Text
    {Bold:"No"}
    Due to internal storage factors, any string less than seven &
    digits will be stored in alphabetical order.  By using this &
    in the {Bold:"Lo"}Att{Bold:"No"} JORF keeps classes &
    so they will be printed in alphabetical order.
  Return (Tut:Ret)

Adv:Rules5
  Win:Add ("String Keys", 0, 0, 14, 60, Here)
    Button:" More . . . ", Row:12, Col:22, Action:"Adv:Sum"
    The String Key system may be used to store &
    ordered strings greater than seven digits long.  It &
    replaces {Bold:"Lo"}Att{Bold:"No"} and &
    {Bold:"Lo"}Val{Bold:"No"} with {Bold:"Lo"}Str{Bold:"No"}.
    {Bold:"Lo"}
        Type           | The Type of Rule  (A Number)
        Obj            | Object
        Str            | Up to 20 characters
        Ptr            | A pointer to data
    {Bold:"No"}
    No {Bold:"Lo"}Prob{Bold:"No"} is set for string keys.  String &
    keys are automatically converted to lower case when stored.
  Return (Tut:Ret)

Adv:Start
  Win:Add ("Type Casting", 0, 0, 14, 66, Here)
    Button:" More . . . ", Row:12, Col:26, Action:"Adv:Casts2"
    Method calls are usually {Bold:"Lo"}Cast{Bold:"No"} &
    by using the class and method name for the call.  For &
    instance, to call our Hello method, you use:
    {Bold:"Lo"}
                   Hello:Start
    {Bold:"No"}
    Methods can be called without the cast, which makes the &
    call polymorphic.  For instance, you could say this:
    {Bold:"Lo"}
                   Start
    {Bold:"No"}
    When no class is given, the will call {Bold:"Lo"}Jorf:Start{Bold:"No"}.
  Return (Tut:Ret)

Adv:Structs
  Win:Add ("Structures", 4, 4, 19, 66, Here)
    Button:" More . . . ", Row:17, Col:24, Action:"Adv:Arrays"
    JORF Structures are stored by name reference, and structure &
    definitions can be made without worrying &
    about live data.  New elements to a structure will &
    be "null" in existing structures.

    A variable of the JORF class can be made into a &
    structure just using the pointer operator.  Structures &
    of class JORF have no definition and can hold any &
    value.
    {Bold:"Lo"}
      New Rule:R Jorf:J
      R->Val = "Josephine" | Assign value
      J->Val = R->Val      | Move to J
      R->QQQ = "Goat"      | Error! QQQ is not in Class Rule
      J->QQQ = "Goat"      | Ok - Class JORF takes anything
    {Bold:"No"}
    The special function {Bold:"Lo"}Jorf:Global{Bold:"No"} &
    uses a JORF structure to store global memory variables.
  Return (Tut:Ret)

Adv:Sum
  Win:Add ("Advanced Topics Summary", 7, 10, 18, 66, Here)
    Button:"  Done  ", Row:16, Col:26, Action:"Return Ok"
     Methods are usually cast, but when they are not, they &
    can be polymorphic and will call the method appropriate &
    to the class of the first parameter.

     Flexibility in Structure elements is essential to making changes &
    to large "Live" data bases without rebuilding or compromising data &
    integrity.

     Arrays need no declaration, just use [square brackets] to &
    create indexed elements.  The indexes may be any number and need &
    not be consecutive.  JORF language arrays are not very fast.

     Indexed storage is done using the Rule system.  This system is &
    adapted from the Artificial Intelligence world because it is &
    simple, flexible, and very powerful.
  Return (Tut:Ret)

Adv:Words
  Win:Add ("Words", 8, 0, 16, 76, Here)
    Button:" More . . . ", Row:14, Col:32, Action:"Adv:Rules"
    The {Bold:"Lo"}Word{Bold:"No"} is a basic &
    unit of JORF.  Just like you use Str:At to get &
    a substring, you use Word:At to get a subword.

    Obviously, a line of text is made of words.  But also structures, &
    the program stack, and arrays, are handled as words.

    Structures and the program stack words have a label &
    assigned to them.  For instance, {Bold:"Lo"}Rule->Val{Bold:"No"} &
    actually references a Word in the Rule structure with &
    the label "Val".  (Remember, structures are stored by name &
    reference.)  The {Bold:"Lo"}Class:At{Bold:"No"} can be used &
    to obtain the label name.

    The labels on the program stack are, naturally, the names &
    of variables.  This can easily be seen by looking at the &
    Stack display in the debugger.
  Return (Tut:Ret)

Class:Address Name Street CityStZip

Class:JORFNote Parent:Address Feeling Thought

Clss:Inh
  Win:Add ("Inherited Classes and Structures", 9, 0, 18, 72, Here)
    Button:" More . . . ", Row:16, Col:28, Action:"Clss:Sum"
    Everyone has Parents, and so do Classes. A parent provides:
    {Bold:"Lo"}
                     Access to the parent's methods
                     The parent's structure elements.
    {Bold:"No"}
    When a class has a parent, any           When the Parent is a Structure
    time that class calls a method           then the class inherits the
    which is not defined, the method         elements as if they were
    of the parent is used.                   declared in the definition
      {Bold:"Lo"}Class:Noun Parent:String                  Class:NewRule Parent:Rule{Bold:"No"}
    If a Noun method is not Found,           NewRule has all the elements
    then the String method is used.          that Rule does.

    A class may have more than one Parent.  Multiple parents are examined &
    in the order in which they are declared.
  Return (Tut:Ret)

Clss:JorfPtr
  Win:Add ("The JORF Data Type", 0, 0, 18, 72, Here)
    Button:" More . . . ", Row:16, Col:28, Action:"Clss:NewClasses"
    Most languages provide data types that relate directly to &
    data objects that the CPU can handle.  These include bytes, &
    integers and floating point numbers.

    The JORF Language is different because there is only one data type; a &
    {Bold:"Lo"}Jorf{Bold:"No"}.  The JORF Language is responsible for &
    range checking and data conversion, and will store the data to &
    disk automatically.

    A {Bold:"Lo"}Jorf{Bold:"No"} can hold

       {Bold:"Lo"}Integers               {Bold:"No"}      88        or      -282
       {Bold:"Lo"}Floating point numbers {Bold:"No"}      5.68989   or  232,000,000.01
       {Bold:"Lo"}Strings                {Bold:"No"}      "Hello"   or   "Josephine"
       {Bold:"Lo"}Text                   {Bold:"No"}      (The contents of this window)
  Return (Tut:Ret)

Clss:NewClasses
  Win:Add ("Class Definitions", 0, 0, 14, 64, Here)
    Button:" More . . . ", Row:12, Col:24, Action:"Clss:Structures"
    A new class is defined with a one line statement.

       {Bold:"Lo"}Class:String       | Defines the Class "String"{Bold:"No"}
       {Bold:"Lo"}Class:Text         | Defines the Class "Text"  {Bold:"No"}

    A Method for the class is created by prefixing the method &
    with the class name followed by a colon.

       {Bold:"Lo"}String:Concatenate S1 S2  | Method to connect strings{Bold:"No"}
       {Bold:"Lo"}  Return S1+S2            |  Return third string     {Bold:"No"}

  Return (Tut:Ret)

Clss:Start
 Script:Add ("Script:Hello")
 If (Kbd:Got != 'Esc_key')
   Hello:Start
 If (Kbd:Got != 'Esc_Key')
   Win:Add ("JORF Language Conventions", 0, 0, 18, 64, Here)
     Button:" More . . . ", Row:16, Col:24, Action:"Clss:JorfPtr"
      JORF is not Case Sensitive.  "Rose" is a "ROSE" is a "rose".

      Classes are designated using a colon.  {Bold:"Lo"}Class:ItemName{Bold:"No"}.

      Indentation controls program flow.

      Keywords are: {Bold:"Lo"}Class{Bold:"No"}, &
     {Bold:"Lo"}JORF{Bold:"No"} and  &
     {Bold:"Lo"}Parent{Bold:"No"}.

      Extra spaces and tabs are ignored.  The end of the line
       is the end of the line.  Lines may not be continued

      Words are delimited by spaces.  Multiple word names must
       use_underscores to make them one word.

      Comments begin with a Pipe ({Bold:"Lo"}|{Bold:"No"}) and go to the end of the line.
  Return (Tut:Ret)

Clss:Structures
  Win:Add ("Structure Definitions", 7, 0, 15, 60, Here)
    Button:" More . . . ", Row:13, Col:24, Action:"Clss:Inh"
    A {Bold:"Lo"}Structure{Bold:"No"} is a class &
    with more than one element. &
    Each element of a class structure is another class. If no &
    class is specified, the element belongs to the default &
    class {Bold:"Lo"}Jorf{Bold:"No"}.

    This definition of the Contact class defines &
    a structure used by the JORF Contact Manager.

    {Bold:"Lo"}Class:Customer Company, Address:Contact, Telephone:Work{Bold:"No"}

    In this example, the element {Bold:"Lo"}Company{Bold:"No"} &
    belongs to the JORF class, the element {Bold:"Lo"}Contact{Bold:"No"} &
    belongs to the "Address" class, and the element {Bold:"Lo"}Work{Bold:"No"} &
    belongs to the "Telephone" class.
  Return (Tut:Ret)

Clss:Sum
  Win:Add ("Summary of Classes and Data Types", 0, 0, 18, 76, Here)
    Button:"  Done  ", Row:16, Col:30, Action:"Return Ok"
     JORF uses one data type, called a &
    {Bold:"Lo"}Jorf{Bold:"No"}.  It can &
    hold integers, floating point numbers, strings and text.

     JORF Classes are defined in one line beginning by the name prefixed &
    with the word {Bold:"Lo"}class{Bold:"No"}. Methods for the class are &
    prefixed with the class name.

     Classes may be {Bold:"Lo"}Structures{Bold:"No"} which have more than one element. &
    Each element belongs to a class.

     The default class is {Bold:"Lo"}Jorf{Bold:"No"}.  Any method or &
    Structure element without an explicit class is assumed to belong &
    to the {Bold:"Lo"}Jorf{Bold:"No"} class.

     A {Bold:"Lo"}Parent{Bold:"No"} may be designated in a &
    class definition.  If a method &
    is not declared for a class, the parent's method will be used. &
    If the parent is a structure, all the elements of that structure &
    are inherited by the class.
  Return (Tut:Ret)

Comp:Actor
  Win:Add ("Actor", 0, 0, 22, 72, Here)
    Button:" More . . . ", Row:20, Col:28, Action:"Comp:Lisp"
    Actor(tm) is an Object Oriented Language created by the Whitewater Group. &
    It fully supports Microsoft Windows(tm) operating &
    system, which makes it ideal for programming for Windows 3.0(tm).

    Actor programs look visually like C, but are &
    different.  The Actor Language requires matched curly brackets &
    and correct &
    placement of colons and semi-colons, just like C, and it is &
    sometimes annoying that it is not C.  It is a compiler and &
    allows you to link with other languages.

    The most recent version of Actor introduced memory swapping. &
    Until this, your entire application had to reside in memory.  Now &
    you can swap up to 2 megabytes  on a 640K DOS system.  (JORF also &
    has swapping.  Those are those annoying "Flushing..." pauses.)

    Like Smalltalk, Actor doesn't support multiple inheritance.
    At $695, Actor is kinda pricey for the novice.  But it is an &
    excellent tool for serious programmers who want to &
    write applications for Microsoft Windows.
  Return (Tut:Ret)

Comp:CPP
  Win:Add ("C++", 0, 0, 18, 70, Here)
    Button:" More . . . ", Row:16, Col:28, Action:"Comp:Cpp2"
    I really love the C language.  But I would never wish it &
    on anyone.  How is it that such a popular language has &
    statements that look like:
    {Bold:"Lo"}
        if (c>='A'&&c<='Z') c|=0x20;  /*Make C lower case*/
    {Bold:"No"}
    C is a great tool building language.  It is the perfect language &
    to write compilers or screen systems with.  Programs in C run &
    about half as fast as those written in assembly language, which &
    is damn good for a high level language.  But C uses a ton of &
    punctuation for no good reason.  This makes it daunting to learn, &
    hard to read, and hard to make self documenting code.

    Now what happens when you have a brilliant engineer add objects &
    to C? If the engineer is {Bold:"Lo"}Bjarne Stroustrup{Bold:"No"} &
    you get C++.  As the name indicates, this is a version of C with twice &
    as much punctuation.
  Return (Tut:Ret)

Comp:Cpp2
  Win:Add ("More on C++", 4, 4, 21, 78, Here)
    Button:" More . . . ", Row:19, Col:30, Action:"Comp:JORF"
    C++ has all the complexity of a transitional language, with &
    extra work besides. Not only do you have to know C &
    to use C++, you have to &
    learn extra things that Bjarne thought were good ideas.

    In C++ there is two ways to comment code (/* */ or //), two flexible &
    printing mechanisms (printf and cout), and two ways to cast types ((int)i &
    and int(i)). I wish Bjarne had cut out upward compatibility and just &
    created a new language.  {Bold:"Lo"}This hybrid adds gratuitous &
    complexity to an OOP version of an unreadable language.{Bold:"No"}

    At its best, C++ is a good tool to add OOP systems to existing C programs. &
    At its worst, it will create an entire generation of programmers &
    with lifetime job security, because no one else can read their code.

    C++ will be the dominant Object Oriented Language for systems tools and &
    low level programming.  But despite what we hear from converts, it is &
    unlikely that most applications programmers will attain the fluency &
    needed to create good programs in C++.
  Return (Tut:Ret)

Comp:JORF
  Win:Add ("JORF", 0, 0, 14, 60, Here)
    Button:" More . . . ", Row:12, Col:24, Action:"Comp:JORF2"
    The JORF Language was introduced in July, 1990, and &
    is one of the few OOP languages available both as an &
    interpreter and as a compiler.  Although interpreters run more slowly &
    than compilers, they provide a better environment for &
    beginners because they are more interactive.

    JORF features a source level debugger and editor that lets &
    you rewind the stack pointer, change a line, and &
    continue the run of the program using the new line.  &
    And the debugger is twisty; both it and the program editor &
    are written in the JORF language, translated and compiled into &
    the interpreter package.
  Return (Tut:Ret)

Comp:JORF2
  Win:Add ("JORF Translator", 0, 0, 20, 60, Here)
    Button:" More . . . ", Row:18, Col:24, Action:"Comp:Sum"
    This version includes a JORF language to C &
    language translator.  The translated code is not as fast &
    as native C because it must do extra work to support the &
    memory handling and typelessness of JORF variables.  But &
    this system gives a hefty speed improvement over &
    Interpreted JORF language code, and creates a "real" &
    EXE file that doesn't need a runtime system.

    Also available is a Developer's kit, that includes source &
    code and documentation for many JORF library functions.  This &
    gives you the information you need to create your own library &
    functions, and add new commands to the JORF language.  You may &
    sell compiled applications without royalty, provided you do not &
    create JORF language programming products (that's our business) &
    and that you include a valid copyright message.
  Return (Tut:Ret)

Comp:Lisp
  Win:Add ("Lisp", 0, 0, 19, 70, Here)
    Button:" More . . . ", Row:17, Col:26, Action:"Comp:OOPPascal"
    Lisp is an language created by John McCarthy in 1960.  It handles &
    {Bold:"Lo"}functions{Bold:"No"} where normal languages &
    handle {Bold:"Lo"}data{Bold:"No"}.  This makes it much more &
    flexible than data handling programming languages.  This &
    flexibility is a problem, because it is hard to pin down &
    Lisp enough to understand it.

    To make Lisp more understandable, dialects have been developed. These &
    "dialects" can almost be &
    considered separate languages.  Two Object Oriented dialects &
    are Flavors and CLOS (Common Lisp Object System).

    In order to like Lisp, you already have to love it.  It &
    uses (lotsa ((parentheses (and (Polish Reverse)) Notation)). &
    I get parentheses mismatch errors in BASIC, and have never &
    attempted Lisp.

    Lucid offers a CLOS environment for 386 based PCs and VAX computers &
    for hundreds and hundreds of dollars.
  Return (Tut:Ret)

Comp:OOPPascal
  Win:Add ("Object Oriented Pascal", 2, 4, 21, 74, Here)
    Button:" More . . . ", Row:19, Col:28, Action:"Comp:CPP"
    Borland International has &
    Object Oriented Turbo Pascal for $150, and Microsoft &
    sells Object Oriented QuickPascal for $99.
    {Bold:"Lo"}{FLRCO:"Center"}
    The BEST feature of Object Oriented Pascal is that
    it is upward compatible with regular Pascal.

    The WORST part of Object Oriented Pascal is that
    it is upward compatible with regular Pascal.
    {Bold:"No"}{FLRCO:"Left"}
    Adding Objects to Pascal makes it better, but does not change the &
    fundamental language.  Although Pascal is popular, it is not a strong &
    language and it has a lot of silly syntax and punctuation rules. &
    (Like requiring "END" for IF and WHILE statements, := instead of = &
    for assignment, and those incredible semi-colons to end a sentence with;

    Object Oriented Pascal is a transitional product that &
    requires you to know both the OOP version and the Pre-OOP version &
    to use the product.  If this does not daunt you, you can't beat &
    the price.
  Return (Tut:Ret)

Comp:SmallTalk
  Win:Add ("Smalltalk", 0, 0, 18, 67, Here)
    Button:" More . . . ", Row:16, Col:28, Action:"Comp:Actor"
    Smalltalk was developed at Xerox Palo Alto Research Center &
    between 1969 and 1983.  It was designed to run on a computer that &
    was never released.  Among other things, this system originated &
    the "Macintosh(tm)" graphics interface that used windows and icons. &
    Digitalk offers a version called Smalltalk/V for under $100.

    Smalltalk is burdened by its 14 years of evolution in the number &
    of "Basic Objects" you must learn to use the system.  You must use &
    colons just right, because "new" and "new:" and ":new" do very &
    different things.  There seems to be no end to the key words you &
    have to learn.  Smalltalk does not support multiple inheritance.

    On the other hand Smalltalk is fast, consistent and effective.  It &
    is faster than JORF, (all languages are faster than JORF) and is &
    relatively portable.
  Return (Tut:Ret)

Comp:Start
  Win:Add ("Comparing OOP Languages", 0, 0, 11, 60, Here)
    Button:" More . . . ", Row:9, Col:24, Action:"Comp:Smalltalk"
    The technique of Object Oriented Programming has been &
    around since 1970.  So there are many languages and tools &
    that support OOP.  But the technique is new enough &
    that there is still a lot of evolution happening, &
    and these tools are constantly gaining features.

    The most popular OOP languages are Smalltalk, Actor, &
    some dialects of Lisp, C++ and Object Oriented Pascal.
  Return (Tut:Ret)

Comp:Sum
  Win:Add ("OOP Comparison Summary", 0, 0, 20, 72, Here)
    Button:"  Done  ", Row:18, Col:30, Action:"Return Ok"
     Smalltalk is an early OOP Language and Smalltalk/V is an &
    inexpensive version of this complex language.

     Flavors and CLOS are Object Oriented dialects of Lisp. &
    (Lisp (is (a (language (for))) (lovers (of &
    (Parentheses)))).

     Object Oriented Pascal is available from both Borland and &
    Microsoft for Cheap!  It is a transitional language, that &
    requires that you learn both the Pre OOP and OOP versions.

     C++ is a hybrid Object Oriented language with gratuitous &
    complexity thrown in.  Bjarne should be required to give us &
    all a nickel for every unnecessary quirk he added to this &
    obsessivly punctuated language.

     JORF is a new language for applications programming.  It is &
    one of the few OOP languages where you can develop with an &
    interpreter and later compile to create a True EXE file.
  Return (Tut:Ret)

Demo:Screen
  New (Rad, Chk, Inp1, Inp2)
  Win:Add ("A Real Screen", 4, 8, 14, 50, Here)
    Menu:"&Help"
      Menu:"&Indented Menu Items"
        Menu:"&Create Sub Menus"
          Menu:"&And Even Deeper"
          Menu:"&Sub Menus"
        Menu:""
        Menu:"(Escape to Exit)"
      Menu:"&Jorf Help           F1" Action:"Hotkey:F1_Key"
      Menu:"&Time and Date  Alt-F10" Action:"HotKey:Alt_F10_Key"
    String:"  Use your Arrow Keys to go up and down.  On"
    String:"  Check Boxes and Radio Buttons, the Enter Key"
    String:"  checks and Space Bar skips.  Be sure to Press"
    String:"  Alt-H to check out the Menus and Submenus!"
    Radio:" Radio &1" Row:6 Col:8
      Check:"Rad==True", Action:"Rad=True"
    Radio:" Radio &2"
      Check:"Rad==False", Action:"Rad=False"
    ChBox:" Check Box &A" Row:6, Col:26
      Check:"Chk==True", Action:"Chk=True"
    ChBox:" Check Box &B"
      Check:"Chk==False", Action:"Chk=False"
    Input:"&Input 1  " Row:9, Col:8 Field:"Inp1"
    Input:"I&nput 2  "              Field:"Inp2"
    Button:"  &Done  "   Row:12, Col:24, Action:"Return 'Esc_Key'"
  Return

Demo:Start
  Msg:Add ("Quick Demonstration", "Ok")
    Sure you can say "Hello World" in one line of
    C code.  But how many punctuation characters
    are required to display a dialog box like this?

Hello:Start
  Msg:Add ("Hello", "Ok")
    Welcome to the Wonderful World of JORF!

Intro:Class1
  Win:Add ("Classes", 0, 0, 19, 62, Here)
    Button:"  More . . . ", Row:17, Col:24, Action:"Intro:Class2"
    A {Bold:"Lo"}Class{Bold:"No"} is the OOP way of &
    saying "Data Type".  Most computer languages have &
    pre-defined data types like {Bold:"Lo"}Strings{Bold:"No"} &
    and {Bold:"Lo"}Floating Point Numbers{Bold:"No"}.

    For instance, in BASIC, a variable of the {Bold:"Lo"}String{Bold:"No"} &
    data type is marked using a dollar sign.
    {Bold:"Lo"}
           10 GOAT$ = "Josephine"
           20 PRINT GOAT$
    {Bold:"No"}
    The C language uses character arrays to store strings.
    {Bold:"Lo"}
         main() {"{"}
           char goat[]="Josephine";
           printf("%s\n", goat);
           {"}"}
    {Bold:"No"}
  Return (Tut:Ret)

Intro:Class2
  Win:Add ("OOP Classes", 0, 0, 9, 52, here)
    Button:"  More . . . ", Row:7, Col:18, Action:"Intro:Class3"
    OOP languages let you define &
    your own data types to suit your specific &
    needs.  In JORF, you create new data types using &
    the key word {Bold:"Lo"}Class{Bold:"No"}.
    {Bold:"Lo"}
      Class:String   | Creates the String class
      Class:Goat     | Creates the Goat Class
    {Bold:"No"}
  Return (Tut:Ret)

Intro:Class3
  Win:Add ("Structures", 7, 0, 18, 52, Here)
    Button:"  More . . . ", Row:16 Col:18, Action:"Intro:Class4"
    The class mechanism may also be used to create classes with &
    several members.  These are called &
    {Bold:"Lo"}Structures{Bold:"No"} in JORF and C++ &
    and {Bold:"Lo"}Collections{Bold:"No"} or &
    {Bold:"Lo"}Sets{Bold:"No"} in Smalltalk.
    {Bold:"Lo"}
        Class:Address Name Address City State Zip
    {Bold:"No"}
    The Class Address has the elements {Bold:"Lo"}Name{Bold:"No"}, &
    {Bold:"Lo"}Address{Bold:"No"}, &
    {Bold:"Lo"}City{Bold:"No"}, &
    {Bold:"Lo"}State{Bold:"No"}, and  &
    {Bold:"Lo"}Zip{Bold:"No"}. &
    To access the elements of the structure, the pointer &
    operator is used:
    {Bold:"Lo"}
             Address->Name    = "Josephine"
             Address->Address = "The Field"
             Address->City    = "Colton"
    {Bold:"No"}
  Return (Tut:Ret)

Intro:Class4
  Win:Add ("Conclusion", 9, 0, 9, 68, Here)
    Button:"  Done  ", Row:7 Col:30, Action:"Return Ok"
    OOP {Bold:"Lo"}Classes{Bold:"No"} are just do-it-yourself &
    Data Types.  {Bold:"Lo"}Numbers{Bold:"No"} and {Bold:"Lo"}Strings{Bold:"No"} &
    are predefined classes, and you can add your own as needed.

    You can also make classes with multiple elements called   &
    {Bold:"Lo"}Structures{Bold:"No"}. Structures act just &
    like {Bold:"Lo"}records{Bold:"No"} in a data base.  &
    Each element of a structure &
    can have its own class, so structures can be nested.
  Return (Tut:Ret)

Intro:Grunt
  Win:Add ("Wayland Bruns", 0, 0, 15, 60, Here)
    Button:"More . . .", Row:13, Col:24 Action:"Intro:Grunt2"
    For the better part of a decade I have supported &
    myself by writing accounting and document processing &
    computer applications.  That is to say - I'm a grunt &
    programmer.

    In these years I have used languages by well paid &
    engineers and ivory tower academics.  These languages, &
    like C++ and Modula II, allow me to create beautiful &
    bubblesorts, and flexible file storage systems.

    But people pay me for working applications, not beautiful &
    bubblesorts.  And the primitive memory handling in C, &
    and upside down procedures of Modula II slow me down.
  Return (Tut:Ret)

Intro:Grunt2
  Win:Add ("Striving to Create", 0, 0, 18, 60, Here)
    Button:"&More . . ." Row:16, Col:24 Action:"Intro:Grunt3"
    JORF is my attempt to create a more appropriate &
    programming language.  With a simpler syntax, and more &
    powerful memory and data base handling.

    The JORF language takes responsiblity for niggly stuff &
    wastes programmer time in other languages. &
    You don't have to worry about &
    {Bold:"Lo"}type mismatch errors{Bold:"No"} &
    because the JORF language has just one data type!

    The JORF Language also handles {Bold:"Lo"}memory allocation{Bold:"No"}. &
    One failure of C++ is that it lacks a better way of handling &
    temporary memory structures.  JORF not only handles temporary &
    structures for you, it can even swap them to disk.  That way, your &
    {Bold:"Lo"}DOS Apps{Bold:"No"} don't run out of memory, and your &
    your {Bold:"Lo"}Win Apps{Bold:"No"} are well behaved.
  Return (Tut:Ret)

Intro:Grunt3
  Win:Add ("A Language for Regular People (Like You)!" 8, 4, 16, 70, Here)
    Button:"&I really must say I agree." Row:14, Col:20 Action:"Return Ok"
    The JORF language is my language.  I've made my career &
    creating {Bold:"Lo"}Business Applications{Bold:"No"}, &
    that is what JORF is best at.

    Since my pet-peeves are machine language data types, &
    numeric overflows, data file handling, and memory management, &
    I've created a language that takes care of these things.

    With the world moving {Bold:"Lo"}backward{Bold:"No"}, &
    toward more complex versions of C, more C-Like versions &
    of BASIC, and quirkier dialects of dBASE, I think it is &
    time to share my effort.

    I think you will agree, when it comes to creating simple Business &
    Applications, JORF is a step toward an easier future.
  Return (Tut:Ret)

Intro:Hyper
  Msg:Add ("Hypertext", "Ok")
    The Hypertext system highlights the current prompt.  Use &
    your arrow keys to highlight the next or previous prompts.

    If there are menu letters, or prompt letters highlighted on &
    the screen, you can zoom to them by holding down the Alt key &
    and pressing the appropriate letter.

    The Hypertext system is designed so that &
    pressing {Bold:"Lo"}Enter{Bold:"No"} &
    brings you to the next prompt, &
    or back to the beginning if you have &
    finished.  You can press &
    {Bold:"Lo"}Escape{Bold:"No"} to &
    exit from the current screen.

    Press Enter now to return to the main screen.
  Return (Tut:Ret)

Intro:Inh1
  New Count
  Win:Add (Null, 0, 0, 5, 0, Here)
    How do you write 200 lines
    of code in 6 letters?
  Win:Pause (100)
  Win:Attr ("Lo")
  Move:To (4, 10)
  While (Count < 6)
    ++Count
    Str:Put (Str:At ("Parent",Count,1))
    Win:Pause (40)
  Win:Attr ("No")
  Win:Pause
  Win:Add ("Inheritance", 0, 0, 18, 66, Here)
    Button:" More . . . ", Row:16, Col:25, Action:"Intro:Inh2"
    The {Bold:"Lo"}Parent{Bold:"No"} key word lets a class inherit &
    all the elements and methods that &
    belong to another class.

    For instance, suppose you had an Address class.  Then you wanted &
    to create a new class for Customer.  The Customer class contains &
    many fields that are also in the Address Class.
    {Bold:"Lo"}
      Class:Address Name, Street, City, State, Zip
      Class:Customer Company, Name, Street, City, State, Zip
    {Bold:"No"}
    It is much easier to define the Customer class &
    if we just inherit the items from the Address &
    class.
    {Bold:"Lo"}
      Class:Address Name, Street, City, State, Zip
      Class:Customer Company, Parent:Address
    {Bold:"No"}
  Return (Tut:Ret)

Intro:Inh2
  Win:Add ("Method Inheritance", 0, 0, 11, 60, Here)
    Button:" More . . . ", Row:9, Col:22, Action:"Intro:Inh3"
    Methods are also inherited, because they belong to the &
    classes.  By declaring Address as a parent, the &
    Customer class inherits all the methods that belong &
    to Address.

    When you call a method, the interpreter first looks in &
    the indicated class.  If the method is declared within &
    that class, it is run.  If it is not declared within &
    the class, the parent classes are checked.
  Return (Tut:Ret)

Intro:Inh3
  Win:Add ("Method Inheritance", 0, 0, 22, 78, Here)
    Button:"  More . . . ", Row:8, Col:58, Action:"Intro:Inh4"
    The following source code defines the classes {Bold:"Lo"}Customer{Bold:"No"} and &
    {Bold:"Lo"}Address{Bold:"No"}.

    Say you have a variable Cust, that belongs to the {Bold:"Lo"}Customer{Bold:"No"} class.  When &
    the interpret runs {Bold:"Lo"}Say Cust{Bold:"No"} it runs the {Bold:"Lo"}Customer:Say{Bold:"No"} &
    method.  When it &
    sees {Bold:"Lo"}Print Cust{Bold:"No"} it runs the inherited &
    {Bold:"Lo"}Address:Print{Bold:"No"} method, because there is &
    no {Bold:"Lo"}Customer:Print{Bold:"No"} method.
    {Bold:"Lo"}
         Class:Address Name Street City State Zip

         Address:Print Addr
           Print Addr->Name
           Print Addr->Street
           Print Addr->City + "," + Addr->State + " " + Addr->Zip

         Address:Say Addr
           Print Addr->Name

         Class:Customer Number Parent:Address Comment

         Customer:Say Cust
           Print "Number:" Cust->Number + "  Name:" Cust->Name
    {Bold:"No"}
  Return (Tut:Ret)

Intro:Inh4
  Win:Add ("Multiple Inheritance", 0, 0, 17, 68, Here)
    Button:" Done ", Row:15, Col:32, Action:"Return Ok"
    Some OOP languages like JORF, allow a class to have &
    more than one parent.  This ability called &
    {Bold:"Lo"}Multiple Inheritance{Bold:"No"}.  For instance &
    you may want a Vendor class, that inherits from both the &
    Address class, and also from the PurchOrder class:
    {Bold:"Lo"}
            Class:Vendor Parent:Address Parent:PurchOrder
    {Bold:"No"}
    When multiple parents are declared, the order is significant &
    in resolving name conflicts.

    Many OOP languages don't support multiple inheritance.  &
    They should, because multiple inheritance is useful and &
    is easy to implement (at least it was in the JORF interpreter).
  Return (Tut:Ret)

Intro:Jo
  Msg:Add ("Josephine T. Goat", "Ok")
    Josephine is a tan pygmy goat that lives at the &
    foot of the Cascade Mountains in &
    lovely Colton, Oregon.

    Josephine doesn't file recipes or write &
    Object Oriented Programs.  Instead she &
    dances and plays in the sunshine.  Her &
    message is simple:
    {Bold:"Lo"}
                   Lighten-up
                   Eat
                   Dance
                   Baaaah.
    {Bold:"No"}
    Josephine doesn't have to work for a living.
  Return (Tut:Ret)

Intro:Meth1
  Win:Add ("Methods", 0, 0, 14, 64, Here)
    Button:"  More . . . ", Row:12, Col:24, Action:"Intro:Meth2"
    A {Bold:"Lo"}Method{Bold:"No"} is the OOP way &
    of saying "Function" or "Subroutine".  Methods &
    are procedural routines to perform a specific task.

    In Non-OOP languages like {Bold:"Lo"}BASIC{Bold:"No"} &
    and {Bold:"Lo"}C{Bold:"No"}, all variables &
    belong to a data type.  But subroutines and functions &
    exist independent of the data types.

    In OOP languages like {Bold:"Lo"}JORF{Bold:"No"} and &
    {Bold:"Lo"}Smalltalk{Bold:"No"}, all methods &
    belong to a class.  Methods that work on Strings belong &
    to the String class.  Methods that print Addresses belong &
    to the Address class.
  Return (Tut:Ret)

Intro:Meth2
  Win:Add ("Method Declarations", 0, 0, 20, 62, Here)
    Button:"  More . . . ", Row:18, Col:24, Action:"Intro:Meth3"
    In JORF, the class of a method prefixes the method name. The &
    following code fragment defines the class address and &
    a {Bold:"Lo"}print{Bold:"No"} method for that class:
    {Bold:"Lo"}
          Class:Address Name Address City State Zip
          Address:Print A
            Print A->Name
            Print A->Address
            Print A->City + "," + A->State + " " + A->Zip
    {Bold:"No"}
    A {Bold:"Lo"}Class{Bold:"No"} and &
    it's {Bold:"Lo"}Methods{Bold:"No"} &
    are packaged together to form an &
    {Bold:"Lo"}Object{Bold:"No"} which is why this &
    is called Object Oriented Programming.

    The packaging of classes and methods is called &
    {Bold:"Lo"}Encapsulation{Bold:"No"} &
    because Computer Scientists and Engineers &
    get a kickback when they &
    obfuscate with five syllable words.
  Return (Tut:Ret)

Intro:Meth3
  Win:Add ("The Starting Method", 8, 10, 18, 72, Here)
    Button:"  More . . . ", Row:16, Col:24, Action:"Intro:Meth4"
    JORF language programs always begin with a &
    method called {Bold:"Lo"}Class:Start{Bold:"No"} &
    where {Bold:"Lo"}class{Bold:"no"} is the name of &
    the source code file.   This sample is in the
    {Bold:"Lo"}Hello.J{Bold:"no"} source file:
    {Bold:"Lo"}
            Hello:Start
              Win:Msg (Null, "Ok")
                Welcome to the World of JORF!
              Jorf:Exit
    {Bold:"No"}
    The first line is the method declaration.  Methods &
    are declared flush left, and the rest of the method &
    is indented.

    The second command calls the JORF Message Window function &
    specifying a Null title, and a button type "Ok".  The &
    indented line is the text of the message.  The last line &
    calls the JORF Exit function that ends every program.
  Return (Tut:Ret)

Intro:Meth4
  Msg:Add (Null, "Ok")
    Welcome to the World of JORF!
  Intro:Meth5
  Return (Tut:Ret)

Intro:Meth5
  Win:Add ("Summary", 0, 0, 16, 52, Here)
    Button:" Done ", Row:14, Col:22, Action:"Return Ok"
     {Bold:"Lo"}Method{Bold:"No"} is the OOP word for &
    {Bold:"Lo"}Subroutine{Bold:"No"} or {Bold:"Lo"}Function{Bold:"No"}.

     OOP language methods are identified by class.  In the JORF &
    language, the class name is the prefix, followed by a colon &
    followed by the method name:   {Bold:"Lo"}Class:MethodName{Bold:"No"}.

     A class definition and its accompanying methods are &
    called an {Bold:"Lo"}Object{Bold:"No"}, hence the name, &
    Object Oriented Programming.

     JORF language programs always begin with a method &
    called {Bold:"Lo"}Start{Bold:"No"}.
  Return (Tut:Ret)

Intro:OOP1
  Win:Add ("Object Oriented Programming" 0, 0, 14, 60, Here)
    Button:"  More . . .", Row:12 Col:24 Action:"Intro:OOP2"
    {Bold:"Lo"}Object Oriented programming{Bold:"No"} &
    is a new technique that is changing the way we all &
    write software.

    This is not because {Bold:"Lo"}Phil Khan{Bold:"No"} makes &
    $300 every time we change languages, or because the Comp Sci &
    department at the University got bored of {Bold:"Lo"}Pascal{Bold:"No"}.

    It is because computers are getting more powerful, and &
    programs are getting more complex.  We've come to a time &
    that we need a new technique to help keep control over &
    these complex programs.
  Return (Tut:Ret)

Intro:OOP2
  Win:Add ("Handling Complexity" 0, 0, 14, 60, Here)
    Button:"  More . . .  ", Row:12 Col:24, Action:"Intro:OOP3"
    It used to be quite sufficient to create a screen by &
    placing each prompt, invoking an input system, and checking &
    the keystrokes.

    Now, a MS-Windows style screen with pull down menus, Alt keys &
    buttons, boxes and input fields may have to handle more than &
    {Bold:"Lo"}100{Bold:"No"} possible keystrokes.

    The old system of {Bold:"Lo"}If Key = 'M' . . . If Key = 'Q' . . .{Bold:"No"}
    is just inadequate for this complex a screen.  You might as &
    well write it in Assembler
  Return (Tut:Ret)

Intro:OOP3
  Win:Add ("Writing in Assembler" 7, 0, 13, 70, Here)
    Button:"  More . . .  ", Row:11 Col:28, Action:"Intro:OOP4"
    Assembly language is the first of all computer languages. &
    {Bold:"Lo"}Key words{Bold:"No"} in assembler correspond &
    to the {Bold:"Lo"}binary machine code{Bold:"No"} &
    that is native to the computer chip.

    The purpose of higher level languages is to use the power of &
    the computer to support data constructs beyond those native to &
    the CPU.

    As computers have grown more and more powerful, it is clear that &
    new languages must support more than complex data constructs.  They &
    must also support a {Bold:"Lo"}higher level conceptual framework{Bold:"No"} &
    for programming.
  Return (Tut:Ret)

Intro:OOP4
  Win:Add ("Object Oriented Programming" 3, 3, 17, 74, Here)
    Button:"  More . . .  ", Row:15 Col:30, Action:"Intro:OOP5"
    In OOP technique, the {Bold:"Lo"}Data{Bold:"No"} is &
    of primary importance.  The {Bold:"Lo"}Program{Bold:"No"} is &
    secondary.  Although the program consists of recognizable &
    subroutines, they are identified by the {Bold:"Lo"}data they &
    handle{Bold:"No"}, not by their function in the program.

    Subroutines, called {Bold:"Lo"}Methods{Bold:"No"} are even &
    named by the data they act on.  The are grouped by the data &
    type, called the {Bold:"Lo"}Class{Bold:"No"}.  The Class and Methods &
    together form a unit called an {Bold:"Lo"}Object{Bold:"No"}, hence &
    the name Object Oriented Programming.

    When creating an O-O program, concise and self-sufficient &
    subroutines are the mark of quality.  If you move an Object &
    to another program, you should not have to make any changes &
    for the subroutines to work properly, even in the new environment.
  Return (Tut:Ret)

Intro:OOP5
  Win:Add ("Learning OOP", 0, 0, 20, 64, Here)
    Button:"  Done  ", Row:18 Col:26, Action:"Return Ok"
    You can use OOP technique with any language, including &
    assembly language.  The technique is in your mind, and in &
    the way you program, not in the language.

    OOP languages are important because they encourage (and coerce) &
    you to use the proper technique.  Most OOP languages also support &
    {Bold:"Lo"}inheritance{Bold:"No"} and {Bold:"Lo"}polymorphism{Bold:"No"} &
    that make code re-use much easier.  These are the icing on the &
    OOP cake, allowing you to easily share like code between Objects.

    The JORF language is the simplest OOP language in data typing and &
    method declaration.  This simplicity is tied to a sophisticated &
    screen and data base management system.

    While no language is easy, JORF is among the easiest to &
    learn of all Object Oriented Programming languages, and &
    {Bold:"Lo"}it is the only one named after a goat{Bold:"No"}!
  Return (Tut:Ret)

Intro:Poly1
  Win:Add ("Polymorphism", 4, 0, 17, 68, Here)
    Button:" More . . . ", Row:15, Col:26, Action:"Intro:Poly2"
    In OOP, it is common for methods of different classes to have &
    the same name, like the {Bold:"Lo"}Address:Print{Bold:"No"} &
    and {Bold:"lo"}Customer:Print{Bold:"No"} methods.

    Each variable (officially called an &
    {Bold:"Lo"}Instance{Bold:"No"}) also belongs to a class.  So when &
    you have a variable {Bold:"Lo"}X{Bold:"No"} or {Bold:"Lo"}Y{Bold:"No"} &
    the method that is called depends on the class of the variable.
    {Bold:"Lo"}
        New Customer:X Address:Y    | Creates variables X and Y
        Print X                     | Calls Customer:Print
        Print Y                     | Calls Address:Print
    {Bold:"No"}
    The system of using methods with the same name, and choosing &
    the appropriate method based on class is called &
    {Bold:"Lo"}Polymorphism{Bold:"No"}. (Another kickback.)
  Return (Tut:Ret)

Intro:Poly2
  Win:Add ("Polymorphism", 6, 4, 15, 74, Here)
    Button:" More . . . ", Row:13, Col:26, Action:"Intro:Poly3"
    Legitimate uses for Polymorphism are rare.  Generally when you &
    call a method, you are calling a specific method.  In JORF, you &
    make the call specific by declaring both the class and name of &
    the method:
    {Bold:"Lo"}
        New Customer:X   | Create variable X, belongs to class Customer
        Print X          | A polymorphic call to Customer:Print
        Address:Print X  | A specific call to Address:Print
    {Bold:"No"}
    In JORF, this is called {Bold:"Lo"}Casting{Bold:"No"} the method &
    name.  In C++ and OOP Pascal, this is done by creating &
    {Bold:"Lo"}Static{Bold:"No"} methods.  Specific calls run faster &
    because the interpreter does not have to obtain the class of the variable, &
    and does not have to search the parent hierarchy.
  Return (Tut:Ret)

Intro:Poly3
  Win:Add ("Polymorphism", 8, 11, 10, 58, Here)
    Button:" Done ", Row:9, Col:24, Action:"Return Ok"
    Although legitimate uses of Polymorphism are rare, when they are &
    necessary nothing else will do.

    The greatest ability of OOP &
    languages is to have methods that can manipulate data without &
    knowing specifically what the data is.  By using polymorphism &
    these "data manager" methods are far more efficient than &
    methods that are duplicated for every data type.
  Return (Tut:Ret)

Intro:Sum
  Win:Add "OOP Summary", 8, 8, 16, 68, Here
    Button:"  Ok  ", Row:14, Col:30, Action:"Return Ok"
     Object Oriented Programming involves four &
    specific features; Classes, Encapsulation, &
    Inheritance and Polymorphism.

     {Bold:"Lo"}Classes{Bold:"No"} are Do-it-yourself Data Types

     {Bold:"Lo"}Encapsulation{Bold:"No"} means that Classes and &
    Methods are packaged together &
    into Objects.

     {Bold:"Lo"}Inheritance{Bold:"No"} saves time when a class can &
    share methods from a parent class.

     {Bold:"Lo"}Polymorphism{Bold:"No"} means that method names are &
    reused many times, and the appropriate method &
    is chosen according to class.
  Return (Tut:Ret)

Mantra:Do (Level)
  New (Row, Col)
  Row = Num:Rand (1, 20)
  Col = Num:Rand (1, 70)
  Win:Add ("OM", Row, Col, 0, 0, Level)
    Am I a butterfly that
    dreams I am a computer?

    Or am I a computer that
    dreams I am a Butterfly?

Mantra:Else
  Return (Ok)

Mantra:Start
  New (Counter)
  Event:Add ("Mantra", "Key", Here)
  While (Ok)
    While (Counter < 40)
      Mantra:Do (Here)
      ++Counter
      If (Kbd:Hit)
        Break
    While (Counter > 0)
      Win:Del
      --Counter
      If (Kbd:Hit)
        Break
    If (Kbd:Hit)
      Break
  Kbd:Get
  Return

Math:Assignment
  Win:Add ("Assignment", 6, 0, 21, 56, Here)
    Button:" More . . . ", Row:19, Col:20, Action:"Math:Parens"
    Values are assigned using single equals sign.

          {Bold:"Lo"}A=B     | Sets A to the value of B{Bold:"No"}

    Assignment is by value for single items, and by reference &
    for structures.  The class is also assigned.
    {Bold:"Lo"}
      New A, B, Rule:R
      A = "Hi"        | Value of A is now "Hi".
      B = "Bye"       | Value of B is now "Bye".
      A = B           | Value of A changed to "Bye".
      A = Null        | Value of A is Null, B still "Bye".
      R->Ptr = "Hi"   | Rule R's Pointer is now "Hi".
      A = R           | A is now class Rule, A->Ptr is "Hi".
      R->Ptr Null     | A->Ptr is also Null.
    {Bold:"No"}
    Parameter passing is handled the same way; elements are &
    passed by value, and structures are passed by reference.
  Return (Tut:Ret)

Math:Cont1
  Win:Add ("JORF Control Functions", 8, 8, 13, 68, Here)
    Button:" More . . . ", Row:11, Col:26, Action:"Math:Cont2"
    Control functions are functions whose job is to change the &
    program flow.  They include the {Bold:"Lo"}If/Else{Bold:"No"}, &
    {Bold:"Lo"}While/Break/Continue{Bold:"No"} and &
    {Bold:"Lo"}Switch/Case/Else{Bold:"No"}.  These &
    statements are used to create &
    branching paths or loop structures.

    In JORF, control functions are implemented as library &
    functions. From the JORF Language, they are used just like &
    keywords.  But programmers who purchase the JORF Developer's Kit &
    can modify and add new control functions.  This gives &
    low level functionality to a very high level language.
  Return (Tut:Ret)

Math:Cont2
  Win:Add ("If/Else", 4, 4, 18, 70, Here)
    Button:" More . . . ", Row:16, Col:28, Action:"Math:Cont3"
    The {Bold:"Lo"}If{Bold:"No"} function tests the             The test does not need to
    value of the following item,          be a logical test:
    and if that item is true it
    executes the indented                   {Bold:"Lo"}If (Rule->Fnd){Bold:"No"}
    statements.  If it is false,              {Bold:"Lo"}Return Rule{Bold:"No"}
    it looks for an else command
    on the same indentation level.        This statement is true if
    If the {Bold:"Lo"}else{Bold:"No"} is Found then             {Bold:"Lo"}Rule->Fnd{Bold:"No"} (The Fnd
    the indented section following        element of Structure Rule)
    is executed.                          has any value at all.
                  {Bold:"Lo"}If (A=2){Bold:"No"}                The test may be complex:{Bold:"Lo"}
                    B=4
                  Else                      If (A=1 && (B+4)=2)
                    B=6                       ++B   {Bold:"No"}
    The {Bold:"Lo"}If{Bold:"No"} test has to be enclosed in parentheses.
  Return (Tut:Ret)

Math:Cont3
  Win:Add ("While/Break/Continue", 0, 0, 21, 78, Here)
    Button:" More . . . ", Row:19, Col:32, Action:"Math:Cont4"
    The {Bold:"Lo"}While{Bold:"No"} statement creates a loop. &
    This loop is repeated as long as the condition of the While statement is &
    not Null.  A {Bold:"Lo"}Break{Bold:"No"} is used &
    to break out of the loop even if the condition &
    is still true.  A {Bold:"Lo"}Continue{Bold:"No"} is &
    used to shortcut the loop, restarting &
    the next iteration immediately.
    {Bold:"Lo"}
          Counter=0                       | Initialize Counter
          While (++Counter <= 5)          | Increment Counter
            Rule:Find (Rule)              | Find a next rule
            If (Rule->Fnd=Null)           | If sequence is ended
              Break                       |   break out of loop
            If (Rule->Ptr=Null)           | If condition is null
              Continue                    | Skip rest of loop
            P=P+"-"+Rule->Ptr             | Add Condition
          Str:PutLine (P)                 | Show result {Bold:"No"}

    The {Bold:"Lo"}Break{Bold:"No"} is used to exit the loop before &
    the condition is false.

    The {Bold:"Lo"}Continue{Bold:"No"} command forces the loop to skip &
    back to the the {Bold:"Lo"}While{Bold:"No"} statement.
  Return (Tut:Ret)

Math:Cont4
  Win:Add ("Switch/Case/Else", 0, 0, 20, 76, Here)
    Button:" More . . . ", Row:18, Col:28, Action:"Math:Cont5"
    The {Bold:"Lo"}Switch{Bold:"No"} command is always a shortcut for &
    repeated {Bold:"Lo"}If/Else{Bold:"No"} commands. &
    It tests a condition, and executes a section indicated by that test.

    For example:                          Is Replaced By
    {Bold:"Lo"}
        If (A=2)                           Switch (A)
          B=A+C                              Case 2
        Else                                   B=A+C
          If (A=3)                           Case 3
            B=A+D                              B=A+D
          Else                               Case 4
            If (A=4)                           B=A+E
              B=A+E                          Else
            Else                               B=A
              B=A
    {Bold:"No"}
    In this case, the Switch command is much neater and easier to use.
  Return (Tut:Ret)

Math:Cont5
  Win:Add ("Switch/Case/Else (Continued)", 0, 0, 20, 76, Here)
    Button:" More . . . ", Row:18, Col:30, Action:"Math:Lib1"
    The {Bold:"Lo"}Case{Bold:"No"} clause test a value and      The Switch statement may not have
    will execute an indented section      a value, in which case the
    if the value matches.  Case           {Bold:"Lo"}Case{Bold:"No"} Statements are evaluated.
    commands may be stacked:
    {Bold:"Lo"}
      Switch (Key)                         Switch
        Case 'a'                             Case (Key>='a' && Key<='Z')
        Case 'A'                             Case (Key>='A' && Key<='Z')
          Str:PutLine ('Key is A')             Str:PutLine ('Key is a Letter')
        Case 'b'                             Case (Key>='0' && Key<='9')
        Case 'B'                               Str:PutLine ('Key is a Number')
          Str:PutLine ('Key is B')           Else
        Else                                   Str:PutLine ('Key is Something Else')
          Str:PutLine ('Key is not A or B')
    {Bold:"No"}
    The JORF Switch command is very powerful and useful.  Use it whenever
    you can to replace multiple {Bold:"Lo"}If{Bold:"No"} statements.
  Return (Tut:Ret)

Math:Lib1
  Win:Add ("JORF Library Functions", 0, 0, 16, 68, Here)
    Button:" More . . . ", Row:14, Col:24, Action:"Math:Lib2"
    If objects pass messages to objects ad infinitem, nothing would get &
    done.  At some point in time, an object must pass a message to &
    someone who can do something.  In the case of JORF, this is the &
    JORF Runtime program JORF.EXE which contains some handy &
    Library Functions.

    These functions are implemented in C code and source code for them &
    is included in The JORF Developer's Kit. This library may be &
    changed and extended to suit the needs of various developers.

    The basic library has a minimum of commands &
    that give a maximum amount of access to the system.  However, there &
    is a lot to do with a computer and there are more than eighty &
    library functions.
  Return (Tut:Ret)

Math:Lib2
  Win:Add ("Some Window Functions", 8, 0, 18, 65, Here)
    Button:" More . . . ", Row:16, Col:26, Action:"Math:Lib3"
    Here are some examples of JORF Library functions.  The complete &
    list is documented in {Bold:"Lo"}F1{Bold:"No"} help system.  &
    Hit {Bold:"Lo"}F1{Bold:"No"} now to take a look!
    {Bold:"Lo"}
         Win:Add (Win:Ptr)  | Adds a new window
    {Bold:"No"}
    Win:Ptr must contain Row, Col, Title, Background, &
    FLRCO, Magic, Text, and more.  These values may be null, but &
    they must be available.
    {Bold:"Lo"}
         Win:Del           | Deletes top window
         Win:Attr  (Mode)  | Changes current text color
         Win:FLRCO (Mode)  | Changes wrap mode.
    {Bold:"No"}
    FLRCO stands for "Full", "Left", "Right", "Center", and "Off". &
    These are the wrap modes used for text in a window.
  Return (Tut:Ret)

Math:Lib3
  Win:Add ("More Window Functions", 9, 10, 15, 64, Here)
    Button:" More . . . ", Row:13, Col:26, Action:"Math:Lib4"
    More window functions...
    {Bold:"Lo"}
    Move:To (Row, Col)   | Moves Cursor to Row and Col
    Move:By (Row, Col)   | Moves Cursor by relative Row and Col
    Kbd:Get (Size)       | Gets key, Cursor Size (Off,Little,Big)
    Kbd:Hit              | Returns true if key has been hit
    Char:Ins (Count)     | Insert Count characters in a text window
    Char:Del (Count)     | Delete Count characters in a text window
    Char:Get             | Get a character displayed in the window
    Char:Put             | Put a character to the window
    Line:Ins (Count)     | Insert Count lines in a text window
    Line:Del (Count)     | Delete Count lines in a text window
  Return (Tut:Ret)

Math:Lib4
  Win:Add ("Text and Word Functions", 0, 0, 20, 68, Here)
    Button:" More . . . ", Row:18, Col:26, Action:"Math:LibSum"
    Text commands operate on multi-lined text.  If something else is used, &
    it is treated as text with only one line.
    {Bold:"Lo"}
      Text:Top  (Text)    | Returns Top line of text
      Text:Bot  (Text)    | Returns Last Line
      Text:Next (Text)    | Returns Next line of text
      Text:Prev (Text)    | Returns Previous line of text
      Text:Wid  (Text)    | Returns Wid of widest line
    {Bold:"No"}
    Word commands operate on a lines of text, and also &
    on structures, including the program stack and class &
    definitions.  If something else &
    is used it is treated as a line with one word.
    {Bold:"Lo"}
      Word:At     (Line, Pos)  | Returns word at position
      Word:AtPut  (Line, Pos)  | Changes word at position
      Class:At    (Line, Pos)  | Returns class at position
      Class:AtPut (Line, Pos)  | Changes class at position
  Return (Tut:Ret)

Math:LibSum
  Win:Add ("Library Function Summary", 0, 0, 21, 64, Here)
    Button:" Done ", Row:19, Col:26, Action:"Return Ok"
     JORF Functions include Control Functions such as {Bold:"Lo"}If/Else{Bold:"No"} &
    as well as Library Functions like {Bold:"Lo"}Win:Add{Bold:"No"}.

     Control Functions are not Keywords.  The are implemented &
    as standard library functions that may be augmented and changed &
    using The JORF Developer's Kit.

     {Bold:"Lo"}If/Else{Bold:"No"} is used to test a condition and execute indented &
    code sections based on that test.  {Bold:"Lo"}Else{Bold:"No"} is optional.

     {Bold:"Lo"}While/Break/Continue{Bold:"No"} is used to create a loop. &
    The {Bold:"Lo"}Break{Bold:"No"} command &
    can be used to exit that loop at any time. &
    The {Bold:"lo"}Continue{Bold:"No"} command is &
    used skip code sections by immediately jumping back to the &
    {Bold:"Lo"}While{Bold:"No"} statement.

     {Bold:"Lo"}Switch/Case/Else{Bold:"No"} is used to simplify &
    repeated {Bold:"Lo"}If/Else{Bold:"No"} commands. &
    It may be used to test a value, or a variety of values, and perform &
    relevant indented code sections.

  Return (Tut:Ret)

Math:Order
  Win:Add ("Order of Operations", 4, 2, 16, 68, Here)
    Button:" More . . . ", Row:14, Col:26, Action:"Math:Assignment"
    These are the basic math characters listed in the order that they are &
    evaluated:
    {Bold:"Lo"}
      ->                    Structure Element Ptr
      []                    Array reference
      - ~ ++ --             Negation, Complement, Increment, Decrement
      * / %                 Multiplication, Division, Modulus
      + -                   Addition and Subtraction
      = == != <> > < >= <=  Equality, Inequality and Comparison
      & ? ^                 Bitwise And, Or and Xor
      && ?? And Or          Logical And, Or
      =                     Assignment of value
  Return (Tut:Ret)

Math:Parens
  Win:Add ("Parentheses", 0, 0, 14, 60, Here)
    Prompt:"Algebra II", Row:6 Col:18 Action:"Math:Remark"
    Button:"  Done  ", Row:12, Col:20, Action:"Return Ok"
    Parentheses are a part of the program flow system in JORF, not the &
    mathematics system.  They may be used to change the order of &
    operations in math statements.
               {Bold:"Lo"}5 * 3 + 4           | 19{Bold:"No"}
               {Bold:"Lo"}5 * ( 3 + 4 )       | 35{Bold:"No"}
    I never finished Algebra II &
    and I get pretty confused when I have to &
    remember the order of operations.  Math is &
    much more clear and robust if you use extra &
    parentheses to show the exact order the &
    statement is to be evaluated
    {Bold:"Lo"}Don't do  A*B+4/C      | This is not very clear or robust{Bold:"No"}
    {Bold:"Lo"}Instead   (A*B)+(4/C)  | Same operation, Much clearer    {Bold:"No"}
  Return (Tut:Ret)

Math:Remark
  Win:Add (Null 0,0,10,30, Here)
    Button:"  Ok  " Row:8, Col:10, Action:"Return Ok"
    Lots of people think you &
    need to know math to &
    be a great programmer. &
    This is not true.

    It is creativity that you &
    need; programming is an art, &
    not an equation.
  Return (Tut:Ret)

Math:Start
  Win:Add ("JORF Mathematics", 0, 0, 16, 64, Here)
    Button:" More . . . ", Row:14, Col:24, Action:"Math:Order"
    In most OOP languages, math operations are implemented as methods. &
    Although this allows a few interesting benefits, there &
    are many penalties.

    Instead, JORF uses an embedded math system. &
    Math statements are automatically resolved BEFORE any accompanying &
    methods are called.  Math statements operate specifically on &
    objects with numeric or string values.

    JORF math syntax and order of operations is taken largely from &
    the C language with one notable exception.  Since JORF uses the &
    pipe ({Bold:"Lo"}|{Bold:"No"}) symbol for comments, &
    the question mark ({Bold:"Lo"}?{Bold:"No"}) is the OR operator.
  Return (Tut:Ret)

Methods:Constants
  Win:Add ("Quotes and Constants", 0, 0, 20, 64, Here)
    Button:" More . . . ", Row:18, Col:28, Action:"Methods:Text"
    String constants may be enclosed by single or double quotes.
    {Bold:"Lo"}
            "A Constant"
            'Another Constant'
            "A 'Quoted' Constant"
            'A constant with a "quote"'
    {Bold:"No"}
    Constants are assigned using the equals sign:
    {Bold:"Lo"}
            New String:S          | A String called "S"
            S="This is a String." | S has value "This is a String."
    {Bold:"No"}
    A quoted constant that is an integer value is a number.
    {Bold:"Lo"}
           The integer value of "33" is 33.
           The integer value of "555-1212" is 555.
    {Bold:"No"}
  Return (Tut:Ret)

Methods:Flow
  Win:Add ("Indentation and Program Flow", 0, 0, 20, 72, Here)
    Button:" More . . . ", Row:18, Col:28, Action:"Methods:New"
    Indented lines "Belong" to the unindented line above.  This system &
    eliminates the need for ENDIF or bracket punctuation. &
    This method fragment demonstrates indentation.
    {Bold:"Lo"}
        Counter=1                 | 1. Initialize Counter
        While (Counter<=Position) | 2. While less than Position
          Rule:Find Rule          | 3. Next rule in sequence
          If (Rule->Fnd=False)    | 4. If not Fnd - done
            Return 'Escape'       | 5.   return 'Escape'.
          ++Counter               | 6. Increment Counter
        Return Rule->Ptr          | 7. Done - Return Ptr
    {Bold:"No"}
    Lines 3 through 6 execute repeatedly as long as the &
    value of Counter is less than or equal to Position (Line 2).
    Line 5 executes only if line 4 is True.
    Line 7 executes when Counter is greater than Position (Line 2) &
    which completes the While loop.
  Return (Tut:Ret)

Methods:Foo
  Script:Add ("Script:ThreeFoo")
  If (Kbd:Got != 'Esc_Key')
    ThreeFoo:Start
  Methods:Flow
  Return (Tut:Ret)

Methods:New
  Win:Add ("Creating New Variables", 0, 0, 18, 72, Here)
    Button:" More . . . ", Row:16, Col:28, Action:"Methods:Constants"
    New Variables can be created at the start of any method. Each instance &
    is comprised of a class and a value, referenced by a name.

    The library function {Bold:"Lo"}New{Bold:"No"} is used to create variables.  It may &
    be followed by any number of variables to be created.  Each variable &
    has a class and a name.  If class is not specified, the variable &
    will be a member of class {Bold:"Lo"}Jorf{Bold:"No"}.
    {Bold:"Lo"}
       New String:S     | Creates an instance of String called "S".
       New Rule:Rule    | An instance of class Rule called "Rule".
       New Counter      | An instance of class Jorf called "Counter".
       New Text:T Rule:NewRule | Two new instances, "T" and "NewRule".
    {Bold:"No"}
    All values are set to Null (which is equivalent to integer 0). &
    All elements of structures are all set to Null.
  Return (Tut:Ret)

Methods:Start
  Win:Add ("Method Definitions", 0, 0, 14, 64, Here)
    Button:" More . . . ", Row:12, Col:24, Action:"Methods:Foo"
    Methods are procedural routines like a BASIC Subroutine &
    or a C Function.  Good methods are between one and twenty lines &
    long.  Methods longer than twenty lines can be divided to &
    make them easier to read and understand.

    Each Method must belong to a class.  If no class is declared, then &
    the method is assumed to belong to class {Bold:"Lo"}Jorf{Bold:"No"}.

    Methods can have one or more parameters.  The first parameter &
    is expected to be the same class as the method.  Other &
    parameters may be from any class.
  Return (Tut:Ret)

Methods:Sum
  Win:Add ("Method Definition Summary", 0, 0, 20, 62, Here)
    Button:"  Done  ", Row:18, Col:26, Action:"Return Ok"
     {Bold:"Lo"}Methods{Bold:"No"} are procedural routines that &
    must belong to a class.

     The first line of a method specifies its class, name and &
    any parameters passed to the method.

     The program flow in the method is dictated by indentation.

     New variables are created in the top of the method using the &
    {Bold:"Lo"}New{Bold:"No"} command.  Each variable has a name &
    and belongs to a class.  All new variables are set to Null (Zero).

     Single or double quotes are used for constant strings.  A single &
    quoted string may contain double quotes and vice versa.  Quoted numbers &
    are treated as strings.

     An indented block of text can be passed as a parameter to a method.
  Return (Tut:Ret)

Methods:Text
  Win:Add ("Blocks of Text as a Parameter", 0, 0, 20, 54, Here)
    Button:" More . . . ", Row:18, Col:20, Action:"Methods:Sum"
    Indented blocks of text may be passed as a parameter &
    to a method.  Whenever a method is called &
    with exactly &
    one parameter missing, the following line &
    is passed {Bold:"Lo"}IF IT IS INDENTED{Bold:"No"}.  &
    This is a &
    convenient way to create multiple line &
    text within program code.
    {Bold:"Lo"}
           Mantra:Box ('MU')
             It could be Franky it
             could be Franky it could
             be very fresh and clean.
           ++WindowCounter
    {Bold:"No"}
    The method {Bold:"Lo"}Mantra:Box{Bold:"No"} is called &
    with two parameters, the title 'MU' and the text that &
    is indented.

    (The text above is from Phillip Glass' first opera, &
    "Einstein on the Beach".)
  Return (Tut:Ret)

Put:DataEntry
  Script:LetterScript
  JORFNote:Start
  Put:DataSum
  Return (Tut:Ret)

Put:DataSum
  Win:Add ("Data Display and Entry", 0, 0, 15, 56, Here)
    Button:"  Done  ", Row:13, Col:24, Action:"Return OK"
     Input items are created using special key words.  You &
    can enter structure elements and array elements as easily &
    as simple variables.

     The {Bold:"Lo"}Time:Get{Bold:"No"} function will &
    get the current date and time &
    and can format this for International as well as U.S. standards.

     Input text is just as easy as input strings.  Just specify &
    a length and a text entry field is created.  Text is a basic &
    data type in JORF, and can be handled almost as easily as the &
    string data type.
  Return (Tut:Ret)

Put:Kbd
  Win:Add ("Keyboard Entry", 0, 0, 15, 56, Here)
    Button:" More . . . ", Row:13, Col:20, Action:"Put:Keystrokes"
    Keyboard entry is handled using one of three commands. &
    {Bold:"Lo"}Win:Pause{Bold:"No"} takes &
    a parameter for the number of hundredths of seconds to pause, and &
    will end and return a keystroke if the operator hits a key.

    The {Bold:"Lo"}Kbd:Hit{Bold:"No"} returns {Bold:"Lo"}True{Bold:"No"} &
    if the operator has hit a key, and the {Bold:"Lo"}Kbd:Get{Bold:"No"} &
    command returns a keystroke.

    JORF returns keystrokes as "Strings".  When you enter an "A", JORF &
    returns a string, five characters long, with the value "A_Key".  JORF does &
    not return 41, the ASCII value of "A", like most languages.
  Return (Tut:Ret)

Put:Keystrokes
  Win:Add ("Testing Keystrokes", 7, 6, 16, 68, Here)
    Button:" More . . . ", Row:14, Col:26, Action:"Put:Mantra"
    To test the keys, you test the string.  For instance, if &
    you want to test to see if the operator hit a normal letter &
    or number key, test the second through fifth characters to &
    see if they are {Bold:"Lo"}"_Key"{Bold:"No"}.
    {Bold:"Lo"}
               New Key
               Key=Kbd:Get
               If ((Str:At Key 2 4)="_Key")
                 Str:Put "It Was the {"{"}String:At Key 1 1{"}"} Key"
    {Bold:"No"}
    To get the value of a key, use the {Bold:"Lo"}To:ASCII{Bold:"No"} &
    function.  It returns the ASCII Decimal value of the &
    first character of a string.
    {Bold:"Lo"}
                     Value=To:ASCII Key
    {Bold:"No"}
  Return (Tut:Ret)

Put:Mantra
  Win:Add ("The Mantra Program", 0, 0, 17, 68, Here)
    Button:" More . . . ", Row:15, Col:26, Action:"Put:MantraScript"
    This next sample programs will display some windows &
    and get some keyboard entry.  One of my pet projects &
    is making computers say Mantras, and idea proposed by &
    Edsger Dijkstra many years ago.

    Tibetan Buddhists use mechanical prayer &
    wheels to pray more quickly and efficiently. &
    Japanese Buddhists of the Amida sect believe &
    that anyone who says "Amida" with pure &
    heart will go to heaven, so they say it as many times as possible &
    in hopes of forgetting and saying it with pure heart once in their lives.

    This Mantra system combines these ideas just in case they &
    may be right.  Who can have purer heart than a &
    computer?  If you run a Mantra system often, perhaps &
    your computer will also forget and therefore insure your place in heaven.
  Return (Tut:Ret)

Put:MantraScript
  Script:MantraScript
  Jorf:Flush
  Mantra:Start
  Put:Sum
  Return (Tut:Ret)

Put:Real
  Win:Add ("Getting Real Information", 0, 0, 19, 70, Here)
    Button:" More . . . ", Row:17, Col:26, Action:"Put:DataEntry"
    JORF Version 2.0 introduces a new system for creating &
    data entry windows.  Certain keywords are used in the &
    window definition let you set up special scree for creating &
    data entry windows.  Certain keywords are used in the &
    window definition let you set up special screen processing. &
    Keywords are followed by the prompt for that item.
    {Bold:"Lo"}
          Radio:"&Item"          - A Radio Button
          ChBox:"&Item"          - A Check Box
          Input:"&Prompt"        - An Input
          Text:"&Prompt"         - An Input text
          Group:"&Prompt"        - A Group Box
          Prompt:"&Prompt"       - A Hypertext Prompt
          String:"&Item"         - Plain text, no entry.
          Button:"&Item"         - A Push Button
    {Bold:"No"}
    Data entry is done automatically when the window is displayed.
  Return (Tut:Ret)

Put:Start
  Win:Add ("Adding Windows", 0, 0, 13, 56, Here)
    Button:" More . . . ", Row:11, Col:20, Action:"Put:Kbd"
    Windows in JORF are more limited than you usually see &
    in MS-Windows programs.  The primary goal is to &
    make it easy to create applications.  The JORF Language &
    does not support multiple fonts, so text is always the &
    same size in JORF.  You cannot have multiple active windows, &
    only the top window is active, so you don't need to refer &
    to window "Handles" with every command.

    JORF Windows scroll automatically, and there is automatic &
    justification for text displayed in a window.
  Return (Tut:Ret)

Put:Sum
  Win:Add ("Data Display and Entry", 0, 0, 14, 56, Here)
    Button:"  Done  ", Row:12, Col:24, Action:"Return OK"
     In JORF, only the top Window is active.  JORF Windows are more &
    limited and easier to program than most MS-Windows tools.

     JORF Keyboard commands get keys as Strings.  The &
    {Bold:"Lo"}ASCII{Bold:"No"} command can be used to convert these &
    strings to numeric values.

     There is a limit of 512 windows visible at one time.
  Return (Tut:Ret)

Quick:Demo1
  Script:Add ("Script:Quick2")
  If (Kbd:Got != 'Esc_key')
    Demo:Screen
  Win:Add ("Quick Demo Summary", 0, 0, 10, 50, Here)
    Button:"  Done  ", Row:12, Col:22, Action:"Return Ok"
    How about that?  A data entry screen in JORF uses &
    one line per option or prompt on the screen, and can &
    take more for complicated prompts.

    Each prompt can &
    set a value or run a method.  This system is extremely &
    flexible, supporting on-line equations and instant data &
    verification.
  Return (Tut:Ret)

Quick:Start
  Script:Add ("Script:Quick1")
  If (Kbd:Got != 'Esc_key')
    Demo:Start
  Win:Add ("Real Windows Programming", 0, 0, 16, 68, Here)
    Button:" More . . . ", Row:14, Col:22, Action:"Quick:Demo1"
    The bigger problem is how long it takes to create a MS-Windows &
    style data entry screen.  The "MS-Windows" look (Or "Macintosh look" or &
    "SAA-look" take your pick) is increasingly popular.  Just how to &
    program it differs depending on your tools.

    Microsoft is advocating the Point and Click tool building system &
    of Visual Basic.  I prefer the faster and more primitive method &
    of creating a screen definition.  I also drive a car with a &
    standard transmission.

    How quick can you make a Data Entry Window with Inputs, Check boxes &
    Radio Buttons, and Pull Down Menus?  Try it and see!
  Return (Tut:Ret)

Script:Add Name
  Debugger:EditBox (Null, Here)
  Event:Add ('Script', 'Key', Here)
  Jorf:File ("Tutorial.Jrf", Here)
  Jorf:Do (Name)
  If (Kbd:Got != 'Esc_key')
    Win:Ptr->Text = Text:Top(Win:Ptr->Text)
    Method:Add (Win:Ptr->Text)
  Return

Script:Box Title Len, Wid, Text
  New Row, Col
  Row = Win:Ptr->Row + Win:Ptr->CurRow + 3
  Col = Win:Ptr->Col - 4
  Win:Add (Title, Row, Col, Len, Wid, Here, Text)
  Return

Script:Else Key
  Return Null

Script:Esc_Key
  Return ('Esc_Key')

Script:Hello
  Script:Say ("Hello:Start")
  Script:Box ("Method Name Declaration", 12, 50)
    Button:" More . . . ", Row:10, Col:20, Action:"Return Ok"
    This line declares a method that &
    belongs to the class {Bold:"Lo"}Hello{Bold:"No"}.  It &
    is called {Bold:"Lo"}Start{Bold:"No"}.

    This method is being written by the JORF system &
    just as if you were typing it in.  When finished, the &
    system will run the program.

    An interesting features of JORF is the ability to &
    create and change methods on-the-fly.
  If (Kbd:Got='Esc_Key')
    Return
  Script:Say ('  Msg:Add ("Hello", "Ok")')
  Script:Say ('    Welcome to the Wonderful World of JORF!')
  Script:Box ('Creating a Text Window', 10, 40)
    Button:" More . . . ", Row:8, Col:12, Action:"Return Ok"
    There is a JORF function named &
    {Bold:"Lo"}Msg:Add{Bold:"No"}. This function creates a dialog box &
    exactly big enough to display the indented text.

    The box Title will be "Hello" and type will be an "Ok" box.
  If (Kbd:Got="Esc_Key")
    Return
  Script:Box ('Running Hello from DOS', 13, 50)
    Button:" More . . . ", Row:11, Col:14, Action:"Return Ok"
    The {Bold:"Lo"}Hello{Bold:"No"} program has been included &
    to be run from DOS.  It is in a file called HELLO.J.
    To run it, start JORF using {Bold:"Lo"}Hello{Bold:"No"}.

         C>{Bold:"Lo"}JORF HELLO{Bold:"No"}

    After running this program, you will be put in the &
    JORF debugger.  Interpreted programs will always end in the &
    debugger unless they end with the command {Bold:"Lo"}Jorf:Exit{Bold:"No"}.
  Return (Tut:Ret)

Script:Letter1
  Script:Say ('Class:Address Name Street CityStZip')
  Script:Box ('Address', 12, 56)
    Button:" More . . . ", Row:10, Col:20, Action:"Return Ok"
    Create a class for holding names and addresses.  &
    Although this is sorely lacking in sophistication &
    (No company name or international mailing code) &
    it makes a nice base for our letter.

    You may note that JORF lets you add fields on &
    existing databases with no need to reformat or &
    modify the database.  This is because items are &
    stored by Name reference and not position reference.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:Letter2
  Script:Say ('Class:JORFNote Parent:Address Feeling Thought')
  Script:Box ('The JORFNote Class', 14, 50)
    Button:" More . . . ", Row:12, Col:16, Action:"Return Ok"
    This is a special class for our letter.  It uses the &
    last {Bold:"Lo"}Address{Bold:"No"} class as &
    a parent.  That means that this class inherits the &
    elements {Bold:"Lo"}as if they were declared here{Bold:"No"}.

    Structure elements are referenced using pointers.
    {Bold:"Lo"}
          New (JORFNote:MyLetter)
          MyLetter->Name = "Josephine"
          MyLetter->Feeling = "Dance-a-Dance-a-Dance"
    {Bold:"No"}
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:Letter3
  Script:Put ('JORFNote:Start')
  Script:Box ('No More Cute', 9, 50)
    Button:" More . . . ", Row:7, Col:16, Action:"Return Ok"
    I want to dispel the notion that the script system is &
    slow.  I was just trying to be cute and gentle by &
    using a on-at-a-time character display.

    Now, its time to roll up our sleeves and really get to &
    work.  No more Little-Bo-Peep.  {Bold:"Lo"}Jo Raps!{Bold:"No"}
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Put ('  New (JORFNote:Letter)')
  Script:Put ('  Win:Add ("Letter To The JORF Company" 0,0,5,20, Here)')
  Script:Put ('    Input:"Your Name   ", Field:"Letter->Name"')
  Script:Put ('    Input:"Your Street ", FIeld:"Letter->Street"')
  Script:Put ('    Input:"City/St/Zip ", Field:"Letter->CityStZip"')
  Script:Box ('Entering Structure Elements', 7, 50)
    Button:" More . . . ", Row:5, Col:16, Action:"Return Ok"
    And input window to gather information.  In the
    {Bold:"Lo"}Foo{Bold:"No"} program we were inputting a &
    {Bold:"Lo"}New{Bold:"No"} variable.  Here we are &
    inputting structure elements.  The process is the same.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Put
  Script:Put ('    String:"How does JORF make you feel?  (Excited, Bored, Confused...)"')
  Script:Put ('    Input:"Your Feeling ", Wid:20, Field:"Letter->Feeling"')
  Script:Put
  Script:Put ('    String:"What do you think of JORF? (Really Neat, Too Complicated...)"')
  Script:Put ('    Input:"", Wid:60 Len:6, Field:"Letter->Thought"')
  Script:Put ('    String:"           (Press Escape to Finish Text Entry)"')
  Script:Put ('  JORFNote:Say (Letter)')
  Script:Put ('  Return')
  Script:Put
  Script:Put
  Script:Box ('Text Entry', 4, 48)
    Button:" More . . . ", Row:3, Col:14, Action:"Return Ok"
    You can enter text just by specifying the length as well as &
    the width of the input.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:Letter4
  Script:Put ('JORFNote:Say (Letter)')
  Script:Put ('  Time:Get (Mem:Ptr)')
  Script:Put ('  Msg:Add ("My Letter", "Ok")')
  Script:Put ('    {Mem:Ptr->SDate}')
  Script:Box ('The Date', 10, 50)
    Button:" More . . . ", Row:8, Col:18, Action:"Return Ok"
    The {Bold:"Lo"}Time:Get{Bold:"No"} function will fill &
    a structure with the current date and time.  The Mem:Ptr &
    is a global structure used for "Junk" variables.

    By getting the time, we get {Bold:"Lo"}SDate{Bold:"No"} &
    that will give us a string with today's date.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Put
  Script:Put ('    Dear Wayland,')
  Script:Put
  Script:Put ('    I just had to write to you, because I am &')
  Script:Put ('    so {Letter->Feeling} by JORF. In Fact, &')
  Script:Put ('    {Letter->Thought}')
  Script:Put
  Script:Put ('    Yours Truly,')
  Script:Put
  Script:Put ('    {Letter->Name}')
  Script:Put ('    {Letter->Street}')
  Script:Put ('    {Letter->CityStZip}')
  Script:Put ('  Return')
  Script:Put
  Script:Put
  Script:Box ('Our Letter', 5, 68)
    Button:" More . . . ", Row:3, Col:24, Action:"Return Ok"
    So I know this is stupid.  You try writing a hundred help &
    screens and a half dozen program scripts!  You'll get pretty &
    rummy too!
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:LetterScript
  New Counter
  Jorf:Flush
  While (Counter < 4)
    Switch Counter
      Case 0
        Script:Add ("Script:Letter1")
      Case 1
        Script:Add ("Script:Letter2")
      Case 2
        Script:Add ("Script:Letter3")
      Case 3
        Script:Add ("Script:Letter4")
    If (Kbd:Got='Esc_Key')
      Break
    Else
      ++Counter
  Return (Tut:Ret)

Script:MantraDo
  Script:Say ('Mantra:Do (Level)')
  Script:Box ('Do a Mantra', 11, 58)
    Button:" More . . . ", Row:9, Col:20, Action:"Return Ok"
    A Method called {Bold:"Lo"}Do{Bold:"No"} that belongs &
    to the {Bold:"Lo"}Mantra{Bold:"No"} class.

    The level is the {Bold:"Lo"}Here{Bold:"No"} from the &
    calling function.  We will pass this to the final &
    window function, so the interpreter knows when the &
    window can be deleted.

    Windows are deleted when the method that creates them &
    has been completed.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  New (Row, Col)')
  Script:Say ('  Row = Num:Rand (1, 20)')
  Script:Say ('  Col = Num:Rand (1, 70)')
  Script:Box ('Randomizing Row and Column', 6, 40)
    Button:" More . . . ", Row:4, Col:12, Action:"Return Ok"
    Create a random Row and Column.  The row must be &
    between 1 and 20, and the column between 1 and 70.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  Win:Add ("OM", Row, Col, 0, 0, Level)')
  Script:Box ('Calling Win:Add', 10, 40)
    Button:" More . . . ", Row:8, Col:12, Action:"Return Ok"
    Call the JORF Win:Add Function.  Title is "OM". &
    Row and Col we just set.

    Setting Length and &
    width to zero tells the system to make a window &
    just the right size.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    Am I a butterfly that')
  Script:Say ('    dreams I am a computer?')
  Script:Say
  Script:Say ('    Or am I a computer that')
  Script:Say ('    dreams I am a Butterfly?')
  Script:Box ('Just some Text', 8, 50)
    Button:" More . . . ", Row:6, Col:16, Action:"Return Ok"
    Indented Text can be passed to methods without &
    even quoting it.  This text is taken loosely   &
    from the writings of Chuang-Tsu, a Chinese     &
    Taoist philosopher who studied recursion and &
    self-reference.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:MantraElse
  Script:Say ('Mantra:Else')
  Script:Say ('  Return (Ok)')
  Script:Box ('A key event', 10, 54)
    Button:"  More . . . ", Row:8, Col:20, Action:"Return Ok"
    This method is called when we hit a key, and when no &
    specific method was created for that key.  If &
    the {Bold:"Lo"}Else{Bold:"No"} method returns a value &
    then the Event system is done.  But if it is absent &
    or returns null, then the next event on the stack will &
    be checked.

    In this case, we just return {Bold:"Lo"}Ok{Bold:"No"}.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:MantraScript
  New Counter
  While (Counter < 5)
    Switch Counter
      Case 2
        Script:Add ("Script:MantraElse")
      Case 1
        Script:Add ("Script:MantraDo")
      Case 0
        Script:Add ("Script:MantraStart")
    If (Kbd:Got='Esc_Key')
      break
    Else
      ++Counter
  Return (Tut:Ret)

Script:MantraStart
  Script:Say ('Mantra:Start')
  Script:Box ('The Start of the Program', 5, 40)
    Button:" More . . . ", Row:3, Col:12, Action:"Return Ok"
    A Method called {Bold:"Lo"}Start{Bold:"No"} that belongs &
    to the {Bold:"Lo"}Mantra{Bold:"No"} class.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  New (Counter)')
  Script:Say ('  Event:Add ("Mantra", "Key", Here)')
  Script:Box ('A Mantra key event', 10, 50)
    Button:" More . . . ", Row:8, Col:16, Action:"Return Ok"
    A key event is used to interpret keystrokes.  This &
    key event will channel all keys to the &
    {Bold:"Lo"}Mantra:Else{Bold:"No"} method.

    The {Bold:"Lo"}Here{Bold:"No"} tells the system what &
    method allocated this key entry, so it can be deleted &
    when this method is complete.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  While (Ok)')
  Script:Box ('An Endless Loop', 6, 44)
    Button:" More . . . ", Row:4, Col:16, Action:"Return Ok"
    The {Bold:"Lo"}Ok{Bold:"No"} function always returns 1, &
    so this while loop will go forever.  Later, we will use &
    {Bold:"Lo"}Break{Bold:"No"} to get out of it.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    While (Counter < 40)')
  Script:Say ('      Mantra:Do (Here)')
  Script:Say ('      ++Counter')
  Script:Say ('      If (Kbd:Hit)')
  Script:Say ('        Break')
  Script:Box ('Count up to 40', 4, 54)
    Button:" More . . . ", Row:2, Col:20, Action:"Return Ok"
    This loop counts up to 40, but stops if you hit a key.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    While (Counter > 0)')
  Script:Say ('      Win:Del')
  Script:Say ('      --Counter')
  Script:Say ('      If (Kbd:Hit)')
  Script:Say ('        Break')
  Script:Say ('    If (Kbd:Hit)')
  Script:Say ('      Break')
  Script:Box ('Count back down', 4, 58)
    Button:" More . . . ", Row:2, Col:20, Action:"Return Ok"
    This loop counts down, and also stops if you hit a key.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  Kbd:Get')
  Script:Say ('  Return')
  Script:Say
  Script:Say
  Script:Box ('Grab that key', 5, 58)
    Button:" More . . . ", Row:3, Col:23, Action:"Return Ok"
    We know a key has been hit, so we must take it out &
    of the input stream.  {Bold:"Lo"}Kbd:Get{Bold:"No"} &
    will grab a keystroke.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Script:Page_Up_Key
  Return 'Back'

Script:Put Line
  Win:Ptr->Text=Text:Add (Line, Win:Ptr->Text)
  Str:PutLine (Line)

Script:Quick1
  Script:Say ("Demo:Start")
  Script:Say ('  Msg:Add ("Quick Demonstration", "Ok")')
  Script:Say ('    Sure you can say "Hello World" in one line of')
  Script:Say ('    C code.  But how many punctuation characters')
  Script:Say ('    are required to display a dialog box like this?')
  Script:Box ('Creating a Dialog Box', 4, 56)
    Button:" Press Enter to save and run this new method ", Row:2, Col:2, Action:"Return Ok"
    The JORF Interpreter supports self writing programs!
  If (Kbd:Got="Esc_Key")
    Return
  Return (Tut:Ret)

Script:Quick2
  Script:Say ("Demo:Screen")
  Script:Say ('  New (Rad, Chk, Inp1, Inp2)')
  Script:Say ('  Win:Add ("A Real Screen", 4, 8, 14, 50, Here)')
  Script:Say ('    Menu:"&Help"')
  Script:Say ('      Menu:"&Indented Menu Items"')
  Script:Say ('        Menu:"&Create Sub Menus"')
  Script:Say ('          Menu:"&And Even Deeper"')
  Script:Say ('          Menu:"&Sub Menus"')
  Script:Say ('        Menu:""')
  Script:Say ('        Menu:"(Escape to Exit)"')
  Script:Say ('      Menu:"&Jorf Help           F1" Action:"Hotkey:F1_Key"')
  Script:Say ('      Menu:"&Time and Date  Alt-F10" Action:"HotKey:Alt_F10_Key"')
  Script:Say ('    String:"  Use your Arrow Keys to go up and down.  On"')
  Script:Say ('    String:"  Check Boxes and Radio Buttons, the Enter Key"')
  Script:Say ('    String:"  checks and Space Bar skips.  Be sure to Press"')
  Script:Say ('    String:"  Alt-H to check out the Menus and Submenus!"')
  Script:Say ('    Radio:" Radio &1" Row:6 Col:8')
  Script:Say ('      Check:"Rad==True", Action:"Rad=True"')
  Script:Say ('    Radio:" Radio &2"')
  Script:Say ('      Check:"Rad==False", Action:"Rad=False"')
  Script:Say ('    ChBox:" Check Box &A" Row:6, Col:26')
  Script:Say ('      Check:"Chk==True", Action:"Chk=True"')
  Script:Say ('    ChBox:" Check Box &B"')
  Script:Say ('      Check:"Chk==False", Action:"Chk=False"')
  Script:Say ('    Input:"&Input 1  " Row:9, Col:8 Field:"Inp1"')
  Script:Say ('    Input:"I&nput 2  "              Field:"Inp2"')
  Script:Say ('    Button:"  &Done  "   Row:12, Col:24, Action:"Return '+"'Esc_Key'"+'"')
  Script:Say ('  Return')
  Script:Say
  Script:Say
  Script:Box ('A Real Dialog Box', 4, 56)
    Button:" Press Enter to save and run this new method ", Row:2, Col:2, Action:"Return Ok"
    Pull Down Menus, Radio buttons, Check boxes and Prompts.
  If (Kbd:Got="Esc_Key")
    Return
  Return (Tut:Ret)

Script:Say Line
  Win:Ptr->Text=Text:Add (Line, Win:Ptr->Text)
  Script:SayLineByCharacter (Line)

Script:SayLineByCharacter J
  New I C
  I=1
  While (ok)
    C=Str:At (J, I, 1)
    If (Str:Len (C) < 1)
      Break
    Str:Put (C)
    ++I
    If (C<>" ")
      Win:Pause (2)
  Str:PutLine

Script:ThreeFoo
  Script:Say ('ThreeFoo:Start')
  Script:Say ('  New (Foo, Counter)')
  Script:Box ('New Variables',9, 40)
    Button:" More . . . ", Row:7, Col:12, Action:"Return Ok"
    New Variables are created using the {Bold:"Lo"}New{Bold:"No"} &
    command.  This line creates two new variables of the {Bold:"Lo"}Jorf{Bold:"No"} &
    class called {Bold:"Lo"}Foo{Bold:"No"} and &
    {Bold:"Lo"}Counter{Bold:"No"}.

    All new instances are Null when created.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('  While (Counter < 3)')
  Script:Box ('While', 7, 54)
    Button:" More . . . ", Row:5, Col:18, Action:"Return Ok"
    The {Bold:"Lo"}While{Bold:"No"} command creates a loop.  This &
    loop will check the value of Counter and will execute until   &
    it is 3.  A {Bold:"Lo"}Break{Bold:"No"} command &
    can also end a while loop.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    Win:Add("OUR SECOND PROGRAM")')
  Script:Box ('JORF Methods', 15, 40)
    Button:" More . . . ", Row:13, Col:10, Action:"Return Ok"
    This line calls the {Bold:"Lo"}Win:Add{Bold:"No"} function.  &
    This is the most powerful and complex function in JORF, and &
    is used for all text and input windows.

    The only parameter here is the title.  In version 2.0 of &
    JORF parameters must be enclosed in parentheses.

    This line is indented from the {Bold:"Lo"}While{Bold:"No"} command &
    making it part of the loop.  All indented lines are part of the loop.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('      String:"This entry window repeats three times."')
  Script:Say ('      Input:"Enter Something to Say:", Wid:22, Field:"Foo"')
  Script:Box ('Indented Lines',10, 60)
    Button:" More . . . ", Row:8, Col:24, Action:"Return Ok"
    Indented lines are part of the command above them.  These lines &
    are passed to the {Bold:"Lo"}Win:Add{Bold:"No"} method directly above.
    The two lines are Window Directives.  These look like &
    JORF language commands, but are specific commands to the &
    window.  The {Bold:"Lo"}String{Bold:"No"} command will &
    display a line, and the {Bold:"Lo"}Input{Bold:"No"} &
    command will change the value of {Bold:"Lo"}Foo{Bold:"No"}
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    ++Counter')
  Script:Box ('Incrementing a Counter',5, 34)
    Button:" More . . . ", Row:3, Col:10, Action:"Return Ok"
    The {Bold:"Lo"}++Counter{Bold:"No"} &
    command is just like saying {Bold:"Lo"}Counter=Counter+1{Bold:"No"}.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    Msg:Add')
  Script:Say ('      Counter is: {Counter}')
  Script:Say ('      Foo is: {Foo}')
  Script:Box ('Displaying Data',8, 60)
    Button:" More . . . ", Row:6, Col:28, Action:"Return Ok"
    Create a {Bold:"Lo"}Message{Bold:"No"} Box to display the &
    contents of {Bold:"Lo"}Foo{Bold:"No"}.

    I use {Bold:"Lo"}Msg:Add{Bold:"No"} a &
    lot when writing new routines &
    to display intermediate values.  As you see here, &
    you can display any stack variable just by &
    enclosing it in curly brackets.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")
  Script:Say ('    Foo=Null')
  Script:Say ('  Return')
  Script:Box ('Assignment',6, 64)
    Button:" Press Enter to Run this Method ", Row:4, Col:14, Action:"Return Ok"
    The next line sets the value of {Bold:"Lo"}Foo{Bold:"No"} to &
    {Bold:"Lo"}Null{Bold:"No"}.  If this is not done, the value of &
    {Bold:"Lo"}Foo{Bold:"No"} will show as a default value &
    on the second and third interations of the loop.
  If (Kbd:Got="Esc_Key")
    Return ("Esc_Key")

Tut:Devel
  Win:Add ("The JORF Developer's Kit", 0, 0, 11, 54, Here)
    Button:"  More . . . ", Row:9, Col:20, Action:"Tut:Devel1"
    The JORF Developer's Kit has been a vapor product since &
    early 1991.  It stands to reason that you would want to link &
    JORF programs with other commands in C, C++ and Pascal libraries.

    The reality is that no one has asked for it, and I think I will &
    need to work closely with the first few customers to truly provide &
    an effective package.
  If Kbd:Got = "Esc_Key"
    Return Ok
  Return "Down_Arrow_Key"


Tut:Devel1
  Win:Add ("What is in JDK", 0, 0, 14, 58, Here)
    Button:"  More . . . ", Row:12, Col:26, Action:"Tut:Devel2"
    All you really need to link in outside routines is the &
    knowledge of a simple set of commands to pass and convert
    parameters.  They are as easy as the following:
    {Bold:"Lo"}
      jtos(jorf j)        /* Convert Jorf to a String   */
      jtoi(jorf j)        /* Convert Jorf to a long Int */
      stoj(char far *s)   /* Far string to a Jorf       */
      itoj(long i)        /* Long integer to a JORF     */
    {Bold:"No"}
    With these commands and others like them, you can easily interface &
    to any other linkable functions.
  Return (Tut:Ret)

Tut:Devel2
  Win:Add ("Complexities in the JDK", 8, 6, 14, 70, Here)
    Button:"  More . . . ", Row:12, Col:26, Action:"Tut:Devel3"
    There are two outstanding issues in the JDK.  First is program &
    size.  We all want to link in lots and lots of really big libraries, &
    but DOS programs MUST run in 640K.  Overlay managers and DOS &
    extenders help, but do not solve this problem.

    The second problem is related:  How to adequately debug mixed language &
    programs without giving away my secrets and techniques.  The JORF &
    memory and disk system is somewhat quirky, and you must be able to &
    understand how they are working.  At the same time, I am not yet &
    willing to release source code to a memory system that swaps at &
    will, and a disk storage system that stores any size data.
  Return (Tut:Ret)

Tut:Devel3
  Win:Add ("Getting the JORF Developers Kit", 10, 16, 17, 68, Here)
    Button:"  Done  ", Row:15, Col:26, Action:"Return Ok"
    These problems are entirely solveable, and I hope to be &
    offering a the JORF Developers kit by Spring of 1992.  Pricing &
    is expected to be an additional $85, because I have always been &
    a broke programmer and I think $600 that most companies are &
    charging for MS-Windows development systems is just too much.

    The whole thing, Registration, Link Libraries, and Developer's &
    Kit should total about $255.  This combination will allow you &
    to create, debug, compile and link business applications that &
    run identically under DOS, Networks, and MS-Windows.  You will &
    be able to link outside libraries, and use an overlay manager.

    Vaporware is neat because it does everything.  Contact The JORF &
    Company for Reality and Availability.
  Return (Tut:Ret)

Tut:JorfCo
  Msg:Add
    JORF Company is just me, and I have been out &
    of money since late 1990.  I run JorfCo part &
    time from 9-5 Pacific Time, Monday through &
    Wednesday.

    I never forget that {Bold:"Lo"}YOU{Bold:"No"} &
    are an important part of my &
    life, so please feel free to &
    write or call:

                  {Bold:"Lo"}Wayland Bruns
                  The JORF Company
                  25858 Elwood Road
                  Colton, OR 97017
                  (503) 824-5673
  Return (Tut:Ret)


Tut:Link
  Win:Add ("The JORF Link Libraries", 0, 0, 13, 64, Here)
    Button:"  More . . . ", Row:11, Col:26, Action:"Tut:Link1"
    The JORF Interpreter and Debugger has another surprise built &
    in.  It contains a code translator that translates JORF programs &
    into C language programs.  Once translated, these programs can &
    be compiled using a Borland compiler to create a true EXE file.

    Consider for a moment that Ashton Tate {Bold:"Lo"}Never{Bold:"No"} &
    created a way to compile dBASE programs, and dBASE has only a quarter &
    the commands of JORF, is not a structured language, and lacks &
    any advanced screen management systems.
  Return (Tut:Ret)

Tut:Link1
  Win:Add ("Translated Programs", 6, 6, 17, 72, Here)
    Button:"  More . . . ", Row:15, Col:28, Action:"Tut:Link2"
    You can try out the translator with the following DOS command:
    {Bold:"Lo"}
                          C> JORF -t ASCII
    {Bold:"No"}
    This command will compile the ASCII.J program into a stand alone &
    C language program.  If you look at the source code, you will &
    see that that the translator has to add a lot of stuff to make &
    C into a typeless language, and to support polymophism.

    So the translated programs are as slow to C, as the C language is &
    slow to assembler.  There is always a tradeoff between fast &
    programming and fast programs.

    To compile and link the programs, you will need the Link Libraries.
  Return (Tut:Ret)

Tut:Link2
  Win:Add ("Translated Programs", 0, 0, 16, 60, Here)
    Button:"  Done  ", Row:14, Col:22, Action:"Return Ok"
    For $85 you get two link libraries:
    {Bold:"Lo"}
        JORFDOS.LIB   - Normal DOS JORF, networkable, small.
        JORFWIN.LIB   - Windows version for Borland C++
    {Bold:"No"}
    JORF.LIB The first library is the basic DOS package.  Minimum &
    program size is about 180K and maximum is about 350K.

    JORFWIN.LIB is the Windows compile for the Borland C++ Compiler.  &
    I do not yet support DLLs or graphics, but hope to add that support soon.
  Return (Tut:Ret)

Tut:Overseas
  Msg:Add ("Overseas Shipping", "Ok")
    Please add $10 to cover the cost of U.S. Air Mail.  We can &
    take checks from most major coutries as long as the check is &
    written in the native currency for the bank that issued the check. 

    For instance, you can send a check for 600 french francs as &
    long as the check is from a french bank.  You can send German &
    marks as long as the check is from a german bank.  You can send &
    Japanese Yen as long as the check is from a Japanese bank.  

    Of course, you can always get a check in dollars from your &
    local Citibank office.

    For Canada, add $5 for shipping.  We accept Canadian Postal &
    Money Orders, but they must be in U.S. dollars.  Shipping is  &
    by U.S. Air Mail unless otherwise specified.
  Return (Tut:Ret)

Tut:Prod
  Win:Add ("JORF Company Products", 0, 0, 23, 60, Here)
    Button:"  Done  ", Row:21, Col:24, Action:"Return Ok"
    {Bold:"Lo"}Demonstration Package                                FREE!{Bold:"No"}
      3 1/2 disk with DOS and Windows versions of JORF,
      a Mini-Manual and Command Reference card.

    {Bold:"Lo"}Registration Package                                   $85{Bold:"No"}
      The same as Demonstration Package, plus a Big Manual
      with a Big Reference section, and Telephone support.

    {Bold:"Lo"}Link Libraries                                         $85{Bold:"No"}
      The libraries you need to Translate and compile your
      JORF programs into true EXE files.  You will also
      need the Borland Turbo C compiler (about $88) to
      compile for DOS, and the Borland C++ compiler
      (about $350) to compile for Windows programs.

    {Bold:"Lo"}Developers Kit                                  2nd Qtr 92?{Bold:"No"}
      My favorite Vaporware package.  This package has
      the source code, and documentation you need to
      create new JORF functions in C, C++, and Pascal.
      Call for pricing an availablility.
  Return (Tut:Ret)

Tut:Regist
  Win:Add ("Registration", 0, 0, 13, 64, Here)
    Button:"  More . . . ", Row:11, Col:22, Action:"Tut:Regist1"
    This program is Shareware.  Feel free to try it out without &
    charge, and to copy it to give it to friends.  If you decide &
    to use the JORF interpreter to create new programs, you must &
    purchase a registered copy from The JORF Company.

    You will want to register anyway because you will need the &
    full spiral bound manual with a complete command reference. When &
    you register you will also get the newest copy &
    of the interpreter, a mini manual, &
    a command reference card, free phone support, and notice of upgrades.
  Return (Tut:Ret)

Tut:Regist1
  Win:Add ("Registration", 0, 0, 13, 52, Here)
    Button:"  &Done ", Row:11, Col:22, Action:"Return Ok"
    To Register, just send a check for $85.  I'll pay for Air Mail &
    shipping within the U.S., and Oregon has no &
    {Prompt:"&Sales Tax", Action:"Tut:Tax"}. We &
    ship both the DOS and Windows version on a single 3 1/2 inch disk &
    so be sure to note if you need 5 1/4 inch disks.

    If you live outside the United States. please add &
    {Prompt:"&Overseas", Action:"Tut:Overseas"} shipping costs.

    Thank you for your interest in JORF.
  Return (Tut:Ret)

Tut:Ret
  If (Kbd:Got = 'Esc_Key')
    Return (Ok)
  Return (Null)

Tut:Tax
  Msg:Add ("Sales Tax", "Ok")
    Oregon has no sales tax, and The JORF Company &
    does not maintain a sales presence in any other &
    state.  According to recent rulings in New York &
    and New Jersey, we can sell our products to you &
    as if you were purchasing here.
  Return (Tut:Ret)

Write:Help
  Win:Add ("The Help System", 0, 0, 12, 60, Here)
    Button:" More . . . ", Row:10, Col:24, Action:"Write:Summary"
    The Help system documents JORF functions available to you. &
    These vary from the prosaic {Bold:"Lo"}Kbd:Get{Bold:"No"} to &
    the complex {Bold:"Lo"}Win:Add{Bold:"No"}.  Also documented &
    are the control functions {Bold:"Lo"}If{Bold:"No"}, &
    {Bold:"Lo"}Else{Bold:"no"}, {Bold:"Lo"}While{Bold:"No"}, and &
    {Bold:"Lo"}Switch{Bold:"No"}.

    You can access the help system at any time by hitting &
    {Bold:"Lo"}F1{Bold:"No"}.  (Try it now!)  The Help system &
    is a JORF language program, just like this tutorial, and &
    depends on there being a HELP.J or HELP.JRF file on  &
    the current directory.
  Return (Tut:Ret)

Write:Mantra
  Win:Add ("Writing JORF Programs", 0, 0, 15, 50, Here)
    Button:" More . . . ", Row:13, Col:16, Action:"Write:Mantra1"
    To edit a program, start JORF using the program name.

          C>{Bold:"Lo"}JORF MANTRA{Bold:"No"}

    If you forget the program name, or want to start in &
    the debugger, you can start JORF by itself.

          C>{Bold:"Lo"}JORF{Bold:"No"}

    This starts the debugger, which will display a list &
    of programs to debug.
  Return (Tut:Ret)

Write:Mantra1
  Win:Add ("Handling .JRF files", 7, 5, 16, 76, Here)
    Button:" More . . . ", Row:14, Col:30, Action:"Write:Progs"
    When you start JORF using a new project, the source file is &
    converted to an internal format {Bold:"Lo"}.JRF{Bold:"No"} file. &
    This file contains indexes and browse list information that is &
    not contained in the source file.  Unfortunately, this format is &
    more likely to bomb than the source, and is often not recoverable.

    To guard against this, write the source code periodically using the &
    {Bold:"Lo"}Alt-W{Bold:"No"} key.  Then, if the .JRF file should &
    bomb, erase it and restart JORF with the source file &
    name.  A nice clean .JRF file will be created.

    The JORF Interpreter uses a file called SWAPFILE.JRF for variables &
    and screens swapped while a program is running.  If you bomb while &
    in JORF, you CHKDSK will recover this file, which is usually from &
    5 to 50K.  Just erase it.  The JORF Interpreter creates a new &
    SWAPFILE.JRF every time it is run.
  Return (Tut:Ret)

Write:Progs
  Win:Add ("Sample Programs", 0, 0, 20, 60, Here)
    Button:" More . . . ", Row:18, Col:20, Action:"Write:Help"
    The sample programs included here are program samples &
    for various commands in the manual, and also include &
    some sample application programs.

    Here is a list of programs:

         Ascii.J        Basic Consol Operations
         Binary.J       Bits and Bytes
         Contact.J      Contact Manager
         FilePrnt.J     File load and print example
         Frenkey.J      French Accents - Easy
         Haiku.J	Poetry Generator
         Mantra.J       Send your computer to heaven
         Textedit.J     Little text editor
         WhatKey.J      Basic Consol Operations

  Return (Tut:Ret)

Write:Start
  Win:Add ("Writing JORF Programs", 0, 0, 16, 64, Here)
    Button:" More . . . ", Row:14, Col:22, Action:"Write:Mantra"
    There is a significant gap between reading &
    this tutorial, and creating &
    new programs using JORF.  This gap can be &
    crossed, and {Bold:"Lo"}You can &
    do it!{Bold:"No"}

    The best way to write JORF programs is to use &
    the {Bold:"Lo"}JORF integrated editor and debugger{Bold:"No"}.  This &
    tool allows you to watch the program and stack as &
    the program runs.  The JORF editor allows you to &
    change stack values, and even the program code, without &
    having to stop and restart it like most debuggers.

    You can enter the debugger by pressing {Bold:"Lo"}Ctrl-Break{Bold:"No"} &
    at any time.  The Break key is near the number pad and &
    is labeled Scroll Lock on an XT or Pause on an AT keyboard.
  Return (Tut:Ret)

Write:Summary
  Win:Add ("Summary", 7, 14, 16, 60, Here)
    Button:"  Done  ", Row:14, Col:24, Action:"Return Ok"
     Start with a small change and work your way up.

     Make changes using the integrated editor and debugger, or &
    by using the Method Browser system.

     Use the Alt-W "Write File" option to write source files.

     Reload source files by invoking The JORF Interpreter with &
    the names of the class files to be reloaded.

     Send $85 to The JORF Company &
    to get the latest (more bombproof) version of the interpreter and &
    a neat manual that steps you through the process of writing &
    programs.
  Return (Tut:Ret)

ThreeFoo:Start
  New (Foo, Counter)
  While (Counter < 3)
    Win:Add("OUR SECOND PROGRAM")
      String:"This entry window repeats three times."
      Input:"Enter Something to Say:", Wid:22, Field:"Foo"
    ++Counter
    Msg:Add
      Counter is: {Counter}
      Foo is: {Foo}
    Foo=Null
  Return

JORFNote:Say (Letter)
  Time:Get (Mem:Ptr)
  Msg:Add ("My Letter", "Ok")
    {Mem:Ptr->SDate}

    Dear Wayland,

    I just had to write to you, because I am &
    so {Letter->Feeling} by JORF. In Fact, &
    {Letter->Thought}

    Yours Truly,

    {Letter->Name}
    {Letter->Street}
    {Letter->CityStZip}
  Return

JORFNote:Start
  New (JORFNote:Letter)
  Win:Add ("Letter To The JORF Company" 0,0,5,20, Here)
    Input:"Your Name   ", Field:"Letter->Name"
    Input:"Your Street ", FIeld:"Letter->Street"
    Input:"City/St/Zip ", Field:"Letter->CityStZip"

    String:"How does JORF make you feel?  (Excited, Bored, Confused...)"
    Input:"Your Feeling ", Wid:20, Field:"Letter->Feeling"

    String:"What do you think of JORF? (Really Neat, Too Complicated...)"
    Input:"", Wid:60 Len:6, Field:"Letter->Thought"
    String:"            (Press Escape to Finish Text Entry)"
  JORFNote:Say (Letter)
  Return

