/* DigiClok.C -- Windows digital clock */
/* Version 2.00 -- 04/29/87 */
/* Copyright (c) 1987 -- Doren Kim Levitt */

#include <windows.h>	/* all Windows functions */
#include <stdio.h>	/* standard I/O */
#include <time.h>	/* time functions */

#define cEscapement	0	/* Font attributes all defaulted */
#define cOrientation	0
#define cWeight		0
#define cItalic		0
#define cUnderline	0
#define cStrikeOut	0

long FAR PASCAL WndProc (HWND, unsigned, WORD, LONG);

static	int cTime, cHeight, cWidth;

/* WinMain - Main loop for all Windows applications */
int PASCAL WinMain ( hInstance, hPrevInstance, lpszCmdLine, nCmdShow)
HANDLE  hInstance, hPrevInstance;
LPSTR   lpszCmdLine;
int     nCmdShow;
{
	static   char szAppName [] = "DigiClok";
	WNDCLASS WndClass;
	HWND     hWnd;
	MSG      msg;

	/* allow only one instance */
	if (hPrevInstance)
	   return FALSE;

	/* define Window class */
	WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
	WndClass.hIcon         = NULL;
	WndClass.cbClsExtra    = 0;
	WndClass.cbWndExtra    = 0;
	WndClass.lpszMenuName  = NULL;
	WndClass.lpszClassName = (LPSTR) szAppName;
	WndClass.hbrBackground = (HBRUSH) GetStockObject( WHITE_BRUSH );
	WndClass.hInstance     = hInstance;
	WndClass.style         = CS_VREDRAW | CS_HREDRAW;
	WndClass.lpfnWndProc   = WndProc;

	/* register this new class with WINDOWS */
	if (!RegisterClass((LPWNDCLASS)&WndClass))
	   return FALSE;   /* Initialization failed */

	/* create window */
	hWnd = CreateWindow((LPSTR) szAppName,
			(LPSTR)  szAppName,
			WS_TILEDWINDOW,
			0, 0, 0, 0,
			(HWND)   NULL,
			(HMENU)  NULL,
			(HANDLE) hInstance,
			(LPSTR)  NULL);

	/* get system metric info */
	cHeight = GetSystemMetrics(SM_CYICON) / 2;
	cWidth = GetSystemMetrics(SM_CXICON) / 5;

	/* set up timer (1 update/sec.) */
	if (!SetTimer (hWnd, 1, 1000, NULL) )
	   return FALSE;

	/* show window (start in ICONIC state) */
	ShowWindow( hWnd, (int) 0xFF8F );
	UpdateWindow( hWnd );

	/* main program loop */
	while (GetMessage ((LPMSG) &msg, NULL, 0, 0)) {
	   TranslateMessage((LPMSG) &msg );
	   DispatchMessage((LPMSG) &msg );
	} /* end while GetMessage */

	/* exit back to Windows */
	return (int) msg.wParam;

} /* end WinMain */

/* WndProc - Window procedure for main window */
long FAR PASCAL WndProc (hWnd, message, wParam, lParam)
HWND	hWnd;
unsigned message;
WORD	wParam;
LONG	lParam;
{
	struct	tm *timehere;
	time_t	gmtime;
	int	nTime;
	char 	*am_pm = "PM";
	char	buffer[20];
	PAINTSTRUCT ps;
	RECT	rect;
	HDC	hDC;
	HFONT	oldFont, newFont;	/* font handles */

	/* switch on message type sent to window by Windows dispatcher */
	switch(message) {
	   case WM_TIMER:
	      time(&gmtime);
	      timehere = localtime(&gmtime);
	      nTime = timehere->tm_min;
	      if ( nTime != cTime ) {	/* if time change */
	         cTime = nTime;
	         InvalidateRect( hWnd, NULL, TRUE );
	      } /* end if */
	      break;
	   case WM_TIMECHANGE:
	      InvalidateRect( hWnd, NULL, TRUE );
	      break;
	   case WM_PAINT:
	      hDC = BeginPaint( hWnd, (LPPAINTSTRUCT) &ps );
	      time(&gmtime);	/* get Greenwich mean time */
	      timehere = localtime(&gmtime);
	      cTime = timehere->tm_min;
	      if (timehere->tm_hour < 12) {
	         am_pm = "AM";
	         if (timehere->tm_hour == 0)
	            timehere->tm_hour = 12;
	      } /* end if AM */
	      else if (timehere->tm_hour > 12)
	         timehere->tm_hour -= 12;
	      sprintf( buffer, "%02u:%02u %s", timehere->tm_hour,
	        timehere->tm_min, am_pm);
	      newFont = CreateFont( cHeight, cWidth, cEscapement,
	        cOrientation, cWeight, cItalic, cUnderline, cStrikeOut,
	        ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
	        DEFAULT_QUALITY, VARIABLE_PITCH|FF_SWISS, (LPSTR)NULL);
	      oldFont = SelectObject( hDC, newFont );
	      GetClientRect( hWnd, (LPRECT) &rect );
	      DrawText( ps.hdc, (LPSTR) buffer, 8, (LPRECT)&rect,DT_WORDBREAK);
	      EndPaint( hWnd, (LPPAINTSTRUCT) &ps );
	      SelectObject( hDC, oldFont );
	      break;
	   case WM_QUERYOPEN:
	      break;
	   case WM_DESTROY:
	      KillTimer (hWnd, 1);
	      PostQuitMessage( 0 );
	      break;
	   default:
	      return DefWindowProc( hWnd, message, wParam, lParam);
	} /* end switch */

	return (long) 0;

} /* end WndProc */
