/*------------------------------------------------------------------
 * tmsg server
 *------------------------------------------------------------------
 * program by Patrick Mueller (pmuellr@vnet.ibm.com)
 *------------------------------------------------------------------
 * written as sample code for EDM/2 article
 *------------------------------------------------------------------
 * Copyright IBM Corp., 1994.  All Rights Reserved.
 *
 * While the information provided herein is believed to be accurate, IBM
 * does not warrant the information, and the information is provided "as
 * is".
 *------------------------------------------------------------------*/

/*------------------------------------------------------------------
 * port number is hardcoded
 *------------------------------------------------------------------*/
port = 6789

/*------------------------------------------------------------------
 * print start-up message
 *------------------------------------------------------------------*/
say date() time() ": tmsg server started"

/*------------------------------------------------------------------
 * character constants
 *------------------------------------------------------------------*/
cr = d2c(13)
lf = d2c(10)
crlf = cr || lf

/*------------------------------------------------------------------
 * initialize socket package
 *------------------------------------------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
   do
   rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
   rc = SockLoadFuncs()
   end

/*------------------------------------------------------------------
 * create socket
 *------------------------------------------------------------------*/
socket  = SockSocket("AF_INET","SOCK_STREAM",0)
if (socket = -1) then
   call error "Error creating socket:" errno

/*------------------------------------------------------------------
 * handle cntl-break
 *------------------------------------------------------------------*/
signal on halt

/*------------------------------------------------------------------
 * bind socket to the port
 *------------------------------------------------------------------*/
server.!family = "AF_INET"
server.!port   = port
server.!addr   = "INADDR_ANY"

rc = SockBind(socket,"server.!")
if (rc = -1) then
   call error "Error binding socket to port" port ":" errno

/*------------------------------------------------------------------
 * set the connect backlog
 *------------------------------------------------------------------*/
rc = SockListen(socket,10)
if (rc = -1) then
   call error "Error setting queue size for socket:" errno

/*------------------------------------------------------------------
 * loop through each request
 *------------------------------------------------------------------*/
do forever

   /*---------------------------------------------------------------
    * accept a client connection, returns new socket
    *---------------------------------------------------------------*/
   newSocket = SockAccept(socket,"client.!")
   if (newSocket = -1) then
      call error "Error on SockAccept:" errno

   /*---------------------------------------------------------------
    * get client's name
    *---------------------------------------------------------------*/
   if (1 = SockGetHostByAddr(client.!addr,"host.!")) then
      clientName = host.!name
   else
      clientName = client.!addr

   /*---------------------------------------------------------------
    * get the message ... loop in case message is broken up
    *---------------------------------------------------------------*/
   text = ""

   do while (pos(crlf,text) = 0)
      rc = SockRecv(newSocket,"chunk",1000)
      if (rc = -1) | (chunk = "") then
         text = text || crlf

      text = text || chunk
   end

   /*---------------------------------------------------------------
    * close the new socket
    *---------------------------------------------------------------*/
   rc = SockClose(newSocket)

   /*---------------------------------------------------------------
    * make a nice message to print, and print it
    *---------------------------------------------------------------*/
   parse var text text (crlf) .

   line = date() time() ":" clientName ":" text
   say line

   /*---------------------------------------------------------------
    * play a little tune
    *---------------------------------------------------------------*/
   call playTune
end

exit

/*------------------------------------------------------------------
 * play a little tune
 *------------------------------------------------------------------*/
playTune: procedure expose os
   do i = 1000 to 2000 by 200
      call beep i, 50
   end

   return

/*------------------------------------------------------------------
 * print an error message
 *------------------------------------------------------------------*/
error: procedure expose socket newSocket
   say arg(1)
   signal halt

/*------------------------------------------------------------------
 * handle cntl-break
 *------------------------------------------------------------------*/
halt:
   if datatype(socket,   "W") then call sockClose socket
   if datatype(newSocket,"W") then call sockClose newSocket

   line = date() time() ": terminating"
   say line

   exit

