// CHEMLIB 1993 Paul DiLascia.
// CHEMLIB shows how to wrap C++ classes in a C DLL API.
// CHEMAPI.CPP: this C module implements the C wrapper APIs. It gets
// linked with the C++ module CHEMLIB.CPP to create CHEMLIB.DLL.

#include <windows.h>
#include "chemlib.h"
#include "chemapi.h"

// DLL initialization, called by Windows when DLL is first loaded.
int WINAPI LibMain(HANDLE, WORD, WORD heapsz, LPSTR)
{
   if (heapsz>0)
      UnlockData(0);
   return 1;
}

// DLL termination, called by Windows when DLL is unloaded.
int DLLFUNC WEP(int)
{
   return 1;
}

// API 1 wrapper function for constructor.
EQUATION DLLFUNC EqnCreate(LPCSTR formula)
{
   return (EQUATION)(new CEqn(formula));
}

// API 1 wrapper function for destructor.
void DLLFUNC EqnDestroy(EQUATION eqn)
{
   delete (CEqn*)eqn;
}

// API 1 wrapper function for "balance" member function.
int DLLFUNC EqnBalance(EQUATION eqn, char* buf, int buflen)
{
   return ((CEqn*)eqn)->balance(buf, buflen);
}

// API 2 wrapper function eliminates the need for apps to create and
// destroy equation objects, and is preferrable for that reason. It
// hides construction/destruction from the app by creating a private
// equation object on the stack, balancing it, and returning the result
// in the caller's buffer. Assumes string is at least 256 bytes long.
//
// This makes CHEMLIB much easier to use from apps like Excel, which are
// non-procedural. App need only deal with strings, not objects.
void DLLFUNC BalanceEqn(LPSTR formula)
{
   CEqn eqn = formula;
   eqn.balance(formula, 256);
}
