// CHEMLIB 1993 Paul DiLascia.
// CHEMLIB shows how to wrap C++ classes in a C DLL API.
// CHEMAPI.H: this file declares the API, and should be
// included by C apps that call the functions in CHEMLIB.DLL.

#include <windows.h>

typedef void* EQUATION;

#ifdef __cplusplus
extern "C" {   // must have external, C linkage (no name mangling)
#endif

// A DLL function is an _exported WINAPI (_far _pascal) function
#define  DLLFUNC WINAPI _export

// API #1: These three functions provide an API that lets
// the app have a pointer to a real C++ object.
EQUATION DLLFUNC EqnCreate(LPCSTR formula);
int      DLLFUNC EqnBalance(EQUATION eqn, LPSTR buf, int buflen);
void     DLLFUNC EqnDestroy(EQUATION eqn);

// API #2: This API uses strings only. It's better for spreadsheets.
void     DLLFUNC BalanceEqn(LPSTR formula);

#ifdef __cplusplus
}
#endif
