//////////////////////////////////////////////////////////
// CHEMLIB Copyright 1993 Paul DiLascia.
// CHEMLIB shows how to wrap C++ classes in a C DLL API.
//
// CHEMAPP is an ordinary C application that calls CHEMLIB.DLL
//

#define STRICT
#include <string.h>
#include "chemapi.h"

int PASCAL WinMain(HINSTANCE hinst, HINSTANCE pinst, LPSTR cmd, int show)
{
	char temp[100];
	LPCSTR eqn1 = "Si2H6+O2=SiO2+H2O";
	LPCSTR eqn2 = "C++ Chemistry is fun!";
	char bal1[256], bal2[256];

	/* First method uses equation objects (magic cookies) */
	EQUATION eqn = EqnCreate("Si2H6+O2=SiO2+H2O");
	EqnBalance(eqn, bal1, sizeof(bal1));
	EqnDestroy(eqn);

	/* Second method, more appropriate for spreadsheet, uses no cookies */
	strcpy(bal2, eqn2);
	BalanceEqn(bal2);

	/* Display results */
	wsprintf(temp, "%s ==> %s\n%s ==> %s", eqn1, bal1, eqn2, bal2);
	MessageBox(NULL, temp, "This is CHEMAPP", MB_OK);

	return 0;
}
