//////////////////////////////////////////////////////////
// CHEMLIB Copyright 1993 Paul DiLascia.
// CHEMLIB shows how to wrap C++ classes in a C DLL API.
//
// CHEMLIB.CPP: Implements the chemistry class library, the C++ classes
// that do Chemistry. This is where the real stuff happens.

#include <windows.h>
#include <string.h>
#include "chemlib.h"

/////////////////
// Constructor: store equation. The real implementation parses
// it and checks that it's a valid chemical equation.
// 
CEqn::CEqn(LPCSTR formula)
{
	strncpy(m_formula, formula, MAXEQNLEN);
}

CEqn::~CEqn()
{
	// nothing to do, but in general there might be
}

///////////////// 
// Balance the equation. Return balanced result in caller's buffer.
//
int CEqn::balance(LPSTR buf, int buflen)
{
	// This is a test. This is only a test. If this were
	// a real program, the code would be more complicated.
	//
	strncpy(buf, "2Si2H6+7O2=4SiO2+6H2O", buflen);
	return 0;
}
