////////////////////////////////////////////////////////////////
// MINMAX.CPP: Simple Program shows how to make min/max templates.
// To compile, type "bcc minmax.cpp"
//
#include <iostream.h>

// Template function for min
template <class T>
T min(T a, T b)  { return a < b ? a : b; }

// Template function for min
template <class T>
T max(T a, T b)  { return a > b ? a : b; }

//////////////////
// Since min(int, int) and max(double, double) are the only 
// min/max functions used in this program, they're the only
// ones the compiler instantiates.
//
int main(int, char**)
{
   // Invokes min(int, int):
   cout << "min(4,17) = " << min(4, 17) << '\n';

   // Invokes max(double, double):
   cout << "max(9.3,37.2) = " << max(9.3,37.2) << '\n';

   return 0;
}
