/*	com2hex.c

Convert a .COM file to a list of ASCII hex numbers.

File name without extension is specified.
<file>.COM is read, and <file>.HEX is written.

Written by Francis X. Guidry
Released to the public domain

*/

#include <stdio.h>
#include <string.h>

main(int argc, char** argv)
{
	FILE *in, *out;
	char inname[256], outname[256];
	unsigned char ch;
	int count = 0;
	
	if(argc < 2)
		errexit("Must specify file to process");
	
	strcpy(inname,argv[1]);
	strcat(inname,".com");
	strcpy(outname,argv[1]);
	strcat(outname,".hex");
	
	in = fopen(inname,"rb");
	if(!in)
		errexit("Unable to open input file");
	
	out = fopen(outname,"w");
	if(!out)
		errexit("Unable to open output file");

	while(fread(&ch,1,1,in)) {
		if(count)
			fprintf(out,",");
		fprintf(out,"0X%02x",ch);
		if(++count == 16) {
			count = 0;
			fprintf(out,",\n");
		}
	}
	
	fprintf(out," \n");
	fclose(in);
	fclose(out); 
	return 0;
}


/* -----------------------------------------------------------
	Exit due to an error condition.
   ----------------------------------------------------------- */

errexit(char *s)
{
	puts(s);
	exit(1);
}


