VERSION 2.00
Begin Form FileForm 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "File Form"
   ControlBox      =   0   'False
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "System"
   FontSize        =   9.75
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   3510
   Icon            =   FILEOPEN.FRX:0000
   Left            =   1485
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3105
   ScaleWidth      =   5640
   Top             =   1605
   Width           =   5760
   Begin CommandButton cmdOk 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   420
      Left            =   4320
      TabIndex        =   8
      Top             =   120
      Width           =   1125
   End
   Begin TextBox txtFileName 
      Height          =   375
      Left            =   240
      TabIndex        =   1
      Text            =   "*.txt"
      Top             =   360
      Width           =   1575
   End
   Begin CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   420
      Left            =   4320
      TabIndex        =   9
      Top             =   720
      Width           =   1125
   End
   Begin FileListBox filFiles 
      Height          =   1395
      Left            =   240
      Pattern         =   "*.txt"
      TabIndex        =   2
      Top             =   840
      Width           =   1620
   End
   Begin DirListBox dirDirs 
      Height          =   1425
      Left            =   2040
      TabIndex        =   5
      Top             =   840
      Width           =   2100
   End
   Begin ComboBox cboFiletype 
      Height          =   300
      Left            =   240
      Style           =   2  'Dropdown List
      TabIndex        =   12
      Top             =   2640
      Width           =   1695
   End
   Begin DriveListBox drvDrives 
      Height          =   1530
      Left            =   2040
      TabIndex        =   7
      Top             =   2640
      Width           =   2115
   End
   Begin Label Label1 
      Caption         =   "List Files of &Type:"
      Height          =   255
      Left            =   240
      TabIndex        =   11
      Top             =   2400
      Width           =   1695
   End
   Begin Label lblFileName 
      Caption         =   "File &Name:"
      Height          =   240
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   1200
   End
   Begin Label lblDirectories 
      Caption         =   "&Directories:"
      Height          =   240
      Left            =   2040
      TabIndex        =   3
      Top             =   150
      Width           =   1200
   End
   Begin Label lblCurrentDir 
      Height          =   225
      Left            =   2040
      TabIndex        =   4
      Top             =   480
      Width           =   2085
   End
   Begin Label lblDrives 
      Caption         =   "Dri&ves:"
      Height          =   255
      Left            =   2040
      TabIndex        =   6
      Top             =   2400
      Width           =   765
   End
End

Sub cboFiletype_Click ()
    Select Case cboFiletype.ListIndex
        Case 0      ' Text Files (*.txt)
            NewPattern = "*.txt"
        Case 1      ' All Files (*.*)
            NewPattern = "*.*"
    End Select
    
    txtFileName.Text = NewPattern
    filFiles.Pattern = NewPattern
    ' reinitialize the file controls
    filFiles.Refresh
End Sub

Sub cmdcancel_Click ()
    
    ' Set the file name text box to null.
    ' By checking the text property of this text box,
    ' other procedures can tell if Cancel has been
    ' selected.
    FileForm.txtFileName.Text = Empty
    
    ' Hide the form
    FileForm.Hide

End Sub

Sub cmdOK_Click ()
Dim Msg As String
On Error Resume Next
    If txtFileName.Text Like "*[;>]*" Or txtFileName.Text Like "*[ ,+|/]*" Then
        Msg = "Bad filename"
        ' Display error and select the offending text.
        MsgBox Msg, 48, App.EXEName
        txtFileName.SetFocus
        txtFileName.SelStart = 0
        txtFileName.SelLength = Len(txtFileName.Text)
    Else
        Hide
    End If

End Sub

Sub dirDirs_Change ()
    
    ' propogate directory changes to other controls
    filFiles.Path = dirDirs.Path
    lblCurrentDir.Caption = dirDirs.Path
    ChDir dirDirs.Path
    txtFileName.Text = filFiles.Pattern

End Sub

Sub drvDrives_Change ()

    ' change the dirDirs control path, it will
    ' pass the change on to the filFiles control
    dirDirs.Path = drvDrives.Drive
    ChDrive (drvDrives.Drive)

End Sub

Sub filFiles_Click ()
    
    ' echo the selected name in the Text box
    txtFileName.Text = filFiles.FileName

End Sub

Sub filFiles_DblClick ()

    ' we have a final selection from the File Save dialog
    'txtFilename.Text = filFiles.FileName
    cmdOK_Click

End Sub

Sub filFiles_PathChange ()
    dirDirs.Path = filFiles.Path
    drvDrives.Drive = filFiles.Path
End Sub

Sub filFiles_PatternChange ()
    'Show the current search pattern in the txtFileName control
    txtFileName.Text = filFiles.Pattern
    dirDirs.Path = filFiles.Path
End Sub

Sub Form_Activate ()
    ' If File Open dialog, set Text box to current pattern
    If FileForm.Caption = "Open" Then
        txtFileName.Text = filFiles.Pattern
    End If
    
    ' If a File Save dialog, set the text box
    ' to the current file name
    If FileForm.Caption = "Save As" Then
        ' File is not named
        If frmMDI.ActiveForm.Caption = "Untitled" Then
            FileForm.txtFileName.Text = filFiles.Pattern
        ' File has a name
        Else
            FileForm.txtFileName.Text = frmMDI.ActiveForm.Caption
    End If
    
    End If
    ' initialize file controls
    filFiles.Refresh
    
    ' Clear current selection in Filetype list box
    cboFiletype.ListIndex = -1
    
    ' Set FileType list box to first item (*.txt)
    cboFiletype.ListIndex = 0
    
    ' highlight the current selection
    FileForm.txtFileName.SelStart = 0
    FileForm.txtFileName.SelLength = Len(FileForm.txtFileName.Text)

End Sub

Sub Form_Load ()
    ' display full path name in a label
    lblCurrentDir.Caption = dirDirs.Path

    ' add items to List Files of Type list
    cboFiletype.AddItem "Text Files (*.txt)"
    cboFiletype.AddItem "All Files (*.*)"
End Sub

Sub Form_Unload (Cancel As Integer)
    
    Cancel = True   ' Don't unload form, just hide it
    Call cmdcancel_Click
End Sub

Sub txtFileName_Change ()
    ' Disable OK button if no filename.
    cmdOK.Enabled = (Len(txtFileName.Text) > 0)
End Sub

