DECLARE SUB DispMaze (MaxX!, MaxY!)
'****************************
'*      MazeGen Editor      *
'*            By            *
'*      Adam Landefeld      *
'*                          *
'****************************
SCREEN 12
WIDTH 80, 60
COLOR 15
LOCATE 1, 1: INPUT "Maze To Load"; File$
CLOSE
OPEN File$ FOR INPUT AS #1
INPUT #1, MaxX
INPUT #1, MaxY
REDIM SHARED MazeMap(MaxX, MaxY)
x = 0
y = 0
DO UNTIL x = MaxX
     x = x + 1
     y = 0
     DO UNTIL y = MaxY
          y = y + 1
          INPUT #1, MazeMap(x, y)
     LOOP
LOOP
CLOSE
WIDTH 80, 60
CALL DispMaze(MaxX, MaxY)

KEY(11) ON
KEY(12) ON
KEY(13) ON
KEY(14) ON
KEY(15) ON
KEY(16) ON
KEY(17) ON
KEY(18) ON
KEY 15, CHR$(&H0) + CHR$(&H39)
KEY 16, CHR$(&H0) + CHR$(&H1F)
KEY 17, CHR$(&H0) + CHR$(&H26)
KEY 18, CHR$(&H0) + CHR$(&H10)
ON KEY(11) GOSUB MoveUp
ON KEY(12) GOSUB MoveLeft
ON KEY(13) GOSUB MoveRight
ON KEY(14) GOSUB MoveDown
ON KEY(15) GOSUB ToggleSpace
ON KEY(16) GOSUB SaveMaze
ON KEY(17) GOSUB LoadMaze
ON KEY(18) GOSUB Endd
CurX = 1
CurY = 1
COLOR 15
DO
     KEY(0) STOP
     LOCATE CurY, CurX: PRINT "_"
     LOCATE CurY, CurX
     IF MazeMap(CurX, CurY) = 1 THEN
          PRINT CHR$(219)
     ELSE
          PRINT " "
     END IF
     KEY(0) ON
LOOP

MoveUp:
CurY = CurY - 1
RETURN

MoveDown:
CurY = CurY + 1
RETURN

MoveRight:
CurX = CurX + 1
RETURN

MoveLeft:
CurX = CurX - 1
RETURN

ToggleSpace:
IF MazeMap(CurX, CurY) = 0 THEN
     PRINT CHR$(177)
     MazeMap(CurX, CurY) = 1
ELSE
     PRINT CHR$(0)
     MazeMap(CurX, CurY) = 0
END IF
RETURN

SaveMaze:
KEY(0) OFF
LOCATE MaxY + 2, 1
INPUT "Filename"; File$
CLOSE
OPEN File$ FOR OUTPUT AS #1
WRITE #1, MaxX
WRITE #1, MaxY
x = 0
y = 0
DO UNTIL x = MaxX
     x = x + 1
     y = 0
     DO UNTIL y = MaxY
          y = y + 1
          WRITE #1, MazeMap(x, y)
     LOOP
LOOP
LOCATE MaxY + 3, 1: PRINT "File Saved"
KEY(0) ON
RETURN

LoadMaze:
KEY(0) OFF
COLOR 15
LOCATE MaxY + 2, 1: INPUT "Maze To Load"; File$
CLOSE
OPEN File$ FOR INPUT AS #1
INPUT #1, MaxX
INPUT #1, MaxY
REDIM SHARED MazeMap(MaxX, MaxY)
x = 0
y = 0
DO UNTIL x = MaxX
     x = x + 1
     y = 0
     DO UNTIL y = MaxY
          y = y + 1
          INPUT #1, MazeMap(x, y)
     LOOP
LOOP
CLS
CALL DispMaze(MaxX, MaxY)
LOCATE MaxY + 3, 1: PRINT "File Loaded"
KEY(0) ON
RETURN

Endd:
SCREEN 0
CLS
COLOR 15
CLOSE
KEY(0) OFF
END

SUB DispMaze (MaxX, MaxY)
x = 0
y = 0
DO UNTIL x = MaxX
     x = x + 1
     y = 0
     DO UNTIL y = MaxY
          y = y + 1
          IF MazeMap(x, y) = 1 THEN
               LOCATE y, x: PRINT CHR$(219)
          END IF
     LOOP
LOOP

END SUB

