CLS
SCREEN 12
RANDOMIZE TIMER
WallChar = 177
FillSBar$ = CHR$(177)
Corner = 15
Density = 3000
Wall = 100
MaxX = 73
MaxY = 40
Direction = 2
Mapx = 1
Mapy = 1

MainMenu:
CLS
WIDTH 80, 30
COLOR 14
LOCATE 1, 30: PRINT "Adam's Maze Generator"
COLOR 15
LOCATE 3, 8: PRINT "Maze Settings"
COLOR 9
LOCATE 4, 10: PRINT "1. Map Width:"; MaxX
LOCATE 5, 10: PRINT "2. Map Height:"; MaxY
LOCATE 6, 10: PRINT "3. Wall Pattern (ASCII):"; WallChar; " "; CHR$(WallChar)
LOCATE 7, 10: PRINT "4. Density:"; Density
COLOR 15
LOCATE 9, 8: PRINT "Probabilities"
COLOR 9
LOCATE 10, 10: PRINT "5. Turn:"; Corner; "%"
LOCATE 11, 10: PRINT "6. Wall:"; Wall; "%"
COLOR 15
LOCATE 12, 10: PRINT "7. Generate Maze"
LOCATE 13, 10: PRINT "8. Run MazEd"
LOCATE 14, 10: PRINT "9. Quit"
LOCATE 15, 1: INPUT "Enter a value"; in$
IF in$ = "1" THEN INPUT MaxX: GOTO MainMenu
IF in$ = "2" THEN INPUT MaxY: GOTO MainMenu
IF in$ = "3" THEN INPUT WallChar: GOTO MainMenu
IF in$ = "4" THEN INPUT Density: GOTO MainMenu
IF in$ = "5" THEN INPUT Corner: GOTO MainMenu
IF in$ = "6" THEN INPUT Wall: GOTO MainMenu
IF in$ = "8" THEN SHELL "mazed": GOTO MainMenu
IF in$ = "9" THEN SCREEN 0: COLOR 15: END

StartMazeDraw:
CLS
REDIM MazeMap(MaxX, MaxY)
Looped = 0
SCREEN 12
WIDTH 80, 60
COLOR 15
locx = 6
COLOR 4
LOCATE MaxY + 2, 5: PRINT "["
LOCATE MaxY + 2, 37: PRINT "]"
COLOR 2
DO UNTIL num = 31
        num = num + 1
        LOCATE MaxY + 2, num + 5: PRINT FillSBar$
LOOP
COLOR 15
DO UNTIL Looped = Density
     Looped = Looped + 1
     locx = locx + .01
     LOCATE MaxY + 2, locx: PRINT "."
     LOCATE MaxY + 2, 39: PRINT INT(100 * (locx / 35.7)); "%"
     RANDOMIZE TIMER
     '**************************************************************
     '** Decide if you should make a wall at the current position **
     Rand = INT(RND * 100)
     IF Rand <= Wall THEN
          IF MazeMap(Mapx, Mapy) = 0 THEN
               MazeMap(Mapx, Mapy) = 1
               LOCATE Mapy, Mapx: PRINT CHR$(WallChar)
          END IF
     ELSE
          MazeMap(Mapx, Mapy) = 0
     END IF
     '**************************************************************

     '**************************************************************
     '** Decide if we should change direction                     **
     IF Direction = 1 THEN
          IF MazeMap(Mapx, Mapy - 1) = 1 THEN DoTwice = 2: GOTO DoDir
          IF MazeMap(Mapx - 1, Mapy) = 1 THEN CheckDir = 1: GOTO GetDir
          IF MazeMap(Mapx + 1, Mapy) = 1 THEN CheckDir = 1: GOTO GetDir
     END IF
     IF Direction = 2 THEN
          IF MazeMap(Mapx + 1, Mapy) = 1 THEN DoTwice = 2: GOTO DoDir
          IF MazeMap(Mapx, Mapy - 1) = 1 THEN CheckDir = 1: GOTO GetDir
          IF MazeMap(Mapx, Mapy + 1) = 1 THEN CheckDir = 1: GOTO GetDir
     END IF
     IF Direction = 3 THEN
          IF MazeMap(Mapx, Mapy + 1) = 1 THEN DoTwice = 2: GOTO DoDir
          IF MazeMap(Mapx - 1, Mapy) = 1 THEN CheckDir = 1: GOTO GetDir
          IF MazeMap(Mapx + 1, Mapy) = 1 THEN CheckDir = 1: GOTO GetDir
     END IF
     IF Direction = 4 THEN
          IF MazeMap(Mapx - 1, Mapy) = 1 THEN DoTwice = 2: GOTO DoDir
          IF MazeMap(Mapx, Mapy - 1) = 1 THEN CheckDir = 1: GOTO GetDir
          IF MazeMap(Mapx, Mapy + 1) = 1 THEN CheckDir = 1: GOTO GetDir
        
     END IF
     '******************
     RANDOMIZE TIMER
     Rand = INT(RND * 100)
     IF Rand <= Corner THEN
GetDir:

          OldDir = Direction
          Direction = INT(RND * 4) + 1
          IF CheckDir = 1 THEN
               IF OldDir = Direction GOTO GetDir
          END IF
     END IF
     CheckDir = 0
     '** Ok, now change location ***********************************

DoDir:
     IF Direction = 1 THEN
          IF Mapy - 1 > 0 THEN
               Mapy = Mapy - 1
          ELSE
               GOTO GetDir
          END IF
     END IF
    
     IF Direction = 2 THEN
          IF Mapx + 1 < MaxX THEN
               Mapx = Mapx + 1
          ELSE
               GOTO GetDir
          END IF
     END IF
    
     IF Direction = 3 THEN
          IF Mapy + 1 < MaxY THEN
               Mapy = Mapy + 1
          ELSE
               GOTO GetDir
          END IF
     END IF
    
     IF Direction = 4 THEN
          IF Mapx - 1 > 0 THEN
               Mapx = Mapx - 1
          ELSE
               GOTO GetDir
          END IF
     END IF
     IF DoTwice >= 1 THEN DoTwice = DoTwice - 1: GOTO DoDir
     '**************************************************************
LOOP
GOSUB DrawBoxBorder
LOCATE MaxY + 3, 1: INPUT "Save Maze To File"; in$
in$ = UCASE$(in$)
IF in$ = "Y" THEN GOTO SaveMaze
COLOR 9
GOTO MainMenu

DrawBoxBorder:

'** Draw Horizontal Borders
Mapy = 1
Mapx = 0
DO UNTIL Mapx = MaxX
     Mapx = Mapx + 1
     MazeMap(Mapx, Mapy) = 1
     LOCATE Mapy, Mapx: PRINT CHR$(WallChar)
LOOP
Mapy = MaxY
Mapx = 0
DO UNTIL Mapx = MaxX
     Mapx = Mapx + 1
     MazeMap(Mapx, Mapy) = 1
     LOCATE Mapy, Mapx: PRINT CHR$(WallChar)
LOOP

'** Draw Vertical Borders
Mapy = 0
Mapx = 1
DO UNTIL Mapy = MaxY
     Mapy = Mapy + 1
     MazeMap(Mapx, Mapy) = 1
     LOCATE Mapy, Mapx: PRINT CHR$(WallChar)
LOOP
Mapy = 0
Mapx = MaxX
DO UNTIL Mapy = MaxY
     Mapy = Mapy + 1
     MazeMap(Mapx, Mapy) = 1
     LOCATE Mapy, Mapx: PRINT CHR$(WallChar)
LOOP
Mapx = 2
Mapy = 2
RETURN

SaveMaze:
x = 0
y = 0
CLS
INPUT "Filename"; File$
CLOSE
OPEN File$ FOR OUTPUT AS #1
WRITE #1, MaxX
WRITE #1, MaxY
DO UNTIL x = MaxX
     x = x + 1
     y = 0
     DO UNTIL y = MaxY
          y = y + 1
          WRITE #1, MazeMap(x, y)
     LOOP
LOOP
LOCATE 3, 1: PRINT "File Saved"
DO UNTIL INKEY$ <> ""
LOOP
GOTO MainMenu



