/*
 * address.C for WindowBoss
 * Function to review or change the field office information
 */

#ifndef lint
static char *addressID = " address.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "wnutils.h"
#include "setup.h"
#include "address.h"
#include "mesgcat.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int   getfoadr ( WINDOW *wn, FOINFO *foinfo );
static int   getfosav ( WINDOW * );
#else
static int   getfoadr();
static int   getfosav();
#endif

/* Function to review or update field office information
 */
int address(
WINDOW *wn,  /* window to use */
FOINFO *foinfo)  /* field office info structure */
{
   int rv;  /* return value */

   if ((rv = getfoadr(wn,foinfo)) == ESC_CODE)
      return(rv);
      /* save results */
      if (getfosav(wn))
         {
         if ((rv = savefo(foinfo)) > 0) {
            wn_iemsg(catstr(rv));
            return(rv); }
         }
      /* get previous field office information */
      else
         if ((rv = getfo(foinfo)) > 0) {
            wn_iemsg(catstr(rv));
            return(rv); }
      clr_stat();
   return(0);
}
/* Function to get new field office information
 */
static int getfoadr(
WINDOW *wn,  /* window to use */
FOINFO *foinfo)  /* field office info structure */
{
   WIFORM frm;  /* form pointer */
   int rv;  /* return value */

   begscrn(" Field Office Info  ");
   frm = wn_frmopn(10);
   if (!frm) {
      wn_iemsg(catstr(207));
      done(1); }
   wn_dtext(SET,frm,0,wn,4,3,
      "Enter field office manager's name and title:");
   wn_gtext(SET, frm, 1, wn, 5, 3, "   Manager's name > ", COLOR_PAIR(2),
      ' ', FOSIZE-2, foinfo -> foname, "%field office%", NSTR);
   wn_gtext(SET, frm, 2, wn, 6, 3, "  Manager's title > ", COLOR_PAIR(2),
      ' ', FOSIZE-2, foinfo -> fotitle, "%field office%", NSTR);
   wn_dtext(SET, frm, 3, wn, 7, 3, "Enter field office address:");
   wn_dtext(SET, frm, 4, wn, 8, 3, "   Address line 0 > ");
   wn_dtext(SET, frm, 5, wn, 8, 23, foinfo -> foaddr[0]);
   wn_gtext(SET, frm, 6, wn, 9, 3, "   Address line 1 > ", COLOR_PAIR(2),
      ' ', FOSIZE-2, foinfo -> foaddr[1], "%field office%", NSTR);
   wn_gtext(SET, frm, 7, wn, 10, 3, "   Address line 2 > ", COLOR_PAIR(2),
      ' ', FOSIZE-2, foinfo -> foaddr[2], "%field office%", NSTR);
   wn_gtext(SET, frm, 8, wn, 11, 3, "   Address line 3 > ", COLOR_PAIR(2),
      ' ', FOSIZE-2, foinfo -> foaddr[3], "%field office%", NSTR);
   wattrset(wn,COLOR_PAIR(6));
   rv = wn_frmget(frm);
   wn_frmcls(frm);
      wn_sdelspc(foinfo -> foname,3);
      wn_sdelspc(foinfo -> fotitle,3);
      wn_sdelspc(foinfo -> foaddr[1],3);
      wn_sdelspc(foinfo -> foaddr[2],3);
      wn_sdelspc(foinfo -> foaddr[3],3);
   return(rv);
}
/* Function to get answer to save-to-disk prompt
 */
static int getfosav(
WINDOW *wn)  /* window to use */
{
   static char ans[3];  /* answer as a string */
   int value;  /* 0 = false, 1 = true */

   begscrn("    Save to Disk    ");
   wattrset(wn,COLOR_PAIR(4));
   wn_dtext(XEQ,NFRM,NFLD,wn,4,3,
      "You are about to change the field office information for this program.");
   wn_dtext(XEQ,NFRM,NFLD,wn,5,3,
      "This information consists of the field office manager's name and title,");
   wn_dtext(XEQ,NFRM,NFLD,wn,6,3,
     "and the address of the field office.  This information is printed on the");
   wn_dtext(XEQ,NFRM,NFLD,wn,7,3,
      "letter produced for a PEBES estimate.  It will be permanently changed");
   wn_dtext(XEQ,NFRM,NFLD,wn,8,3,
      "(until you change it by choosing this option again).");
   wattrset(wn,COLOR_PAIR(6));
   wn_gbool(XEQ,NFRM,NFLD,wn,10,3,
   "Do you want to save the new field office information to disk? (Y or N) > ",
      COLOR_PAIR(2), ' ', &value, ans, NSTR, catstr(258));
   return(value);
}
