/*
 * anypia.C for WindowBoss
 * This program computes a primary insurance amount
 */

#ifndef lint
static char *anypiaID = " anypia.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#include <stdlib.h>
#if defined(__cplusplus)
#include <sysent.h>
#else
#if defined(M_UNIX)
#include <prototypes.h>
#else
extern int   getopt   ( int, char **, char * );
#endif
#endif
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#if defined(MSDOS)
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#ifdef _MSC_VER
#include <fcntl.h>
#endif
#endif
#include "common.h"
#include "pia.h"
#include "piain.h"
#include "wnutils.h"
#include "prtutils.h"
#include "baseyear.h"
#include "config.h"
#include "address.h"
#include "oldawbi.h"
#include "piaoutwn.h"
#include "lawchgwn.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static void  savecase ( WORKERDATA *workerdata, char *directory, char *ernfil );
#else
static void  savecase();
#endif

extern char *optarg;  /* option argument */

static struct pmenu filemenu = {
#if defined(M_XENIX) | defined(M_UNIX)
   (PANEL *)0,
#endif
   (WINDOW *)0, FALSE, 0,
   0, 5, {
   { FF, FF3, "Open...", 0 },
   { FF3, FF3, "Save", 1 },
   { FF4, FF3, "Save as...", 2 },
   { FF5, FF3, "Delete...", 3 },
   { FF6, FF3, "Directory", 4 },
   { FF7, FF3, "Quit", 5 },
   { 99, 99, "", 99 } }
   };

static struct pmenu mainmenu = {
#if defined(M_XENIX) | defined(M_UNIX)
   (PANEL *)0,
#endif
   (WINDOW *)0, FALSE, 0,
   0, 4, {
   { FF2, 2, "File", 0 },
   { FF2, 10, "View", 1 },
   { FF2, 18, "Setup", 2 },
   { FF2, 26, "Run", 3 },
   { FF2, 34, "Help", 4 },
   { 99, 99, "", 99 } }
   };

static struct pmenu runmenu = {
#if defined(M_XENIX) | defined(M_UNIX)
   (PANEL *)0,
#endif
   (WINDOW *)0, FALSE, 0,
   0, 0, {
   { FF, FF3, "Start", 0 },
   { 99, 99, "", 99 } }
   };

static struct pmenu helpmenu = {
#if defined(M_XENIX) | defined(M_UNIX)
   (PANEL *)0,
#endif
   (WINDOW *)0, FALSE, 0,
   0, 2, {
   { FF, FF3, "This Program", 0 },
   { FF3, FF3, "Main Menu", 1 },
   { FF4, FF3, "Forms", 2 },
   { 99, 99, "", 99 } }
   };

static struct pmenu setupmenu = {
#if defined(M_XENIX) | defined(M_UNIX)
   (PANEL *)0,
#endif
   (WINDOW *)0, FALSE, 0,
#ifdef LAWCHG
   0, 4, {
#else
   0, 3, {
#endif
   { FF, FF3, "Configuration", 0 },
   { FF3, FF3, "Historical amounts", 1 },
   { FF4, FF3, "Computation year", 2 },
   { FF5, FF3, "Field office info", 3 },
#ifdef LAWCHG
   { FF6, FF3, "Law-change indicators", 4 },
#endif
   { 99, 99, "", 99 } }
   };

#ifdef LAWCHG
#define ANYPIA "anypialc"
#else
#define ANYPIA "anypia"
#endif

#if defined(MSDOS)
#define UNTITLED "UNTITLED.PIA"
#else
#define UNTITLED "untitled.pia"
#endif

main(int argc, char **argv)
{
   int choice = 0;  /* choice on starting form */
   char *calmesg;  /* configuration error message */
   FILE *in;  /* pointer to file with configuration case */
   char *ernfil; /* name of file with stored case */
   char *infile;  /* full pathname of file with stored case */
   int temp;  /* temporary value of IX */
   WORKERDATA *workerdata;  /* workerdata structure */
   PIAPARMS *piaparms;  /* piaparms structure */
   Lawchg *lawchgdata;  /* Lawchg structure */
   Pebs *pebsdata;  /* Pebs structure */
   Taxes *taxdata;  /* taxdata structure */
   PIADATA *piadata;  /* piadata structure */
   FOINFO *foinfo;  /* field office info structure */
   Config *config;  /* configuration structure */
   int ierr = 0;  /* error indicator */
   WINDOW *wn;  /* main window */
   int IX = 129;  /* last possible year minus 1936 */

#ifdef _MSC_VER
   setmode(fileno(stdprn), O_TEXT);
#endif
   /* check options */
   while ((choice = getopt(argc,argv,"y:")) != -1)
      switch (choice) {
      case 'y':
         (void)sscanf(optarg,"%d",&temp);
         if (temp < 2000 || temp > 2100)
            ierr++;
         else {
            IX = temp - 1936;
            }
         break;
      default:
         ierr++;
      }
   /* exit if bad options */
   if (ierr) {
      (void)fprintf(stderr,
#if defined(MSDOS)
         "usage:  anypia [/yyear]\n         where 2000 <= year <= 2100\n");
#else
         "usage:  anypia [-y year]\n        where 2000 <= year <= 2100\n");
#endif
      exit(1);
      }
   /* set configuration variables */
   if ((config = initcnf(MAXCHR, &calmesg)) == (Config *)0) {
      printf(calmesg);
      done(ierr); }
   /* get configuration */
   if ((ierr = getcnf(config)) > 0) {
      printf("Cannot get configuration\n");
      exit(ierr); }
   wn = initwin(config -> icolor);
   if ((ierr = initpia(&taxdata, &piadata, &workerdata, &piaparms,
      &lawchgdata, &foinfo, &pebsdata, config, IX, MAXCHR, MAXEARN)) > 0) {
      wn_iemsg(catstr(ierr));
      done(ierr);
      }
   /* get configuration case */
   if ((in = fopen(CONFIGPIA,"r")) == (FILE *)NULL) {
      wn_iemsg(catstr(96));
      done(96); }
   status(catstr(290));
   if ((ierr = readfile(in, workerdata)) > 0) {
      wn_iemsg(catstr(ierr));
      done(ierr); }
   setistart(workerdata, piaparms -> istart);
   if ((ierr = datacheck(workerdata, piaparms, piadata, lawchgdata)) > 0)
      wn_iemsg(catstr(ierr));
   calculat1(workerdata, piaparms, piadata);
   ernfil = UNTITLED;
   concat(&infile, config -> direct[1], ANYPIA);
   if (wn_hlinit(1,1,COLS-4+2*FF,18+2*FF,COLOR_PAIR(4),COLOR_PAIR(9),
      infile) == FALSE)
      done(1);
   clr_stat();
  menubar:
   begscrn(stringd(20, (int)wns_bchars[2]));
   WREFRESH(wn);
   choice = wn_popup(1000,0,0,COLS,1,COLOR_PAIR(4),COLOR_PAIR(9),
      &mainmenu,FALSE);
   switch (choice)
      {
      case 0:
         goto file;
      case 1:
         goto newcase;
      case 2:
         goto setup;
      case 3:
         goto run;
      case 4:
         goto help;
      default:
         done(1);
      }

  file:
   choice = wn_popup(0,1,2,14+2*FF,6+2*FF,COLOR_PAIR(4),COLOR_PAIR(9),
      &filemenu,TRUE);
   switch (choice)
      {
      case 0:
         if ((ierr = opencase(&ernfil)) == ESC_CODE)
            break;
         concat(&infile, config -> direct[0], ernfil);
         if ((in = fopen(infile,"r")) == (FILE *)NULL) {
            wn_iemsg(catstr(68));
            break; }
         status(catstr(290));
         ierr = readfile(in, workerdata);
         clr_stat();
         if (ierr > 0) {
            wn_iemsg(catstr(ierr));
            break;
            }
         setistart(workerdata, piaparms -> istart);
         if ((ierr = datacheck(workerdata, piaparms, piadata,
            lawchgdata)) > 0)
            wn_iemsg(catstr(ierr));
         break;
      case 1:
         savecase(workerdata, config -> direct[0], ernfil);
         break;
      case 2:
         if (opencase(&ernfil) == ESC_CODE)
            break;
         savecase(workerdata, config -> direct[0], ernfil);
         break;
      case 3:
         if ((ierr = opencase(&ernfil)) == ESC_CODE)
            break;
         concat(&infile, config -> direct[0], ernfil);
         if ((in = fopen(infile,"r")) == (FILE *)NULL) {
            wn_iemsg(catstr(68));
            break; }
         fclose(in);
         if ((ierr = UNLINK(infile)) != 0)
            wn_iemsg(catstr(97));
         break;
      case 4:
         if (dispdir(wn, config -> direct[0], 0))
            wn_iemsg(catstr(98));
         else
            getret();
         break;
      case 5:
         done(0);
      default:  /* Escape */
         break;
      } /* end switch */
   goto menubar;

  setup:
      begscrn("     Data setup     ");
      choice = wn_popup(0,1,18,23+2*FF,5+2*FF,COLOR_PAIR(4),COLOR_PAIR(9),
         &setupmenu,TRUE);
      switch (choice)
         {
         case 0:
            if ((ierr = getconfig(wn, config)) > 0)
               done(ierr);
            /* set printer initialization string */
            setprn_init(piadata, config -> prn_init);
            break;
         case 1:
            if ((ierr = oldawbi(wn, piaparms)) > 0) {
               wn_iemsg(catstr(ierr));
               done(ierr); }
            /* initialize previous assumptions */
            zerojalt(workerdata);
            break;
         case 2:
            if ((ierr = baseyear(wn, piaparms)) > 0)
               done(ierr);
            /* initialize previous assumptions */
            zerojalt(workerdata);
            setistart(workerdata, piaparms -> istart);
            break;
         case 3:
            if ((ierr = address(wn,foinfo)) > 0)
               done(ierr);
            break;
#ifdef LAWCHG
         case 4:
            if ((ierr = lawchg(wn, lawchgdata)) > 0)
               done(ierr);
            break;
#endif
         default:
            break;
         }
      goto menubar;

  run:
   choice = wn_popup(0,1,26,7+2*FF,1+2*FF,COLOR_PAIR(4),COLOR_PAIR(9),
      &runmenu,TRUE);
   switch (choice)
      {
      case 0:
         if ((ierr = datacheck(workerdata, piaparms, piadata,
            lawchgdata)) > 0) {
            wn_iemsg(catstr(ierr));
            break; }
         begscrn("  PIA Calculation   ");
         WREFRESH(wn);
         if ((ierr = calculat1(workerdata, piaparms, piadata)) > 0) {
            wn_iemsg(catstr(ierr));
            break; }
         status(catstr(291));
         if ((ierr = calculat2(workerdata, piaparms, piadata, taxdata,
            lawchgdata, pebsdata, 1977)) > 0) {
            wn_iemsg(catstr(ierr));
            break; }
         clr_stat();
         /* no problem with calculation */
         wattrset(wn,COLOR_PAIR(4));
         if (workerdata -> joasdi == PEBS_CALC)
            pebscrn(wn, pebsdata);
         else
            sumscrn(wn, workerdata, piadata);
         wattrset(wn, COLOR_PAIR(6));
         if (getprt(wn)) {
            strcpy(piadata -> dateln, datime());
            strcpy(pebsdata -> dateln2, datenow());
            getprntr(wn,COLOR_PAIR(4));
            getrpr();
            if (workerdata -> joasdi == PEBS_CALC)
               (void) pebspage(workerdata, piaparms, piadata, pebsdata,
                  taxdata,foinfo);
            else
               (void) piaoutwn(workerdata, piadata, piaparms, lawchgdata,
                  taxdata);
            }
         break;
      default:
         break;
      }
   goto menubar;

  newcase:
   clr_stat();
   ierr = datain(wn, workerdata, piaparms, piadata, lawchgdata);
   goto menubar;

  help:
   choice = wn_popup(0,1,34,13+2*FF,3+2*FF,COLOR_PAIR(4),COLOR_PAIR(9),
      &helpmenu,TRUE);
   switch (choice)
      {
      case 0:
         wn_help("%this program%");
         break;
      case 1:
         wn_help("%main menu%");
         break;
      case 2:
         wn_help("%forms%");
         break;
      default:  /* Escape */
         break;
      } /* end switch */
   goto menubar;
}
/* Function to open output file, save case, and close file
 */
static void savecase(
WORKERDATA *workerdata,  /* workerdata structure */
char *directory,  /* directory to use */
char *ernfil)  /* name of file to store case under */
{
   FILE *out;  /* pointer to output file */
   char *outfile;  /* full pathname of file to store case */
   int ierr;  /* error indicator */

   /* do not allow untitled case */
   if (strcmp(ernfil, UNTITLED) == 0) {
      wn_iemsg(catstr(99));
      return; }
   concat(&outfile, directory, ernfil);
   if ((out = fopen(outfile,"w")) == (FILE *)NULL) {
      wn_iemsg(catstr(70));
      return; }
   status(catstr(292));
   if ((ierr = savdis(out, workerdata)) > 0) {
      wn_iemsg(catstr(ierr));
      return; }
   clr_stat();
}
