/*
 * @(#)anypiab.C	1.10   6/27/94
 * This program reads a series of cases in standard anypia format, computes
 * a primary insurance amount and associated data for each one, and prints
 * the results to a file named "output".  The particular variables that are
 * printed can be specified in function savecase, at the end of this file.
 */

#ifndef lint
static char *anypiabID = " @(#)anypiab.C	1.10   6/27/94 ";
#endif

#include <stdio.h>
#include <stdlib.h>
#if defined(M_UNIX)
#include <prototypes.h>
#endif
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#include "common.h"
#include "pia.h"
#include "comma.h"

#ifdef MSDOS
extern int   getopt   ( int, char **, char * );
#endif
static void  savecase ( FILE *out, WORKERDATA *workerdata, PIADATA *piadata );

extern char *optarg;  /* option argument */

#ifdef LAWCHG
#define ANYPIA "anypialc"
#else
#define ANYPIA "anypia"
#endif

main(
int argc,
char **argv)
{
   int choice = 0;  /* choice on starting form */
   char *calmesg;  /* calculation error message */
   FILE *in;  /* pointer to file with configuration case */
   FILE *out;  /* pointer to output file */
   char ernfil[80]; /* name of file with stored case */
   char *infile;  /* full pathname of file with stored case */
   int temp;  /* temporary value of IX */
   WORKERDATA *workerdata;  /* workerdata structure */
   PIAPARMS *piaparms;  /* piaparms structure */
   Pebs *pebsdata;  /* pebsdata structure */
   Taxes *taxdata;  /* taxdata structure */
   Lawchg *lawchgdata;  /* lawchgdata structure */
   int ierr = 0;  /* error indicator */
   PIADATA *piadata;  /* piadata structure */
   FOINFO *foinfo;  /* field office info structure */
   Config *config;  /* configuration structure */
   int IX = 129;  /* last possible year minus 1936 */

   /* check options */
   while ((choice = getopt(argc,argv,"y:")) != -1)
      switch (choice) {
      case 'y':
         (void)sscanf(optarg,"%d",&temp);
         if (temp < 2000 || temp > 2100)
            ierr++;
         else {
            IX = temp - 1936;
            }
         break;
      default:
         ierr++;
      }
   /* exit if bad options */
   if (ierr) {
      (void)fprintf(stderr,
#if defined(MSDOS)
         "usage:  anypiab [/yyear]\n         where 2000 <= year <= 2100\n");
#else
         "usage:  anypiab [-y year]\n        where 2000 <= year <= 2100\n");
#endif
      exit(1);
      }
   /* set configuration variables */
   if ((config = initcnf(MAXCHR, &calmesg)) == (Config *)0) {
      printf("%s\n", calmesg);
      exit(ierr); }
   /* get configuration */
   if ((ierr = getcnf(config)) > 0) {
      printf("Cannot get configuration\n");
      exit(ierr); }
   /* set variables */
   if ((ierr = initpia(&taxdata, &piadata, &workerdata, &piaparms,
      &lawchgdata, &foinfo, &pebsdata, config, IX, MAXCHR, MAXEARN)) > 0) {
      printf("%s\n", catstr(ierr));
      exit(1); }
   if ((out = fopen("output","w")) == (FILE *)NULL) {
      printf("%s\n", catstr(78));
      exit(1); }

  menubar:
         if (gets(ernfil) == NULL)
            exit(0);
         concat(&infile, config -> direct[0], ernfil);
         if ((in = fopen(infile,"r")) == (FILE *)NULL) {
            printf("%s\n", catstr(68));
            exit(1); }
         printf("Reading from %s\n", ernfil);
         ierr = readfile(in, workerdata);
         if (ierr > 0)
            printf("%s\n", catstr(ierr));
         setistart(workerdata, piaparms -> istart);
         if ((ierr = datacheck(workerdata, piaparms, piadata, lawchgdata)) >
            0) {
            printf("%s\n", catstr(ierr));
            goto menubar; }
         if ((ierr = calculat1(workerdata, piaparms, piadata)) > 0) {
            printf("%s\n", catstr(ierr));
            goto menubar; }
         if ((ierr = calculat2(workerdata, piaparms, piadata, taxdata,
            lawchgdata, pebsdata, 1977)) > 0) {
            printf("%s\n", catstr(ierr));
            goto menubar; }
         savecase(out, workerdata, piadata);
         if (piadata -> qctot < piadata -> qcreq)
            printf("%s\n", catstr(192));
#ifdef DEBUG
         /* print detailed results for each case */
         if ((ierr = piaout(workerdata, piaparms, lawchgdata, 3, 1977)) > 0)
            printf("Error %d writing output\n",ierr);
#endif
         /* no problem with calculation */
   goto menubar;
}
static void  savecase (
FILE *out,
WORKERDATA *workerdata,
PIADATA *piadata)
{
   fprintf(out, "%12s%10.2lf%10.2lf\n", workerdata -> ssn, piadata -> hipia,
      piadata -> himfb);
}
