/*
 * @(#)ardri.C	1.36   3/10/94
 * Functions to calculate the number of months of early or delayed
 * retirement, and normal and early retirement age
 */

#ifndef lint
static char *ardriID = " @(#)ardri.C	1.36   3/10/94 ";
#endif

#include <stdio.h>
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "piadata.h"
#include "ardri.h"
#include "compdate.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int    mardrical ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata );
static double retcr ( int telgyr );
static void   nra3cal ( WORKERDATA *workerdata, PIAPARMS *piaparms,
   PIADATA *piadata );
#else
static int mardrical ();
static double retcr();
static void nra3cal();
#endif

/* Function to calculate the number of months of early or
 * delayed retirement
 */
int ardri(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata,  /* piadata structure */
Lawchg *lawchgdata)  /* Lawchg structure */
{
   int i7;  /* maximum possible number of months of reduction */

   piadata -> mardri = 0;
   if (piadata -> iage[0] <= 0) /* impossible age */
      return(141);

   /* delayed retirement increment or early retirement reduction */

   if (workerdata -> ioasdi == OLD_AGE) { /* only for old-age */
      /* retirement before earliest possible age */
      if (compym(piadata -> iage, piadata -> nra1) < 0)
         return(142);
      /* delayed retirement credit */
      if (compym(piadata -> iage, piadata -> nra) >= 0) {
         piadata -> mardri = mardrical(workerdata, piaparms, piadata);
         piadata -> arf = (1. + ((double) piadata -> mardri) *
            retcr(piadata -> ielgyr[0]));
         }
      else { /* early retirement reduction */
         piadata -> mardri = piadata -> nra[0] * 12 + piadata -> nra[1] -
            (piadata -> iage[0] * 12 + piadata -> iage[1]);
         piadata -> arf = (piadata -> mardri <= 36) ?
            (1. - ((double) piadata -> mardri) * 5. / 900.) :
            (1. - (36. * 5. / 900.) -
            ((((double) piadata -> mardri) - 36.) * 5. / 1200.));
         }
      }

   /* survivors */

   if (workerdata -> ioasdi == SURVIVOR) {
   switch (workerdata -> jsurv)
   {
   case NO_SURV:  /* no survivor */
      return(13);
   case YOUNG_SURV:  /* young survivors */
      piadata -> arf = .75;
      return(0);
   case DISAB_WID:  /* disabled widow */
      if (compmdy(workerdata -> ient, piaparms -> amend672) < 0)
         return(143);
      if (piadata -> jage[0] < 50)
         return(144);
      if (piadata -> jage[0] > 59)
         return(145);
      piadata -> mardri = (60 - piadata -> jage[0]) * 12 - piadata -> jage[1];
      if (compmdy(workerdata -> ient, piaparms -> amend722) < 0)
         piadata -> arf = (.69167 - ((double) piadata -> mardri * 43./19800.));
      if (compmdy(workerdata -> ient, piaparms -> amend722) >= 0 &&
         compmdy(workerdata -> ient, piaparms -> amend83) < 0)
         piadata -> arf = (.715 - ((double) piadata -> mardri * 43./24000.));
      if (compmdy(workerdata -> ient, piaparms -> amend83) >= 0)
         piadata -> arf = .715;
      return(0);
   case AGED_WID:  /* aged widow */
      nra3cal(workerdata, piaparms, piadata);
      if (compym(piadata -> jage, piadata -> nra3) < 0)
         return(146);
      /* widow's normal retirement age */
      nracal(workerdata, lawchgdata, piadata -> nra2,
         piadata -> lbirth[2] + 60);
      if (compmdy(workerdata -> bendate, piaparms -> amend61) < 0) {
         piadata -> arf = .75;
         return(0);
         }
      if (compmdy(workerdata -> bendate, piaparms -> amend722) < 0) {
         if (piadata -> jage[0] >=62)
            piadata -> arf = .825;
         else {
            piadata -> mardri = (62 - piadata -> jage[0]) * 12 -
               piadata -> jage[1];
            piadata -> arf = (.825 - ((double) piadata -> mardri * 5./900.));
            }
         return(0);
         }
      /* handle 1973 and later */
      if (compym(piadata -> jage, piadata -> nra2) >= 0)
         piadata -> arf = 1.0;
      else {
         piadata -> mardri = piadata -> nra2[0] * 12 + piadata -> nra2[1] -
            (piadata -> jage[0] * 12 + piadata -> jage[1]);
         i7 = piadata -> nra2[0] * 12 + piadata -> nra2[1] - 60 * 12;
         piadata -> arf =
            (1. - ((double) piadata -> mardri * .285 / (double)i7)); }
      return(0);
      }
   }

   /* disability */

   if (workerdata -> ioasdi == DISABILITY) {
      if (workerdata -> ient[2] <= 1959) {
         if (workerdata -> ient[2] < 1957)
            return(149);
         if (piadata -> iage[0] < 50)
            return(150);
         return(0);
         }
      if (compym(piadata -> iage, piadata -> nra) < 0)
         piadata -> arf = 1.0;
      else
         return(151);
   }
   return(0);
}
/* Function to calculate number of months of delayed retirement credit
 */
static int mardrical(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   int i1;  /* index of first month to which delayed retirement credit can
      apply (Jan 1971 = 1) */
   int i2;  /* index of month after last month to which delayed retirement
      credit can apply */
   int i3;  /* index of month of attainment of normal retirement age */
   int i4;  /* index of month of age 72 or 70 */
   int i5;  /* index of month of entitlement */
   int i6;  /* index of January of year of entitlement, or month of
      attainment of normal retirement age, if later */
   int i7;  /* index of month of benefit */

   i3 = piadata -> kbirth[0] + piadata -> nra[1] +
      12 * (piadata -> kbirth[2] - 1971 + piadata -> nra[0]);
   i1 = (i3>1) ? i3 : 1;
   /* decrease maximum age for DRI from 72 to 70 in Jan 1984 */
   if (piadata -> ielgyr[0] <= 1975) {
      i4 = piadata -> kbirth[0] + 12 * (piadata -> kbirth[2] + 72 - 1971);
      if (piadata -> ielgyr[0] >= 1974 && i4 > 157)
         i4=157;
      }
   else
      i4 = piadata -> kbirth[0] + 12 * (piadata -> kbirth[2] + 70 - 1971);
   i5 = workerdata -> ient[0] + 12*(workerdata -> ient[2] - 1971);
   i6 = 12*(workerdata -> ient[2] - 1971) + 1;
   if (i6 < i3)
      i6 = i3;
   i7 = workerdata -> bendate[0] + 12*(workerdata -> bendate[2] - 1971);
   /* if already age 70 (or 72), use DRCs through age 70 (or 72) */
   if (i4 <= i5)
      i2 = i4;
   else
      {  /* if calculating benefit after age 70 (or 72), or in year after
          * entitlement, use DRCs through entitlement */
      if (i4 <= i7 || workerdata -> bendate[2] > workerdata -> ient[2])
         i2 = i5;
      /* otherwise use DRCs through end of year before entitlement */
      else
         i2 = i6;
      }
   /* no DRC until January 1973 */
   if (compmdy(workerdata -> ient, piaparms -> amend722) < 0)
      i2 = 0;
   return((i2 > i1) ? i2 - i1 : 0);
}
/* function to calculate normal retirement age
 */
void nracal(
WORKERDATA *workerdata,  /* workerdata structure */
Lawchg *lawchgdata,  /* Lawchg structure */
int *nrax,  /* normal retirement age, in years and months */
int melgyr)  /* year of eligibility */
{
   if (melgyr < 2000) { /* age 65 */
      nrax[0] = 65;
      nrax[1] = 0; }
#ifdef LAWCHG
   if (lawchgdata -> jind[26] > 0 &&
      workerdata -> ient[2] >= lawchgdata -> jstart[0][26]) {
      nrax[0] = 65;
      nrax[1] = 0;
      return; }
#endif
   if (melgyr > 1999 && melgyr < 2005) {
      /* age 65 and 2 months to age 65 and 10 months */
      nrax[0] = 65;
      nrax[1] = 2*(melgyr-1999); }
   if (melgyr > 2004 && melgyr < 2017) { /* age 66 */
      nrax[0] = 66;
      nrax[1] = 0; }
   if (melgyr > 2016 && melgyr < 2022) {
      /* age 66 and 2 months to age 66 and 10 months */
      nrax[0] = 66;
      nrax[1] = 2*(melgyr-2016); }
   if (melgyr > 2021) { /* age 67 */
      nrax[0] = 67;
      nrax[1] = 0; }
}
/* Function to set earliest possible retirement age
 */
void nra1cal(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   static int amend611[3] = { 7,31,1899 };  /* first birth date for which
      age 62 is effective for males */
   static int amend612[3] = { 8,31,1896 };  /* second birth date for which
      age 62 is effective for males */
   static int amend561[3] = { 10,31,1894 };  /* first birth date for which
      age 62 is effective for females */
   static int amend562[3] = { 11,31,1891 };  /* second birth date for which
      age 62 is effective for females */

   if (workerdata -> isex == 1)
      { /* change to age 62 */
      if (compmdy(piadata -> kbirth, amend611) > 0) {
         piadata -> nra1[0] = 62;
         piadata -> nra1[1] = 0; }
      if (compmdy(piadata -> kbirth, amend611) <= 0 &&
         compmdy(piadata -> kbirth, amend612) > 0) {
         piadata -> nra1[0] = 1961 - piadata -> kbirth[2];
         piadata -> nra1[1] = (int)AUGUST - piadata -> kbirth[0];
         if (piadata -> nra1[1] < 0 ) {
            piadata -> nra1[1] += 12;
            piadata -> nra1[0]--; }
         }
      if (compmdy(piadata -> kbirth, amend612) <= 0) {
         piadata -> nra1[0] = 65;
         piadata -> nra1[1] = 0; }
      }
    else
      { /* change to age 62 */
      if (compmdy(piadata -> kbirth, amend561) > 0) {
         piadata -> nra1[0] = 62;
         piadata -> nra1[1] = 0; }
      if (compmdy(piadata -> kbirth, amend561) <= 0 &&
         compmdy(piadata -> kbirth, amend562) > 0) {
         piadata -> nra1[0] = 1956 - piadata -> kbirth[2];
         piadata -> nra1[1] = (int)NOVEMBER - piadata -> kbirth[0];
         if (piadata -> nra1[1] < 0 ) {
            piadata -> nra1[1] += 12;
            piadata -> nra1[0]--; }
         }
      if (compmdy(piadata -> kbirth, amend562) <= 0) {
         piadata -> nra1[0] = 65;
         piadata -> nra1[1] = 0; }
      }
   /* increase to age 62 and 1 month */
   if (compmdy(piadata -> kbirth, piaparms -> amend81) > 0 &&
      piadata -> kbirth[1] != 1)
      piadata -> nra1[1] = 1;
}
/* Function to set amount of monthly credit */
static double retcr(
int telgyr)  /* year of eligibility */
{
   if (telgyr < 1979)
      return(1./1200.);
   if (telgyr >= 1979 && telgyr < 1987)
      return(1./400.);
   if (telgyr > 1986 && telgyr < 2005)
      return((double)((telgyr-1985)/2)/2400. + 1./400.);
   return(2./300.);
}
/* Function to set earliest possible widow's retirement age
 */
static void nra3cal(
WORKERDATA *workerdata,  /* workerdata structure */
PIAPARMS *piaparms,  /* piaparms structure */
PIADATA *piadata)  /* piadata structure */
{
   piadata -> nra3[1] = 0;
   if (compmdy(workerdata -> bendate, piaparms -> amend56) < 0) {
      piadata -> nra3[0] = 65;
      return; }
   if (compmdy(workerdata -> bendate, piaparms -> amend652) < 0) {
      piadata -> nra3[0] = 62;
      return; }
   piadata -> nra3[0] = 60;
   return;
}
