/*
 * avgwage.C for WindowBoss
 * Various average wage functions
 */

#ifndef lint
static char *avgwageID = " avgwage.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "lawchg.h"
#include "wnutils.h"
#include "piaparms.h"
#include "piadata.h"
#include "piain.h"
#include "mesgcat.h"

/* Function to read user-specified average wage increases
 */
int avgred(
WINDOW *wn,  /* window to use */
float *fqinc,  /* average wage increase array */
int firstyr,  /* first year to show */
int lastyr,  /* last year to show */
int option,  /* form option
                0: allow no changes
                1: allow change to last figure only
                2: allow changes to all figures */
char *hlpmsg)  /* help message */
{
   int i,i1,i2; /* loop counters */
   WIFORM frm;  /* form pointer */
   char answer[60][11];  /* earnings as a string */
   char prmpt[60][18];  /* prompt for each year of earnings */
   int rv = 0;  /* return value */

   begscrn("Average Wage Changes");
   frm = wn_frmopn(61);
   if (!frm) {
      wn_iemsg(catstr(213));
      done(1); }
   wattrset(wn, COLOR_PAIR(4));
   for (i = 0; (i < 60 && i <= lastyr-firstyr); i++)
      {
      i2 = i / 20;
      i1 = i - i % 20;
      if (option == 2)
         {  /* get new value */
         sprintf(answer[i], "%9.6f", fqinc[firstyr-1937+i]);
         sprintf(prmpt[i], "%4d   ", firstyr+i);
         wn_gfloat(SET, frm, i, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[i],
            COLOR_PAIR(2), '_', fqinc + firstyr - 1937 + i, 9, 6,
            -10., 100., answer[i], hlpmsg, catstr(111));
         }
      else if (option == 1 && i == lastyr-firstyr)
         {  /* get new value */
         sprintf(answer[0], "%9.6f", fqinc[firstyr-1937+i]);
         sprintf(prmpt[0], "%4d   ", firstyr+i);
         wn_gfloat(SET, frm, 0, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[0],
            COLOR_PAIR(2), '_',fqinc+firstyr-1937+i,9,6,-10.,100.,answer[0],
            hlpmsg, catstr(111));
         }
      else
         {  /* display only */
         sprintf(prmpt[i], "%4d   %9.6f", firstyr+i,
            fqinc[firstyr-1937+i]);
         wn_dtext(XEQ, NFRM, NFLD, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[i]);
         }
      }
   WREFRESH(wn);
   if (option != 0) {
      wattrset(wn, COLOR_PAIR(6));
      rv = wn_frmget(frm); }
   wn_frmcls(frm);
   if (option == 0)
      getret();
   return(rv);
}
