/*
 * baseyear.C for WindowBoss
 * Function to review or change the computation year
 */

#ifndef lint
static char *baseyrID = " baseyear.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "wrkrdata.h"
#include "lawchg.h"
#include "piaparms.h"
#include "wnutils.h"
#include "setup.h"
#include "baseyear.h"
#include "scanfile.h"
#include "mesgcat.h"

#if !defined(NO_PROTOTYPE) | defined(__cplusplus)
static int   getbas   ( WINDOW *wn, PIAPARMS *piaparms );
static int   getbsav  ( WINDOW * );
#else
static int   getbas();
static int   getbsav();
#endif

static startnew;  /* new value for istart */

/* Function to review or update computation year
 */
baseyear(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   int rv;  /* return value */

   if ((rv = getbas(wn, piaparms)) == ESC_CODE)
      return(rv);
   /* save results */
   if (getbsav(wn))
      {
      setbasyr(piaparms, startnew);
      if ((rv = savebasyr(piaparms)) > 0) {
         wn_iemsg(catstr(rv));
         return(rv); }
      /* get new historical amounts */
      if ((rv = gethst(piaparms)) > 0) {
         wn_iemsg(catstr(rv));
         return(rv); }
      if ((rv = asmtit(piaparms)) > 0) {
         wn_iemsg(catstr(rv));
         return(rv); }
      }
   clr_stat();
   return(0);
}
/* Function to get new computation year
 */
static getbas(
WINDOW *wn,  /* window to use */
PIAPARMS *piaparms)  /* piaparms structure */
{
   WIFORM frm;  /* form pointer */
   FILE *tempfile;  /* temporary file pointer */
   static char istartst[10];  /* istart as a string */
   int rv;  /* return value */
   char *infile;  /* full pathname of historical data file */
   int startold;  /* saved value of istart */

   begscrn("  Computation year  ");
   frm = wn_frmopn(2);
   if (!frm) {
      wn_iemsg(catstr(214));
      done(1); }
   sprintf(istartst, "%4d", piaparms -> istart);
   wn_gint(SET, frm, 0, wn, 4, 3, "Enter computation year > ", COLOR_PAIR(2),
      ' ', &startnew, 4, 1979, 1999, istartst, "%computation year%",
      catstr(259));
  form:
   wattrset(wn, COLOR_PAIR(6));
   if ((rv = wn_frmget(frm)) == ESC_CODE)
      return(rv);
   /* test for existence of historical data file */
   startold = piaparms -> istart;
   setbasyr(piaparms, startnew);
   infile = getawbifl(piaparms);
   setbasyr(piaparms, startold);
   if ((tempfile = fopen(infile, "r")) == (FILE *)NULL) {
      wn_iemsg(catstr(71));
      goto form; }
   fclose(tempfile);
   wn_frmcls(frm);
   return(rv);
}
/* Function to get answer to save-to-disk prompt
 */
static int getbsav(
WINDOW *wn)  /* window to use */
{
   static char ans[3];  /* answer as a string */
   int value;  /* 0 = false, 1 = true */

   begscrn("    Save to disk    ");
   wattrset(wn, COLOR_PAIR(4));
   wn_dtext(XEQ, NFRM, NFLD, wn, 4, 3,
      "You are about to change the computation year for this program.");
   wn_dtext(XEQ, NFRM, NFLD, wn, 5, 3,
      "Historical data must exist in a correctly named file on the disk for");
   wn_dtext(XEQ, NFRM, NFLD, wn, 6, 3,
      "the year that you enter.  For instance, if you enter 1990, there must");
   wn_dtext(XEQ, NFRM, NFLD, wn, 7, 3,
      "be a file named AWBI90.DAT.  Some historical files are distributed");
   wn_dtext(XEQ, NFRM, NFLD, wn, 8, 3,
      "with the program.  Others can be created by the user by choosing the");
   wn_dtext(XEQ, NFRM, NFLD, wn, 9, 3,
      "menu option to update the historical amounts.");
   wn_dtext(XEQ, NFRM, NFLD, wn, 11, 3,
      "You can increase or decrease the computation year, as long as the");
   wn_dtext(XEQ, NFRM, NFLD, wn, 12, 3,
      "corresponding file of historical data is available.");
   wattrset(wn, COLOR_PAIR(6));
   wn_gbool(XEQ, NFRM, NFLD, wn, 14, 3,
      "Do you want to save the new computation year (Y or N) > ",
      COLOR_PAIR(2), ' ', &value, ans, "%baseyear Y or N%", catstr(258));
   return(value);
}
