/*
 * beninc.C for WindowBoss
 * Various benefit increase functions
 */

#ifndef lint
static char *benincID = " beninc.C for WindowBoss ";
#endif

#include "curses.h"
#include "winboss.h"
#include "winboss1.h"
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
#ifdef MSDOS
#if DLC > 0
#include <disp.h>
#else
#include <conio.h>
#endif
#endif
#include "pia.h"
#include "wnutils.h"
#include "piain.h"

/* Function to read user-specified catch-up benefit increases
 */
int benred(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   int i,i1,i2; /* loop counters */
   WIFORM frm;  /* form pointer */
   char answer[80][11];  /* catchup increases as a string */
   char prmpt[80][10];  /* prompt for each year of earnings */
   static char *mesg =
      "elig     xxxx    xxxx    xxxx    xxxx    xxxx    xxxx    xxxx    xxxx";
   int rv = 0;  /* return value */
   char temp[10];  /* temporary string */

   begscrn(" Catch-up increases ");
   frm = wn_frmopn(84);
   wattrset(wn, COLOR_PAIR(4));
   if (!frm) {
      wn_iemsg(catstr(215));
      done(1); }
   /* do title */
   wn_dtext(SET, frm, 0, wn, FF2+1, 4+FF2, "year");
   wn_dtext(SET, frm, 1, wn, FF2+2, 5+FF2,
      "of      year of catch-up increase ...");
   sprintf(mesg, "elig ");
   for (i1 = 2; i1 < 10; i1++) {
      sprintf(temp, "%4d", workerdata -> istart + i1);
      strncpy(mesg + 8*i1 - 7, temp, 4); }
   wn_dtext(SET, frm, 2, wn, FF2+3, 4+FF2, mesg);
   /* do first column */
   for (i2 = 0; i2 < 10; i2++) {
      i = 8*i2;
      sprintf(answer[i], "%6.1f", workerdata -> cachup[i2][0]);
      sprintf(prmpt[i], "%4d    ", workerdata -> istart + i2);
      wn_gdouble(SET, frm, i+3, wn, i2+FF2+5, 4+FF2, prmpt[i],
         COLOR_PAIR(2), '_', &(workerdata -> cachup[i2][0]), 6, 1, 0.0, 100.,
         answer[i], "%catch-up increases%", catstr(123));
      }
   /* do body of form */
   for (i2 = 0; i2 < 10; i2++) {
      for (i1 = 1; i1 < 8; i1++) {
         i = 8*i2 + i1;
         sprintf(answer[i], "%6.1f", workerdata -> cachup[i2][i1]);
         sprintf(prmpt[i], "");
         wn_gdouble(SET, frm, i+3, wn, i2+FF2+5, 12+FF2+i1*8, prmpt[i],
            COLOR_PAIR(2), '_', &(workerdata -> cachup[i2][i1]), 6, 1, 0.0,
            100., answer[i], "%catch-up increases%", catstr(123));
         }
      }
   wattrset(wn, COLOR_PAIR(6));
   rv = wn_frmget(frm);
   wn_frmcls(frm);
   return(rv);
}
/* Function to get benefit increase, average wage, and wage base
 * assumptions
 */
int assumpr(
WINDOW *wn,  /* window to use */
WORKERDATA *workerdata)  /* workerdata structure */
{
   WIFORM frm1, frm2;  /* form pointers */
   char ialtbist[10];  /* ialtbi as a string */
   char ialtawst[10];  /* ialtaw as a string */
   char ibaschst[10];  /* ibasch as a string */
   static char *mesg1 = "Must be between x and x";
   int rv;  /* return value */
   static char ans[3];  /* answer as a string */
   int value;  /* 0 = false, 1 = true */
   char temp[5];  /* temporary string */
   int ialtawt;  /* integer version of ialtaw */
   int ialtbit;  /* integer version of ialtbi */
   int i1, i2;  /* low and high values for assumptions */
   char *bihelp;  /* benefit increase assumption help */
   char *awhelp;  /* average wage increase assumption help */

   begscrn("    Assumptions     ");
   wattrset(wn, COLOR_PAIR(6));
   frm1 = wn_frmopn(5);
   if (!frm1) {
      wn_iemsg("Could not open assumptions form");
      done(1); }
#if !defined(EXPANDED_PEBES)
   if (workerdata -> joasdi == PEBS_CALC) {
      bihelp = "%PEBS ben inc trigger%";
      awhelp = "%PEBS avg wage inc trig%";
      i1 = 5;
      i2 = 6; }
   else
#endif
      {
      bihelp = "%ben inc trigger%";
      awhelp = "%avg wage inc trig%";
      i1 = 1;
      i2 = MAXASM; }
   sprintf(temp, "%d", i1);
   strncpy(mesg1+16, temp, 1);
   sprintf(temp, "%d", i2);
   strncpy(mesg1+22, temp, 1);
   ialtbit = (int)workerdata -> ialtbi;
   sprintf(ialtbist, "%d", ialtbit);
   /* get benefit increase assumption */
   wn_gint(SET, frm1, 0, wn, 3, 27, "Benefit increase assumption > ",
      COLOR_PAIR(2),' ',&ialtbit,1,i1,i2,ialtbist,bihelp,
      mesg1);
   ialtawt = (int)workerdata -> ialtaw;
   sprintf(ialtawst, "%d", ialtawt);
   /* get average wage increase assumption */
   wn_gint(SET, frm1, 1, wn, 4, 22, "Average wage increase assumption > ",
      COLOR_PAIR(2),' ',&ialtawt,1,i1,i2,ialtawst,
      awhelp,mesg1);
   /* get catch-up response and wage base change indicator */
   if (workerdata -> joasdi == PEBS_CALC) {
      ans[0] = 'N';
      ans[1] = '\0';
      wn_dtext(SET, frm1, 2, wn, 5, 4,
         "Are there any catch-up benefit increases? (Y or N) > N");
      setibasch(workerdata, 1);
      wn_dtext(SET, frm1, 3, wn, 6, 3,
         "Wage base change indicator (1: automatic, 2: enter) > 1"); }
   else {
      ans[0] = workerdata -> anscch;
      ans[1] = '\0';
      wn_gbool(SET, frm1, 2, wn, 5, 4,
         "Are there any catch-up benefit increases? (Y or N) > ",
         COLOR_PAIR(2), ' ', &value, ans, "%catch-up Y or N%",
         catstr(258));
      sprintf(ibaschst, "%d", workerdata -> ibasch);
      wn_gint(SET, frm1, 3, wn, 6, 3,
         "Wage base change indicator (1: automatic, 2: enter) > ",
         COLOR_PAIR(2), ' ', &(workerdata -> ibasch), 1, 1, 2, ibaschst,
         "%wage base change%", catstr(21)); }
  form1:
   rv = wn_frmget(frm1);
   if (rv == ESC_CODE || rv == KEY_PPAGE) {
      wn_frmcls(frm1);
      return(rv); }
   setialtaw(workerdata, ialtawt);
   if (workerdata -> ialtaw == OTHER_ASSUM)
      workerdata -> jaltaw = 0;
   setialtbi(workerdata, ialtbit);
   setanscch(workerdata, ans[0]);
   if (workerdata -> ialtbi == OTHER_ASSUM)
      workerdata -> jaltbi = 0;
   if (workerdata -> ibasch == 2)
      workerdata -> jbasch = 0;

   if (workerdata -> ialtaw == OTHER_ASSUM ||
      workerdata -> ialtbi == OTHER_ASSUM)
      {
      frm2 = wn_frmopn(5);
      if (!frm2) {
         wn_iemsg(catstr(217));
         done(1); }
      wn_dtext(SET, frm2, 0, wn, 8, 3,
         "Title of benefit increase assumptions:");
      if (workerdata -> ialtbi == OTHER_ASSUM)
         wn_gtext(SET, frm2, 1, wn, 9, 3, NSTR, COLOR_PAIR(2), ' ',
            (int)workerdata -> maxchr - 2, workerdata -> titlbi,
            "%title of ben inc%", NSTR);
      else
         wn_dtext(SET, frm2, 1, wn, 9, 3,
            getbeninc((int)workerdata -> ialtbi));
      wn_dtext(SET, frm2, 2, wn, 11, 3,
         "Title of average wage increase assumptions:");
      if (workerdata -> ialtaw == OTHER_ASSUM)
         wn_gtext(SET, frm2, 3, wn, 12, 3, NSTR, COLOR_PAIR(2), ' ',
            (int)workerdata -> maxchr - 2, workerdata -> titlaw,
            "%avg wage title%", NSTR);
      else
         wn_dtext(SET, frm2, 3, wn, 12, 3,
            getavgwage((int)workerdata -> ialtaw));
      if ((rv = wn_frmget(frm2)) == ESC_CODE) {
         wn_frmcls(frm1);
         wn_frmcls(frm2);
         return(rv); }
      wn_sdelspc(workerdata -> titlbi, 3);
      wn_sdelspc(workerdata -> titlaw, 3);
      wn_frmcls(frm2);
      if (rv == KEY_PPAGE)
         goto form1;
      }
   else
      {
      wn_dtext(XEQ, NFRM, NFLD, wn, 8, 3,
         "Title of benefit increase assumptions:");
      wn_dtext(XEQ, NFRM, NFLD, wn, 9, 3,
         getbeninc((int)workerdata -> ialtbi));
      wn_dtext(XEQ, NFRM, NFLD, wn, 11, 3,
         "Title of average wage increase assumptions:");
      wn_dtext(XEQ, NFRM, NFLD, wn, 12, 3,
         getavgwage((int)workerdata -> ialtaw));
      WREFRESH(wn);
      getret();
      }
   wn_frmcls(frm1);
   return(rv);
}
/* Function to review or edit benefit increases
 */
int benincr(
WINDOW *wn,  /* window to use */
float *cpiinc,  /* array of benefit increases */
int firstyr,  /* first year to show */
int lastyr,  /* last year to show */
int option,  /* form option
                0: allow no changes
                1: allow change to last figure only
                2: allow changes to all figures */
char *hlpmsg)  /* help message */
{
   int i,i1,i2; /* loop counters */
   WIFORM frm;  /* form pointer */
   char answer[60][11];  /* earnings as a string */
   char prmpt[60][18];  /* prompt for each year of earnings */
   int rv = 0;  /* return value */

   begscrn("  Benefit increases ");
   frm = wn_frmopn(61);
   wattrset(wn, COLOR_PAIR(4));
   if (!frm) {
      wn_iemsg(catstr(218));
      done(1); }
   for (i = 0; (i < 60 && i <= lastyr-firstyr); i++)
      {
      i2 = i / 20;
      i1 = i - i % 20;
      if (option == 2)
         {  /* get new value */
         sprintf(answer[i], "%9.1f", cpiinc[firstyr-1951+i]);
         sprintf(prmpt[i], "%4d   ", firstyr+i);
         wn_gfloat(SET, frm, i, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[i],
            COLOR_PAIR(2),'_',cpiinc+firstyr-1951+i,9,1,0.0,100.,answer[i],
            hlpmsg, catstr(110));
         }
      else if (option == 1 && i == lastyr-firstyr)
         {  /* get new value */
         sprintf(answer[0], "%9.1f", cpiinc[firstyr-1951+i]);
         sprintf(prmpt[0], "%4d   ", firstyr+i);
         wn_gfloat(SET, frm, 0, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[0],
            COLOR_PAIR(2),'_',cpiinc+firstyr-1951+i,9,1,0.0,100.,answer[0],
            hlpmsg, catstr(110));
         }
      else
         {  /* display only */
         sprintf(prmpt[i], "%4d   %9.1f", firstyr+i,
            cpiinc[firstyr-1951+i]);
         wn_dtext(XEQ, NFRM, NFLD, wn, i+FF2-i1, 8+FF2+i2*(COLS/3), prmpt[i]);
         }
      }
   WREFRESH(wn);
   if (option != 0) {
      wattrset(wn, COLOR_PAIR(6));
      rv = wn_frmget(frm); }
   wn_frmcls(frm);
   if (option == 0)
      getret();
   return(rv);
}
